/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.typinghooks;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.spi.editor.typinghooks.CamelCaseInterceptor;
import org.openide.util.NbPreferences;

public class PhpCamelCaseInterceptor
implements CamelCaseInterceptor {
    private static final String CAMEL_CASE_NAVIGATION_PROPERTY = "useCamelCaseStyleNavigation";

    private static boolean isUsingCamelCase() {
        return NbPreferences.root().getBoolean(CAMEL_CASE_NAVIGATION_PROPERTY, true);
    }

    public boolean beforeChange(CamelCaseInterceptor.MutableContext context) throws BadLocationException {
        return false;
    }

    public void change(CamelCaseInterceptor.MutableContext context) throws BadLocationException {
        if (PhpCamelCaseInterceptor.isUsingCamelCase()) {
            BaseDocument doc = (BaseDocument)context.getDocument();
            boolean reverse = context.isBackward();
            int offset = context.getOffset();
            TokenSequence<PHPTokenId> ts = LexUtilities.getPHPTokenSequence((Document)doc, offset);
            if (ts == null) {
                return;
            }
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return;
            }
            if (reverse && ts.offset() == offset && !ts.movePrevious()) {
                return;
            }
            Token token = ts.token();
            TokenId id = token.id();
            if (id == PHPTokenId.WHITESPACE) {
                int start;
                if (reverse && ts.offset() < offset || !reverse && ts.offset() > offset) {
                    context.setNextWordOffset(ts.offset());
                    return;
                }
                while (id == PHPTokenId.WHITESPACE) {
                    if (reverse && !ts.movePrevious()) {
                        return;
                    }
                    if (!reverse && !ts.moveNext()) {
                        return;
                    }
                    token = ts.token();
                    id = token.id();
                }
                if (reverse) {
                    start = ts.offset() + token.length();
                    if (start < offset) {
                        context.setNextWordOffset(start);
                        return;
                    }
                } else {
                    start = ts.offset();
                    if (start > offset) {
                        context.setNextWordOffset(start);
                        return;
                    }
                }
            }
            if (id == PHPTokenId.PHP_VARIABLE || id == PHPTokenId.PHP_STRING) {
                String s = token.text().toString();
                int length = s.length();
                int wordOffset = offset - ts.offset();
                if (reverse) {
                    int offsetInImage = offset - 1 - ts.offset();
                    if (offsetInImage < 0) {
                        return;
                    }
                    if (offsetInImage < length && Character.isUpperCase(s.charAt(offsetInImage))) {
                        for (int i = offsetInImage - 1; i >= 0; --i) {
                            char charAtI = s.charAt(i);
                            if (charAtI == '_') {
                                context.setNextWordOffset(ts.offset() + i + 1);
                                return;
                            }
                            if (Character.isUpperCase(charAtI)) continue;
                            context.setNextWordOffset(ts.offset() + i + 1);
                            return;
                        }
                        context.setNextWordOffset(ts.offset());
                    } else {
                        for (int i = offsetInImage - 1; i >= 0; --i) {
                            char charAtI = s.charAt(i);
                            if (charAtI == '_') {
                                context.setNextWordOffset(ts.offset() + i + 1);
                                return;
                            }
                            if (!Character.isUpperCase(charAtI)) continue;
                            for (int j = i; j >= 0; --j) {
                                char charAtJ = s.charAt(j);
                                if (charAtJ == '_') {
                                    context.setNextWordOffset(ts.offset() + j + 1);
                                    return;
                                }
                                if (Character.isUpperCase(charAtJ)) continue;
                                context.setNextWordOffset(ts.offset() + j + 1);
                                return;
                            }
                            context.setNextWordOffset(ts.offset());
                            return;
                        }
                        context.setNextWordOffset(ts.offset());
                    }
                } else {
                    char charAtI;
                    int i;
                    int start = wordOffset + 1;
                    if (wordOffset < 0 || wordOffset >= s.length()) {
                        return;
                    }
                    if (Character.isUpperCase(s.charAt(wordOffset))) {
                        for (i = start; i < length && Character.isUpperCase(charAtI = s.charAt(i)); ++i) {
                            if (s.charAt(i) == '_') {
                                context.setNextWordOffset(ts.offset() + i);
                                return;
                            }
                            ++start;
                        }
                    }
                    for (i = start; i < length; ++i) {
                        charAtI = s.charAt(i);
                        if (charAtI != '_' && !Character.isUpperCase(charAtI)) continue;
                        context.setNextWordOffset(ts.offset() + i);
                        return;
                    }
                }
            }
        }
    }

    public void afterChange(CamelCaseInterceptor.MutableContext context) throws BadLocationException {
    }

    public void cancelled(CamelCaseInterceptor.MutableContext context) {
    }

    public static class Factory
    implements CamelCaseInterceptor.Factory {
        public CamelCaseInterceptor createCamelCaseInterceptor(MimePath mimePath) {
            return new PhpCamelCaseInterceptor();
        }
    }
}

