/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.EmptyStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class EmptyStatementHint
extends HintRule {
    private static final String HINT_ID = "Empty.Statement.Hint";

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            hints.addAll(checkVisitor.getHints());
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.EmptyStatementHintDesc();
    }

    public String getDisplayName() {
        return Bundle.EmptyStatementHintDisp();
    }

    private static final class Fix
    implements HintFix {
        private final EmptyStatement node;
        private final BaseDocument baseDocument;

        private Fix(EmptyStatement node, BaseDocument baseDocument) {
            this.node = node;
            this.baseDocument = baseDocument;
        }

        public String getDescription() {
            return Bundle.EmptyStatementHintFix();
        }

        public void implement() throws Exception {
            EditList editList = new EditList(this.baseDocument);
            int removeLength = this.node.getEndOffset() - this.node.getStartOffset();
            editList.replace(this.node.getStartOffset(), removeLength, "", true, 0);
            editList.apply();
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final List<Hint> hints;

        public CheckVisitor(FileObject fileObject, BaseDocument baseDocument) {
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.hints = new ArrayList<Hint>();
        }

        public List<Hint> getHints() {
            return this.hints;
        }

        @Override
        public void visit(EmptyStatement node) {
            super.visit(node);
            if (this.isSemicolon(node)) {
                this.createHint(node);
            }
        }

        private void createHint(EmptyStatement node) {
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (EmptyStatementHint.this.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)EmptyStatementHint.this, Bundle.EmptyStatementHintText(), this.fileObject, offsetRange, Collections.singletonList(new Fix(node, this.baseDocument)), 500));
            }
        }

        private boolean isSemicolon(EmptyStatement node) {
            return node.getEndOffset() - node.getStartOffset() == 1;
        }
    }
}

