/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class PSR0Hint
extends HintRule {
    @Override
    public void invoke(PHPRuleContext context, List<Hint> result) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            CheckVisitor checkVisitor = this.createVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            result.addAll(checkVisitor.getHints());
        }
    }

    abstract CheckVisitor createVisitor(FileObject var1, BaseDocument var2);

    @Override
    public boolean getDefaultEnabled() {
        return false;
    }

    private static abstract class CheckVisitor
    extends DefaultVisitor {
        private final PSR0Hint psr0hint;
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final File file;
        private final List<Hint> hints;

        public CheckVisitor(PSR0Hint psr0hint, FileObject fileObject, BaseDocument baseDocument) {
            this.psr0hint = psr0hint;
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.file = FileUtil.toFile((FileObject)fileObject);
            this.hints = new ArrayList<Hint>();
        }

        public List<Hint> getHints() {
            return this.hints;
        }

        protected void createHint(ASTNode node, String message) {
            OffsetRange offsetRange = new OffsetRange(node.getStartOffset(), node.getEndOffset());
            if (this.psr0hint.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)this.psr0hint, Bundle.PSR0ViolationHintText(message), this.fileObject, offsetRange, null, 500));
            }
        }

        protected File getFile() {
            return this.file;
        }
    }

    public static class TypeDeclarationHint
    extends PSR0Hint {
        private static final String HINT_ID = "PSR0.Hint.Type";

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new TypeVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.PSR0TypeHintDesc();
        }

        public String getDisplayName() {
            return Bundle.PSR0TypeHintDisp();
        }

        private static final class TypeVisitor
        extends CheckVisitor {
            private static final String PHP_FILE_EXTENSION = ".php";

            public TypeVisitor(PSR0Hint psr0hint, FileObject fileObject, BaseDocument baseDocument) {
                super(psr0hint, fileObject, baseDocument);
            }

            @Override
            public void visit(ClassDeclaration node) {
                this.processTypeDeclaration(node);
                super.visit(node);
            }

            @Override
            public void visit(InterfaceDeclaration node) {
                this.processTypeDeclaration(node);
                super.visit(node);
            }

            @Override
            public void visit(TraitDeclaration node) {
                this.processTypeDeclaration(node);
                super.visit(node);
            }

            private void processTypeDeclaration(TypeDeclaration node) {
                String currentTypeName = CodeUtils.extractTypeName(node);
                String typeNameToPath = currentTypeName.replace('_', File.separatorChar);
                String filePath = this.getFile().getPath();
                if (!filePath.endsWith(typeNameToPath + PHP_FILE_EXTENSION)) {
                    Identifier name = node.getName();
                    this.createHint(name, Bundle.PSR0WrongTypeNameHintText());
                }
            }
        }
    }

    public static class NamespaceDeclarationHint
    extends PSR0Hint {
        private static final String HINT_ID = "PSR0.Hint.Namespace";

        @Override
        CheckVisitor createVisitor(FileObject fileObject, BaseDocument baseDocument) {
            return new NamespaceVisitor(this, fileObject, baseDocument);
        }

        public String getId() {
            return HINT_ID;
        }

        public String getDescription() {
            return Bundle.PSR0NamespaceHintDesc();
        }

        public String getDisplayName() {
            return Bundle.PSR0NamespaceHintDisp();
        }

        private static final class NamespaceVisitor
        extends CheckVisitor {
            public NamespaceVisitor(PSR0Hint psr0hint, FileObject fileObject, BaseDocument baseDocument) {
                super(psr0hint, fileObject, baseDocument);
            }

            @Override
            public void visit(NamespaceDeclaration node) {
                NamespaceName namespaceName = node.getName();
                if (namespaceName != null) {
                    String currentNamespaceName = CodeUtils.extractQualifiedName(namespaceName);
                    String namespaceNameToPath = currentNamespaceName.replace('\\', File.separatorChar);
                    String fileDirPath = this.getFile().getParent();
                    if (!fileDirPath.contains(namespaceNameToPath)) {
                        this.createHint(namespaceName, Bundle.PSR0WrongNamespaceNameHintText());
                    }
                }
                super.visit(node);
            }
        }
    }
}

