/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.util.ImageUtilities;

public class EditorUtils {
    public static final String DEFINE = "define";
    public static final String REQUIRE = "require";
    public static final String REQUIREJS = "requirejs";
    public static final String PATHS = "paths";
    public static final String BASE_URL = "baseUrl";
    public static final String PACKAGES = "packages";
    public static final String CONFIG_METHOD_NAME = "config";
    private static final String REQUIRE_JS_ICON_PATH = "org/netbeans/modules/javascript2/requirejs/resources/requirejs.png";
    private static ImageIcon REQUIREJS_ICON = null;

    public static ImageIcon getRequireJsIcon() {
        if (REQUIREJS_ICON == null) {
            REQUIREJS_ICON = new ImageIcon(ImageUtilities.loadImage((String)REQUIRE_JS_ICON_PATH));
        }
        return REQUIREJS_ICON;
    }

    public static boolean isFileReference(Snapshot snapshot, int offset) {
        CodeCompletionContext context = EditorUtils.findContext(snapshot, offset);
        return context == CodeCompletionContext.CONFIG_BASE_URL_VALUE || context == CodeCompletionContext.CONFIG_PATHS_VALUE || context == CodeCompletionContext.REQUIRE_MODULE;
    }

    public static CodeCompletionContext findContext(Snapshot snapshot, int offset) {
        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)snapshot, (int)offset);
        if (ts == null) {
            return CodeCompletionContext.UNKNOWN;
        }
        ts.move(offset);
        if (ts.moveNext()) {
            Token token = ts.token();
            if (token.id() == JsTokenId.STRING || token.id() == JsTokenId.STRING_END) {
                token = LexUtilities.findPrevious((TokenSequence)ts, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT, JsTokenId.LINE_COMMENT, JsTokenId.STRING_BEGIN, JsTokenId.STRING, JsTokenId.STRING_END, JsTokenId.OPERATOR_COMMA));
                if ((token.id() == JsTokenId.BRACKET_LEFT_BRACKET || token.id() == JsTokenId.OPERATOR_COLON || token.id() == JsTokenId.BRACKET_LEFT_PAREN) && (token = LexUtilities.findPreviousToken((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER))).id() == JsTokenId.IDENTIFIER) {
                    if (DEFINE.equals(token.text().toString()) || REQUIRE.equals(token.text().toString()) || REQUIREJS.equals(token.text().toString())) {
                        return CodeCompletionContext.REQUIRE_MODULE;
                    }
                    if (BASE_URL.equals(token.text().toString())) {
                        return CodeCompletionContext.CONFIG_BASE_URL_VALUE;
                    }
                    if (PATHS.equals(token.text().toString())) {
                        return CodeCompletionContext.CONFIG_PATHS_VALUE;
                    }
                    token = LexUtilities.findPreviousToken((TokenSequence)ts, Arrays.asList(JsTokenId.BRACKET_LEFT_CURLY));
                    if (token.id() == JsTokenId.BRACKET_LEFT_CURLY && (token = LexUtilities.findPreviousToken((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER))).id() == JsTokenId.IDENTIFIER && PATHS.equals(token.text().toString())) {
                        return CodeCompletionContext.CONFIG_PATHS_VALUE;
                    }
                }
            } else {
                List<JsTokenId> listIds = Arrays.asList(JsTokenId.OPERATOR_COMMA, JsTokenId.OPERATOR_COLON, JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.OPERATOR_SEMICOLON, JsTokenId.BRACKET_RIGHT_CURLY);
                token = LexUtilities.findPreviousToken((TokenSequence)ts, listIds);
                boolean commaFirst = false;
                boolean isPropertyName = false;
                int balance = 1;
                while (token.id() == JsTokenId.OPERATOR_COMMA && ts.movePrevious()) {
                    token = LexUtilities.findPreviousToken((TokenSequence)ts, listIds);
                    commaFirst = true;
                    if (token.id() == JsTokenId.BRACKET_RIGHT_CURLY) {
                        while (ts.movePrevious() && balance > 0) {
                            token = ts.token();
                            if (token.id() == JsTokenId.BRACKET_RIGHT_CURLY) {
                                ++balance;
                                continue;
                            }
                            if (token.id() != JsTokenId.BRACKET_LEFT_CURLY) continue;
                            --balance;
                        }
                        token = LexUtilities.findPreviousToken((TokenSequence)ts, listIds);
                    }
                    if (token.id() != JsTokenId.OPERATOR_COLON) continue;
                    isPropertyName = true;
                    break;
                }
                List<JsTokenId> emptyIds = Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.BLOCK_COMMENT);
                if (token.id() == JsTokenId.BRACKET_LEFT_CURLY && ts.movePrevious()) {
                    token = LexUtilities.findPrevious((TokenSequence)ts, emptyIds);
                    if (token.id() == JsTokenId.BRACKET_LEFT_PAREN || token.id() == JsTokenId.OPERATOR_COMMA || token.id() == JsTokenId.OPERATOR_EQUALS) {
                        isPropertyName = true;
                    } else if (token.id() == JsTokenId.BRACKET_RIGHT_PAREN) {
                        balance = 1;
                        while (ts.movePrevious() && balance > 0) {
                            token = ts.token();
                            if (token.id() == JsTokenId.BRACKET_RIGHT_PAREN) {
                                ++balance;
                                continue;
                            }
                            if (token.id() != JsTokenId.BRACKET_LEFT_PAREN) continue;
                            --balance;
                        }
                        if (balance == 0 && (token = LexUtilities.findPrevious((TokenSequence)ts, emptyIds)).id() == JsTokenId.KEYWORD_FUNCTION && ts.movePrevious() && (token = LexUtilities.findPrevious((TokenSequence)ts, emptyIds)).id() == JsTokenId.OPERATOR_COLON) {
                            isPropertyName = commaFirst;
                        }
                    }
                }
                if (isPropertyName) {
                    if (token.id() == JsTokenId.OPERATOR_COLON) {
                        balance = 1;
                        while (ts.movePrevious() && balance > 0) {
                            token = ts.token();
                            if (token.id() == JsTokenId.BRACKET_RIGHT_CURLY) {
                                ++balance;
                                continue;
                            }
                            if (token.id() != JsTokenId.BRACKET_LEFT_CURLY) continue;
                            --balance;
                        }
                        token = LexUtilities.findPrevious((TokenSequence)ts, emptyIds);
                    }
                    if (token.id() == JsTokenId.BRACKET_LEFT_PAREN && ts.movePrevious() && (token = LexUtilities.findPrevious((TokenSequence)ts, emptyIds)).id() == JsTokenId.IDENTIFIER && CONFIG_METHOD_NAME.equals(token.text().toString())) {
                        return CodeCompletionContext.CONFIG_PROPERTY_NAME;
                    }
                }
            }
        }
        return CodeCompletionContext.UNKNOWN;
    }

    public static Collection<String> getUsedFileInDefine(Snapshot shanpshot, int offset) {
        TokenSequence ts = LexUtilities.getJsTokenSequence((Snapshot)shanpshot, (int)offset);
        if (ts == null) {
            return Collections.emptyList();
        }
        ts.move(0);
        if (!ts.moveNext()) {
            return Collections.emptyList();
        }
        Token token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER));
        while (token.id() == JsTokenId.IDENTIFIER && !DEFINE.equals(token.text().toString()) && ts.moveNext()) {
            token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER));
        }
        if (token.id() == JsTokenId.IDENTIFIER && DEFINE.equals(token.text().toString())) {
            ArrayList<String> paths = new ArrayList<String>();
            token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.BRACKET_LEFT_BRACKET, JsTokenId.KEYWORD_FUNCTION, JsTokenId.BRACKET_LEFT_CURLY, JsTokenId.BRACKET_RIGHT_PAREN));
            if (token.id() == JsTokenId.BRACKET_LEFT_BRACKET) {
                do {
                    if ((token = LexUtilities.findNextToken((TokenSequence)ts, Arrays.asList(JsTokenId.STRING, JsTokenId.OPERATOR_COMMA, JsTokenId.BRACKET_RIGHT_PAREN))).id() != JsTokenId.STRING) continue;
                    paths.add(token.text().toString());
                } while (token.id() != JsTokenId.BRACKET_RIGHT_PAREN && token.id() != JsTokenId.OPERATOR_SEMICOLON && !((JsTokenId)token.id()).isKeyword() && ts.moveNext());
                return paths;
            }
        }
        return Collections.emptyList();
    }

    public static enum CodeCompletionContext {
        CONFIG_BASE_URL_VALUE,
        CONFIG_PATHS_VALUE,
        CONFIG_PROPERTY_NAME,
        REQUIRE_MODULE,
        UNKNOWN;

    }
}

