/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.javascript2.editor.model.TypeUsage;
import org.netbeans.modules.javascript2.editor.spi.model.ModelElementFactory;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class RequireJsIndex {
    private static final Logger LOGGER = Logger.getLogger(RequireJsIndex.class.getSimpleName());
    private final QuerySupport querySupport;
    private static final Map<Project, RequireJsIndex> INDEXES = new WeakHashMap<Project, RequireJsIndex>();
    private static boolean areProjectsOpen = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RequireJsIndex get(Project project) throws IOException {
        if (project == null) {
            return null;
        }
        Map<Project, RequireJsIndex> map = INDEXES;
        synchronized (map) {
            RequireJsIndex index = INDEXES.get(project);
            if (index == null) {
                if (!areProjectsOpen) {
                    try {
                        OpenProjects.getDefault().openProjects().get();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        areProjectsOpen = true;
                    }
                }
                Collection sourceRoots = QuerySupport.findRoots((Project)project, null, Collections.emptyList(), Collections.emptyList());
                QuerySupport querySupport = QuerySupport.forRoots((String)"requirejs", (int)1, (FileObject[])sourceRoots.toArray(new FileObject[0]));
                index = new RequireJsIndex(querySupport);
                if (sourceRoots.size() > 0) {
                    INDEXES.put(project, index);
                }
            }
            return index;
        }
    }

    private RequireJsIndex(QuerySupport querySupport) throws IOException {
        this.querySupport = querySupport;
    }

    public Collection<? extends TypeUsage> getExposedTypes(String module, ModelElementFactory factory) {
        Collection result = null;
        String moduleName = module;
        String[] parts = moduleName.split("/");
        if (parts.length > 0) {
            moduleName = parts[parts.length - 1];
        }
        try {
            result = this.querySupport.query("mn", moduleName, QuerySupport.Kind.PREFIX, new String[]{"mn", "et"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            ArrayList<TypeUsage> types = new ArrayList<TypeUsage>();
            for (IndexResult indexResult : result) {
                String[] values = indexResult.getValues("et");
                String mn = indexResult.getValue("mn");
                if (!mn.equals(moduleName)) continue;
                for (String stype : values) {
                    String[] typeParts = stype.split(":");
                    String typeName = typeParts[0];
                    int offset = Integer.parseInt(typeParts[1]);
                    boolean resolved = "1".equals(typeParts[2]);
                    types.add(factory.newType(typeName, offset, resolved));
                }
            }
            return types;
        }
        return Collections.emptyList();
    }

    public Map<String, String> getPathMappings(String prefix) {
        Collection result = null;
        try {
            result = this.querySupport.query("mp", prefix, QuerySupport.Kind.PREFIX, new String[]{"mp"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            HashMap<String, String> mappings = new HashMap<String, String>();
            for (IndexResult indexResult : result) {
                for (String value : indexResult.getValues("mp")) {
                    String[] parts = value.split(";");
                    if (parts.length != 2 || !parts[0].startsWith(prefix)) continue;
                    mappings.put(parts[0], parts[1]);
                }
            }
            return mappings;
        }
        return Collections.emptyMap();
    }

    public Collection<String> getBasePaths() {
        Collection result = null;
        try {
            result = this.querySupport.query("bp", "", QuerySupport.Kind.PREFIX, new String[]{"bp"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            ArrayList<String> paths = new ArrayList<String>();
            for (IndexResult indexResult : result) {
                paths.addAll(Arrays.asList(indexResult.getValues("bp")));
            }
            return paths;
        }
        return Collections.emptyList();
    }

    public Collection<String> getUsedPlugins() {
        Collection result = null;
        try {
            result = this.querySupport.query("up", "", QuerySupport.Kind.PREFIX, new String[]{"up"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            HashSet<String> plugins = new HashSet<String>();
            for (IndexResult indexResult : result) {
                String[] values = indexResult.getValues("up");
                for (int i = 0; i < values.length; ++i) {
                    String pluginNames = values[i];
                    String[] names = pluginNames.split(";");
                    for (int j = 0; j < names.length; ++j) {
                        String name = names[j];
                        if (plugins.contains(name)) continue;
                        plugins.add(name);
                    }
                }
            }
            return plugins;
        }
        return Collections.emptyList();
    }

    public Map<String, String> getPackages() {
        Collection result = null;
        try {
            result = this.querySupport.query("pk", "", QuerySupport.Kind.PREFIX, new String[]{"pk"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            HashMap<String, String> mappings = new HashMap<String, String>();
            for (IndexResult indexResult : result) {
                for (String value : indexResult.getValues("pk")) {
                    String[] parts = value.split(";");
                    if (parts.length != 2) continue;
                    mappings.put(parts[0], parts[1]);
                }
            }
            return mappings;
        }
        return Collections.emptyMap();
    }

    public Collection<String> getSourceRoots() {
        Collection result = null;
        try {
            result = this.querySupport.query("sr", "", QuerySupport.Kind.PREFIX, new String[]{"sr"});
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (result != null && !result.isEmpty()) {
            HashSet<String> paths = new HashSet<String>();
            for (IndexResult indexResult : result) {
                paths.addAll(Arrays.asList(indexResult.getValues("sr")));
            }
            return paths;
        }
        return Collections.emptyList();
    }
}

