/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.netbeans.modules.web.javascript.debugger.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.DOMBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.EventsBreakpoint;
import org.netbeans.modules.web.javascript.debugger.breakpoints.WebKitBreakpointManager;
import org.netbeans.modules.web.javascript.debugger.breakpoints.XHRBreakpoint;
import org.netbeans.modules.web.javascript.debugger.browser.ProjectContext;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class BreakpointRuntimeSetter
extends LazyActionsManagerListener
implements LazyDebuggerManagerListener {
    public static final RequestProcessor RP = new RequestProcessor("Breakpoint updater");
    private final Debugger d;
    private final WebKitDebugging wd;
    private final ProjectContext pc;
    private final List<FileObject> projectSourceRoots;
    private final Map<Breakpoint, WebKitBreakpointManager> breakpointImpls = new HashMap<Breakpoint, WebKitBreakpointManager>();

    public BreakpointRuntimeSetter(ContextProvider lookupProvider) {
        this.d = (Debugger)lookupProvider.lookupFirst(null, Debugger.class);
        this.wd = (WebKitDebugging)lookupProvider.lookupFirst(null, WebKitDebugging.class);
        this.pc = (ProjectContext)lookupProvider.lookupFirst(null, ProjectContext.class);
        Project prj = this.pc.getProject();
        this.projectSourceRoots = prj == null ? null : BreakpointRuntimeSetter.getProjectSourceRoots(prj);
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)this);
        this.createBreakpointImpls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBreakpointImpls() {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<WebKitBreakpointManager> toAdd = new ArrayList<WebKitBreakpointManager>();
        Map<Breakpoint, WebKitBreakpointManager> map = this.breakpointImpls;
        synchronized (map) {
            for (Breakpoint breakpoint : breakpoints) {
                AbstractBreakpoint ab;
                WebKitBreakpointManager bm;
                JSLineBreakpoint lb;
                if (breakpoint instanceof JSLineBreakpoint && this.acceptBreakpoint(lb = (JSLineBreakpoint)breakpoint) && !this.breakpointImpls.containsKey(lb)) {
                    bm = this.createWebKitBreakpointManager(lb);
                    this.breakpointImpls.put((Breakpoint)lb, bm);
                    toAdd.add(bm);
                }
                if (!(breakpoint instanceof AbstractBreakpoint) || this.breakpointImpls.containsKey((Object)(ab = (AbstractBreakpoint)breakpoint))) continue;
                bm = this.createWebKitBreakpointManager(ab);
                this.breakpointImpls.put(ab, bm);
                toAdd.add(bm);
            }
        }
        for (WebKitBreakpointManager bm : toAdd) {
            if (!bm.canAdd()) continue;
            bm.add();
        }
    }

    private WebKitBreakpointManager createWebKitBreakpointManager(JSLineBreakpoint lb) {
        return WebKitBreakpointManager.create(this.d, this.pc, lb);
    }

    private WebKitBreakpointManager createWebKitBreakpointManager(AbstractBreakpoint ab) {
        if (ab instanceof DOMBreakpoint) {
            return WebKitBreakpointManager.create(this.wd, this.pc, (DOMBreakpoint)ab);
        }
        if (ab instanceof EventsBreakpoint) {
            return WebKitBreakpointManager.create(this.d, (EventsBreakpoint)ab);
        }
        if (ab instanceof XHRBreakpoint) {
            return WebKitBreakpointManager.create(this.d, (XHRBreakpoint)ab);
        }
        throw new IllegalArgumentException("Unknown breakpoint: " + (Object)((Object)ab));
    }

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointAdded(Breakpoint breakpoint) {
        JSLineBreakpoint lb = null;
        AbstractBreakpoint ab = null;
        if (breakpoint instanceof JSLineBreakpoint) {
            lb = (JSLineBreakpoint)breakpoint;
            if (!this.acceptBreakpoint(lb)) {
                return;
            }
        } else if (breakpoint instanceof AbstractBreakpoint) {
            ab = (AbstractBreakpoint)breakpoint;
        } else {
            return;
        }
        Object b = lb != null ? lb : ab;
        Map<Breakpoint, WebKitBreakpointManager> map = this.breakpointImpls;
        synchronized (map) {
            if (this.breakpointImpls.containsKey(b)) {
                return;
            }
        }
        final WebKitBreakpointManager bm = lb != null ? this.createWebKitBreakpointManager(lb) : this.createWebKitBreakpointManager(ab);
        Map<Breakpoint, WebKitBreakpointManager> map2 = this.breakpointImpls;
        synchronized (map2) {
            if (this.breakpointImpls.containsKey(b)) {
                bm.destroy();
                return;
            }
            this.breakpointImpls.put((Breakpoint)b, bm);
        }
        if (b.isEnabled()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    bm.add();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemoved(Breakpoint breakpoint) {
        WebKitBreakpointManager bm;
        if (!(breakpoint instanceof AbstractBreakpoint) && !(breakpoint instanceof JSLineBreakpoint)) {
            return;
        }
        Map<Breakpoint, WebKitBreakpointManager> map = this.breakpointImpls;
        synchronized (map) {
            bm = this.breakpointImpls.remove(breakpoint);
        }
        if (bm != null) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    bm.destroy();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        ArrayList<WebKitBreakpointManager> toDestroy;
        DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this);
        Map<Breakpoint, WebKitBreakpointManager> map = this.breakpointImpls;
        synchronized (map) {
            toDestroy = new ArrayList<WebKitBreakpointManager>(this.breakpointImpls.values());
            this.breakpointImpls.clear();
        }
        for (WebKitBreakpointManager bm : toDestroy) {
            bm.destroy();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private static List<FileObject> getProjectSourceRoots(Project project) {
        LinkedHashSet<FileObject> sources = new LinkedHashSet<FileObject>();
        sources.addAll(BreakpointRuntimeSetter.getProjectSourceRoots(project, "HTML5-SiteRoot"));
        sources.addAll(BreakpointRuntimeSetter.getProjectSourceRoots(project, "HTML5-Tests"));
        sources.addAll(BreakpointRuntimeSetter.getProjectSourceRoots(project, "HTML5-Tests-Selenium"));
        return new ArrayList<FileObject>(sources);
    }

    private static List<FileObject> getProjectSourceRoots(Project project, String type) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups(type);
        ArrayList<FileObject> roots = new ArrayList<FileObject>(sourceGroups.length);
        for (SourceGroup sourceGroup : sourceGroups) {
            FileObject rootFolder = sourceGroup.getRootFolder();
            roots.add(rootFolder);
        }
        if (roots.isEmpty()) {
            roots.add(project.getProjectDirectory());
        }
        return roots;
    }

    private boolean acceptBreakpoint(JSLineBreakpoint lb) {
        FileObject fo = lb.getFileObject();
        if (fo == null) {
            return false;
        }
        if (RemoteFileCache.isRemoteFile((FileObject)fo) != null) {
            return true;
        }
        if (FileUtil.toFile((FileObject)fo) == null) {
            return true;
        }
        if (this.projectSourceRoots == null) {
            return true;
        }
        boolean isInPrjSources = false;
        for (FileObject psr : this.projectSourceRoots) {
            if (!FileUtil.isParentOf((FileObject)psr, (FileObject)fo)) continue;
            isInPrjSources = true;
            break;
        }
        return isInPrjSources;
    }
}

