/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.breakpoints;

import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.web.common.api.RemoteFileCache;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.openide.filesystems.FileObject;

class LineBreakpointUtils {
    LineBreakpointUtils() {
    }

    static String getURLStringToPersist(JSLineBreakpoint lb) {
        return LineBreakpointUtils.getURLStringImpl(lb, null, null, false);
    }

    static String getURLString(JSLineBreakpoint lb, Project p, URL urlConnectionBeingDebugged) {
        return LineBreakpointUtils.getURLStringImpl(lb, p, urlConnectionBeingDebugged, true);
    }

    private static String getURLStringImpl(JSLineBreakpoint lb, Project p, URL urlConnectionBeingDebugged, boolean applyInternalServerMapping) {
        String url;
        FileObject fo = (FileObject)lb.getLine().getLookup().lookup(FileObject.class);
        URL remoteURL = RemoteFileCache.isRemoteFile((FileObject)fo);
        if (remoteURL == null) {
            if (applyInternalServerMapping && p != null) {
                URL internalServerURL2;
                assert (urlConnectionBeingDebugged != null);
                URL internalServerURL = ServerURLMapping.toServer((Project)p, (int)1, (FileObject)fo);
                boolean useTestingContext = false;
                if (internalServerURL == null) {
                    useTestingContext = true;
                } else if (!internalServerURL.getHost().equals(urlConnectionBeingDebugged.getHost()) || internalServerURL.getPort() != urlConnectionBeingDebugged.getPort()) {
                    useTestingContext = true;
                }
                if (useTestingContext && p != null && (internalServerURL2 = ServerURLMapping.toServer((Project)p, (int)2, (FileObject)fo)) != null && (internalServerURL2.getHost().equals(urlConnectionBeingDebugged.getHost()) || internalServerURL2.getPort() == urlConnectionBeingDebugged.getPort())) {
                    internalServerURL = internalServerURL2;
                }
                if (internalServerURL != null) {
                    return internalServerURL.toExternalForm();
                }
            }
            url = fo.toURL().toExternalForm();
        } else {
            url = remoteURL.toExternalForm();
        }
        return url;
    }
}

