/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.eval.ui;

import java.util.List;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.modules.web.javascript.debugger.eval.ui.Bundle;
import org.netbeans.modules.web.javascript.debugger.locals.VariablesModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.CodeEvaluator;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class EvaluationResultsModel
extends VariablesModel {
    private static final String ICON_HISTORY_NODE = "org/netbeans/modules/debugger/resources/evaluator/history_node_16.png";
    private static final String ICON_HISTORY_ITEM = "org/netbeans/modules/debugger/resources/evaluator/eval_history_item.png";
    private static final String ICON_EVAL_RESULT = "org/netbeans/modules/debugger/resources/evaluator/evaluator_result_16.png";
    private static final RequestProcessor RP = new RequestProcessor(EvaluationResultsModel.class);
    private final CodeEvaluator.Result result;
    private EvaluatorListener evalListener = new EvaluatorListener();

    public EvaluationResultsModel(ContextProvider contextProvider) {
        super(contextProvider);
        this.result = CodeEvaluator.Result.get((DebuggerEngine)((DebuggerEngine)contextProvider.lookupFirst(null, DebuggerEngine.class)));
        this.result.addListener((CodeEvaluator.Result.Listener)this.evalListener);
    }

    @Override
    public int getChildrenCount(Object parent) throws UnknownTypeException {
        if (parent instanceof HistoryNode) {
            return ((HistoryNode)parent).getItems().size();
        }
        if (parent == "Root") {
            return 2;
        }
        return super.getChildrenCount(parent);
    }

    @Override
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent instanceof HistoryNode) {
            List<CodeEvaluator.Result.DefaultHistoryItem> l = ((HistoryNode)parent).getItems();
            for (CodeEvaluator.Result.DefaultHistoryItem o : l) {
                if (o instanceof CodeEvaluator.Result.DefaultHistoryItem) continue;
                return new Object[0];
            }
            return l.toArray();
        }
        if (parent == "Root") {
            if (this.result != null) {
                Object result = this.result.getResult();
                List items = this.result.getHistoryItems();
                int count = 0;
                if (result != null) {
                    ++count;
                }
                if (items.size() > 0) {
                    ++count;
                }
                Object[] children = new Object[count];
                int index = 0;
                if (result != null) {
                    children[index++] = result;
                }
                if (items.size() > 0) {
                    children[index] = new HistoryNode(items);
                }
                return children;
            }
            return new Object[0];
        }
        return super.getChildren(parent, from, to);
    }

    @Override
    public boolean isLeaf(Object node) throws UnknownTypeException {
        if ("Root".equals(node)) {
            return false;
        }
        if (node instanceof HistoryNode) {
            return false;
        }
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            return true;
        }
        return super.isLeaf(node);
    }

    @Override
    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            return ((CodeEvaluator.Result.DefaultHistoryItem)node).getExpression();
        }
        if (node instanceof HistoryNode) {
            return Bundle.CTL_EvaluatorHistoryNode();
        }
        return super.getDisplayName(node);
    }

    @Override
    public String getShortDescription(Object node) throws UnknownTypeException {
        String str;
        if (node == this.result.getResult() && (str = this.result.getExpression()) != null) {
            StringBuffer buf = new StringBuffer();
            buf.append("<html>");
            str = str.replaceAll("&", "&amp;");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
            str = str.replaceAll("\n", "<br/>");
            str = str.replaceAll("\r", "");
            buf.append(str);
            buf.append("</html>");
            return buf.toString();
        }
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            return ((CodeEvaluator.Result.DefaultHistoryItem)node).getTooltip();
        }
        if (node instanceof HistoryNode) {
            return Bundle.CTL_EvaluatorHistoryNodeDescr();
        }
        return super.getShortDescription(node);
    }

    @Override
    public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
        if (node == this.result.getResult()) {
            return ICON_EVAL_RESULT;
        }
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            return ICON_HISTORY_ITEM;
        }
        if (node instanceof HistoryNode) {
            return ICON_HISTORY_NODE;
        }
        return super.getIconBaseWithExtension(node);
    }

    @Override
    public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem) {
            CodeEvaluator.Result.DefaultHistoryItem item = (CodeEvaluator.Result.DefaultHistoryItem)node;
            if ("LocalsToString".equals(columnID)) {
                return item.getToStringValue();
            }
            if ("LocalsType".equals(columnID)) {
                return item.getType();
            }
            if ("LocalsValue".equals(columnID)) {
                return item.getValue();
            }
            return "";
        }
        if (node instanceof HistoryNode) {
            return "";
        }
        return super.getValueAt(node, columnID);
    }

    @Override
    public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem || node instanceof HistoryNode) {
            return true;
        }
        return super.isReadOnly(node, columnID);
    }

    @Override
    public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        if (node instanceof CodeEvaluator.Result.DefaultHistoryItem || node instanceof HistoryNode) {
            return;
        }
        super.setValueAt(node, columnID, value);
    }

    public void fireNodeChanged(Object node) {
        this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSelectionChanged(final Object result) {
        ModelListener[] ls;
        List list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new ModelListener[0]);
        }
        ModelEvent.SelectionChanged ev = new ModelEvent.SelectionChanged((Object)this, new Object[0]);
        for (int i = 0; i < ls.length; ++i) {
            ls[i].modelChanged((ModelEvent)ev);
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                ModelEvent.SelectionChanged ev = new ModelEvent.SelectionChanged((Object)EvaluationResultsModel.this, new Object[]{result});
                for (int i = 0; i < ls.length; ++i) {
                    ls[i].modelChanged((ModelEvent)ev);
                }
            }
        }, 500);
    }

    private class EvaluatorListener
    implements CodeEvaluator.Result.Listener<VariablesModel.ScopedRemoteObject> {
        private EvaluatorListener() {
        }

        public void resultChanged(VariablesModel.ScopedRemoteObject o) {
            EvaluationResultsModel.this.fireNodeChanged("Root");
            EvaluationResultsModel.this.fireSelectionChanged(o);
        }
    }

    private static class HistoryNode {
        private final List<CodeEvaluator.Result.DefaultHistoryItem> items;

        HistoryNode(List<CodeEvaluator.Result.DefaultHistoryItem> items) {
            this.items = items;
        }

        List<CodeEvaluator.Result.DefaultHistoryItem> getItems() {
            return this.items;
        }
    }
}

