/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.javascript.debugger.sessions;

import java.util.List;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.javascript2.debug.models.ViewModelSupport;
import org.netbeans.modules.web.javascript.debugger.sessions.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.Debugger;
import org.netbeans.modules.web.webkit.debugging.api.debugger.CallFrame;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public final class SessionsModel
extends ViewModelSupport
implements TableModelFilter,
Debugger.Listener {
    private Debugger d;

    public Object getValueAt(TableModel original, Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Session && SessionsModel.isDebuggerSession((Session)row) && "SessionState".equals(columnID)) {
            return this.getSessionState((Session)row);
        }
        return original.getValueAt(row, columnID);
    }

    public boolean isReadOnly(TableModel original, Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Session && SessionsModel.isDebuggerSession((Session)row) && "SessionState".equals(columnID)) {
            return true;
        }
        return original.isReadOnly(row, columnID);
    }

    public void setValueAt(TableModel original, Object row, String columnID, Object value) throws UnknownTypeException {
        original.setValueAt(row, columnID, value);
    }

    private static boolean isDebuggerSession(Session s) {
        DebuggerEngine e = s.getCurrentEngine();
        if (e == null) {
            return false;
        }
        return e.lookupFirst(null, Debugger.class) != null;
    }

    private Object getSessionState(Session s) {
        Debugger debugger = (Debugger)s.getCurrentEngine().lookupFirst(null, Debugger.class);
        if (debugger == null) {
            return "";
        }
        if (this.d == null) {
            this.d = debugger;
            this.d.addListener((Debugger.Listener)this);
        }
        if (debugger.isEnabled()) {
            if (debugger.isSuspended()) {
                return Bundle.Session_paused();
            }
            return Bundle.Session_running();
        }
        return Bundle.Session_none();
    }

    public void paused(List<CallFrame> callStack, String reason) {
        this.refresh();
    }

    public void resumed() {
        this.refresh();
    }

    public void reset() {
    }

    public void enabled(boolean enabled) {
    }
}

