/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.mixeddev;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmSymbolResolver;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.openide.util.Pair;

public final class MixedDevUtils {
    public static final String DOT = ".";
    public static final String COMMA = ",";
    public static final String LPAREN = "(";
    public static final String RPAREN = ")";
    public static final String SCOPE = "::";
    public static final String POINTER = "*";

    public static String stringize(Collection<? extends CharSequence> collection, CharSequence separator) {
        boolean first = true;
        StringBuilder result = new StringBuilder();
        for (CharSequence charSequence : collection) {
            if (!first) {
                result.append(separator);
            } else {
                first = false;
            }
            result.append(charSequence);
        }
        return result.toString();
    }

    public static String repeat(String pattern, int times) {
        StringBuilder sb = new StringBuilder();
        while (times-- > 0) {
            sb.append(pattern);
        }
        return sb.toString();
    }

    public static <K, V> Map<K, V> createMapping(Pair<K, V> ... pairs) {
        HashMap<Object, Object> mapping = new HashMap<Object, Object>();
        for (Pair<K, V> pair : pairs) {
            mapping.put(pair.first(), pair.second());
        }
        return Collections.unmodifiableMap(mapping);
    }

    public static <F, T> T[] transform(F[] from, Converter<F, T> converter, Class<T> toClass) {
        Object[] to = (Object[])Array.newInstance(toClass, from.length);
        for (int i = 0; i < from.length; ++i) {
            to[i] = converter.convert(from[i]);
        }
        return to;
    }

    public static <F, T> List<T> transform(List<F> from, Converter<F, T> converter) {
        ArrayList<T> to = new ArrayList<T>(from.size());
        for (F f : from) {
            to.add(converter.convert(f));
        }
        return to;
    }

    public static <T> List<T> toList(Iterable<T> iterable) {
        ArrayList<T> result = new ArrayList<T>();
        for (T t : iterable) {
            result.add(t);
        }
        return result;
    }

    public static Iterable<NativeProject> findNativeProjects() {
        final Project[] projects = OpenProjects.getDefault().getOpenProjects();
        return new Iterable<NativeProject>(){

            @Override
            public Iterator<NativeProject> iterator() {
                return new Iterator<NativeProject>(){
                    private int i = 0;
                    private NativeProject nextProject = this.findNext();

                    @Override
                    public boolean hasNext() {
                        return this.nextProject != null;
                    }

                    @Override
                    public NativeProject next() {
                        NativeProject current = this.nextProject;
                        this.nextProject = this.findNext();
                        return current;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported.");
                    }

                    private NativeProject findNext() {
                        NativeProject nativeProject = null;
                        while (nativeProject == null && this.i < projects.length) {
                            nativeProject = (NativeProject)projects[this.i].getLookup().lookup(NativeProject.class);
                            ++this.i;
                        }
                        return nativeProject;
                    }
                };
            }
        };
    }

    public static CsmOffsetable findCppSymbol(String[] cppNames) {
        if (cppNames != null) {
            for (NativeProject nativeProject : MixedDevUtils.findNativeProjects()) {
                for (String cppName : cppNames) {
                    Collection candidates = CsmSymbolResolver.resolveSymbol((NativeProject)nativeProject, (CharSequence)cppName);
                    if (candidates.isEmpty()) continue;
                    return (CsmOffsetable)candidates.iterator().next();
                }
            }
        }
        return null;
    }

    private MixedDevUtils() {
        throw new AssertionError((Object)"Not instantiable");
    }

    public static interface Converter<F, T> {
        public T convert(F var1);
    }
}

