/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.server.GrailsInstance;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;

public final class GrailsInstanceProvider
implements ServerInstanceProvider {
    private static final ExecutorService PROCESS_EXECUTOR = Executors.newCachedThreadPool();
    private static GrailsInstanceProvider instance;
    private final Map<Process, Project> running = new HashMap<Process, Project>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private GrailsInstance grailsInstance;

    private GrailsInstanceProvider() {
    }

    public static synchronized GrailsInstanceProvider getInstance() {
        if (instance == null) {
            instance = new GrailsInstanceProvider();
            GrailsInstanceProvider.instance.grailsInstance = GrailsInstance.forProvider(instance);
        }
        return instance;
    }

    public List<ServerInstance> getInstances() {
        if (!GrailsPlatform.getDefault().isConfigured()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)this.grailsInstance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Process, Project> getRunningProjects() {
        GrailsInstanceProvider grailsInstanceProvider = this;
        synchronized (grailsInstanceProvider) {
            return new HashMap<Process, Project>(this.running);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStarted(Project project, Process process) {
        assert (process != null);
        GrailsInstanceProvider grailsInstanceProvider = this;
        synchronized (grailsInstanceProvider) {
            this.running.put(process, project);
            PROCESS_EXECUTOR.submit(new ProcessHandler(this, process));
        }
        this.grailsInstance.refreshChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverStopped(Process process) {
        GrailsInstanceProvider grailsInstanceProvider = this;
        synchronized (grailsInstanceProvider) {
            this.running.remove(process);
        }
        this.grailsInstance.refreshChildren();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runtimeChanged() {
        GrailsInstanceProvider grailsInstanceProvider = this;
        synchronized (grailsInstanceProvider) {
            this.running.clear();
        }
        this.grailsInstance.refreshNode();
        this.grailsInstance.refreshChildren();
        this.changeSupport.fireChange();
    }

    private static class ProcessHandler
    implements Runnable {
        private final GrailsInstanceProvider provider;
        private final Process serverProcess;

        public ProcessHandler(GrailsInstanceProvider provider, Process serverProcess) {
            this.provider = provider;
            this.serverProcess = serverProcess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.serverProcess.waitFor();
            }
            catch (InterruptedException ex) {
                this.serverProcess.destroy();
            }
            finally {
                this.provider.serverStopped(this.serverProcess);
            }
        }
    }
}

