/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.analysis.api.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.cnd.analysis.api.AbstractCustomizerProvider;
import org.netbeans.modules.cnd.analysis.api.AbstractHintsPanel;
import org.netbeans.modules.cnd.analysis.api.CodeAuditProviderImpl;
import org.netbeans.modules.cnd.analysis.api.options.HintsPanelLogic;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditProvider;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ui.NamedOption;
import org.netbeans.modules.options.editor.spi.OptionsFilter;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class HintsPanel
extends AbstractHintsPanel
implements TreeCellRenderer {
    private final DefaultTreeCellRenderer dr = new DefaultTreeCellRenderer();
    private final JCheckBox renderer = new JCheckBox();
    private HintsPanelLogic logic;
    private final ExtendedModel model;
    private static final RequestProcessor WORKER = new RequestProcessor(HintsPanel.class.getName(), 1, false, false);
    private final RequestProcessor.Task expandTask = WORKER.create(new Runnable(){

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JTree tree = HintsPanel.this.errorTree;
                    for (int r = 0; r < tree.getRowCount(); ++r) {
                        tree.expandRow(r);
                    }
                }
            });
        }
    });
    private JPanel customizerPanel;
    private JLabel descriptionLabel;
    private JPanel descriptionPanel;
    private JEditorPane descriptionTextArea;
    private JPanel detailsPanel;
    private JTree errorTree;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JPanel optionsPanel;
    private JComboBox severityComboBox;
    private JLabel severityLabel;
    private JPanel treePanel;

    public HintsPanel(Lookup masterLookup, CodeAuditProvider selection, String mimeType) {
        assert (mimeType != null);
        this.initComponents();
        this.descriptionTextArea.setContentType("text/html");
        this.errorTree.setCellRenderer(this);
        this.errorTree.setRootVisible(false);
        this.errorTree.setShowsRootHandles(true);
        this.errorTree.getSelectionModel().setSelectionMode(1);
        this.model = new ExtendedModel(selection, mimeType);
        OptionsFilter filter = null;
        if (masterLookup != null) {
            filter = (OptionsFilter)masterLookup.lookup(OptionsFilter.class);
        }
        if (filter != null) {
            filter.installFilteringModel(this.errorTree, (TreeModel)this.model, (OptionsFilter.Acceptor)new AcceptorImpl());
        } else {
            this.errorTree.setModel(this.model);
        }
        this.logic = new HintsPanelLogic();
        this.logic.connect(this.errorTree, this.model, this.severityLabel, this.severityComboBox, this.customizerPanel, this.descriptionTextArea);
    }

    void selectPath(String path) {
        TreePath treePath = null;
        block0: for (DefaultMutableTreeNode node : this.model.audits) {
            String providerID;
            Object provider = node.getUserObject();
            if (!(provider instanceof CodeAuditProviderProxy) || !path.startsWith(providerID = ((CodeAuditProviderProxy)provider).getName())) continue;
            treePath = new TreePath(new Object[]{this.model.getRoot(), node});
            if ((path = path.substring(providerID.length())).length() <= 1) break;
            path = path.substring(1);
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                String name;
                Object audit;
                TreeNode sub = children.nextElement();
                if (!(sub instanceof DefaultMutableTreeNode) || !((audit = ((DefaultMutableTreeNode)sub).getUserObject()) instanceof CodeAuditProxy) || !path.startsWith(name = ((CodeAuditProxy)audit).getID())) continue;
                treePath = new TreePath(new Object[]{this.model.getRoot(), node, sub});
                break block0;
            }
            break block0;
        }
        if (treePath != null) {
            this.errorTree.setSelectionPath(treePath);
            this.errorTree.scrollPathToVisible(treePath);
            this.errorTree.requestFocusInWindow();
        }
    }

    @Override
    public void setSettings(Preferences settings) {
        CndUtils.assertTrueInConsole((boolean)false, (String)"Method is not implemented");
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.treePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.errorTree = new JTree();
        this.detailsPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.severityLabel = new JLabel();
        this.severityComboBox = new JComboBox();
        this.customizerPanel = new JPanel();
        this.descriptionPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.descriptionTextArea = new JEditorPane();
        this.descriptionLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setPreferredSize(new Dimension(400, 400));
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setPreferredSize(new Dimension(400, 400));
        this.treePanel.setOpaque(false);
        this.treePanel.setPreferredSize(new Dimension(200, 400));
        this.treePanel.setLayout(new BorderLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.errorTree);
        this.errorTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleName"));
        this.errorTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.errorTree.AccessibleContext.accessibleDescription"));
        this.treePanel.add((Component)this.jScrollPane1, "Center");
        this.jSplitPane1.setLeftComponent(this.treePanel);
        this.detailsPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.detailsPanel.setOpaque(false);
        this.detailsPanel.setPreferredSize(new Dimension(200, 400));
        this.detailsPanel.setLayout(new BorderLayout());
        this.optionsPanel.setOpaque(false);
        this.optionsPanel.setPreferredSize(new Dimension(200, 200));
        this.severityLabel.setLabelFor(this.severityComboBox);
        Mnemonics.setLocalizedText((JLabel)this.severityLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_ShowAs_Label"));
        this.customizerPanel.setOpaque(false);
        this.customizerPanel.setLayout(new BorderLayout());
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.customizerPanel, -1, -1, Short.MAX_VALUE).addGroup(optionsPanelLayout.createSequentialGroup().addComponent(this.severityLabel).addGap(18, 18, 18).addComponent(this.severityComboBox, -2, 249, -2).addGap(0, 91, Short.MAX_VALUE))).addContainerGap()));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.severityLabel).addComponent(this.severityComboBox, -2, -1, -2)).addGap(8, 8, 8).addComponent(this.customizerPanel, -1, 152, Short.MAX_VALUE).addContainerGap()));
        this.severityLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.severityLabel.AccessibleContext.accessibleDescription"));
        this.severityComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"AN_Show_As_Combo"));
        this.severityComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"AD_Show_As_Combo"));
        this.detailsPanel.add((Component)this.optionsPanel, "Center");
        this.descriptionPanel.setOpaque(false);
        this.descriptionPanel.setPreferredSize(new Dimension(200, 200));
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setPreferredSize(new Dimension(100, 50));
        this.jScrollPane2.setViewportView(this.descriptionTextArea);
        this.descriptionLabel.setLabelFor(this.descriptionTextArea);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(HintsPanel.class, (String)"CTL_Description_Border"));
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(descriptionPanelLayout.createSequentialGroup().addComponent(this.descriptionLabel).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -1, 428, Short.MAX_VALUE));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(descriptionPanelLayout.createSequentialGroup().addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 177, Short.MAX_VALUE)));
        this.jScrollPane2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.jScrollPane2.AccessibleContext.accessibleName"));
        this.detailsPanel.add((Component)this.descriptionPanel, "South");
        this.jSplitPane1.setRightComponent(this.detailsPanel);
        this.add((Component)this.jSplitPane1, "Center");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HintsPanel.class, (String)"HintsPanel.AccessibleContext.accessibleDescription"));
    }

    final synchronized void update() {
        if (this.logic != null) {
            this.logic.disconnect();
        }
        this.logic = new HintsPanelLogic();
        this.logic.connect(this.errorTree, this.model, this.severityLabel, this.severityComboBox, this.customizerPanel, this.descriptionTextArea);
    }

    void cancel() {
        this.logic.cancel();
        this.logic.disconnect();
        this.logic = null;
    }

    boolean isChanged() {
        return this.logic != null ? this.logic.isChanged() : false;
    }

    void applyChanges() {
        this.logic.applyChanges();
        this.logic.disconnect();
        this.logic = null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.renderer.setBackground(selected ? this.dr.getBackgroundSelectionColor() : this.dr.getBackgroundNonSelectionColor());
        this.renderer.setForeground(selected ? this.dr.getTextSelectionColor() : this.dr.getTextNonSelectionColor());
        this.renderer.setEnabled(true);
        if (value instanceof DefaultMutableTreeNode) {
            Object data = ((DefaultMutableTreeNode)value).getUserObject();
            if (data instanceof CodeAuditProxy) {
                CodeAuditProxy audit = (CodeAuditProxy)data;
                this.renderer.setText(audit.getName());
                this.renderer.setSelected(audit.isEnabled());
            } else if (data instanceof CodeAuditProviderProxy) {
                CodeAuditProviderProxy provider = (CodeAuditProviderProxy)data;
                this.renderer.setText(provider.getDisplayName());
                boolean hasEnabled = false;
                boolean hasDisabled = false;
                for (int i = 0; i < ((DefaultMutableTreeNode)value).getChildCount(); ++i) {
                    DefaultMutableTreeNode childAt = (DefaultMutableTreeNode)((DefaultMutableTreeNode)value).getChildAt(i);
                    CodeAuditProxy audit = (CodeAuditProxy)childAt.getUserObject();
                    if (audit.isEnabled()) {
                        hasEnabled = true;
                        continue;
                    }
                    hasDisabled = true;
                }
                if (hasEnabled) {
                    if (hasDisabled) {
                        this.renderer.setSelected(true);
                    } else {
                        this.renderer.setSelected(true);
                    }
                } else {
                    this.renderer.setSelected(false);
                }
            } else if (data instanceof NamedOptionProxy) {
                NamedOptionProxy option = (NamedOptionProxy)data;
                this.renderer.setText(option.getDisplayName());
                this.renderer.setSelected(option.getBoolean());
            }
        }
        return this.renderer;
    }

    static final class ModifiedPreferences
    extends AbstractPreferences {
        private Map<String, String> map = new HashMap<String, String>();
        private final Map<String, String> modifiedKeys = new HashMap<String, String>();
        private final boolean supportChanges;
        private final Preferences proxyNode;
        private volatile boolean modified;

        public ModifiedPreferences(Preferences node, boolean supportChanges) {
            super(null, "");
            this.supportChanges = supportChanges;
            this.proxyNode = node;
            this.init(node);
        }

        private void init(Preferences node) {
            this.map.clear();
            try {
                for (String key : node.keys()) {
                    this.map.put(key, node.get(key, null));
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.modifiedKeys.clear();
            this.modified = false;
        }

        @Override
        public String absolutePath() {
            return this.proxyNode.absolutePath();
        }

        public boolean isModified() {
            return this.modified;
        }

        void store() {
            for (Map.Entry<String, String> entry : this.modifiedKeys.entrySet()) {
                String key = entry.getKey();
                String origVal = entry.getValue();
                String curVal = this.map.get(key);
                if (curVal == null) {
                    this.proxyNode.remove(key);
                    continue;
                }
                if (curVal.equals(origVal)) continue;
                this.proxyNode.put(key, curVal);
            }
            this.modifiedKeys.clear();
            this.modified = false;
        }

        void cancel() {
            this.init(this.proxyNode);
        }

        @Override
        protected void putSpi(String key, String value) {
            if (!this.modifiedKeys.containsKey(key)) {
                this.modifiedKeys.put(key, this.map.get(key));
            }
            this.map.put(key, value);
            if (!this.supportChanges) {
                this.store();
                this.init(this.proxyNode);
            } else {
                this.calculateModified();
            }
        }

        @Override
        protected String getSpi(String key) {
            return this.map.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            if (!this.modifiedKeys.containsKey(key)) {
                this.modifiedKeys.put(key, this.map.get(key));
            }
            this.map.remove(key);
            if (!this.supportChanges) {
                this.store();
                this.init(this.proxyNode);
            } else {
                this.calculateModified();
            }
        }

        private void calculateModified() {
            this.modified = false;
            for (Map.Entry<String, String> entry : this.modifiedKeys.entrySet()) {
                String key = entry.getKey();
                String origVal = entry.getValue();
                String curVal = this.map.get(key);
                if (origVal != null) {
                    this.modified = !origVal.equals(curVal);
                } else {
                    boolean bl = this.modified = curVal != null;
                }
                if (!this.modified) continue;
                return;
            }
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(array);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException();
        }
    }

    static final class NamedOptionProxy
    extends NamedOption
    implements HintModelController {
        private final NamedOption proxy;
        private final ModifiedPreferences modifiedPref;

        private NamedOptionProxy(NamedOption proxy, boolean supportChanges) {
            this.proxy = proxy;
            this.modifiedPref = new ModifiedPreferences(NbPreferences.forModule(NamedOption.class), supportChanges);
        }

        @Override
        public JComponent createComponent() {
            if (this.proxy instanceof AbstractCustomizerProvider) {
                return ((AbstractCustomizerProvider)this.proxy).createComponent(this.modifiedPref);
            }
            return null;
        }

        public String getName() {
            return this.proxy.getName();
        }

        public String getDisplayName() {
            return this.proxy.getDisplayName();
        }

        public String getDescription() {
            return this.proxy.getDescription();
        }

        public NamedOption.OptionKind getKind() {
            return this.proxy.getKind();
        }

        public Object getDefaultValue() {
            return this.proxy.getDefaultValue();
        }

        public boolean getBoolean() {
            return this.modifiedPref.getBoolean(this.getName(), (Boolean)this.getDefaultValue());
        }

        public void setBoolean(boolean value) {
            boolean old = this.getBoolean();
            if (old != value) {
                this.modifiedPref.putBoolean(this.getName(), value);
            }
        }

        @Override
        public boolean isChanged() {
            return this.modifiedPref.isModified();
        }

        @Override
        public void store() {
            this.modifiedPref.store();
        }

        @Override
        public void cancel() {
            this.modifiedPref.cancel();
        }
    }

    static final class CodeAuditProxy
    extends AbstractCodeAudit
    implements HintModelController {
        private final CodeAudit proxy;
        private final AuditPreferences modifiedAuditPref;
        private final ModifiedPreferences modifiedPref;

        private static CodeAuditProxy create(CodeAudit proxy, boolean supportChanges) {
            ModifiedPreferences modifiedPref = new ModifiedPreferences(proxy.getPreferences().getPreferences(), supportChanges);
            AuditPreferences modifiedAuditPref = new AuditPreferences((Preferences)modifiedPref);
            return new CodeAuditProxy(proxy, supportChanges, modifiedPref, modifiedAuditPref);
        }

        private CodeAuditProxy(CodeAudit proxy, boolean supportChanges, ModifiedPreferences modifiedPref, AuditPreferences modifiedAuditPref) {
            super(proxy.getID(), proxy.getName(), proxy.getDescription(), proxy.getDefaultSeverity(), proxy.getDefaultEnabled(), modifiedAuditPref);
            this.proxy = proxy;
            this.modifiedPref = modifiedPref;
            this.modifiedAuditPref = modifiedAuditPref;
        }

        @Override
        public JComponent createComponent() {
            if (this.proxy instanceof AbstractCustomizerProvider) {
                return ((AbstractCustomizerProvider)this.proxy).createComponent(this.modifiedPref);
            }
            return null;
        }

        public String getKind() {
            return this.proxy.getKind();
        }

        public AuditPreferences getPreferences() {
            return this.modifiedAuditPref;
        }

        void setSeverity(Severity value) {
            String old = this.minimalSeverity();
            String defValue = this.getDefaultSeverity();
            switch (value) {
                case ERROR: {
                    if ("error".equals(old)) break;
                    this.putString("severity", "error", defValue);
                    break;
                }
                case HINT: {
                    if ("hint".equals(old)) break;
                    this.putString("severity", "hint", defValue);
                    break;
                }
                case WARNING: {
                    if ("warning".equals(old)) break;
                    this.putString("severity", "warning", defValue);
                }
            }
        }

        void setEnabled(boolean enabled) {
            String defValue;
            boolean old = this.isEnabled();
            String string = defValue = this.getDefaultEnabled() ? "true" : "false";
            if (enabled) {
                if (!old) {
                    this.putString("enabled", "true", defValue);
                }
            } else if (old) {
                this.putString("enabled", "false", defValue);
            }
        }

        private void putString(String key, String value, String defValue) {
            this.getPreferences().put(this.getID(), key, value, defValue);
        }

        @Override
        public boolean isChanged() {
            return this.modifiedPref.isModified();
        }

        @Override
        public void store() {
            this.modifiedPref.store();
        }

        @Override
        public void cancel() {
            this.modifiedPref.cancel();
        }

        public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
            throw new UnsupportedOperationException();
        }

        public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
            throw new UnsupportedOperationException();
        }
    }

    static final class CodeAuditProviderProxy
    implements CodeAuditProvider,
    HintModelController {
        private final CodeAuditProvider proxy;
        private final List<CodeAudit> audits = new ArrayList<CodeAudit>();
        private final AuditPreferences modifiedAuditPref;
        private final ModifiedPreferences modifiedPref;

        private CodeAuditProviderProxy(CodeAuditProvider proxy, boolean supportChanges) {
            this.proxy = proxy;
            this.modifiedPref = new ModifiedPreferences(proxy.getPreferences().getPreferences(), supportChanges);
            this.modifiedAuditPref = new AuditPreferences((Preferences)this.modifiedPref);
            for (CodeAudit a : proxy.getAudits()) {
                this.audits.add((CodeAudit)CodeAuditProxy.create(a, supportChanges));
            }
        }

        @Override
        public JComponent createComponent() {
            if (this.proxy instanceof AbstractCustomizerProvider) {
                return ((AbstractCustomizerProvider)this.proxy).createComponent(this.modifiedPref);
            }
            return null;
        }

        public Collection<CodeAudit> getAudits() {
            return this.audits;
        }

        public String getName() {
            return this.proxy.getName();
        }

        public String getDisplayName() {
            return this.proxy.getDisplayName();
        }

        public String getDescription() {
            return this.proxy.getDescription();
        }

        public AuditPreferences getPreferences() {
            return this.modifiedAuditPref;
        }

        @Override
        public boolean isChanged() {
            return this.modifiedPref.isModified();
        }

        @Override
        public void store() {
            this.modifiedPref.store();
        }

        @Override
        public void cancel() {
            this.modifiedPref.cancel();
        }

        public String getMimeType() {
            return this.proxy.getMimeType();
        }
    }

    static interface HintModelController {
        public boolean isChanged();

        public void store();

        public void cancel();

        public JComponent createComponent();
    }

    private final class AcceptorImpl
    implements OptionsFilter.Acceptor {
        private AcceptorImpl() {
        }

        public boolean accept(Object originalTreeNode, String filterText) {
            if (filterText.isEmpty()) {
                return true;
            }
            HintsPanel.this.expandTask.schedule(100);
            if (!(originalTreeNode instanceof DefaultMutableTreeNode)) {
                return true;
            }
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)originalTreeNode;
            Object uo = n.getUserObject();
            if (!(uo instanceof CodeAuditProxy)) {
                return false;
            }
            CodeAuditProxy audit = (CodeAuditProxy)uo;
            return audit.getName().toLowerCase().contains(filterText.toLowerCase());
        }
    }

    static final class ExtendedModel
    implements TreeModel {
        private final List<DefaultMutableTreeNode> audits;
        private final List<HintModelController> storage;
        private final String mimeType;
        private final CodeAuditProvider selection;

        private ExtendedModel(CodeAuditProvider selection, String mimeType) {
            block5: {
                block4: {
                    HintModelController proxy;
                    this.audits = new ArrayList<DefaultMutableTreeNode>();
                    this.storage = new ArrayList<HintModelController>();
                    this.mimeType = mimeType;
                    this.selection = selection;
                    if (selection != null) break block4;
                    for (CodeAuditProvider provider : CodeAuditProviderImpl.getDefault()) {
                        if (!mimeType.equals(provider.getMimeType())) continue;
                        proxy = new CodeAuditProviderProxy(provider, true);
                        DefaultMutableTreeNode providerRoot = new DefaultMutableTreeNode(proxy);
                        this.audits.add(providerRoot);
                        this.storage.add(proxy);
                        for (CodeAudit audit : ((CodeAuditProviderProxy)proxy).getAudits()) {
                            providerRoot.add(new DefaultMutableTreeNode(audit));
                            this.storage.add((HintModelController)audit);
                        }
                    }
                    if (!"text/x-cnd+sourcefile".equals(mimeType)) break block5;
                    for (NamedOption option : Lookups.forPath((String)"CND/options/hints").lookupAll(NamedOption.class)) {
                        if (!option.isVisible()) continue;
                        proxy = new NamedOptionProxy(option, true);
                        this.audits.add(new DefaultMutableTreeNode(proxy));
                        this.storage.add(proxy);
                    }
                    break block5;
                }
                CodeAuditProviderProxy proxy = new CodeAuditProviderProxy(selection, false);
                DefaultMutableTreeNode providerRoot = new DefaultMutableTreeNode(proxy);
                this.audits.add(providerRoot);
                this.storage.add(proxy);
                for (CodeAudit audit : proxy.getAudits()) {
                    providerRoot.add(new DefaultMutableTreeNode(audit));
                    this.storage.add((HintModelController)audit);
                }
            }
        }

        boolean isChanged() {
            for (HintModelController node : this.storage) {
                if (!node.isChanged()) continue;
                return true;
            }
            return false;
        }

        void store() {
            for (HintModelController node : this.storage) {
                if (!node.isChanged()) continue;
                node.store();
            }
        }

        void cancel() {
            for (HintModelController node : this.storage) {
                if (!node.isChanged()) continue;
                node.cancel();
            }
        }

        @Override
        public Object getRoot() {
            return "Root";
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.getRoot()) {
                return this.audits.get(index);
            }
            if (parent instanceof DefaultMutableTreeNode) {
                return ((DefaultMutableTreeNode)parent).getChildAt(index);
            }
            return null;
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.getRoot()) {
                return this.audits.size();
            }
            if (parent instanceof DefaultMutableTreeNode) {
                return ((DefaultMutableTreeNode)parent).getChildCount();
            }
            return 0;
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node == this.getRoot()) {
                return false;
            }
            if (node instanceof DefaultMutableTreeNode) {
                return ((DefaultMutableTreeNode)node).isLeaf();
            }
            return true;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this.getRoot()) {
                return this.audits.indexOf(child);
            }
            if (parent instanceof DefaultMutableTreeNode) {
                return ((DefaultMutableTreeNode)parent).getIndex((DefaultMutableTreeNode)child);
            }
            return 0;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        public void nodeChanged(TreeNode node) {
        }
    }
}

