/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.DirectoryEntry;
import org.clang.basic.ExternalIdentifierLookup;
import org.clang.basic.FileEntry;
import org.clang.basic.FileManager;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.LangOptions;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SrcMgr;
import org.clang.basic.target.TargetInfo;
import org.clang.lex.DirectoryLookup;
import org.clang.lex.ExternalHeaderFileInfoSource;
import org.clang.lex.HeaderFileInfo;
import org.clang.lex.HeaderFileInfoVector;
import org.clang.lex.HeaderMap;
import org.clang.lex.HeaderSearchOptions;
import org.clang.lex.ModuleMap;
import org.clang.lex.impl.HeaderSearchStatics;
import org.clang.lex.impl.SmallVectorPtrPairFileEntryDirectoryEntry;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.APInt;
import org.llvm.adt.HashingGlobals;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSet;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMapIteratorTypeBool;
import org.llvm.adt.aliases.DenseMapTypeBool;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.adt.aliases.StringMapIteratorChar;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class HeaderSearch
implements Destructors.ClassWithDestructor {
    private IntrusiveRefCntPtr<HeaderSearchOptions> HSOpts;
    private DiagnosticsEngine Diags;
    private FileManager FileMgr;
    private std.vector<DirectoryLookup> SearchDirs;
    private int AngledDirIdx;
    private int SystemDirIdx;
    private boolean NoCurDirSearch;
    private std.vector<std.pairTypeBool<std.string>> SystemHeaderPrefixes;
    private std.string ModuleCachePath;
    private HeaderFileInfoVector FileInfo;
    public static final String REUSE_HEADER_FILE_INFOS_PROP = "clang.header.file.infos.reuse";
    public static final boolean REUSE_HEADER_FILE_INFOS = Boolean.valueOf(System.getProperty("clang.header.file.infos.reuse", "true"));
    private StringMap<LookupFileCacheInfo, BumpPtrAllocator> LookupFileCache;
    private StringMap<FrameworkCacheEntry, BumpPtrAllocator> FrameworkMap;
    private std_ptr.unique_ptr<StringMap<std.string, BumpPtrAllocator>> IncludeAliases;
    private std.vector<std.pair<FileEntry, HeaderMap>> HeaderMaps;
    private ModuleMap ModMap;
    private DenseMapTypeBool<DirectoryEntry> DirectoryHasModuleMap;
    private DenseMapTypeBool<FileEntry> LoadedModuleMaps;
    private StringSet<BumpPtrAllocator> FrameworkNames;
    private ExternalIdentifierLookup ExternalLookup;
    private ExternalHeaderFileInfoSource ExternalSource;
    private int NumIncluded;
    private int NumMultiIncludeFileOptzn;
    private int NumFrameworkLookups;
    private int NumSubFrameworkLookups;
    private LangOptions LangOpts;
    private final SmallString $LookupFileTmpDir = new SmallString(1024);
    private boolean $LookupFileTmpDirInUse = false;
    private final SmallString $LookupFileMappedName = new SmallString(64);
    private boolean $LookupFileMappedNameInUse = false;
    private final bool.ref $InUserSpecifiedSystemFramework = NativePointer.create_bool$ref((boolean)false);
    private boolean $InUserSpecifiedSystemFrameworkInUse = false;
    private final bool.ref $HasBeenMapped = NativePointer.create_bool$ref((boolean)false);
    private boolean $HasBeenMappedInUse = false;

    private HeaderSearch(HeaderSearch $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private void $assign(HeaderSearch $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    public HeaderSearch(IntrusiveRefCntPtr<HeaderSearchOptions> HSOpts, SourceManager SourceMgr, DiagnosticsEngine Diags, LangOptions LangOpts, TargetInfo Target) {
        this.HSOpts = new IntrusiveRefCntPtr(HSOpts);
        this.Diags = Diags;
        this.FileMgr = SourceMgr.getFileManager();
        this.SearchDirs = new std.vector((Object)new DirectoryLookup());
        this.SystemHeaderPrefixes = new std.vector((Object)new std.pairTypeBool((Object)std.string.EMPTY, false));
        this.ModuleCachePath = new std.string();
        this.FileInfo = HeaderFileInfoVector.$create();
        this.LookupFileCache = new StringMap((Object)new LookupFileCacheInfo());
        this.FrameworkMap = new StringMap(64L, (Object)new FrameworkCacheEntry());
        this.IncludeAliases = new std_ptr.unique_ptr();
        this.HeaderMaps = new std.vector((Object)std.make_pair((Object)null, (Object)null));
        this.ModMap = new ModuleMap(SourceMgr, Diags, LangOpts, Target, this);
        this.DirectoryHasModuleMap = new DenseMapTypeBool(DirectoryEntry.DenseMapInfo, false);
        this.LoadedModuleMaps = new DenseMapTypeBool(FileEntry.DenseMapInfo, false);
        this.FrameworkNames = new StringSet();
        this.LangOpts = LangOpts;
        this.AngledDirIdx = 0;
        this.SystemDirIdx = 0;
        this.NoCurDirSearch = false;
        this.ExternalLookup = null;
        this.ExternalSource = null;
        this.NumIncluded = 0;
        this.NumMultiIncludeFileOptzn = 0;
        this.NumSubFrameworkLookups = 0;
        this.NumFrameworkLookups = 0;
    }

    public void $destroy() {
        int e = this.HeaderMaps.size();
        for (int i = 0; i != e; ++i) {
            if (((std.pair)this.HeaderMaps.$at((int)i)).second == null) continue;
            ((HeaderMap)((std.pair)this.HeaderMaps.$at((int)i)).second).$destroy();
        }
        this.FrameworkNames.$destroy();
        this.LoadedModuleMaps.$destroy();
        this.DirectoryHasModuleMap.$destroy();
        this.ModMap.$destroy();
        this.HeaderMaps.$destroy();
        this.IncludeAliases.$destroy();
        this.FrameworkMap.$destroy();
        this.LookupFileCache.$destroy();
        HeaderFileInfoVector.$release(this.FileInfo);
        this.FileInfo = null;
        this.ModuleCachePath.$destroy();
        this.SystemHeaderPrefixes.$destroy();
        this.SearchDirs.$destroy();
        this.HSOpts.$destroy();
    }

    public HeaderSearchOptions getHeaderSearchOpts() {
        return (HeaderSearchOptions)((Object)this.HSOpts.$star());
    }

    public FileManager getFileMgr() {
        return this.FileMgr;
    }

    public void SetSearchPaths(std.vector<DirectoryLookup> dirs, int angledDirIdx, int systemDirIdx, boolean noCurDirSearch) {
        assert (angledDirIdx <= systemDirIdx && systemDirIdx <= dirs.size()) : "Directory indicies are unordered";
        this.SearchDirs.$assign(dirs);
        this.AngledDirIdx = angledDirIdx;
        this.SystemDirIdx = systemDirIdx;
        this.NoCurDirSearch = noCurDirSearch;
    }

    public void AddSearchPath(DirectoryLookup dir, boolean isAngled) {
        int idx = isAngled ? this.SystemDirIdx : this.AngledDirIdx;
        this.SearchDirs.insert(this.SearchDirs.begin().$add(idx), (Object)dir);
        if (!isAngled) {
            ++this.AngledDirIdx;
        }
        ++this.SystemDirIdx;
    }

    public void SetSystemHeaderPrefixes(ArrayRef<std.pairTypeBool<std.string>> P) {
        this.SystemHeaderPrefixes.assign((type.iterator)P.begin(), (type.iterator)P.end());
    }

    public boolean HasIncludeAliasMap() {
        return this.IncludeAliases.$boolean();
    }

    public void AddIncludeAlias(StringRef Source, StringRef Dest) {
        if (this.IncludeAliases.$not()) {
            this.IncludeAliases.reset((Object)new StringMap((Object)new std.string()));
        }
        ((std.string)((StringMap)this.IncludeAliases.$star()).$at(Source)).$assign(Dest.$basic_string());
    }

    public StringRef MapHeaderToIncludeAlias(StringRef Source) {
        assert (this.IncludeAliases.$boolean()) : "Trying to map headers when there's no map";
        StringMapIterator Iter = ((StringMap)this.IncludeAliases.$arrow()).find(Source);
        if (Iter.$noteq((StringMapConstIterator)((StringMap)this.IncludeAliases.$arrow()).end())) {
            return new StringRef((std.string)Iter.$arrow().second);
        }
        return new StringRef();
    }

    public void setModuleCachePath(StringRef CachePath) {
        this.ModuleCachePath.$assign(CachePath.$basic_string());
    }

    public StringRef getModuleCachePath() {
        return new StringRef(this.ModuleCachePath);
    }

    public void setDirectoryHasModuleMap(DirectoryEntry Dir) {
        this.DirectoryHasModuleMap.FindAndConstruct((Object)Dir).second = true;
    }

    public void ClearFileInfo() {
        this.FileInfo.clear();
    }

    public void SetExternalLookup(ExternalIdentifierLookup EIL) {
        this.ExternalLookup = EIL;
    }

    public ExternalIdentifierLookup getExternalLookup() {
        return this.ExternalLookup;
    }

    public void SetExternalSource(ExternalHeaderFileInfoSource ES) {
        this.ExternalSource = ES;
    }

    public void setTarget(TargetInfo Target) {
        this.ModMap.setTarget(Target);
    }

    public FileEntry LookupFile(StringRef Filename, SourceLocation IncludeLoc, boolean isAngled, type.ptr<DirectoryLookup> FromDir, type.ref<type.ptr<DirectoryLookup>> CurDir, SmallVectorPtrPairFileEntryDirectoryEntry Includers, SmallString SearchPath, SmallString RelativePath, ModuleMap.KnownHeader SuggestedModule) {
        return this.LookupFile(Filename, IncludeLoc, isAngled, FromDir, CurDir, Includers, SearchPath, RelativePath, SuggestedModule, false);
    }

    /*
     * Exception decompiling
     */
    public FileEntry LookupFile(StringRef Filename, SourceLocation IncludeLoc, boolean isAngled, type.ptr<DirectoryLookup> FromDir, type.ref<type.ptr<DirectoryLookup>> CurDir, SmallVectorPtrPairFileEntryDirectoryEntry Includers, SmallString SearchPath, SmallString RelativePath, ModuleMap.KnownHeader SuggestedModule, boolean SkipCache) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 2[TRYBLOCK]], but top level block is 21[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry LookupSubframeworkHeader(StringRef Filename, FileEntry ContextFileEnt, SmallString SearchPath, SmallString RelativePath, ModuleMap.KnownHeader SuggestedModule) {
        SmallString FrameworkName = null;
        SmallString HeadersFilename = null;
        try {
            byte DirInfo;
            assert (ContextFileEnt != null) : "No context file?";
            int SlashPos = Filename.find(NativePointer.$((char)'/'));
            if (SlashPos == StringRef.npos) {
                FileEntry fileEntry = null;
                return fileEntry;
            }
            char.ptr ContextName = Native.$tryClone((char.ptr)ContextFileEnt.getName());
            int DotFrameworkLen = 10;
            char.ptr FrameworkPos = Native.$tryClone((char.ptr)std.strstr((char.ptr)ContextName, (char.ptr)NativePointer.$((String)".framework")));
            if (FrameworkPos == null || FrameworkPos.$at(DotFrameworkLen) != NativePointer.$((char)'/') && FrameworkPos.$at(DotFrameworkLen) != NativePointer.$((char)'\\')) {
                FileEntry fileEntry = null;
                return fileEntry;
            }
            FrameworkName = new SmallString((char.iterator)ContextName, (char.iterator)((char.ptr)FrameworkPos.$add(DotFrameworkLen)).$add(1), 1024);
            FrameworkName.$addassign((CharSequence)"Frameworks/");
            FrameworkName.append(Filename, 0, SlashPos);
            FrameworkName.$addassign((CharSequence)".framework/");
            StringMapEntry CacheLookup = this.FrameworkMap.GetOrCreateValue(Filename.substr(0, SlashPos), (Object)new FrameworkCacheEntry());
            if (((FrameworkCacheEntry)CacheLookup.second).Directory != null && CacheLookup.getKeyLength() == FrameworkName.size() && std.memcmp((char.ptr)CacheLookup.getKeyStr(), (char.ptr)FrameworkName.data(), (int)CacheLookup.getKeyLength()) != 0) {
                FileEntry fileEntry = null;
                return fileEntry;
            }
            if (((FrameworkCacheEntry)CacheLookup.second).Directory == null) {
                ++this.NumSubFrameworkLookups;
                DirectoryEntry Dir = this.FileMgr.getDirectory(FrameworkName.str());
                if (Dir == null) {
                    FileEntry fileEntry = null;
                    return fileEntry;
                }
                ((FrameworkCacheEntry)CacheLookup.second).Directory = Dir;
            }
            FileEntry FE = null;
            if (RelativePath != null) {
                RelativePath.clear();
                RelativePath.append(Filename, SlashPos + 1, Filename.size());
            }
            HeadersFilename = new SmallString(FrameworkName);
            HeadersFilename.$addassign((CharSequence)"Headers/");
            if (SearchPath != null) {
                SearchPath.clear();
                SearchPath.append((SmallVectorImplChar)HeadersFilename, 0, HeadersFilename.size() - 1);
            }
            HeadersFilename.append(Filename, SlashPos + 1, Filename.size());
            FE = this.FileMgr.getFile(HeadersFilename.str(), true);
            if (FE == null) {
                HeadersFilename.$assign((SmallVectorImplChar)FrameworkName);
                HeadersFilename.$addassign((CharSequence)"PrivateHeaders/");
                if (SearchPath != null) {
                    SearchPath.clear();
                    SearchPath.append((SmallVectorImplChar)HeadersFilename, 0, HeadersFilename.size() - 1);
                }
                HeadersFilename.append(Filename, SlashPos + 1, Filename.size());
                FE = this.FileMgr.getFile(HeadersFilename.str(), true);
                if (FE == null) {
                    FileEntry fileEntry = null;
                    return fileEntry;
                }
            }
            this.getFileInfo((FileEntry)FE).DirInfo = DirInfo = this.getFileInfo((FileEntry)ContextFileEnt).DirInfo;
            if (SuggestedModule != null) {
                SmallVector SubmodulePath = null;
                try {
                    FrameworkName.pop_back();
                    SubmodulePath = new SmallVector(4, (Object)new std.string());
                    DirectoryEntry TopFrameworkDir = HeaderSearchStatics.getTopFrameworkDir(this.FileMgr, FrameworkName.$StringRef(), (SmallVectorImpl<std.string>)SubmodulePath);
                    StringRef ModuleName = path.stem((StringRef)new StringRef(TopFrameworkDir.getName(), TopFrameworkDir.getNameLen()));
                    boolean IsSystem = false;
                    if (this.loadFrameworkModule(ModuleName, TopFrameworkDir, IsSystem) != null) {
                        SuggestedModule.$assignMove(this.findModuleForHeader(FE));
                    }
                }
                finally {
                    if (SubmodulePath != null) {
                        SubmodulePath.$destroy();
                    }
                }
            }
            FileEntry fileEntry = FE;
            return fileEntry;
        }
        finally {
            if (HeadersFilename != null) {
                HeadersFilename.$destroy();
            }
            if (FrameworkName != null) {
                FrameworkName.$destroy();
            }
        }
    }

    public FrameworkCacheEntry LookupFrameworkCache(StringRef FWName) {
        return (FrameworkCacheEntry)this.FrameworkMap.$at(FWName);
    }

    public boolean ShouldEnterIncludeFile(FileEntry File, boolean isImport) {
        IdentifierInfo ControllingMacro;
        ++this.NumIncluded;
        HeaderFileInfo FileInfo = this.getFileInfo(File);
        if (isImport) {
            FileInfo.isImport = true;
            if (FileInfo.NumIncludes != '\u0000') {
                return false;
            }
        } else if (FileInfo.isImport) {
            return false;
        }
        if ((ControllingMacro = FileInfo.getControllingMacro(this.ExternalLookup)) != null && ControllingMacro.hasMacroDefinition()) {
            ++this.NumMultiIncludeFileOptzn;
            return false;
        }
        FileInfo.NumIncludes = (char)(FileInfo.NumIncludes + '\u0001');
        return true;
    }

    public SrcMgr.CharacteristicKind getFileDirFlavor(FileEntry File) {
        return SrcMgr.CharacteristicKind.valueOf((int)this.getFileInfo((FileEntry)File).DirInfo);
    }

    public byte getRawFileDirFlavor(FileEntry File) {
        return this.getFileInfo((FileEntry)File).DirInfo;
    }

    public void MarkFileIncludeOnce(FileEntry File) {
        HeaderFileInfo FI = this.getFileInfo(File);
        FI.isImport = true;
        FI.isPragmaOnce = true;
    }

    public void MarkFileSystemHeader(FileEntry File) {
        this.getFileInfo((FileEntry)File).DirInfo = 1;
    }

    public void MarkFileModuleHeader(FileEntry FE, int Role, boolean isCompilingModuleHeader) {
        if (FE.getUID() >= this.FileInfo.size()) {
            this.FileInfo.resize(FE.getUID() + 1);
        }
        HeaderFileInfo HFI = this.FileInfo.$at(FE.getUID());
        HFI.isModuleHeader = true;
        HFI.isCompilingModuleHeader = isCompilingModuleHeader;
        HFI.setHeaderRole(Role);
    }

    public void IncrementIncludeCount(FileEntry File) {
        this.getFileInfo((FileEntry)File).NumIncludes = (char)(this.getFileInfo((FileEntry)File).NumIncludes + '\u0001');
    }

    public void SetFileControllingMacro(FileEntry File, IdentifierInfo ControllingMacro) {
        this.getFileInfo((FileEntry)File).ControllingMacro = ControllingMacro;
    }

    public boolean FirstTimeLexingFile(FileEntry File) {
        return this.getFileInfo((FileEntry)File).NumIncludes == '\u0001';
    }

    public boolean isFileMultipleIncludeGuarded(FileEntry File) {
        if (File.getUID() >= this.FileInfo.size()) {
            return false;
        }
        HeaderFileInfo HFI = this.FileInfo.$at(File.getUID());
        if (this.ExternalSource != null && !HFI.Resolved) {
            HeaderSearchStatics.mergeHeaderFileInfo(HFI, this.ExternalSource.GetHeaderFileInfo(File));
        }
        return HFI.isPragmaOnce || HFI.isImport || HFI.ControllingMacro != null || HFI.ControllingMacroID != 0L;
    }

    public HeaderMap CreateHeaderMap(FileEntry FE) {
        HeaderMap HM;
        if (!this.HeaderMaps.empty()) {
            int e = this.HeaderMaps.size();
            for (int i = 0; i != e; ++i) {
                if (((std.pair)this.HeaderMaps.$at((int)i)).first != FE) continue;
                return (HeaderMap)((std.pair)this.HeaderMaps.$at((int)i)).second;
            }
        }
        if ((HM = HeaderMap.Create(FE, this.FileMgr)) != null) {
            this.HeaderMaps.push_back((Object)std.make_pair((Object)FE, (Object)HM));
            return HM;
        }
        return null;
    }

    public boolean enabledModules() {
        return this.LangOpts.Modules;
    }

    public std.string getModuleFileName(Module Module2) {
        FileEntry ModuleMap2 = this.getModuleMap().getModuleMapFileForUniquing(Module2);
        return this.getModuleFileName(new StringRef(Module2.Name), new StringRef(ModuleMap2.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string getModuleFileName(StringRef ModuleName, StringRef ModuleMapPath) {
        SmallString Result = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            if (this.ModuleCachePath.empty()) {
                std.string string2 = new std.string();
                return string2;
            }
            Result = new SmallString(new StringRef(this.ModuleCachePath), 256);
            fs.make_absolute((SmallString)Result);
            if (((HeaderSearchOptions)((Object)this.HSOpts.$arrow())).DisableModuleHash) {
                path.append((SmallString)Result, (Twine)llvm.$plus_StringRef_char$ptr((StringRef)ModuleName, (char.ptr)NativePointer.$((String)".pcm")));
            } else {
                SmallString HashStr = null;
                try {
                    DirectoryEntry Dir = this.FileMgr.getDirectory(path.parent_path((StringRef)ModuleMapPath));
                    if (Dir == null) {
                        std.string string3 = new std.string();
                        return string3;
                    }
                    StringRef DirName = this.FileMgr.getCanonicalName(Dir);
                    StringRef FileName = path.filename((StringRef)ModuleMapPath);
                    HashingGlobals.hash_code Hash = (HashingGlobals.hash_code)$c.clean((Object)HashingGlobals.hash_combine((Object)$c.track((Object)DirName.lower()), (Object)$c.track((Object)FileName.lower())));
                    HashStr = new SmallString(128);
                    ((APInt)$c.track((Object)new APInt(64, Hash.$long()))).toStringUnsigned(HashStr, 36);
                    $c.clean();
                    path.append((SmallString)Result, (Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_char$ptr((StringRef)ModuleName, (char.ptr)NativePointer.$((String)"-")), (Twine)new Twine(HashStr.str())), (Twine)new Twine(NativePointer.$((String)".pcm"))));
                }
                finally {
                    if (HashStr != null) {
                        HashStr.$destroy();
                    }
                }
            }
            std.string string4 = Result.str().str();
            return string4;
        }
        finally {
            if (Result != null) {
                Result.$destroy();
            }
            $c.$destroy();
        }
    }

    public Module lookupModule(StringRef ModuleName) {
        return this.lookupModule(ModuleName, true);
    }

    public Module lookupModule(StringRef ModuleName, boolean AllowSearch) {
        Module Module2 = this.ModMap.findModule(ModuleName);
        if (Module2 != null || !AllowSearch || !this.LangOpts.ModulesImplicitMaps) {
            return Module2;
        }
        int N = this.SearchDirs.size();
        for (int Idx = 0; Idx != N; ++Idx) {
            if (((DirectoryLookup)this.SearchDirs.$at(Idx)).isFramework()) {
                boolean IsSystem;
                SmallString FrameworkDirName = new SmallString(128);
                DirectoryEntry frameworkDir = ((DirectoryLookup)this.SearchDirs.$at(Idx)).getFrameworkDir();
                FrameworkDirName.$addassign(frameworkDir.getName(), frameworkDir.getNameLen());
                path.append((SmallString)FrameworkDirName, (Twine)llvm.$plus_StringRef_T((StringRef)ModuleName, (CharSequence)".framework"));
                DirectoryEntry FrameworkDir = this.FileMgr.getDirectory(FrameworkDirName.$StringRef());
                if (FrameworkDir != null && (Module2 = this.loadFrameworkModule(ModuleName, FrameworkDir, IsSystem = ((DirectoryLookup)this.SearchDirs.$at(Idx)).getDirCharacteristic() != SrcMgr.CharacteristicKind.C_User)) != null) break;
            }
            if (!((DirectoryLookup)this.SearchDirs.$at(Idx)).isNormalDir()) continue;
            boolean IsSystem = ((DirectoryLookup)this.SearchDirs.$at(Idx)).isSystemHeaderDirectory();
            DirectoryEntry dir = ((DirectoryLookup)this.SearchDirs.$at(Idx)).getDir();
            if (this.loadModuleMapFile(dir, IsSystem, false) == LoadModuleMapResult.LMM_NewlyLoaded && (Module2 = this.ModMap.findModule(ModuleName)) != null) break;
            SmallString NestedModuleMapDirName = new SmallString(128);
            NestedModuleMapDirName.$assign(dir.getName(), dir.getNameLen());
            path.append((SmallString)NestedModuleMapDirName, (StringRef)ModuleName);
            if (this.loadModuleMapFile(NestedModuleMapDirName.$StringRef(), IsSystem, false) == LoadModuleMapResult.LMM_NewlyLoaded && (Module2 = this.ModMap.findModule(ModuleName)) != null) break;
            if (((DirectoryLookup)this.SearchDirs.$at(Idx)).haveSearchedAllModuleMaps()) continue;
            this.loadSubdirectoryModuleMaps((DirectoryLookup)this.SearchDirs.$at(Idx));
            Module2 = this.ModMap.findModule(ModuleName);
            if (Module2 != null) break;
        }
        return Module2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry lookupModuleMapFile(DirectoryEntry Dir, boolean IsFramework) {
        SmallString ModuleMapFileName = null;
        try {
            if (!this.LangOpts.ModulesImplicitMaps) {
                FileEntry fileEntry = null;
                return fileEntry;
            }
            ModuleMapFileName = new SmallString(new StringRef(Dir.getName(), Dir.getNameLen()), 128);
            if (IsFramework) {
                path.append((SmallString)ModuleMapFileName, (char.ptr)NativePointer.$((String)"Modules"));
            }
            path.append((SmallString)ModuleMapFileName, (char.ptr)NativePointer.$((String)"module.modulemap"));
            FileEntry F = this.FileMgr.getFile(ModuleMapFileName.$StringRef());
            if (F != null) {
                FileEntry fileEntry = F;
                return fileEntry;
            }
            ModuleMapFileName.$assign(Dir.getName(), Dir.getNameLen());
            path.append((SmallString)ModuleMapFileName, (char.ptr)NativePointer.$((String)"module.map"));
            FileEntry fileEntry = this.FileMgr.getFile(ModuleMapFileName.$StringRef());
            return fileEntry;
        }
        finally {
            if (ModuleMapFileName != null) {
                ModuleMapFileName.$destroy();
            }
        }
    }

    public void IncrementFrameworkLookupCount() {
        ++this.NumFrameworkLookups;
    }

    public boolean hasModuleMap(StringRef FileName, DirectoryEntry Root, boolean IsSystem) {
        SmallVector FixUpDirectories = null;
        try {
            if (!this.enabledModules() || !this.LangOpts.ModulesImplicitMaps) {
                boolean bl = false;
                return bl;
            }
            FixUpDirectories = new SmallVector(2, (Object)null);
            StringRef DirName = new StringRef(FileName);
            while (true) {
                DirName.$assignMove(path.parent_path((StringRef)DirName));
                if (path.is_empty((StringRef)DirName)) {
                    boolean bl = false;
                    return bl;
                }
                DirectoryEntry Dir = this.FileMgr.getDirectory(DirName);
                if (Dir == null) {
                    boolean bl = false;
                    return bl;
                }
                switch (this.loadModuleMapFile(Dir, IsSystem, llvm.$eq_StringRef((StringRef)path.extension((StringRef)new StringRef(Dir.getName(), Dir.getNameLen())), (StringRef)new StringRef(NativePointer.$((String)".framework"))))) {
                    case LMM_NewlyLoaded: 
                    case LMM_AlreadyLoaded: {
                        int N = FixUpDirectories.size();
                        for (int I = 0; I != N; ++I) {
                            this.DirectoryHasModuleMap.FindAndConstruct((Object)FixUpDirectories.$at((int)I)).second = true;
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
                if (Dir == Root) {
                    boolean bl = false;
                    return bl;
                }
                FixUpDirectories.push_back((Object)Dir);
            }
        }
        finally {
            if (FixUpDirectories != null) {
                FixUpDirectories.$destroy();
            }
        }
    }

    public ModuleMap.KnownHeader findModuleForHeader(FileEntry File) {
        if (this.ExternalSource != null) {
            this.getFileInfo(File);
        }
        return this.ModMap.findModuleForHeader(File);
    }

    public boolean loadModuleMapFile(FileEntry File, boolean IsSystem) {
        DirectoryEntry Dir = null;
        if (this.getHeaderSearchOpts().ModuleMapFileHomeIsCwd) {
            Dir = this.FileMgr.getDirectory(StringRef.DOT);
        } else {
            Dir = File.getDir();
            StringRef DirName = new StringRef(Dir.getName(), Dir.getNameLen());
            if (llvm.$eq_StringRef((StringRef)path.filename((StringRef)DirName), (CharSequence)"Modules")) {
                DirName.$assignMove(path.parent_path((StringRef)DirName));
                if (DirName.endswith((CharSequence)".framework")) {
                    Dir = this.FileMgr.getDirectory(DirName);
                }
                assert (Dir != null) : "parent must exist";
            }
        }
        switch (this.loadModuleMapFileImpl(File, IsSystem, Dir)) {
            case LMM_NewlyLoaded: 
            case LMM_AlreadyLoaded: {
                return false;
            }
            case LMM_NoDirectory: 
            case LMM_InvalidModuleMap: {
                return true;
            }
        }
        throw new llvm_unreachable((CharSequence)"Unknown load module map result");
    }

    public void collectAllModules(SmallVectorImpl<Module> Modules) {
        Modules.clear();
        if (this.LangOpts.ModulesImplicitMaps) {
            int N = this.SearchDirs.size();
            for (int Idx = 0; Idx != N; ++Idx) {
                boolean IsSystem = ((DirectoryLookup)this.SearchDirs.$at(Idx)).isSystemHeaderDirectory();
                if (((DirectoryLookup)this.SearchDirs.$at(Idx)).isFramework()) {
                    std_errors.error_code EC = new std_errors.error_code();
                    SmallString DirNative = new SmallString(128);
                    path.__native((Twine)new Twine(((DirectoryLookup)this.SearchDirs.$at(Idx)).getFrameworkDir().getName()), (SmallString)DirNative);
                    fs.directory_iterator Dir = new fs.directory_iterator(new Twine(DirNative.str()), EC);
                    fs.directory_iterator DirEnd = new fs.directory_iterator();
                    while (Dir.$noteq(DirEnd) && EC.$Void2Void() == null) {
                        DirectoryEntry FrameworkDir;
                        if (!llvm.$noteq_StringRef((StringRef)path.extension((StringRef)new StringRef(Dir.$arrow().path())), (StringRef)new StringRef((CharSequence)".framework")) && (FrameworkDir = this.FileMgr.getDirectory(new StringRef(Dir.$arrow().path()))) != null) {
                            this.loadFrameworkModule(path.stem((StringRef)new StringRef(Dir.$arrow().path())), FrameworkDir, IsSystem);
                        }
                        Dir.increment(EC);
                    }
                    continue;
                }
                if (((DirectoryLookup)this.SearchDirs.$at(Idx)).isHeaderMap()) continue;
                this.loadModuleMapFile(((DirectoryLookup)this.SearchDirs.$at(Idx)).getDir(), IsSystem, false);
                this.loadSubdirectoryModuleMaps((DirectoryLookup)this.SearchDirs.$at(Idx));
            }
        }
        StringMapIterator<Module> M = this.ModMap.module_begin();
        StringMapIterator<Module> MEnd = this.ModMap.module_end();
        while (M.$noteq(MEnd)) {
            Modules.push_back(M.$arrow().getValue());
            M.$preInc();
        }
    }

    public void loadTopLevelSystemModules() {
        if (!this.LangOpts.ModulesImplicitMaps) {
            return;
        }
        int N = this.SearchDirs.size();
        for (int Idx = 0; Idx != N; ++Idx) {
            if (!((DirectoryLookup)this.SearchDirs.$at(Idx)).isNormalDir()) continue;
            this.loadModuleMapFile(((DirectoryLookup)this.SearchDirs.$at(Idx)).getDir(), ((DirectoryLookup)this.SearchDirs.$at(Idx)).isSystemHeaderDirectory(), ((DirectoryLookup)this.SearchDirs.$at(Idx)).isFramework());
        }
    }

    Module loadFrameworkModule(StringRef Name, DirectoryEntry Dir, boolean IsSystem) {
        Module Module2 = this.ModMap.findModule(Name);
        if (Module2 != null) {
            return Module2;
        }
        switch (this.loadModuleMapFile(Dir, IsSystem, true)) {
            case LMM_InvalidModuleMap: {
                break;
            }
            case LMM_AlreadyLoaded: 
            case LMM_NoDirectory: {
                return null;
            }
            case LMM_NewlyLoaded: {
                return this.ModMap.findModule(Name);
            }
        }
        if (this.LangOpts.ModulesImplicitMaps) {
            return this.ModMap.inferFrameworkModule(Name, Dir, IsSystem, null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSubdirectoryModuleMaps(DirectoryLookup SearchDir) {
        SmallString DirNative = null;
        try {
            assert (this.LangOpts.ModulesImplicitMaps) : "Should not be loading subdirectory module maps";
            if (SearchDir.haveSearchedAllModuleMaps()) {
                return;
            }
            std_errors.error_code EC = new std_errors.error_code();
            DirNative = new SmallString(128);
            path.__native((Twine)new Twine(SearchDir.getDir().getName()), (SmallString)DirNative);
            fs.directory_iterator Dir = null;
            fs.directory_iterator DirEnd = null;
            try {
                Dir = new fs.directory_iterator(new Twine(DirNative.str()), EC);
                DirEnd = new fs.directory_iterator();
                while (Dir.$noteq(DirEnd) && !EC.$boolean()) {
                    this.loadModuleMapFile(new StringRef(Dir.$arrow().path()), SearchDir.isSystemHeaderDirectory(), SearchDir.isFramework());
                    Dir.increment(EC);
                }
            }
            finally {
                if (DirEnd != null) {
                    DirEnd.$destroy();
                }
                if (Dir != null) {
                    Dir.$destroy();
                }
            }
            SearchDir.setSearchedAllModuleMaps(true);
        }
        finally {
            if (DirNative != null) {
                DirNative.$destroy();
            }
        }
    }

    public ModuleMap getModuleMap() {
        return this.ModMap;
    }

    public int header_file_size() {
        return this.FileInfo.size();
    }

    public boolean tryGetFileInfo(FileEntry FE, HeaderFileInfo Result) {
        if (FE.getUID() >= this.FileInfo.size()) {
            return false;
        }
        HeaderFileInfo HFI = this.FileInfo.$at(FE.getUID());
        if (HFI.IsValid) {
            Result.$assign(HFI);
            return true;
        }
        return false;
    }

    public StdVector.iterator<DirectoryLookup> search_dir_begin() {
        return this.SearchDirs.begin();
    }

    public StdVector.iterator<DirectoryLookup> search_dir_end() {
        return this.SearchDirs.end();
    }

    std.vector<DirectoryLookup> $SearchDirs() {
        return this.SearchDirs;
    }

    public int search_dir_size() {
        return this.SearchDirs.size();
    }

    public StdVector.iterator<DirectoryLookup> quoted_dir_begin() {
        return this.SearchDirs.begin();
    }

    public StdVector.iterator<DirectoryLookup> quoted_dir_end() {
        return this.SearchDirs.begin().$add(this.AngledDirIdx);
    }

    public StdVector.iterator<DirectoryLookup> angled_dir_begin() {
        return this.SearchDirs.begin().$add(this.AngledDirIdx);
    }

    public StdVector.iterator<DirectoryLookup> angled_dir_end() {
        return this.SearchDirs.begin().$add(this.SystemDirIdx);
    }

    public StdVector.iterator<DirectoryLookup> system_dir_begin() {
        return this.SearchDirs.begin().$add(this.SystemDirIdx);
    }

    public StdVector.iterator<DirectoryLookup> system_dir_end() {
        return this.SearchDirs.end();
    }

    public StringRef getUniqueFrameworkName(StringRef Framework) {
        return ((StringMapIteratorChar)this.FrameworkNames.insert((StringRef)Framework).first).$arrow().first();
    }

    public void PrintStats() {
        this.PrintStats(llvm.errs());
    }

    public void PrintStats(raw_ostream OS) {
        OS.$out((CharSequence)String.format("\n*** HeaderSearch Stats:\n", new Object[0]));
        OS.$out((CharSequence)String.format("%d files tracked.\n", this.FileInfo.size()));
        long NumOnceOnlyFiles = 0L;
        long MaxNumIncludes = 0L;
        long NumSingleIncludedFiles = 0L;
        int e = this.FileInfo.size();
        for (int i = 0; i != e; ++i) {
            NumOnceOnlyFiles += (long)(this.FileInfo.$at((int)i).isImport ? 1 : 0);
            if (MaxNumIncludes < (long)this.FileInfo.$at((int)i).NumIncludes) {
                MaxNumIncludes = this.FileInfo.$at((int)i).NumIncludes;
            }
            NumSingleIncludedFiles += (long)(this.FileInfo.$at((int)i).NumIncludes == '\u0001' ? 1 : 0);
        }
        OS.$out((CharSequence)String.format("  %d #import/#pragma once files.\n", NumOnceOnlyFiles));
        OS.$out((CharSequence)String.format("  %d included exactly once.\n", NumSingleIncludedFiles));
        OS.$out((CharSequence)String.format("  %d max times a file is included.\n", MaxNumIncludes));
        OS.$out((CharSequence)String.format("  %d #include/#include_next/#import.\n", this.NumIncluded));
        OS.$out((CharSequence)String.format("    %d #includes skipped due to the multi-include optimization.\n", this.NumMultiIncludeFileOptzn));
        OS.$out((CharSequence)String.format("%d framework lookups.\n", this.NumFrameworkLookups));
        OS.$out((CharSequence)String.format("%d subframework lookups.\n", this.NumSubFrameworkLookups));
    }

    public long getTotalMemory() {
        return (long)this.SearchDirs.capacity() + llvm.capacity_in_bytes((NativeType.SizeofCapable)this.FileInfo) + llvm.capacity_in_bytes(this.HeaderMaps) + ((BumpPtrAllocator)this.LookupFileCache.getAllocator()).getTotalMemory() + ((BumpPtrAllocator)this.FrameworkMap.getAllocator()).getTotalMemory();
    }

    public static std.string NormalizeDashIncludePath(StringRef File, FileManager FileMgr) {
        throw new UnsupportedOperationException("They forgot to delete it?");
    }

    private LoadModuleMapResult loadModuleMapFile(StringRef DirName, boolean IsSystem, boolean IsFramework) {
        DirectoryEntry Dir = this.FileMgr.getDirectory(DirName);
        if (Dir != null) {
            return this.loadModuleMapFile(Dir, IsSystem, IsFramework);
        }
        return LoadModuleMapResult.LMM_NoDirectory;
    }

    private LoadModuleMapResult loadModuleMapFileImpl(FileEntry File, boolean IsSystem, DirectoryEntry Dir) {
        assert (File != null) : "expected FileEntry";
        std.pairTypeBool AddResult = this.LoadedModuleMaps.insert(std.make_pair((Object)File, (boolean)true));
        if (!AddResult.second) {
            return ((DenseMapIteratorTypeBool)AddResult.first).$star().second ? LoadModuleMapResult.LMM_AlreadyLoaded : LoadModuleMapResult.LMM_InvalidModuleMap;
        }
        if (this.ModMap.parseModuleMapFile(File, IsSystem, Dir)) {
            this.LoadedModuleMaps.FindAndConstruct((Object)File).second = false;
            return LoadModuleMapResult.LMM_InvalidModuleMap;
        }
        FileEntry PMMFile = HeaderSearchStatics.getPrivateModuleMap(File, this.FileMgr);
        if (PMMFile != null && this.ModMap.parseModuleMapFile(PMMFile, IsSystem, Dir)) {
            this.LoadedModuleMaps.FindAndConstruct((Object)File).second = false;
            return LoadModuleMapResult.LMM_InvalidModuleMap;
        }
        return LoadModuleMapResult.LMM_NewlyLoaded;
    }

    private LoadModuleMapResult loadModuleMapFile(DirectoryEntry Dir, boolean IsSystem, boolean IsFramework) {
        DenseMapIteratorTypeBool KnownDir = this.DirectoryHasModuleMap.find((Object)Dir);
        if (KnownDir.$noteq(new DenseMapIteratorTypeBool(this.DirectoryHasModuleMap.end()))) {
            return KnownDir.$star().second ? LoadModuleMapResult.LMM_AlreadyLoaded : LoadModuleMapResult.LMM_InvalidModuleMap;
        }
        FileEntry ModuleMapFile = this.lookupModuleMapFile(Dir, IsFramework);
        if (ModuleMapFile != null) {
            LoadModuleMapResult Result = this.loadModuleMapFileImpl(ModuleMapFile, IsSystem, Dir);
            if (Result == LoadModuleMapResult.LMM_NewlyLoaded) {
                this.DirectoryHasModuleMap.FindAndConstruct((Object)Dir).second = true;
            } else if (Result == LoadModuleMapResult.LMM_InvalidModuleMap) {
                this.DirectoryHasModuleMap.FindAndConstruct((Object)Dir).second = false;
            }
            return Result;
        }
        return LoadModuleMapResult.LMM_InvalidModuleMap;
    }

    private HeaderFileInfo getFileInfo(FileEntry FE) {
        if (FE.getUID() >= this.FileInfo.size()) {
            this.FileInfo.resize(FE.getUID() + 1);
        }
        HeaderFileInfo HFI = this.FileInfo.$at(FE.getUID());
        if (this.ExternalSource != null && !HFI.Resolved) {
            HeaderSearchStatics.mergeHeaderFileInfo(HFI, this.ExternalSource.GetHeaderFileInfo(FE));
        }
        HFI.IsValid = true;
        return HFI;
    }

    private SmallString $getLookupFileTmpDir() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$LookupFileTmpDirInUse) break block3;
                this.$LookupFileTmpDirInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$LookupFileTmpDir;
    }

    private void $releaseLookupFileTmpDir(SmallString buf) {
        assert (this.$LookupFileTmpDirInUse);
        if (!$assertionsDisabled) {
            this.$LookupFileTmpDirInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (buf == this.$LookupFileTmpDir);
        this.$LookupFileTmpDir.clear();
    }

    private SmallString $getLookupFileMappedName() {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$LookupFileMappedNameInUse) break block3;
                this.$LookupFileMappedNameInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        return this.$LookupFileMappedName;
    }

    private void $releaseLookupFileMappedName(SmallString buf) {
        assert (this.$LookupFileMappedNameInUse);
        if (!$assertionsDisabled) {
            this.$LookupFileMappedNameInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (buf == this.$LookupFileMappedName);
        this.$LookupFileMappedName.clear();
    }

    private bool.ref $getInUserSpecifiedSystemFramework(boolean val) {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$InUserSpecifiedSystemFrameworkInUse) break block3;
                this.$InUserSpecifiedSystemFrameworkInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        this.$InUserSpecifiedSystemFramework.$set(val);
        return this.$InUserSpecifiedSystemFramework;
    }

    private boolean $releaseInUserSpecifiedSystemFramework(bool.ref buf) {
        assert (this.$InUserSpecifiedSystemFrameworkInUse);
        if (!$assertionsDisabled) {
            this.$InUserSpecifiedSystemFrameworkInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (buf == this.$InUserSpecifiedSystemFramework);
        return this.$InUserSpecifiedSystemFramework.$deref();
    }

    private bool.ref $getHasBeenMapped(boolean val) {
        block2: {
            block3: {
                if ($assertionsDisabled) break block2;
                if (this.$HasBeenMappedInUse) break block3;
                this.$HasBeenMappedInUse = true;
                if (true) break block2;
            }
            throw new AssertionError();
        }
        this.$HasBeenMapped.$set(val);
        return this.$HasBeenMapped;
    }

    private boolean $releaseHasBeenMapped(bool.ref buf) {
        assert (this.$HasBeenMappedInUse);
        if (!$assertionsDisabled) {
            this.$HasBeenMappedInUse = false;
            if (!false) {
                // empty if block
            }
        }
        assert (buf == this.$HasBeenMapped);
        return this.$HasBeenMapped.$deref();
    }

    private static final class LoadModuleMapResult
    extends Enum<LoadModuleMapResult> {
        public static final /* enum */ LoadModuleMapResult LMM_AlreadyLoaded = new LoadModuleMapResult(0);
        public static final /* enum */ LoadModuleMapResult LMM_NewlyLoaded = new LoadModuleMapResult(1);
        public static final /* enum */ LoadModuleMapResult LMM_NoDirectory = new LoadModuleMapResult(2);
        public static final /* enum */ LoadModuleMapResult LMM_InvalidModuleMap = new LoadModuleMapResult(3);
        private final int value;
        private static final /* synthetic */ LoadModuleMapResult[] $VALUES;

        public static LoadModuleMapResult[] values() {
            return (LoadModuleMapResult[])$VALUES.clone();
        }

        public static LoadModuleMapResult valueOf(String name) {
            return Enum.valueOf(LoadModuleMapResult.class, name);
        }

        public static LoadModuleMapResult valueOf(int val) {
            LoadModuleMapResult out;
            LoadModuleMapResult loadModuleMapResult = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private LoadModuleMapResult(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new LoadModuleMapResult[]{LMM_AlreadyLoaded, LMM_NewlyLoaded, LMM_NoDirectory, LMM_InvalidModuleMap};
        }

        private static final class Values {
            private static final LoadModuleMapResult[] VALUES;
            private static final LoadModuleMapResult[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (LoadModuleMapResult kind : LoadModuleMapResult.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new LoadModuleMapResult[min < 0 ? 1 - min : 0];
                VALUES = new LoadModuleMapResult[max >= 0 ? 1 + max : 0];
                for (LoadModuleMapResult kind : LoadModuleMapResult.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((LoadModuleMapResult)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((LoadModuleMapResult)kind).value] = kind;
                }
            }
        }
    }

    public final class IncludeAliasMap
    extends StringMap<std.string, BumpPtrAllocator> {
        public IncludeAliasMap() {
            super((Object)new std.string());
        }
    }

    private static class LookupFileCacheInfo
    implements NativeCloneable<LookupFileCacheInfo> {
        public int StartIdx;
        public int HitIdx;
        public char.ptr MappedName;

        public LookupFileCacheInfo() {
            this.StartIdx = 0;
            this.HitIdx = 0;
            this.MappedName = null;
        }

        public void reset(int StartIdx) {
            this.StartIdx = StartIdx;
            this.MappedName = null;
        }

        public LookupFileCacheInfo(LookupFileCacheInfo $Prm0) {
            this.StartIdx = $Prm0.StartIdx;
            this.HitIdx = $Prm0.HitIdx;
            this.MappedName = Native.$tryClone((char.ptr)$Prm0.MappedName);
        }

        public LookupFileCacheInfo(JavaDifferentiators.Move _dparam, LookupFileCacheInfo $Prm0) {
            this.StartIdx = $Prm0.StartIdx;
            this.HitIdx = $Prm0.HitIdx;
            this.MappedName = Native.$tryClone((char.ptr)$Prm0.MappedName);
        }

        public LookupFileCacheInfo clone() {
            return new LookupFileCacheInfo(this);
        }

        public String toString() {
            return "StartIdx=" + this.StartIdx + ", HitIdx=" + this.HitIdx + ", MappedName=" + this.MappedName;
        }
    }

    static class FrameworkCacheEntry
    implements NativeCloneable<FrameworkCacheEntry> {
        public DirectoryEntry Directory;
        public boolean IsUserSpecifiedSystemFramework;

        public FrameworkCacheEntry() {
            this.Directory = null;
            this.IsUserSpecifiedSystemFramework = false;
        }

        public FrameworkCacheEntry(FrameworkCacheEntry $Prm0) {
            this.Directory = $Prm0.Directory;
            this.IsUserSpecifiedSystemFramework = $Prm0.IsUserSpecifiedSystemFramework;
        }

        public FrameworkCacheEntry(JavaDifferentiators.Move _dparam, FrameworkCacheEntry $Prm0) {
            this.Directory = $Prm0.Directory;
            this.IsUserSpecifiedSystemFramework = $Prm0.IsUserSpecifiedSystemFramework;
        }

        public FrameworkCacheEntry $assign(FrameworkCacheEntry $Prm0) {
            this.Directory = $Prm0.Directory;
            this.IsUserSpecifiedSystemFramework = $Prm0.IsUserSpecifiedSystemFramework;
            return this;
        }

        public FrameworkCacheEntry clone() {
            return new FrameworkCacheEntry(this);
        }

        public String toString() {
            return "FrameworkCacheEntry{Directory=" + this.Directory + ", IsUserSpecifiedSystemFramework=" + this.IsUserSpecifiedSystemFramework + '}';
        }
    }
}

