/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import java.util.Arrays;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.tok;
import org.clang.lex.Lexer;
import org.clang.lex.MacroInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.SmallVectorToken;
import org.clang.lex.Token;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.bool;
import org.llvm.adt.SmallString;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public class MacroArgs
implements Destructors.ClassWithDestructor {
    private int NumUnexpArgTokens;
    private final Token[] UnexpArgTokens;
    private boolean VarargsElided;
    private final SmallVector<SmallVectorToken> PreExpArgTokens;
    private final SmallVectorToken StringifiedArgs;
    private MacroArgs ArgCache;
    private static long instances = 0L;

    private MacroArgs(int NumToks, boolean varargsElided) {
        this.NumUnexpArgTokens = NumToks;
        this.UnexpArgTokens = new Token[NumToks];
        for (int i = 0; i < this.UnexpArgTokens.length; ++i) {
            this.UnexpArgTokens[i] = new Token();
        }
        this.VarargsElided = varargsElided;
        this.PreExpArgTokens = new SmallVector(0, null);
        this.StringifiedArgs = new SmallVectorToken(0, null);
        this.ArgCache = null;
        MacroArgs.trackInstance();
    }

    public void $destroy() {
        this.PreExpArgTokens.set_size(0);
        this.PreExpArgTokens.set_size(0);
        this.StringifiedArgs.set_size(0);
        for (int i = 0; i < this.NumUnexpArgTokens; ++i) {
            this.UnexpArgTokens[i].$destroy();
        }
    }

    public static MacroArgs create(MacroInfo MI, SmallVectorToken UnexpArgTokens, boolean VarargsElided, Preprocessor PP) {
        MacroArgs Result;
        assert (MI.isFunctionLike()) : "Can't have args for an object-like macro!";
        MacroArgs ResultEnt = null;
        MacroArgs PreviousEnt = null;
        MacroArgs PreviousForResultEnt = null;
        long ClosestMatch = Long.MAX_VALUE;
        int neededSize = UnexpArgTokens.size();
        MacroArgs Entry2 = PP.MacroArgCache;
        while (Entry2 != null) {
            if (Entry2.NumUnexpArgTokens >= neededSize && (long)Entry2.NumUnexpArgTokens < ClosestMatch) {
                ResultEnt = Entry2;
                PreviousForResultEnt = PreviousEnt;
                if (Entry2.NumUnexpArgTokens == neededSize) break;
                ClosestMatch = Entry2.NumUnexpArgTokens;
            }
            PreviousEnt = Entry2;
            Entry2 = Entry2.ArgCache;
        }
        if (ResultEnt == null) {
            Result = new MacroArgs(neededSize, VarargsElided);
        } else {
            Result = ResultEnt;
            assert (Result != null);
            --PP.MacroArgCacheNumEntries;
            PP.MacroArgCacheCapacity -= (long)Result.$UnexpArgTokens().length;
            if (PreviousForResultEnt == null) {
                assert (PP.MacroArgCache == Result);
                PP.MacroArgCache = Result.ArgCache;
            } else {
                assert (PreviousForResultEnt.ArgCache == Result);
                PreviousForResultEnt.ArgCache = Result.ArgCache;
            }
            Result.NumUnexpArgTokens = neededSize;
            Result.VarargsElided = VarargsElided;
        }
        if (!UnexpArgTokens.empty()) {
            for (int i = 0; i < neededSize; ++i) {
                Result.$UnexpArgTokens()[i].$assign(UnexpArgTokens.$array()[i]);
            }
        }
        return Result;
    }

    public void destroy(Preprocessor PP) {
        this.StringifiedArgs.clear();
        long e = this.PreExpArgTokens.size();
        for (long i = 0L; i != e; ++i) {
            ((SmallVectorToken)this.PreExpArgTokens.$at(i)).clear();
        }
        int capacity = this.$UnexpArgTokens().length;
        if (capacity < Preprocessor.MACRO_ARG_ELEMENT_MAX_CAPACITY && PP.MacroArgCacheCapacity < (long)Preprocessor.MACRO_ARG_CACHE_MAX_CAPACITY) {
            this.ArgCache = PP.MacroArgCache;
            PP.MacroArgCache = this;
            ++PP.MacroArgCacheNumEntries;
            PP.MacroArgCacheCapacity += (long)capacity;
        } else if (NativeTrace.VERBOSE_MODE) {
            llvm.errs().$out((CharSequence)"<=Skip MacroArg ").$out((CharSequence)NativeTrace.formatNumber((long)capacity, (int)12));
            llvm.errs().$out((CharSequence)" Where Total Capacity ").$out((CharSequence)NativeTrace.formatNumber((long)PP.MacroArgCacheCapacity, (int)12)).$out((CharSequence)"\n");
        }
    }

    public static boolean ArgNeedsPreexpansion(Token[] ArgTok, int ArgTokenIdx, Preprocessor PP) {
        while (ArgTok[ArgTokenIdx].isNot((short)1)) {
            IdentifierInfo II = ArgTok[ArgTokenIdx].getIdentifierInfo();
            if (II != null && II.hasMacroDefinition() && PP.getMacroInfo(II).isEnabled()) {
                return true;
            }
            ++ArgTokenIdx;
        }
        return false;
    }

    public int getUnexpArgument(int Arg) {
        int Result = 0;
        while (Arg != 0) {
            assert (Result < this.NumUnexpArgTokens) : "Invalid arg #";
            if (this.UnexpArgTokens[Result].is((short)1)) {
                --Arg;
            }
            ++Result;
        }
        assert (Result < this.NumUnexpArgTokens) : "Invalid arg #";
        return Result;
    }

    public Token[] $UnexpArgTokens() {
        return this.UnexpArgTokens;
    }

    public static int getArgLength(Token[] ArgPtr, int ArgPtrIdx) {
        int NumArgTokens = 0;
        while (ArgPtr[ArgPtrIdx].isNot((short)1)) {
            ++NumArgTokens;
            ++ArgPtrIdx;
        }
        return NumArgTokens;
    }

    public SmallVectorToken getPreExpArgument(int Arg, MacroInfo MI, Preprocessor PP) {
        SmallVectorToken Result;
        boolean PreExpandingMacroArgs = PP.InMacroArgPreExpansion;
        assert (Arg < MI.getNumArgs()) : "Invalid argument number!";
        if (this.PreExpArgTokens.size() < MI.getNumArgs()) {
            this.PreExpArgTokens.resize(MI.getNumArgs(), (Object)new SmallVectorToken(0, null));
        }
        if (!(Result = (SmallVectorToken)this.PreExpArgTokens.$at(Arg)).empty()) {
            PP.InMacroArgPreExpansion = PreExpandingMacroArgs;
            return Result;
        }
        PP.InMacroArgPreExpansion = true;
        int AT = this.getUnexpArgument(Arg);
        int NumToks = MacroArgs.getArgLength(this.$UnexpArgTokens(), AT) + 1;
        PP.EnterTokenStream(this.$UnexpArgTokens(), AT, NumToks, false, false);
        do {
            Result.push_back(new Token());
            Token Tok = Result.back();
            PP.Lex(Tok);
        } while (Result.back().isNot((short)1));
        if (PP.InCachingLexMode()) {
            PP.ExitCachingLexMode();
        }
        PP.RemoveTopOfLexerStack();
        PP.InMacroArgPreExpansion = PreExpandingMacroArgs;
        return Result;
    }

    public Token getStringifiedArgument(int ArgNo, Preprocessor PP, int ExpansionLocStart, int ExpansionLocEnd) {
        assert (ArgNo < this.NumUnexpArgTokens) : "Invalid argument number!";
        if (this.StringifiedArgs.empty()) {
            this.StringifiedArgs.resize(this.getNumArguments());
            Token[] $array = this.StringifiedArgs.$array();
            for (int i = 0; i < this.getNumArguments(); ++i) {
                $array[i].startToken();
            }
        }
        if (this.StringifiedArgs.$at(ArgNo).isNot((short)13)) {
            this.StringifiedArgs.$set(ArgNo, MacroArgs.StringifyArgument(this.$UnexpArgTokens(), this.getUnexpArgument(ArgNo), PP, false, ExpansionLocStart, ExpansionLocEnd));
        }
        return this.StringifiedArgs.$at(ArgNo);
    }

    public int getNumArguments() {
        return this.NumUnexpArgTokens;
    }

    public boolean isVarargsElidedUse() {
        return this.VarargsElided;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Token StringifyArgument(Token[] ArgToks, int ArgToksIdx, Preprocessor PP, boolean Charify, int ExpansionLocStart, int ExpansionLocEnd) {
        Token _Tok = new Token();
        _Tok.startToken();
        _Tok.setKind(Charify ? (short)8 : 13);
        int ArgTokStart = ArgToksIdx;
        SmallString Result = PP.$getStringifyArgument_Result();
        try {
            Result.$addassign(NativePointer.$((char)'\"'));
            boolean isFirst = true;
            while (ArgToks[ArgToksIdx].isNot((short)1)) {
                Token Tok = ArgToks[ArgToksIdx];
                if (!isFirst && (Tok.hasLeadingSpace() || Tok.isAtStartOfLine())) {
                    Result.$addassign(NativePointer.$((char)' '));
                }
                isFirst = false;
                if (tok.isStringLiteral((short)Tok.getKind()) || Tok.is((short)8) || Tok.is((short)9) || Tok.is((short)10) || Tok.is((short)11) || Tok.is((short)12)) {
                    bool.ptr Invalid = NativePointer.create_bool$ptr((boolean)false);
                    std.string TokStr = PP.getSpelling(Tok, Invalid);
                    if (!Invalid.$star()) {
                        std.string Str = Lexer.Stringify(TokStr);
                        Result.append(Str);
                    }
                } else if (Tok.is((short)3)) {
                    PP.CodeCompleteNaturalLanguage();
                } else {
                    long CurStrLen = Result.size();
                    Result.resize(CurStrLen + (long)Tok.getLength());
                    long ActualTokLen = PP.copySpelling(Tok, Result, CurStrLen);
                    if (ActualTokLen != -1L && ActualTokLen != (long)Tok.getLength()) {
                        Result.resize(CurStrLen + ActualTokLen);
                    }
                }
                ++ArgToksIdx;
            }
            if (Result.back() == 92) {
                long FirstNonSlash = Result.size() - 2;
                while (Result.$at(FirstNonSlash) == 92) {
                    --FirstNonSlash;
                }
                if (((long)(Result.size() - 1) - FirstNonSlash & 1L) != 0L) {
                    PP.Diag(ArgToks[ArgToksIdx - 1], 826L).$destroy();
                    Result.pop_back();
                }
            }
            Result.$addassign(NativePointer.$((char)'\"'));
            if (Charify) {
                Result.$set(0, NativePointer.$((char)'\''));
                Result.$set(Result.size() - 1, NativePointer.$((char)'\''));
                boolean isBad = false;
                if (Result.size() == 3) {
                    isBad = Result.$at(1) == NativePointer.$((char)'\'');
                } else {
                    boolean bl = isBad = Result.size() != 4 || Result.$at(1) != 92;
                }
                if (isBad) {
                    PP.Diag(ArgToks[ArgTokStart], 639L).$destroy();
                    Result.$assign((CharSequence)"' '");
                }
            }
            PP.CreateString(Result.$array(), 0, Result.size(), _Tok, ExpansionLocStart, ExpansionLocEnd);
            Token token = _Tok;
            return token;
        }
        finally {
            PP.$releaseStringifyArgument_Result(Result);
        }
    }

    public MacroArgs deallocate() {
        MacroArgs Next = this.ArgCache;
        this.$destroy();
        std.free((Object)this);
        return Next;
    }

    public String toString() {
        return "MacroArgs{NumUnexpArgTokens=" + this.NumUnexpArgTokens + ", UnexpArgTokens=" + Arrays.toString(this.UnexpArgTokens) + ", VarargsElided=" + this.VarargsElided + ", PreExpArgTokens=" + this.PreExpArgTokens + ", StringifiedArgs=" + this.StringifiedArgs + ", ArgCache=" + this.ArgCache + '}';
    }

    private static void trackInstance() {
        if (NativeTrace.STATISTICS) {
            ++instances;
        }
    }

    public static void clearStatistics() {
        instances = 0L;
    }

    public static void PrintStats(raw_ostream out) {
        out.$out((CharSequence)String.format("%22s created:\t", MacroArgs.class.getSimpleName())).$out((CharSequence)NativeTrace.formatNumber((long)instances)).$out((CharSequence)".\n");
    }
}

