/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.ClangGlobals;
import org.clang.basic.FileID;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.basic.io;
import org.clang.lex.PPConditionalInfo;
import org.clang.lex.PTHManager;
import org.clang.lex.Preprocessor;
import org.clang.lex.PreprocessorLexer;
import org.clang.lex.Token;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeType;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uchar;
import org.clank.support.void;
import org.llvm.support.llvm;

public class PTHLexer
extends PreprocessorLexer
implements Destructors.ClassWithDestructor {
    private SourceLocation FileStartLoc;
    private uchar.ptr TokBuf;
    private uchar.ptr CurPtr;
    private uchar.ptr LastHashTokPtr;
    private uchar.ptr PPCond;
    private uchar.ptr CurPPCondPtr;
    private PTHManager PTHMgr;
    private Token EofToken;
    private static final int DISK_TOKEN_SIZE = 12;

    private PTHLexer(PTHLexer $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private void $assign(PTHLexer $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private void ReadToken(Token T) {
        throw new UnsupportedOperationException("ReadToken doesn't have implementation");
    }

    private boolean LexEndOfFile(Token Result) {
        if (this.ParsingPreprocessorDirective) {
            this.ParsingPreprocessorDirective = false;
            return true;
        }
        assert (!this.LexingRawMode);
        while (!this.ConditionalStack.empty()) {
            if (ClangGlobals.$noteq_SourceLocation((SourceLocation)this.PP.getCodeCompletionFileLoc(), (SourceLocation)this.FileStartLoc)) {
                this.PP.Diag(((PPConditionalInfo)this.ConditionalStack.back()).getIfLoc(), 734L).$destroy();
            }
            this.ConditionalStack.pop_back();
        }
        return this.PP.HandleEndOfFile(Result);
    }

    protected PTHLexer(Preprocessor PP, FileID FID, uchar.ptr D, uchar.ptr ppcond, PTHManager PM) {
        this(PP, FID.$ID(), D, ppcond, PM);
    }

    protected PTHLexer(Preprocessor PP, int FID, uchar.ptr D, uchar.ptr ppcond, PTHManager PM) {
        super(PP, FID);
        this.FileStartLoc = new SourceLocation();
        this.TokBuf = D;
        this.CurPtr = D;
        this.LastHashTokPtr = null;
        this.PPCond = ppcond;
        this.CurPPCondPtr = ppcond;
        this.PTHMgr = PM;
        this.EofToken = new Token();
        this.FileStartLoc.$assign(PP.getSourceManager().getLocForStartOfFile(FID));
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public boolean Lex(Token Tok) {
        uchar.ptr CurPtrShadow = Native.$tryClone((uchar.ptr)this.CurPtr);
        long Word0 = (Long)llvm.support.endian.readNext((uchar.ptr)CurPtrShadow, Long.class, (llvm.support.endianness)llvm.support.endianness.little, (long)0L);
        long IdentifierID = (Long)llvm.support.endian.readNext((uchar.ptr)CurPtrShadow, Long.class, (llvm.support.endianness)llvm.support.endianness.little, (long)0L);
        long FileOffset = (Long)llvm.support.endian.readNext((uchar.ptr)CurPtrShadow, Long.class, (llvm.support.endianness)llvm.support.endianness.little, (long)0L);
        short TKind = (short)(Word0 & 0xFFL);
        int TFlags = (int)(Word0 >> 8 & 0xFFL);
        long Len = Word0 >> 16;
        this.CurPtr = Native.$tryClone((uchar.ptr)CurPtrShadow);
        Tok.startToken();
        Tok.setKind(TKind);
        Tok.setFlag(TFlags);
        assert (!this.LexingRawMode);
        Tok.setLocation(this.FileStartLoc.getLocWithOffset(FileOffset));
        Tok.setLength(Len);
        if (Tok.isLiteral()) {
            Tok.setLiteralData((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)((void.ptr)this.PTHMgr.SpellingBase.$add(IdentifierID))));
        } else if (IdentifierID != 0L) {
            this.MIOpt.ReadToken();
            IdentifierInfo II = this.PTHMgr.GetIdentifierInfo(IdentifierID - 1L);
            Tok.setIdentifierInfo(II);
            Tok.setKind(II.getTokenID());
            if (II.isHandleIdentifierCase()) {
                return this.PP.HandleIdentifier(Tok);
            }
            return true;
        }
        if (TKind == 1) {
            this.EofToken.$assign(Tok);
            assert (!this.ParsingPreprocessorDirective);
            assert (!this.LexingRawMode);
            return this.LexEndOfFile(Tok);
        }
        if (TKind == 65 && Tok.isAtStartOfLine()) {
            this.LastHashTokPtr = (uchar.ptr)this.CurPtr.$sub(12L);
            assert (!this.LexingRawMode);
            this.PP.HandleDirective(Tok);
            return false;
        }
        if (TKind == 2) {
            assert (this.ParsingPreprocessorDirective);
            this.ParsingPreprocessorDirective = false;
            return true;
        }
        this.MIOpt.ReadToken();
        return true;
    }

    public void getEOF(Token Tok) {
        assert (this.EofToken.is((short)1));
        Tok.$assign(this.EofToken);
    }

    public void DiscardToEndOfLine() {
        byte y;
        short x;
        assert (this.ParsingPreprocessorDirective && !this.ParsingFilename) : "Must be in a preprocessing directive!";
        this.ParsingPreprocessorDirective = false;
        uchar.ptr p = Native.$tryClone((uchar.ptr)this.CurPtr);
        while ((x = (short)((byte)p.$star())) != 1 && ((y = (byte)p.$at(1)) & 1) == 0) {
            p.$inc(12L);
        }
        this.CurPtr = Native.$tryClone((uchar.ptr)p);
    }

    public int isNextPPTokenLParen() {
        short x = (short)this.CurPtr.$star();
        return x == 1 ? 2 : (x == 21 ? 1 : 0);
    }

    @Override
    public void IndirectLex(Token Result) {
        this.Lex(Result);
    }

    @Override
    public SourceLocation getSourceLocation() {
        uchar.ptr OffsetPtr = (uchar.ptr)this.CurPtr.$add(8L);
        long Offset = (Long)llvm.support.endian.readNext((uchar.ptr)OffsetPtr, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L);
        return this.FileStartLoc.getLocWithOffset(Offset);
    }

    public boolean SkipBlock() {
        boolean isEndif;
        long TableIdx;
        assert (this.CurPPCondPtr != null) : "No cached PP conditional information.";
        assert (this.LastHashTokPtr != null) : "No known '#' token.";
        uchar.ptr HashEntryI = null;
        do {
            long Offset = (Long)llvm.support.endian.readNext((uchar.ptr)this.CurPPCondPtr, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L);
            TableIdx = (Long)llvm.support.endian.readNext((uchar.ptr)this.CurPPCondPtr, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L);
            HashEntryI = (uchar.ptr)this.TokBuf.$add(Offset);
            if (!HashEntryI.$less((Object)this.LastHashTokPtr) || TableIdx == 0L) continue;
            uchar.ptr NextPPCondPtr = (uchar.ptr)this.PPCond.$add(TableIdx * (long)(NativeType.sizeof(Long.TYPE) * 2));
            assert (NextPPCondPtr.$greatereq((Object)this.CurPPCondPtr));
            uchar.ptr HashEntryJ = (uchar.ptr)this.TokBuf.$add(((Long)llvm.support.endian.readNext((uchar.ptr)NextPPCondPtr, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L)).longValue());
            if (!HashEntryJ.$lesseq((Object)this.LastHashTokPtr)) continue;
            HashEntryI = Native.$tryClone((uchar.ptr)HashEntryJ);
            TableIdx = io.ReadLE32((uchar.ptr)NextPPCondPtr);
            this.CurPPCondPtr = Native.$tryClone((uchar.ptr)NextPPCondPtr);
        } while (HashEntryI.$less((Object)this.LastHashTokPtr));
        assert (HashEntryI == this.LastHashTokPtr) : "No PP-cond entry found for '#'";
        assert (TableIdx != 0L) : "No jumping from #endifs.";
        uchar.ptr NextPPCondPtr = (uchar.ptr)this.PPCond.$add(TableIdx * (long)(NativeType.sizeof(Long.TYPE) * 2));
        assert (NextPPCondPtr.$greatereq((Object)this.CurPPCondPtr));
        this.CurPPCondPtr = Native.$tryClone((uchar.ptr)NextPPCondPtr);
        HashEntryI = (uchar.ptr)this.TokBuf.$add(io.ReadLE32((uchar.ptr)NextPPCondPtr));
        long NextIdx = io.ReadLE32((uchar.ptr)NextPPCondPtr);
        boolean bl = isEndif = NextIdx == 0L;
        if (this.CurPtr.$greater((Object)HashEntryI)) {
            assert (this.CurPtr.$eq((Object)HashEntryI.$add(12L)));
            if (isEndif) {
                this.CurPtr.$inc(24L);
            } else {
                this.LastHashTokPtr = Native.$tryClone((uchar.ptr)HashEntryI);
            }
            return isEndif;
        }
        this.CurPtr = Native.$tryClone((uchar.ptr)HashEntryI);
        this.LastHashTokPtr = Native.$tryClone((uchar.ptr)this.CurPtr);
        assert (this.CurPtr.$star() == 'A');
        this.CurPtr.$inc(12L);
        if (isEndif) {
            this.CurPtr.$inc(24L);
        }
        return isEndif;
    }
}

