/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.CharSourceRange;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.MemberPointers;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.lex.ExternalPreprocessingRecordSource;
import org.clang.lex.InclusionDirective;
import org.clang.lex.MacroArgs;
import org.clang.lex.MacroDefinition;
import org.clang.lex.MacroDirective;
import org.clang.lex.MacroExpansion;
import org.clang.lex.MacroInfo;
import org.clang.lex.PPCallbacks;
import org.clang.lex.PreprocessedEntity;
import org.clang.lex.Token;
import org.clang.lex.impl.PreprocessingRecordStatics;
import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.DenseMapInfoObject;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.llvm;

public class PreprocessingRecord
extends PPCallbacks
implements Destructors.ClassWithDestructor {
    private SourceManager SourceMgr;
    private BumpPtrAllocator BumpAlloc;
    private std.vector<PreprocessedEntity> PreprocessedEntities;
    private std.vector<PreprocessedEntity> LoadedPreprocessedEntities;
    private std.vector<SourceRange> SkippedRanges;
    private DenseMap<MacroInfo, MacroDefinition> MacroDefinitions;
    private ExternalPreprocessingRecordSource ExternalSource;
    private static final MemberPointers.SourceRange$GetSourceLocation SourceRange$getBegin = new MemberPointers.SourceRange$GetSourceLocation(){

        public SourceLocation $call(SourceRange obj) {
            return obj.getBegin();
        }
    };
    private Unnamed_struct3 CachedRangeQuery;

    private static PPEntityID getPPEntityID(int Index, boolean isLoaded) {
        return isLoaded ? new PPEntityID(-Index - 1) : new PPEntityID(Index + 1);
    }

    private PreprocessedEntity getPreprocessedEntity(PPEntityID PPID) {
        if (PPID.ID < 0) {
            int Index = -PPID.ID - 1;
            assert (Index < this.LoadedPreprocessedEntities.size()) : "Out-of bounds loaded preprocessed entity";
            return this.getLoadedPreprocessedEntity(Index);
        }
        if (PPID.ID == 0) {
            return null;
        }
        int Index = PPID.ID - 1;
        assert (Index < this.PreprocessedEntities.size()) : "Out-of bounds local preprocessed entity";
        return (PreprocessedEntity)this.PreprocessedEntities.$at(Index);
    }

    private PreprocessedEntity getLoadedPreprocessedEntity(int Index) {
        assert (Index < this.LoadedPreprocessedEntities.size()) : "Out-of bounds loaded preprocessed entity";
        assert (this.ExternalSource != null) : "No external source to load from";
        PreprocessedEntity Entity = (PreprocessedEntity)this.LoadedPreprocessedEntities.$at(Index);
        if (Entity == null) {
            Entity = this.ExternalSource.ReadPreprocessedEntity(Index);
            if (Entity == null) {
                Entity = new PreprocessedEntity(PreprocessedEntity.EntityKind.InvalidKind, new SourceRange());
            }
            this.LoadedPreprocessedEntities.ref$at(Index).$set((Object)Entity);
        }
        return Entity;
    }

    private int getNumLoadedPreprocessedEntities() {
        return this.LoadedPreprocessedEntities.size();
    }

    private std.pairUIntUInt findLocalPreprocessedEntitiesInRange(SourceRange Range) {
        if (Range.isInvalid()) {
            return std.make_pair_uint_uint((long)0L, (long)0L);
        }
        assert (!this.SourceMgr.isBeforeInTranslationUnit(Range.getEnd(), Range.getBegin()));
        int Begin = this.findBeginLocalPreprocessedEntity(Range.getBegin());
        int End = this.findEndLocalPreprocessedEntity(Range.getEnd());
        return std.make_pair_uint_uint((long)Begin, (long)End);
    }

    private int findBeginLocalPreprocessedEntity(SourceLocation Loc) {
        if (this.SourceMgr.isLoadedSourceLocation(Loc)) {
            return 0;
        }
        int Count = this.PreprocessedEntities.size();
        StdVector.iterator First = this.PreprocessedEntities.begin();
        StdVector.iterator I = new StdVector.iterator(this.PreprocessedEntities, 0, false);
        while (Count > 0) {
            int Half = Count / 2;
            I.$assign(First);
            std.advance((abstract_iterator)I, (long)Half);
            if (this.SourceMgr.isBeforeInTranslationUnit(((PreprocessedEntity)I.$star()).getSourceRange().getEnd(), Loc)) {
                First.$assign(I);
                First.$preInc();
                Count = Count - Half - 1;
                continue;
            }
            Count = Half;
        }
        return std.$minus___normal_iterator((StdVector.iterator)First, (StdVector.iterator)this.PreprocessedEntities.begin());
    }

    private int findEndLocalPreprocessedEntity(SourceLocation Loc) {
        if (this.SourceMgr.isLoadedSourceLocation(Loc)) {
            return 0;
        }
        StdVector.iterator I = (StdVector.iterator)std.upper_bound((type.iterator)this.PreprocessedEntities.begin(), (type.iterator)this.PreprocessedEntities.end(), (Object)Loc, (Native.ComparatorLower)new PreprocessingRecordStatics.PPEntityComp(this.SourceMgr, SourceRange$getBegin));
        return std.$minus___normal_iterator((StdVector.iterator)I, (StdVector.iterator)this.PreprocessedEntities.begin());
    }

    private int allocateLoadedEntities(int NumEntities) {
        int Result = this.LoadedPreprocessedEntities.size();
        this.LoadedPreprocessedEntities.resize(this.LoadedPreprocessedEntities.size() + NumEntities);
        return Result;
    }

    private void RegisterMacroDefinition(MacroInfo Macro, MacroDefinition Def) {
        this.MacroDefinitions.ref$at((Object)Macro).$set((Object)Def);
    }

    public PreprocessingRecord(SourceManager SM) {
        this.SourceMgr = SM;
        this.BumpAlloc = new BumpPtrAllocator();
        this.PreprocessedEntities = new std.vector((Object)null);
        this.LoadedPreprocessedEntities = new std.vector((Object)null);
        this.SkippedRanges = new std.vector((Object)new SourceRange());
        this.MacroDefinitions = new DenseMap((DenseMapInfo)new DenseMapInfoObject((Object)new MacroInfo(), (Object)new MacroInfo()), null);
        this.ExternalSource = null;
        this.CachedRangeQuery = new Unnamed_struct3();
    }

    public char.ptr Allocate(int Size) {
        return this.Allocate(Size, 8);
    }

    public char.ptr Allocate(int Size, int Align) {
        return this.BumpAlloc.Allocate(Size, Align);
    }

    public void Deallocate(void.ptr Ptr) {
    }

    public long getTotalMemory() {
        return this.BumpAlloc.getTotalMemory() + llvm.capacity_in_bytes(this.MacroDefinitions) + llvm.capacity_in_bytes(this.PreprocessedEntities) + llvm.capacity_in_bytes(this.LoadedPreprocessedEntities);
    }

    public SourceManager getSourceManager() {
        return this.SourceMgr;
    }

    public iterator begin() {
        return new iterator(this, -this.LoadedPreprocessedEntities.size());
    }

    public iterator end() {
        return new iterator(this, this.PreprocessedEntities.size());
    }

    public iterator local_begin() {
        return new iterator(this, 0);
    }

    public iterator local_end() {
        return new iterator(this, this.PreprocessedEntities.size());
    }

    public std.pair<iterator, iterator> getIteratorsForLoadedRange(int start, int count) {
        int end = start + count;
        assert (end <= this.LoadedPreprocessedEntities.size());
        return std.make_pair((Object)new iterator(this, start - this.LoadedPreprocessedEntities.size()), (Object)new iterator(this, end - this.LoadedPreprocessedEntities.size()));
    }

    public std.pair<iterator, iterator> getPreprocessedEntitiesInRange(SourceRange Range) {
        if (Range.isInvalid()) {
            return std.make_pair((Object)new iterator(), (Object)new iterator());
        }
        if (this.CachedRangeQuery.Range.$eq(Range)) {
            return std.make_pair((Object)new iterator(this, this.CachedRangeQuery.Result.first), (Object)new iterator(this, this.CachedRangeQuery.Result.second));
        }
        std.pairIntInt Res = this.getPreprocessedEntitiesInRangeSlow(Range);
        this.CachedRangeQuery.Range.$assign(Range);
        this.CachedRangeQuery.Result.$assign(Res);
        return std.make_pair((Object)new iterator(this, Res.first), (Object)new iterator(this, Res.second));
    }

    public boolean isEntityInFileID(iterator PPEI, FileID FID) {
        if (FID.isInvalid()) {
            return false;
        }
        int Pos = PPEI.Position;
        if (Pos < 0) {
            if (-Pos - 1 >= this.LoadedPreprocessedEntities.size()) {
                assert (false) : "Out-of bounds loaded preprocessed entity";
                return false;
            }
            assert (this.ExternalSource != null) : "No external source to load from";
            int LoadedIndex = this.LoadedPreprocessedEntities.size() + Pos;
            PreprocessedEntity PPE = (PreprocessedEntity)this.LoadedPreprocessedEntities.$at(LoadedIndex);
            if (PPE != null) {
                return PreprocessingRecordStatics.isPreprocessedEntityIfInFileID(PPE, FID, this.SourceMgr);
            }
            ADTAliases.OptionalBool IsInFile = this.ExternalSource.isPreprocessedEntityInFileID(LoadedIndex, FID);
            if (IsInFile.hasValue()) {
                return (Boolean)IsInFile.getValue();
            }
            return PreprocessingRecordStatics.isPreprocessedEntityIfInFileID(this.getLoadedPreprocessedEntity(LoadedIndex), FID, this.SourceMgr);
        }
        if (Pos >= this.PreprocessedEntities.size()) {
            assert (false) : "Out-of bounds local preprocessed entity";
            return false;
        }
        return PreprocessingRecordStatics.isPreprocessedEntityIfInFileID((PreprocessedEntity)this.PreprocessedEntities.$at(Pos), FID, this.SourceMgr);
    }

    public PPEntityID addPreprocessedEntity(PreprocessedEntity Entity) {
        assert (Entity != null);
        SourceLocation BeginLoc = Entity.getSourceRange().getBegin();
        if (llvm.isa(MacroDefinition.class, (Object)Entity)) {
            assert (this.PreprocessedEntities.empty() || !this.SourceMgr.isBeforeInTranslationUnit(BeginLoc, ((PreprocessedEntity)this.PreprocessedEntities.back()).getSourceRange().getBegin())) : "a macro definition was encountered out-of-order";
            this.PreprocessedEntities.push_back((Object)Entity);
            return PreprocessingRecord.getPPEntityID(this.PreprocessedEntities.size() - 1, false);
        }
        if (this.PreprocessedEntities.empty() || !this.SourceMgr.isBeforeInTranslationUnit(BeginLoc, ((PreprocessedEntity)this.PreprocessedEntities.back()).getSourceRange().getBegin())) {
            this.PreprocessedEntities.push_back((Object)Entity);
            return PreprocessingRecord.getPPEntityID(this.PreprocessedEntities.size() - 1, false);
        }
        StdVector.iterator RI = this.PreprocessedEntities.end();
        StdVector.iterator Begin = this.PreprocessedEntities.begin();
        for (int count = 0; std.$noteq___normal_iterator((StdVector.iterator)RI, (StdVector.iterator)Begin) && count < 4; ++count) {
            StdVector.iterator I = (StdVector.iterator)Native.$tryClone((NativeCloneable)RI);
            I.$preDec();
            if (!this.SourceMgr.isBeforeInTranslationUnit(BeginLoc, ((PreprocessedEntity)I.$star()).getSourceRange().getBegin())) {
                StdVector.iterator insertI = this.PreprocessedEntities.insert(RI, (Object)Entity);
                return PreprocessingRecord.getPPEntityID(std.$minus___normal_iterator((StdVector.iterator)insertI, (StdVector.iterator)this.PreprocessedEntities.begin()), false);
            }
            RI.$preDec();
        }
        StdVector.iterator I = (StdVector.iterator)std.upper_bound((type.iterator)this.PreprocessedEntities.begin(), (type.iterator)this.PreprocessedEntities.end(), (Object)BeginLoc, (Native.ComparatorLower)new PreprocessingRecordStatics.PPEntityComp(this.SourceMgr, SourceRange$getBegin));
        StdVector.iterator insertI = this.PreprocessedEntities.insert(I, (Object)Entity);
        return PreprocessingRecord.getPPEntityID(std.$minus___normal_iterator((StdVector.iterator)insertI, (StdVector.iterator)this.PreprocessedEntities.begin()), false);
    }

    public void SetExternalSource(ExternalPreprocessingRecordSource Source) {
        assert (this.ExternalSource == null) : "Preprocessing record already has an external source";
        this.ExternalSource = Source;
    }

    public ExternalPreprocessingRecordSource getExternalSource() {
        return this.ExternalSource;
    }

    public MacroDefinition findMacroDefinition(MacroInfo MI) {
        DenseMapIterator Pos = this.MacroDefinitions.find((Object)MI);
        if (Pos.$eq(this.MacroDefinitions.end())) {
            return null;
        }
        return (MacroDefinition)Pos.$star().second;
    }

    public std.vector<SourceRange> getSkippedRanges() {
        return this.SkippedRanges;
    }

    @Override
    public void MacroExpands(Token Id, MacroDirective MD, SourceRange Range, MacroArgs Args) {
        this.addMacroExpansion(Id, MD.getMacroInfo(), Range);
    }

    @Override
    public void MacroDefined(SourceLocation HashLoc, SourceLocation EodLoc, Token Id, MacroDirective MD) {
        MacroInfo MI = MD.getMacroInfo();
        SourceRange R = new SourceRange(MI.getRawDefinitionLoc(), MI.getRawDefinitionEndLoc());
        MacroDefinition Def = new MacroDefinition(Id.getIdentifierInfo(), R);
        this.addPreprocessedEntity(Def);
        this.MacroDefinitions.ref$at((Object)MI).$set((Object)Def);
    }

    @Override
    public void MacroUndefined(SourceLocation HashLoc, SourceLocation EodLoc, Token Id, MacroDirective MD) {
        if (MD != null) {
            this.MacroDefinitions.erase((Object)MD.getMacroInfo());
        }
    }

    @Override
    public void InclusionDirective(SourceLocation HashLoc, SourceLocation EodLoc, Token IncludeTok, StringRef FileName, boolean IsAngled, CharSourceRange FilenameRange, FileEntry File2, StringRef SearchPath, StringRef RelativePath, Module Imported) {
        InclusionDirective.InclusionKind Kind2 = InclusionDirective.InclusionKind.Include;
        switch (IncludeTok.getIdentifierInfo().getPPKeywordID()) {
            case 8: {
                Kind2 = InclusionDirective.InclusionKind.Include;
                break;
            }
            case 15: {
                Kind2 = InclusionDirective.InclusionKind.Import;
                break;
            }
            case 16: {
                Kind2 = InclusionDirective.InclusionKind.IncludeNext;
                break;
            }
            case 9: {
                Kind2 = InclusionDirective.InclusionKind.IncludeMacros;
                break;
            }
            default: {
                llvm.llvm_unreachable_internal((String)"Unknown include directive kind");
            }
        }
        SourceLocation EndLoc = new SourceLocation();
        if (!IsAngled) {
            EndLoc.$assign(FilenameRange.getBegin());
        } else {
            EndLoc.$assign(FilenameRange.getEnd());
            if (FilenameRange.isCharRange()) {
                EndLoc.$assign(EndLoc.getLocWithOffset(-1L));
            }
        }
        InclusionDirective ID = new InclusionDirective(this, Kind2, FileName, !IsAngled, Imported != null, File2, new SourceRange(HashLoc, EndLoc));
        this.addPreprocessedEntity(ID);
    }

    @Override
    public void Ifdef(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, Token MacroNameTok, MacroDirective MD) {
        if (MD != null) {
            this.addMacroExpansion(MacroNameTok, MD.getMacroInfo(), new SourceRange(MacroNameTok.getRawLocation()));
        }
    }

    @Override
    public void Ifndef(SourceLocation HashLoc, SourceLocation EodLoc, SourceLocation Loc, Token MacroNameTok, MacroDirective MD) {
        if (MD != null) {
            this.addMacroExpansion(MacroNameTok, MD.getMacroInfo(), new SourceRange(MacroNameTok.getRawLocation()));
        }
    }

    @Override
    public void Defined(Token MacroNameTok, MacroDirective MD, SourceRange Range) {
        if (MD != null) {
            this.addMacroExpansion(MacroNameTok, MD.getMacroInfo(), new SourceRange(MacroNameTok.getRawLocation()));
        }
    }

    @Override
    public void SourceRangeSkipped(SourceRange Range) {
        this.SkippedRanges.push_back((Object)Range);
    }

    private void addMacroExpansion(Token Id, MacroInfo MI, SourceRange Range) {
        if (SourceLocation.isMacroID((int)Id.getRawLocation())) {
            return;
        }
        if (MI.isBuiltinMacro()) {
            this.addPreprocessedEntity(new MacroExpansion(Id.getIdentifierInfo(), Range));
        } else {
            MacroDefinition Def = this.findMacroDefinition(MI);
            if (Def != null) {
                this.addPreprocessedEntity(new MacroExpansion(Def, Range));
            }
        }
    }

    private std.pairIntInt getPreprocessedEntitiesInRangeSlow(SourceRange Range) {
        assert (Range.isValid());
        assert (!this.SourceMgr.isBeforeInTranslationUnit(Range.getEnd(), Range.getBegin()));
        std.pairUIntUInt Local = this.findLocalPreprocessedEntitiesInRange(Range);
        if (this.ExternalSource == null || this.SourceMgr.isLocalSourceLocation(Range.getBegin())) {
            return std.make_pair_int_int((int)((int)Local.first), (int)((int)Local.second));
        }
        std.pairUIntUInt Loaded = this.ExternalSource.findPreprocessedEntitiesInRange(Range);
        if (Loaded.first == Loaded.second) {
            return std.make_pair_int_int((int)((int)Local.first), (int)((int)Local.second));
        }
        int TotalLoaded = this.LoadedPreprocessedEntities.size();
        if (Local.first == Local.second) {
            return std.make_pair_int_int((int)((int)Loaded.first - TotalLoaded), (int)((int)Loaded.second - TotalLoaded));
        }
        return std.make_pair_int_int((int)((int)Loaded.first - TotalLoaded), (int)((int)Local.second));
    }

    @Override
    public void $destroy() {
        this.MacroDefinitions.$destroy();
        this.SkippedRanges.$destroy();
        this.LoadedPreprocessedEntities.$destroy();
        this.PreprocessedEntities.$destroy();
        this.BumpAlloc.$destroy();
        super.$destroy();
    }

    private static class Unnamed_struct3 {
        public SourceRange Range = new SourceRange();
        public std.pairIntInt Result = new std.pairIntInt();
    }

    public static class iterator {
        private PreprocessingRecord Self;
        private int Position;

        public iterator() {
            this.Self = null;
            this.Position = 0;
        }

        public iterator(PreprocessingRecord Self, int Position) {
            this.Self = Self;
            this.Position = Position;
        }

        public PreprocessedEntity $star() {
            boolean isLoaded = this.Position < 0;
            int Index = isLoaded ? this.Self.LoadedPreprocessedEntities.size() + this.Position : this.Position;
            PPEntityID ID = PreprocessingRecord.getPPEntityID(Index, isLoaded);
            return this.Self.getPreprocessedEntity(ID);
        }

        public PreprocessedEntity $at(int D) {
            boolean isLoaded = this.Position < 0;
            int Index = isLoaded ? this.Self.LoadedPreprocessedEntities.size() + this.Position : this.Position;
            PPEntityID ID = PreprocessingRecord.getPPEntityID(Index + D, isLoaded);
            return this.Self.getPreprocessedEntity(ID);
        }

        public iterator $preInc() {
            ++this.Position;
            return this;
        }

        public iterator $postInc(int $Prm0) {
            iterator Prev = new iterator(this);
            ++this.Position;
            return Prev;
        }

        public iterator $preDec() {
            --this.Position;
            return this;
        }

        public iterator $postDec(int $Prm0) {
            iterator Prev = new iterator(this);
            --this.Position;
            return Prev;
        }

        public iterator(iterator $Prm0) {
            this.Self = $Prm0.Self;
            this.Position = $Prm0.Position;
        }

        public final class iterator_category
        extends std.random_access_iterator_tag {
        }

        public final class pointer
        extends value_type {
            public pointer(PreprocessedEntity.EntityKind Kind2, SourceRange Range) {
                super(Kind2, Range);
            }
        }

        public final class reference
        extends value_type {
            public reference(PreprocessedEntity.EntityKind Kind2, SourceRange Range) {
                super(Kind2, Range);
            }
        }

        public class value_type
        extends PreprocessedEntity {
            public value_type(PreprocessedEntity.EntityKind Kind2, SourceRange Range) {
                super(Kind2, Range);
            }
        }
    }

    public static class PPEntityID {
        private int ID;

        private PPEntityID(int ID) {
            this.ID = ID;
        }

        public PPEntityID() {
            this.ID = 0;
        }

        public PPEntityID(PPEntityID $Prm0) {
            this.ID = $Prm0.ID;
        }
    }
}

