/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.SourceLocation;
import org.clang.lex.MultipleIncludeOpt;
import org.clang.lex.PPConditionalInfo;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clank.support.Destructors;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;

public abstract class PreprocessorLexer
implements Destructors.ClassWithDestructor {
    protected Preprocessor PP;
    protected int FID;
    protected long InitialNumSLocEntries;
    protected boolean ParsingPreprocessorDirective;
    protected boolean ParsingFilename;
    protected boolean LexingRawMode;
    protected boolean SkipTokensBetweenDirectives = false;
    protected final MultipleIncludeOpt MIOpt;
    private static final SmallVector<PPConditionalInfo> EmptyConditionalStack = new SmallVector(0, null);
    protected SmallVector<PPConditionalInfo> ConditionalStack;

    protected void anchor() {
    }

    protected PreprocessorLexer(PreprocessorLexer $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    protected void $assign(PreprocessorLexer $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    protected PreprocessorLexer(Preprocessor pp, FileID fid) {
        this(pp, fid.$ID());
    }

    protected PreprocessorLexer(Preprocessor pp, int fid) {
        this.PP = pp;
        this.FID = fid;
        this.InitialNumSLocEntries = 0L;
        this.ParsingPreprocessorDirective = false;
        this.ParsingFilename = false;
        this.LexingRawMode = false;
        this.MIOpt = new MultipleIncludeOpt();
        this.ConditionalStack = new SmallVector(4, null);
        if (pp != null) {
            this.InitialNumSLocEntries = pp.getSourceManager().local_sloc_entry_size();
        }
    }

    protected PreprocessorLexer() {
        this(true);
    }

    protected PreprocessorLexer(boolean needMIOpt) {
        this.PP = null;
        this.FID = FileID.getInvalidID();
        this.InitialNumSLocEntries = 0L;
        this.ParsingPreprocessorDirective = false;
        this.ParsingFilename = false;
        this.LexingRawMode = false;
        this.MIOpt = needMIOpt ? new MultipleIncludeOpt() : MultipleIncludeOpt.NULL;
        this.ConditionalStack = EmptyConditionalStack;
    }

    public void $destroy() {
    }

    protected abstract void IndirectLex(Token var1);

    protected abstract SourceLocation getSourceLocation();

    protected void pushConditionalLevel(int DirectiveStart, boolean WasSkipping, boolean FoundNonSkip, boolean FoundElse) {
        PPConditionalInfo CI = new PPConditionalInfo();
        CI.setIfLoc(DirectiveStart);
        CI.WasSkipping = WasSkipping;
        CI.FoundNonSkip = FoundNonSkip;
        CI.FoundElse = FoundElse;
        if (this.ConditionalStack == EmptyConditionalStack) {
            this.ConditionalStack = new SmallVector(4, null);
        }
        this.ConditionalStack.push_back((Object)CI);
    }

    protected void pushConditionalLevel(PPConditionalInfo CI) {
        if (this.ConditionalStack == EmptyConditionalStack) {
            this.ConditionalStack = new SmallVector(4, null);
        }
        this.ConditionalStack.push_back((Object)CI);
    }

    protected boolean popConditionalLevel(PPConditionalInfo CI) {
        if (this.ConditionalStack.empty()) {
            return true;
        }
        CI.$assign((PPConditionalInfo)this.ConditionalStack.pop_back_val());
        return false;
    }

    protected PPConditionalInfo peekConditionalLevel() {
        assert (!this.ConditionalStack.empty()) : "No conditionals active!";
        return (PPConditionalInfo)this.ConditionalStack.back();
    }

    protected long getConditionalStackDepth() {
        return this.ConditionalStack.size();
    }

    public void LexIncludeFilename(Token FilenameTok) {
        assert (this.ParsingPreprocessorDirective && !this.ParsingFilename) : "Must be in a preprocessing directive!";
        this.ParsingFilename = true;
        if (this.LexingRawMode) {
            this.IndirectLex(FilenameTok);
        } else {
            this.PP.Lex(FilenameTok);
        }
        this.ParsingFilename = false;
        if (FilenameTok.is((short)2)) {
            this.PP.Diag(FilenameTok.getLocation(), 703L).$destroy();
        }
    }

    public void setParsingPreprocessorDirective(boolean f) {
        this.ParsingPreprocessorDirective = f;
    }

    public boolean isLexingRawMode() {
        return this.LexingRawMode;
    }

    public Preprocessor getPP() {
        return this.PP;
    }

    public int getFileID() {
        assert (this.PP != null) : "PreprocessorLexer::getFileID() should only be used with a Preprocessor";
        return this.FID;
    }

    public long getInitialNumSLocEntries() {
        return this.InitialNumSLocEntries;
    }

    public FileEntry getFileEntry() {
        return this.PP.getSourceManager().getFileEntryForID(this.getFileID());
    }

    public SmallVectorImpl.iterator<PPConditionalInfo> conditional_begin() {
        return this.ConditionalStack.begin();
    }

    public SmallVectorImpl.iterator<PPConditionalInfo> conditional_end() {
        return this.ConditionalStack.end();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "FID=" + this.FID + ", InitialNumSLocEntries=" + this.InitialNumSLocEntries + ", ParsingPreprocessorDirective=" + this.ParsingPreprocessorDirective + ", ParsingFilename=" + this.ParsingFilename + ", LexingRawMode=" + this.LexingRawMode + ", MIOpt=" + this.MIOpt + '}';
    }
}

