/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.CharSourceRange;
import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileID;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.lex.ConflictMarkerKind;
import org.clang.lex.Lexer;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clang.lex.impl.UnicodeCharSetsStatics;
import org.clank.java.std;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.support.sys.UnicodeCharSet;

public final class LexerStatics {
    private static final UnicodeCharSet C11AllowedIDChars = new UnicodeCharSet(new ArrayRef((Object[])UnicodeCharSetsStatics.C11AllowedIDCharRanges));
    private static final UnicodeCharSet CXX03AllowedIDChars = new UnicodeCharSet(new ArrayRef((Object[])UnicodeCharSetsStatics.CXX03AllowedIDCharRanges));
    private static final UnicodeCharSet C99AllowedIDChars = new UnicodeCharSet(new ArrayRef((Object[])UnicodeCharSetsStatics.C99AllowedIDCharRanges));
    private static final UnicodeCharSet C11DisallowedInitialIDChars = new UnicodeCharSet(new ArrayRef((Object[])UnicodeCharSetsStatics.C11DisallowedInitialIDCharRanges));
    private static final UnicodeCharSet C99DisallowedInitialIDChars = new UnicodeCharSet(new ArrayRef((Object[])UnicodeCharSetsStatics.C99DisallowedInitialIDCharRanges));

    public static int getSpellingSlow(Token Tok, char.ptr _BufPtr, LangOptions LangOpts, byte[] Spelling, int toIdx) {
        long Size;
        int BufPtr;
        assert (Tok.needsCleaning()) : "getSpellingSlow called on simple token";
        int Length = 0;
        int BufEnd = BufPtr + Tok.getLength();
        byte[] BufArray = _BufPtr.$array();
        if (Tok.is((short)13)) {
            for (BufPtr = _BufPtr.$index(); BufPtr < BufEnd; BufPtr += std.$second_int((long)Size)) {
                int n = Length++;
                Size = Lexer.getCharAndSizeNoWarn(BufArray, BufPtr, LangOpts);
                Spelling[toIdx + n] = std.$first_byte((long)Size);
                if (Spelling[toIdx + Length - 1] != NativePointer.$((char)'\"')) continue;
                break;
            }
            if (Length >= 2 && Spelling[toIdx + Length - 2] == NativePointer.$((char)'R') && Spelling[toIdx + Length - 1] == NativePointer.$((char)'\"')) {
                int RawEnd = BufEnd;
                while (BufArray[--RawEnd] != NativePointer.$((char)'\"')) {
                }
                int RawLength = RawEnd - BufPtr + 1;
                std.memcpy((byte[])Spelling, (int)(toIdx + Length), (byte[])BufArray, (int)BufPtr, (int)RawLength);
                Length += RawLength;
                BufPtr += RawLength;
            }
        }
        while (BufPtr < BufEnd) {
            int n = Length++;
            Size = Lexer.getCharAndSizeNoWarn(BufArray, BufPtr, LangOpts);
            Spelling[toIdx + n] = std.$first_byte((long)Size);
            BufPtr += std.$second_int((long)Size);
        }
        assert (Length < Tok.getLength()) : "NeedsCleaning flag set on token that didn't need cleaning!";
        return Length;
    }

    public static int getBeginningOfFileToken(SourceLocation Loc, SourceManager SM, LangOptions LangOpts) {
        return LexerStatics.getBeginningOfFileToken(Loc.getRawEncodingUInt(), SM, LangOpts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBeginningOfFileToken(int Loc, SourceManager SM, LangOptions LangOpts) {
        Lexer TheLexer = null;
        try {
            assert (SourceLocation.isFileID((int)Loc));
            long LocInfo = SM.getDecomposedLoc(Loc);
            if (FileID.isInvalid((int)ClangGlobals.$first_FileID((long)LocInfo))) {
                int n = Loc;
                return n;
            }
            bool.ptr Invalid = null;
            StringRef Buffer = SM.getBufferData(ClangGlobals.$first_FileID((long)LocInfo), Invalid);
            if (Buffer == SourceManager.INVALID_BUFFER_DATA) {
                int n = Loc;
                return n;
            }
            char.ptr BufStart = Buffer.data();
            if (ClangGlobals.$second_offset((long)LocInfo) >= Buffer.size()) {
                int n = Loc;
                return n;
            }
            char.ptr StrData = (char.ptr)BufStart.$add(ClangGlobals.$second_offset((long)LocInfo));
            if (StrData.$at(0) == 10 || StrData.$at(0) == 13) {
                int n = Loc;
                return n;
            }
            int StrDataIndex = StrData.$index();
            char.ptr LexStart = StrData;
            while (LexStart.$noteq((Object)BufStart)) {
                if (LexStart.$at(0) == 10 || LexStart.$at(0) == 13) {
                    LexStart.$preInc();
                    break;
                }
                LexStart.$preDec();
            }
            int LexerStartLoc = SourceLocation.getRawLocWithOffset((int)Loc, (int)(-ClangGlobals.$second_offset((long)LocInfo)));
            TheLexer = new Lexer(LexerStartLoc, LangOpts, Native.$noClone((char.ptr)BufStart), Native.$noClone((char.ptr)LexStart), BufStart.$index() + Buffer.size());
            TheLexer.SetCommentRetentionState(true);
            Token TheTok = new Token();
            do {
                TheLexer.LexFromRawLexer(TheTok);
                if (TheLexer.getBufferLocation().$index() <= StrDataIndex) continue;
                if (TheLexer.getBufferLocation().$index() - TheTok.getLength() > StrDataIndex) break;
                int n = TheTok.getRawLocation();
                return n;
            } while (TheTok.getKind() != 1);
            int n = Loc;
            return n;
        }
        finally {
            if (TheLexer != null) {
                TheLexer.$destroy();
            }
        }
    }

    public static CharSourceRange makeRangeFromFileLocs(CharSourceRange Range, SourceManager SM, LangOptions LangOpts) {
        int Begin = Range.getRawBegin();
        int End = Range.getRawEnd();
        assert (SourceLocation.isFileID((int)Begin) && SourceLocation.isFileID((int)End));
        if (Range.isTokenRange() && SourceLocation.isInvalid((int)(End = Lexer.getLocForEndOfToken(End, 0L, SM, LangOpts)))) {
            return new CharSourceRange();
        }
        int FID = FileID.getInvalidID();
        long decompLoc = SM.getDecomposedLoc(Begin);
        FID = ClangGlobals.$first_FileID((long)decompLoc);
        int BeginOffs = ClangGlobals.$second_offset((long)decompLoc);
        if (FileID.isInvalid((int)FID)) {
            return new CharSourceRange();
        }
        int.ptr EndOffs = NativePointer.create_int$ptr();
        if (!SM.isInFileID(End, FID, EndOffs) || BeginOffs > EndOffs.$star()) {
            return new CharSourceRange();
        }
        return CharSourceRange.getCharRange((int)Begin, (int)End);
    }

    public static int GetMappedTokenLoc(Preprocessor PP, int FileLoc, long CharNo, long TokLen) {
        assert (SourceLocation.isMacroID((int)FileLoc)) : "Must be a macro expansion";
        SourceManager SM = PP.getSourceManager();
        int SpellingLoc = SM.getSpellingLoc(FileLoc);
        SpellingLoc = SourceLocation.getRawLocWithOffset((int)SpellingLoc, (long)CharNo);
        long II = SM.getImmediateExpansionRange(FileLoc);
        return SM.createExpansionLoc(SpellingLoc, std.$first_int((long)II), std.$second_int((long)II), TokLen);
    }

    public static byte GetTrigraphCharForLetter(byte Letter) {
        switch (Letter) {
            default: {
                return 0;
            }
            case 61: {
                return 35;
            }
            case 41: {
                return 93;
            }
            case 40: {
                return 91;
            }
            case 33: {
                return 124;
            }
            case 39: {
                return 94;
            }
            case 62: {
                return 125;
            }
            case 47: {
                return 92;
            }
            case 60: {
                return 123;
            }
            case 45: 
        }
        return 126;
    }

    public static byte DecodeTrigraphChar(char.ptr CP, Lexer L) {
        byte Res = LexerStatics.GetTrigraphCharForLetter(CP.$star());
        if (Res == 0 || L == null) {
            return Res;
        }
        if (!L.getLangOpts().Trigraphs) {
            if (!L.isLexingRawMode()) {
                L.Diag((char.ptr)CP.$sub(2), 834L).$destroy();
            }
            return 0;
        }
        if (!L.isLexingRawMode()) {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)L.Diag((char.ptr)CP.$sub(2), 832L), (StringRef)new StringRef(NativePointer.create_char$ptr((CharSequence)(Res + "")), 1)).$destroy();
        }
        return Res;
    }

    public static boolean isAllowedIDChar(long C, LangOptions LangOpts) {
        if (LangOpts.CPlusPlus11 || LangOpts.C11) {
            return C11AllowedIDChars.contains(C);
        }
        if (LangOpts.CPlusPlus) {
            return CXX03AllowedIDChars.contains(C);
        }
        return C99AllowedIDChars.contains(C);
    }

    public static boolean isAllowedInitiallyIDChar(long C, LangOptions LangOpts) {
        assert (LexerStatics.isAllowedIDChar(C, LangOpts));
        if (LangOpts.CPlusPlus11 || LangOpts.C11) {
            return !C11DisallowedInitialIDChars.contains(C);
        }
        if (LangOpts.CPlusPlus) {
            return true;
        }
        return !C99DisallowedInitialIDChars.contains(C);
    }

    public static CharSourceRange makeCharRange(Lexer L, char.ptr Begin, char.ptr End) {
        return CharSourceRange.getCharRange((int)L.getSourceLocation(Begin), (int)L.getSourceLocation(End));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void maybeDiagnoseIDCharCompat(DiagnosticsEngine Diags, long C, CharSourceRange Range, boolean IsFirst) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            if (!Diags.isIgnored(839L, Range.getBegin())) {
                if (!C99AllowedIDChars.contains(C)) {
                    $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_CharSourceRange((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(Range.getBegin(), 839L))), (CharSourceRange)Range), (int)Unnamed_enum_maybeDiagnoseIDCharCompat.CannotAppearInIdentifier.getValue()));
                } else if (IsFirst && C99DisallowedInitialIDChars.contains(C)) {
                    $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_CharSourceRange((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(Range.getBegin(), 839L))), (CharSourceRange)Range), (int)Unnamed_enum_maybeDiagnoseIDCharCompat.CannotStartIdentifier.getValue()));
                }
            }
            if (!Diags.isIgnored(855L, Range.getBegin()) && !CXX03AllowedIDChars.contains(C)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_CharSourceRange((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(Range.getBegin(), 855L))), (CharSourceRange)Range));
            }
        }
        finally {
            $c.$destroy();
        }
    }

    public static boolean isEndOfBlockCommentWithEscapedNewLine(char.ptr CurPtr, Lexer L) {
        assert (CurPtr.$at(0) == 10 || CurPtr.$at(0) == 13);
        CurPtr.$preDec();
        if (CurPtr.$at(0) == 10 || CurPtr.$at(0) == 13) {
            if (CurPtr.$at(0) == CurPtr.$at(1)) {
                return false;
            }
            CurPtr.$preDec();
        }
        boolean HasSpace = false;
        while (ClangGlobals.isHorizontalWhitespace((byte)CurPtr.$star()) || CurPtr.$star() == 0) {
            CurPtr.$preDec();
            HasSpace = true;
        }
        if (CurPtr.$star() == 92) {
            if (CurPtr.$at(-1) != NativePointer.$((char)'*')) {
                return false;
            }
        } else {
            if (CurPtr.$at(0) != NativePointer.$((char)'/') || CurPtr.$at(-1) != NativePointer.$((char)'?') || CurPtr.$at(-2) != NativePointer.$((char)'?') || CurPtr.$at(-3) != NativePointer.$((char)'*')) {
                return false;
            }
            CurPtr.$dec(2);
            if (!L.getLangOpts().Trigraphs) {
                if (!L.isLexingRawMode()) {
                    L.Diag(CurPtr, 835L).$destroy();
                }
                return false;
            }
            if (!L.isLexingRawMode()) {
                L.Diag(CurPtr, 833L).$destroy();
            }
        }
        if (!L.isLexingRawMode()) {
            L.Diag(CurPtr, 756L).$destroy();
        }
        if (HasSpace && !L.isLexingRawMode()) {
            L.Diag(CurPtr, 621L).$destroy();
        }
        return true;
    }

    public static char.ptr FindConflictEnd(char.ptr CurPtr, char.ptr BufferEnd, ConflictMarkerKind CMK) {
        String Terminator = CMK == ConflictMarkerKind.CMK_Perforce ? "<<<<\n" : ">>>>>>>";
        long TermLen = CMK == ConflictMarkerKind.CMK_Perforce ? 5L : 7L;
        StringRef RestOfBuffer = new StringRef((char.ptr)CurPtr.$add(TermLen), (long)BufferEnd.$sub((abstract_iterator)CurPtr) - TermLen);
        long Pos = RestOfBuffer.find((CharSequence)Terminator);
        while (Pos != (long)StringRef.npos) {
            if (Pos == 0L || RestOfBuffer.$at(Pos - 1L) != NativePointer.$((char)'\r') && RestOfBuffer.$at(Pos - 1L) != NativePointer.$((char)'\n')) {
                RestOfBuffer.$assign$substr(Unsigned.long2uint((long)(Pos + TermLen)));
                Pos = RestOfBuffer.find((CharSequence)Terminator);
                continue;
            }
            return (char.ptr)RestOfBuffer.data().$add(Pos);
        }
        return null;
    }

    private static final class Unnamed_enum_maybeDiagnoseIDCharCompat
    extends Enum<Unnamed_enum_maybeDiagnoseIDCharCompat> {
        public static final /* enum */ Unnamed_enum_maybeDiagnoseIDCharCompat CannotAppearInIdentifier = new Unnamed_enum_maybeDiagnoseIDCharCompat(0L);
        public static final /* enum */ Unnamed_enum_maybeDiagnoseIDCharCompat CannotStartIdentifier = new Unnamed_enum_maybeDiagnoseIDCharCompat(CannotAppearInIdentifier.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Unnamed_enum_maybeDiagnoseIDCharCompat[] $VALUES;

        public static Unnamed_enum_maybeDiagnoseIDCharCompat[] values() {
            return (Unnamed_enum_maybeDiagnoseIDCharCompat[])$VALUES.clone();
        }

        public static Unnamed_enum_maybeDiagnoseIDCharCompat valueOf(String name) {
            return Enum.valueOf(Unnamed_enum_maybeDiagnoseIDCharCompat.class, name);
        }

        public static Unnamed_enum_maybeDiagnoseIDCharCompat valueOf(int val) {
            Unnamed_enum_maybeDiagnoseIDCharCompat out;
            Unnamed_enum_maybeDiagnoseIDCharCompat unnamed_enum_maybeDiagnoseIDCharCompat = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Unnamed_enum_maybeDiagnoseIDCharCompat(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum_maybeDiagnoseIDCharCompat[]{CannotAppearInIdentifier, CannotStartIdentifier};
        }

        private static final class Values {
            private static final Unnamed_enum_maybeDiagnoseIDCharCompat[] VALUES;
            private static final Unnamed_enum_maybeDiagnoseIDCharCompat[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum_maybeDiagnoseIDCharCompat kind : Unnamed_enum_maybeDiagnoseIDCharCompat.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum_maybeDiagnoseIDCharCompat[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum_maybeDiagnoseIDCharCompat[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum_maybeDiagnoseIDCharCompat kind : Unnamed_enum_maybeDiagnoseIDCharCompat.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Unnamed_enum_maybeDiagnoseIDCharCompat)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Unnamed_enum_maybeDiagnoseIDCharCompat)kind).value] = kind;
                }
            }
        }
    }

    public static final class PreambleDirectiveKind
    extends Enum<PreambleDirectiveKind> {
        public static final /* enum */ PreambleDirectiveKind PDK_Skipped = new PreambleDirectiveKind(0L);
        public static final /* enum */ PreambleDirectiveKind PDK_StartIf = new PreambleDirectiveKind(1L);
        public static final /* enum */ PreambleDirectiveKind PDK_EndIf = new PreambleDirectiveKind(2L);
        public static final /* enum */ PreambleDirectiveKind PDK_Unknown = new PreambleDirectiveKind(3L);
        private final int value;
        private static final /* synthetic */ PreambleDirectiveKind[] $VALUES;

        public static PreambleDirectiveKind[] values() {
            return (PreambleDirectiveKind[])$VALUES.clone();
        }

        public static PreambleDirectiveKind valueOf(String name) {
            return Enum.valueOf(PreambleDirectiveKind.class, name);
        }

        public static PreambleDirectiveKind valueOf(int val) {
            PreambleDirectiveKind out;
            PreambleDirectiveKind preambleDirectiveKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private PreambleDirectiveKind(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new PreambleDirectiveKind[]{PDK_Skipped, PDK_StartIf, PDK_EndIf, PDK_Unknown};
        }

        private static final class Values {
            private static final PreambleDirectiveKind[] VALUES;
            private static final PreambleDirectiveKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (PreambleDirectiveKind kind : PreambleDirectiveKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new PreambleDirectiveKind[min < 0 ? 1 - min : 0];
                VALUES = new PreambleDirectiveKind[max >= 0 ? 1 + max : 0];
                for (PreambleDirectiveKind kind : PreambleDirectiveKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((PreambleDirectiveKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((PreambleDirectiveKind)kind).value] = kind;
                }
            }
        }
    }
}

