/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.ClankAliases;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.LangOptions;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.target.TargetInfo;
import org.clang.lex.ArrayRefToken;
import org.clang.lex.Lexer;
import org.clang.lex.ModuleMap;
import org.clang.lex.StringLiteralParser;
import org.clang.lex.Token;
import org.clang.lex.impl.AttributeKind;
import org.clang.lex.impl.MMToken;
import org.clang.lex.impl.ModuleMapStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.support.BumpPtrAllocatorImpl;
import org.llvm.support.sys.path;

public class ModuleMapParser
implements Destructors.ClassWithDestructor {
    private Lexer L;
    private SourceManager SourceMgr;
    private TargetInfo Target;
    private DiagnosticsEngine Diags;
    private ModuleMap Map;
    private FileEntry ModuleMapFile;
    private DirectoryEntry Directory;
    private DirectoryEntry BuiltinIncludeDir;
    private boolean IsSystem;
    private boolean HadError;
    private BumpPtrAllocatorImpl StringData;
    private MMToken Tok;
    private Module ActiveModule;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceLocation consumeToken() {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            SourceLocation Result;
            block22: while (true) {
                Result = this.Tok.getLocation();
                this.Tok.clear();
                Token LToken = new Token();
                this.L.LexFromRawLexer(LToken);
                this.Tok.Location = LToken.getLocation().getRawEncoding();
                switch (LToken.getKind()) {
                    case 6: {
                        StringRef RI = LToken.getRawIdentifier();
                        this.Tok.StringData = Native.$tryClone((char.ptr)RI.data());
                        this.Tok.StringLength = RI.size();
                        this.Tok.Kind = (Short)new StringSwitch(RI).Case(NativePointer.$((String)"config_macros"), (Object)1).Case(NativePointer.$((String)"conflict"), (Object)2).Case(NativePointer.$((String)"exclude"), (Object)7).Case(NativePointer.$((String)"explicit"), (Object)8).Case(NativePointer.$((String)"export"), (Object)9).Case(NativePointer.$((String)"extern"), (Object)10).Case(NativePointer.$((String)"framework"), (Object)11).Case(NativePointer.$((String)"header"), (Object)4).Case(NativePointer.$((String)"link"), (Object)12).Case(NativePointer.$((String)"module"), (Object)13).Case(NativePointer.$((String)"private"), (Object)15).Case(NativePointer.$((String)"requires"), (Object)18).Case(NativePointer.$((String)"textual"), (Object)21).Case(NativePointer.$((String)"umbrella"), (Object)16).Case(NativePointer.$((String)"use"), (Object)17).Default((Object)5);
                        break block22;
                    }
                    case 64: {
                        this.Tok.Kind = 0;
                        break block22;
                    }
                    case 1: {
                        this.Tok.Kind = (short)3;
                        break block22;
                    }
                    case 23: {
                        this.Tok.Kind = (short)22;
                        break block22;
                    }
                    case 19: {
                        this.Tok.Kind = (short)24;
                        break block22;
                    }
                    case 25: {
                        this.Tok.Kind = (short)14;
                        break block22;
                    }
                    case 24: {
                        this.Tok.Kind = (short)23;
                        break block22;
                    }
                    case 20: {
                        this.Tok.Kind = (short)25;
                        break block22;
                    }
                    case 30: {
                        this.Tok.Kind = (short)19;
                        break block22;
                    }
                    case 40: {
                        this.Tok.Kind = (short)6;
                        break block22;
                    }
                    case 13: {
                        LangOptions LangOpts = null;
                        StringLiteralParser StringLiteral = null;
                        try {
                            if (LToken.hasUDSuffix()) {
                                $c.clean($c.track((Object)this.Diags.Report(LToken.getLocation(), 18L)));
                                this.HadError = true;
                                continue block22;
                            }
                            LangOpts = new LangOptions();
                            StringLiteral = new StringLiteralParser(new ArrayRefToken(LToken), this.SourceMgr, LangOpts, this.Target);
                            if (StringLiteral.hadError) continue block22;
                            int Length = StringLiteral.GetStringLength();
                            char.ptr Saved = this.StringData.Allocate(Length + 1);
                            std.memcpy((char.ptr)Saved, (char.ptr)StringLiteral.GetString().data(), (int)Length);
                            Saved.$set(Length, (byte)0);
                            this.Tok.Kind = (short)20;
                            this.Tok.StringData = Native.$tryClone((char.ptr)Saved);
                            this.Tok.StringLength = Length;
                            break block22;
                        }
                        finally {
                            if (LangOpts == null) continue block22;
                            LangOpts.$destroy();
                            continue block22;
                        }
                    }
                    case 4: {
                        continue block22;
                    }
                    default: {
                        $c.clean($c.track((Object)this.Diags.Report(LToken.getLocation(), 679L)));
                        this.HadError = true;
                        continue block22;
                    }
                }
                break;
            }
            SourceLocation sourceLocation = Result;
            return sourceLocation;
        }
        finally {
            $c.$destroy();
        }
    }

    private void skipUntil(short K) {
        long braceDepth = 0L;
        long squareDepth = 0L;
        while (true) {
            switch (this.Tok.Kind) {
                case 3: {
                    return;
                }
                case 22: {
                    if (this.Tok.is(K) && braceDepth == 0L && squareDepth == 0L) {
                        return;
                    }
                    ++braceDepth;
                    break;
                }
                case 24: {
                    if (this.Tok.is(K) && braceDepth == 0L && squareDepth == 0L) {
                        return;
                    }
                    ++squareDepth;
                    break;
                }
                case 23: {
                    if (braceDepth > 0L) {
                        --braceDepth;
                        break;
                    }
                    if (!this.Tok.is(K)) break;
                    return;
                }
                case 25: {
                    if (squareDepth > 0L) {
                        --squareDepth;
                        break;
                    }
                    if (!this.Tok.is(K)) break;
                    return;
                }
                default: {
                    if (braceDepth != 0L || squareDepth != 0L || !this.Tok.is(K)) break;
                    return;
                }
            }
            this.consumeToken();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseModuleId(ClankAliases.ModuleId Id) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            Id.clear();
            while (true) {
                if (!this.Tok.is((short)5) && !this.Tok.is((short)20)) {
                    $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 662L)));
                    boolean bl = true;
                    return bl;
                }
                Id.push_back($c.track((Object)new std.pair(std.make_pair((Object)this.Tok.getString().str(), (Object)this.Tok.getLocation()))));
                $c.clean();
                this.consumeToken();
                if (!this.Tok.is((short)14)) break;
                this.consumeToken();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseModuleDecl() {
        ClankAliases.ModuleId Id = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            assert (this.Tok.is((short)8) || this.Tok.is((short)13) || this.Tok.is((short)11) || this.Tok.is((short)10));
            if (this.Tok.is((short)10)) {
                this.parseExternModuleDecl();
                return;
            }
            SourceLocation ExplicitLoc = new SourceLocation();
            boolean Explicit = false;
            boolean Framework = false;
            if (this.Tok.is((short)8)) {
                ExplicitLoc.$assignMove(this.consumeToken());
                Explicit = true;
            }
            if (this.Tok.is((short)11)) {
                this.consumeToken();
                Framework = true;
            }
            if (!this.Tok.is((short)13)) {
                $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 661L)));
                this.consumeToken();
                this.HadError = true;
                return;
            }
            this.consumeToken();
            if (this.Tok.is((short)19)) {
                this.parseInferredModuleDecl(Framework, Explicit);
                return;
            }
            Id = new ClankAliases.ModuleId();
            if (this.parseModuleId(Id)) {
                this.HadError = true;
                return;
            }
            if (this.ActiveModule != null) {
                if (Id.size() > 1) {
                    $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report((SourceLocation)((std.pair)Id.front()).second, 675L))), (SourceRange)new SourceRange((SourceLocation)((std.pair)Id.front()).second, (SourceLocation)((std.pair)Id.back()).second)));
                    this.HadError = true;
                    return;
                }
            } else if (Id.size() == 1 && Explicit) {
                $c.clean($c.track((Object)this.Diags.Report(ExplicitLoc, 666L)));
                Explicit = false;
                ExplicitLoc.$assignMove(new SourceLocation());
                this.HadError = true;
            }
            Module PreviousActiveModule = this.ActiveModule;
            if (Id.size() > 1) {
                this.ActiveModule = null;
                Module TopLevelModule = null;
                long N = Id.size() - 1;
                for (long I = 0L; I != N; ++I) {
                    Module Next = this.Map.lookupModuleQualified(new StringRef((std.string)((std.pair)Id.$at((long)I)).first), this.ActiveModule);
                    if (Next != null) {
                        if (I == 0L) {
                            TopLevelModule = Next;
                        }
                    } else {
                        if (this.ActiveModule != null) {
                            $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report((SourceLocation)((std.pair)Id.$at((long)I)).second, 671L))), (StringRef)new StringRef((std.string)((std.pair)Id.$at((long)I)).first)), (StringRef)new StringRef((std.string)$c.track((Object)this.ActiveModule.getTopLevelModule().getFullModuleName()))));
                        } else {
                            $c.clean($c.track((Object)this.Diags.Report((SourceLocation)((std.pair)Id.$at((long)I)).second, 662L)));
                        }
                        this.HadError = true;
                        return;
                    }
                    this.ActiveModule = Next;
                }
                if (this.ModuleMapFile != this.Map.getContainingModuleMapFile(TopLevelModule)) {
                    assert (this.ModuleMapFile != this.Map.getModuleMapFileForUniquing(TopLevelModule)) : "submodule defined in same file as 'module *' that allowed its top-level module";
                    this.Map.addAdditionalModuleMapFile(TopLevelModule, this.ModuleMapFile);
                }
            }
            StringRef ModuleName = new StringRef((std.string)((std.pair)Id.back()).first);
            int ModuleNameLoc = ((SourceLocation)((std.pair)Id.back()).second).getRawEncodingUInt();
            ModuleMap.Attributes Attrs = new ModuleMap.Attributes();
            this.parseOptionalAttributes(Attrs);
            if (!this.Tok.is((short)22)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 656L))), (StringRef)ModuleName));
                this.HadError = true;
                return;
            }
            SourceLocation LBraceLoc = this.consumeToken();
            Module Existing = this.Map.lookupModuleQualified(ModuleName, this.ActiveModule);
            if (Existing != null) {
                if (Existing.DefinitionLoc.isInvalid() && this.ActiveModule == null) {
                    this.skipUntil((short)23);
                    if (this.Tok.is((short)23)) {
                        this.consumeToken();
                    } else {
                        $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 663L)));
                        $c.clean($c.track((Object)this.Diags.Report(LBraceLoc, 807L)));
                        this.HadError = true;
                    }
                    return;
                }
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(ModuleNameLoc, 674L))), (StringRef)ModuleName));
                $c.clean($c.track((Object)this.Diags.Report(Existing.DefinitionLoc, 809L)));
                this.skipUntil((short)23);
                if (this.Tok.is((short)23)) {
                    this.consumeToken();
                }
                this.HadError = true;
                return;
            }
            this.ActiveModule = (Module)this.Map.findOrCreateModule((StringRef)ModuleName, (Module)this.ActiveModule, (boolean)Framework, (boolean)Explicit).first;
            this.ActiveModule.DefinitionLoc.$assign(ModuleNameLoc);
            if (Attrs.IsSystem || this.IsSystem) {
                this.ActiveModule.IsSystem = true;
            }
            if (Attrs.IsExternC) {
                this.ActiveModule.IsExternC = true;
            }
            this.ActiveModule.Directory = this.Directory;
            boolean Done = false;
            do {
                switch (this.Tok.Kind) {
                    case 3: 
                    case 23: {
                        Done = true;
                        break;
                    }
                    case 1: {
                        this.parseConfigMacros();
                        break;
                    }
                    case 2: {
                        this.parseConflict();
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 11: 
                    case 13: {
                        this.parseModuleDecl();
                        break;
                    }
                    case 9: {
                        this.parseExportDecl();
                        break;
                    }
                    case 17: {
                        this.parseUseDecl();
                        break;
                    }
                    case 18: {
                        this.parseRequiresDecl();
                        break;
                    }
                    case 21: {
                        this.parseHeaderDecl((short)21, this.consumeToken());
                        break;
                    }
                    case 16: {
                        SourceLocation UmbrellaLoc = this.consumeToken();
                        if (this.Tok.is((short)4)) {
                            this.parseHeaderDecl((short)16, UmbrellaLoc);
                            break;
                        }
                        this.parseUmbrellaDirDecl(UmbrellaLoc);
                        break;
                    }
                    case 7: {
                        this.parseHeaderDecl((short)7, this.consumeToken());
                        break;
                    }
                    case 15: {
                        this.parseHeaderDecl((short)15, this.consumeToken());
                        break;
                    }
                    case 4: {
                        this.parseHeaderDecl((short)4, this.consumeToken());
                        break;
                    }
                    case 12: {
                        this.parseLinkDecl();
                        break;
                    }
                    default: {
                        $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 659L)));
                        this.consumeToken();
                    }
                }
            } while (!Done);
            if (this.Tok.is((short)23)) {
                this.consumeToken();
            } else {
                $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 663L)));
                $c.clean($c.track((Object)this.Diags.Report(LBraceLoc, 807L)));
                this.HadError = true;
            }
            if (this.ActiveModule.IsFramework && !this.ActiveModule.isSubFramework() && this.ActiveModule.LinkLibraries.empty()) {
                ModuleMapStatics.inferFrameworkLink(this.ActiveModule, this.Directory, this.SourceMgr.getFileManager());
            }
            if (!this.ActiveModule.IsAvailable && !this.ActiveModule.IsMissingRequirement && this.ActiveModule.Parent != null) {
                this.ActiveModule.getTopLevelModule().markUnavailable();
                this.ActiveModule.getTopLevelModule().MissingHeaders.append((type.iterator)this.ActiveModule.MissingHeaders.begin(), (type.iterator)this.ActiveModule.MissingHeaders.end());
            }
            this.ActiveModule = PreviousActiveModule;
        }
        finally {
            if (Id != null) {
                Id.$destroy();
            }
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseExternModuleDecl() {
        ClankAliases.ModuleId Id = null;
        std.string FileName = null;
        SmallString ModuleMapFileName = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            FileEntry File2;
            assert (this.Tok.is((short)10));
            this.consumeToken();
            if (!this.Tok.is((short)13)) {
                $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 661L)));
                this.consumeToken();
                this.HadError = true;
                return;
            }
            this.consumeToken();
            Id = new ClankAliases.ModuleId();
            if (this.parseModuleId(Id)) {
                this.HadError = true;
                return;
            }
            if (!this.Tok.is((short)20)) {
                $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 660L)));
                this.HadError = true;
                return;
            }
            FileName = this.Tok.getString().$basic_string();
            this.consumeToken();
            StringRef FileNameRef = new StringRef(FileName);
            ModuleMapFileName = new SmallString(128);
            if (path.is_relative((Twine)new Twine(FileNameRef))) {
                ModuleMapFileName.$addassign(this.Directory.getName(), this.Directory.getNameLen());
                path.append((SmallString)ModuleMapFileName, (std.string)FileName);
                FileNameRef.$assignMove(ModuleMapFileName.str());
            }
            if ((File2 = this.SourceMgr.getFileManager().getFile(FileNameRef)) != null) {
                this.Map.parseModuleMapFile(File2, false, this.Map.HeaderInfo.getHeaderSearchOpts().ModuleMapFileHomeIsCwd ? this.Directory : File2.getDir());
            }
        }
        finally {
            if (ModuleMapFileName != null) {
                ModuleMapFileName.$destroy();
            }
            if (FileName != null) {
                FileName.$destroy();
            }
            if (Id != null) {
                Id.$destroy();
            }
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void parseRequiresDecl() {
        block14: {
            $c = Native.$createJavaCleaner();
            if (!ModuleMapParser.$assertionsDisabled && !this.Tok.is((short)18)) {
                throw new AssertionError();
            }
            this.consumeToken();
            while (true) lbl-1000:
            // 3 sources

            {
                Feature = null;
                try {
                    RequiredState = true;
                    if (this.Tok.is((short)6)) {
                        RequiredState = false;
                        this.consumeToken();
                    }
                    if (!this.Tok.is((short)5)) {
                        $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 653L)));
                        this.HadError = true;
                        return;
                    }
                    Feature = this.Tok.getString().$basic_string();
                    this.consumeToken();
                    this.ActiveModule.addRequirement(new StringRef(Feature), RequiredState, this.Map.LangOpts, this.Map.Target);
                    if (this.Tok.is((short)0)) {
                        this.consumeToken();
                    }
                    break block14;
                }
                finally {
                    if (Feature == null) continue;
                    Feature.$destroy();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                $c.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseHeaderDecl(short LeadingToken, SourceLocation LeadingLoc) {
        Module.UnresolvedHeaderDirective Header2 = null;
        SmallString RelativePathName = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            FileEntry BuiltinFile;
            FileEntry File2;
            int Role;
            block38: {
                Role = 0;
                if (LeadingToken == 15) {
                    Role = 1;
                    if (this.Tok.is((short)21)) {
                        LeadingToken = this.Tok.Kind;
                        this.consumeToken();
                    }
                }
                if (LeadingToken == 21) {
                    Role |= 2;
                }
                if (LeadingToken != 4) {
                    if (!this.Tok.is((short)4)) {
                        $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 654L))), (char.ptr)(LeadingToken == 15 ? NativePointer.$((String)"private") : (LeadingToken == 7 ? NativePointer.$((String)"exclude") : (LeadingToken == 21 ? NativePointer.$((String)"textual") : NativePointer.$((String)"umbrella"))))));
                        return;
                    }
                    this.consumeToken();
                }
                if (!this.Tok.is((short)20)) {
                    $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 654L))), (char.ptr)NativePointer.$((String)"header")));
                    this.HadError = true;
                    return;
                }
                Header2 = new Module.UnresolvedHeaderDirective();
                $c.clean((Object)Header2.FileName.$assignMove((std.string)$c.track((Object)this.Tok.getString().$basic_string())));
                Header2.FileNameLoc.$assignMove(this.consumeToken());
                if (LeadingToken == 16 && this.ActiveModule.Umbrella.$boolean()) {
                    $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(Header2.FileNameLoc, 677L))), (StringRef)new StringRef((std.string)$c.track((Object)this.ActiveModule.getFullModuleName()))));
                    this.HadError = true;
                    return;
                }
                File2 = null;
                BuiltinFile = null;
                RelativePathName = new SmallString(128);
                if (path.is_absolute((std.string)Header2.FileName)) {
                    RelativePathName.$assign(Header2.FileName);
                    File2 = this.SourceMgr.getFileManager().getFile(RelativePathName.$StringRef());
                } else {
                    SmallString FullPathName = null;
                    try {
                        FullPathName = new SmallString(new StringRef(this.Directory.getName(), this.Directory.getNameLen()), 128);
                        long FullPathLength = FullPathName.size();
                        if (this.ActiveModule.isPartOfFramework()) {
                            ModuleMapStatics.appendSubframeworkPaths(this.ActiveModule, RelativePathName);
                            path.append((SmallString)RelativePathName, (Twine)new Twine(NativePointer.$((String)"Headers")), (Twine)new Twine(Header2.FileName));
                            path.append((SmallString)FullPathName, (SmallVectorImplChar)RelativePathName);
                            File2 = this.SourceMgr.getFileManager().getFile(FullPathName.$StringRef());
                            if (File2 == null) {
                                RelativePathName.clear();
                                FullPathName.resize(FullPathLength);
                                path.append((SmallString)RelativePathName, (Twine)new Twine(NativePointer.$((String)"PrivateHeaders")), (Twine)new Twine(Header2.FileName));
                                path.append((SmallString)FullPathName, (SmallVectorImplChar)RelativePathName);
                                File2 = this.SourceMgr.getFileManager().getFile(FullPathName.$StringRef());
                            }
                            break block38;
                        }
                        path.append((SmallString)RelativePathName, (std.string)Header2.FileName);
                        path.append((SmallString)FullPathName, (SmallVectorImplChar)RelativePathName);
                        File2 = this.SourceMgr.getFileManager().getFile(FullPathName.$StringRef());
                        if (!this.ActiveModule.IsSystem || LeadingToken == 16 || this.BuiltinIncludeDir == null || this.BuiltinIncludeDir == this.Directory || !ModuleMapStatics.isBuiltinHeader(new StringRef(Header2.FileName))) break block38;
                        SmallString BuiltinPathName = null;
                        try {
                            BuiltinPathName = new SmallString(new StringRef(this.BuiltinIncludeDir.getName(), this.BuiltinIncludeDir.getNameLen()), 128);
                            path.append((SmallString)BuiltinPathName, (std.string)Header2.FileName);
                            BuiltinFile = this.SourceMgr.getFileManager().getFile(BuiltinPathName.$StringRef());
                            if (File2 == null && BuiltinFile != null) {
                                File2 = BuiltinFile;
                                RelativePathName.$assign((SmallVectorImplChar)BuiltinPathName);
                                BuiltinFile = null;
                            }
                        }
                        finally {
                            if (BuiltinPathName != null) {
                                BuiltinPathName.$destroy();
                            }
                        }
                    }
                    finally {
                        if (FullPathName != null) {
                            FullPathName.$destroy();
                        }
                    }
                }
            }
            if (File2 != null) {
                Module.Header H;
                if (LeadingToken == 16) {
                    DirectoryEntry UmbrellaDir = File2.getDir();
                    Module UmbrellaModule = (Module)this.Map.UmbrellaDirs.$at((Object)UmbrellaDir);
                    if (UmbrellaModule != null) {
                        $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(LeadingLoc, 677L))), (StringRef)new StringRef((std.string)$c.track((Object)UmbrellaModule.getFullModuleName()))));
                        this.HadError = true;
                    } else {
                        this.Map.setUmbrellaHeader(this.ActiveModule, File2);
                    }
                } else if (LeadingToken == 7) {
                    H = new Module.Header(RelativePathName.str().$basic_string(), File2);
                    this.Map.excludeHeader(this.ActiveModule, (Module.Header)$c.track((Object)new Module.Header(H)));
                    $c.clean();
                } else {
                    if (BuiltinFile != null) {
                        H = new Module.Header(new std.string(BuiltinFile.getName()), BuiltinFile);
                        this.Map.addHeader(this.ActiveModule, (Module.Header)$c.track((Object)new Module.Header(H)), Role);
                        $c.clean();
                    }
                    H = new Module.Header(RelativePathName.str().$basic_string(), File2);
                    this.Map.addHeader(this.ActiveModule, (Module.Header)$c.track((Object)new Module.Header(H)), Role);
                    $c.clean();
                }
            } else if (LeadingToken != 7) {
                Header2.IsUmbrella = LeadingToken == 16;
                this.ActiveModule.markUnavailable();
                this.ActiveModule.MissingHeaders.push_back((Object)Header2);
            }
        }
        finally {
            if (RelativePathName != null) {
                RelativePathName.$destroy();
            }
            if (Header2 != null) {
                Header2.$destroy();
            }
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseUmbrellaDirDecl(SourceLocation UmbrellaLoc) {
        std.string DirName = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            if (!this.Tok.is((short)20)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 654L))), (char.ptr)NativePointer.$((String)"umbrella")));
                this.HadError = true;
                return;
            }
            DirName = this.Tok.getString().$basic_string();
            SourceLocation DirNameLoc = this.consumeToken();
            if (this.ActiveModule.Umbrella.$boolean()) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(DirNameLoc, 677L))), (StringRef)new StringRef((std.string)$c.track((Object)this.ActiveModule.getFullModuleName()))));
                this.HadError = true;
                return;
            }
            DirectoryEntry Dir = null;
            if (path.is_absolute((std.string)DirName)) {
                Dir = this.SourceMgr.getFileManager().getDirectory(new StringRef(DirName));
            } else {
                SmallString PathName = null;
                try {
                    PathName = new SmallString(128);
                    PathName.$assign(this.Directory.getName(), this.Directory.getNameLen());
                    path.append((SmallString)PathName, (std.string)DirName);
                    Dir = this.SourceMgr.getFileManager().getDirectory(PathName.$StringRef());
                }
                finally {
                    if (PathName != null) {
                        PathName.$destroy();
                    }
                }
            }
            if (Dir == null) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(DirNameLoc, 678L))), (StringRef)new StringRef(DirName)));
                this.HadError = true;
                return;
            }
            Module OwningModule = (Module)this.Map.UmbrellaDirs.$at((Object)Dir);
            if (OwningModule != null) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(UmbrellaLoc, 677L))), (StringRef)new StringRef((std.string)$c.track((Object)OwningModule.getFullModuleName()))));
                this.HadError = true;
                return;
            }
            this.Map.setUmbrellaDir(this.ActiveModule, Dir);
        }
        finally {
            if (DirName != null) {
                DirName.$destroy();
            }
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseExportDecl() {
        ClankAliases.ModuleId ParsedModuleId = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            boolean Wildcard;
            SourceLocation ExportLoc;
            block10: {
                assert (this.Tok.is((short)9));
                ExportLoc = this.consumeToken();
                ParsedModuleId = new ClankAliases.ModuleId();
                Wildcard = false;
                while (this.Tok.is((short)5)) {
                    ParsedModuleId.push_back($c.track((Object)new std.pair(std.make_pair((Object)this.Tok.getString().str(), (Object)this.Tok.getLocation()))));
                    $c.clean();
                    this.consumeToken();
                    if (this.Tok.is((short)14)) {
                        this.consumeToken();
                        continue;
                    }
                    break block10;
                }
                if (this.Tok.is((short)19)) {
                    Wildcard = true;
                    this.consumeToken();
                } else {
                    $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 673L)));
                    this.HadError = true;
                    return;
                }
            }
            Module.UnresolvedExportDecl Unresolved = new Module.UnresolvedExportDecl(ExportLoc, ParsedModuleId, Wildcard);
            this.ActiveModule.UnresolvedExports.push_back((Object)Unresolved);
        }
        finally {
            if (ParsedModuleId != null) {
                ParsedModuleId.$destroy();
            }
            $c.$destroy();
        }
    }

    private void parseUseDecl() {
        ClankAliases.ModuleId ParsedModuleId = null;
        try {
            assert (this.Tok.is((short)17));
            this.consumeToken();
            ParsedModuleId = new ClankAliases.ModuleId();
            this.parseModuleId(ParsedModuleId);
            this.ActiveModule.UnresolvedDirectUses.push_back((Object)ParsedModuleId);
        }
        finally {
            if (ParsedModuleId != null) {
                ParsedModuleId.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLinkDecl() {
        std.string LibraryName = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            assert (this.Tok.is((short)12));
            SourceLocation LinkLoc = this.consumeToken();
            boolean IsFramework = false;
            if (this.Tok.is((short)11)) {
                this.consumeToken();
                IsFramework = true;
            }
            if (!this.Tok.is((short)20)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 658L))), (boolean)IsFramework), (SourceRange)new SourceRange(LinkLoc)));
                this.HadError = true;
                return;
            }
            LibraryName = this.Tok.getString().$basic_string();
            this.consumeToken();
            this.ActiveModule.LinkLibraries.push_back($c.track((Object)new Module.LinkLibrary(LibraryName, IsFramework)));
            $c.clean();
        }
        finally {
            if (LibraryName != null) {
                LibraryName.$destroy();
            }
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseConfigMacros() {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            assert (this.Tok.is((short)1));
            SourceLocation ConfigMacrosLoc = this.consumeToken();
            if (this.ActiveModule.Parent != null) {
                $c.clean($c.track((Object)this.Diags.Report(ConfigMacrosLoc, 647L)));
            }
            ModuleMap.Attributes Attrs = new ModuleMap.Attributes();
            this.parseOptionalAttributes(Attrs);
            if (Attrs.IsExhaustive && this.ActiveModule.Parent == null) {
                this.ActiveModule.ConfigMacrosExhaustive = true;
            }
            if (!this.Tok.is((short)5)) {
                return;
            }
            if (this.ActiveModule.Parent == null) {
                this.ActiveModule.ConfigMacros.push_back((std.string)$c.track((Object)this.Tok.getString().str()));
                $c.clean();
            }
            this.consumeToken();
            while (this.Tok.is((short)0)) {
                this.consumeToken();
                if (!this.Tok.is((short)5)) {
                    $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 649L)));
                    break;
                }
                if (this.ActiveModule.Parent == null) {
                    this.ActiveModule.ConfigMacros.push_back((std.string)$c.track((Object)this.Tok.getString().str()));
                    $c.clean();
                }
                this.consumeToken();
            }
        }
        finally {
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseConflict() {
        Module.UnresolvedConflict Conflict2 = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            assert (this.Tok.is((short)2));
            SourceLocation ConflictLoc = this.consumeToken();
            Conflict2 = new Module.UnresolvedConflict();
            if (this.parseModuleId(Conflict2.Id)) {
                return;
            }
            if (!this.Tok.is((short)0)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 650L))), (SourceRange)new SourceRange(ConflictLoc)));
                return;
            }
            this.consumeToken();
            if (!this.Tok.is((short)20)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 651L))), (StringRef)new StringRef((std.string)$c.track((Object)ModuleMapStatics.formatModuleId(Conflict2.Id)))));
                return;
            }
            $c.clean((Object)Conflict2.Message.$assignMove((std.string)$c.track((Object)this.Tok.getString().str())));
            this.consumeToken();
            this.ActiveModule.UnresolvedConflicts.push_back((Object)Conflict2);
        }
        finally {
            if (Conflict2 != null) {
                Conflict2.$destroy();
            }
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInferredModuleDecl(boolean Framework, boolean Explicit) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            assert (this.Tok.is((short)19));
            SourceLocation StarLoc = this.consumeToken();
            boolean Failed = false;
            if (this.ActiveModule == null && !Framework) {
                $c.clean($c.track((Object)this.Diags.Report(StarLoc, 676L)));
                Failed = true;
            }
            if (this.ActiveModule != null) {
                if (!Failed && this.ActiveModule.IsAvailable && this.ActiveModule.getUmbrellaDir() == null) {
                    $c.clean($c.track((Object)this.Diags.Report(StarLoc, 668L)));
                    Failed = true;
                }
                if (!Failed && this.ActiveModule.InferSubmodules) {
                    $c.clean($c.track((Object)this.Diags.Report(StarLoc, 669L)));
                    if (this.ActiveModule.InferredSubmoduleLoc.isValid()) {
                        $c.clean($c.track((Object)this.Diags.Report(this.ActiveModule.InferredSubmoduleLoc, 809L)));
                    }
                    Failed = true;
                }
                if (Framework) {
                    $c.clean($c.track((Object)this.Diags.Report(StarLoc, 667L)));
                    Framework = false;
                }
            } else if (Explicit) {
                $c.clean($c.track((Object)this.Diags.Report(StarLoc, 665L)));
                Explicit = false;
            }
            if (Failed) {
                if (this.Tok.is((short)22)) {
                    this.consumeToken();
                    this.skipUntil((short)23);
                    if (this.Tok.is((short)23)) {
                        this.consumeToken();
                    }
                }
                this.HadError = true;
                return;
            }
            ModuleMap.Attributes Attrs = new ModuleMap.Attributes();
            this.parseOptionalAttributes(Attrs);
            if (this.ActiveModule != null) {
                this.ActiveModule.InferSubmodules = true;
                this.ActiveModule.InferredSubmoduleLoc.$assign(StarLoc);
                this.ActiveModule.InferExplicitSubmodules = Explicit;
            } else {
                ((ModuleMap.InferredDirectory)this.Map.InferredDirectories.$at((Object)this.Directory)).InferModules = true;
                ((ModuleMap.InferredDirectory)this.Map.InferredDirectories.$at((Object)this.Directory)).Attrs.$assign(Attrs);
                ((ModuleMap.InferredDirectory)this.Map.InferredDirectories.$at((Object)this.Directory)).ModuleMapFile = this.ModuleMapFile;
            }
            if (!this.Tok.is((short)22)) {
                $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 657L)));
                this.HadError = true;
                return;
            }
            SourceLocation LBraceLoc = this.consumeToken();
            boolean Done = false;
            do {
                switch (this.Tok.Kind) {
                    case 3: 
                    case 23: {
                        Done = true;
                        break;
                    }
                    case 7: {
                        if (this.ActiveModule != null) {
                            $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 655L))), (this.ActiveModule != null ? 1 : 0) != 0));
                            this.consumeToken();
                            break;
                        }
                        this.consumeToken();
                        if (!this.Tok.is((short)5)) {
                            $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 670L)));
                            break;
                        }
                        ((ModuleMap.InferredDirectory)this.Map.InferredDirectories.$at((Object)this.Directory)).ExcludedModules.push_back($c.track((Object)this.Tok.getString().$basic_string()));
                        $c.clean();
                        this.consumeToken();
                        break;
                    }
                    case 9: {
                        if (this.ActiveModule == null) {
                            $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 655L))), (this.ActiveModule != null ? 1 : 0) != 0));
                            this.consumeToken();
                            break;
                        }
                        this.consumeToken();
                        if (this.Tok.is((short)19)) {
                            this.ActiveModule.InferExportWildcard = true;
                        } else {
                            $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 652L)));
                        }
                        this.consumeToken();
                        break;
                    }
                    default: {
                        $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 655L))), (this.ActiveModule != null ? 1 : 0) != 0));
                        this.consumeToken();
                    }
                }
            } while (!Done);
            if (this.Tok.is((short)23)) {
                this.consumeToken();
            } else {
                $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 663L)));
                $c.clean($c.track((Object)this.Diags.Report(LBraceLoc, 807L)));
                this.HadError = true;
            }
        }
        finally {
            $c.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseOptionalAttributes(ModuleMap.Attributes Attrs) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            boolean HadError = false;
            while (this.Tok.is((short)24)) {
                SourceLocation LSquareLoc = this.consumeToken();
                if (!this.Tok.is((short)5)) {
                    $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 648L)));
                    this.skipUntil((short)25);
                    if (this.Tok.is((short)25)) {
                        this.consumeToken();
                    }
                    HadError = true;
                }
                AttributeKind Attribute = (AttributeKind)((Object)new StringSwitch(this.Tok.getString()).Case(NativePointer.$((String)"exhaustive"), (Object)AttributeKind.AT_exhaustive).Case(NativePointer.$((String)"extern_c"), (Object)AttributeKind.AT_extern_c).Case(NativePointer.$((String)"system"), (Object)AttributeKind.AT_system).Default((Object)AttributeKind.AT_unknown));
                switch (Attribute) {
                    case AT_unknown: {
                        $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(this.Tok.getLocation(), 862L))), (StringRef)this.Tok.getString()));
                        break;
                    }
                    case AT_system: {
                        Attrs.IsSystem = true;
                        break;
                    }
                    case AT_extern_c: {
                        Attrs.IsExternC = true;
                        break;
                    }
                    case AT_exhaustive: {
                        Attrs.IsExhaustive = true;
                    }
                }
                this.consumeToken();
                if (!this.Tok.is((short)25)) {
                    $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 664L)));
                    $c.clean($c.track((Object)this.Diags.Report(LSquareLoc, 808L)));
                    this.skipUntil((short)25);
                    HadError = true;
                }
                if (!this.Tok.is((short)25)) continue;
                this.consumeToken();
            }
            boolean bl = HadError;
            return bl;
        }
        finally {
            $c.$destroy();
        }
    }

    public ModuleMapParser(Lexer L, SourceManager SourceMgr, TargetInfo Target, DiagnosticsEngine Diags, ModuleMap Map2, FileEntry ModuleMapFile, DirectoryEntry Directory, DirectoryEntry BuiltinIncludeDir, boolean IsSystem) {
        this.L = L;
        this.SourceMgr = SourceMgr;
        this.Target = Target;
        this.Diags = Diags;
        this.Map = Map2;
        this.ModuleMapFile = ModuleMapFile;
        this.Directory = Directory;
        this.BuiltinIncludeDir = BuiltinIncludeDir;
        this.IsSystem = IsSystem;
        this.HadError = false;
        this.StringData = new BumpPtrAllocatorImpl();
        this.Tok = new MMToken();
        this.ActiveModule = null;
        this.Tok.clear();
        this.consumeToken();
    }

    public boolean parseModuleMapFile() {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            while (true) {
                switch (this.Tok.Kind) {
                    case 3: {
                        boolean bl = this.HadError;
                        return bl;
                    }
                    case 8: 
                    case 10: 
                    case 11: 
                    case 13: {
                        this.parseModuleDecl();
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 9: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        $c.clean($c.track((Object)this.Diags.Report(this.Tok.getLocation(), 661L)));
                        this.HadError = true;
                        this.consumeToken();
                    }
                }
            }
        }
        finally {
            $c.$destroy();
        }
    }

    public void $destroy() {
        this.StringData.$destroy();
    }

    public String toString() {
        return "L=" + this.L + ", SourceMgr=" + this.SourceMgr + ", Target=" + this.Target + ", Diags=" + this.Diags + ", Map=" + this.Map + ", ModuleMapFile=" + this.ModuleMapFile + ", Directory=" + this.Directory + ", BuiltinIncludeDir=" + this.BuiltinIncludeDir + ", IsSystem=" + this.IsSystem + ", HadError=" + this.HadError + ", StringData=" + this.StringData + ", Tok=" + this.Tok + ", ActiveModule=" + this.ActiveModule;
    }
}

