/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.SourceLocation;
import org.clang.lex.PPCallbacks;
import org.clang.lex.PragmaHandler;
import org.clang.lex.PragmaIntroducerKind;
import org.clang.lex.Preprocessor;
import org.clang.lex.Token;
import org.clank.support.Destructors;
import org.llvm.adt.StringRef;
import org.llvm.support.CrashRecoveryContext;
import org.llvm.support.llvm;
import org.netbeans.api.annotations.common.SuppressWarnings;

public class PragmaDebugHandler
extends PragmaHandler
implements Destructors.ClassWithDestructor {
    public PragmaDebugHandler() {
        super(new StringRef((CharSequence)"__debug"));
    }

    @Override
    public void HandlePragma(Preprocessor PP, PragmaIntroducerKind Introducer, Token DepToken) {
        Token Tok = new Token();
        PP.LexUnexpandedToken(Tok);
        if (Tok.isNot((short)5)) {
            PP.Diag(Tok, 878L).$destroy();
            return;
        }
        IdentifierInfo II = Tok.getIdentifierInfo();
        if (II.isStr((CharSequence)"assert")) {
            llvm.llvm_unreachable_internal((String)"This is an assertion!");
        } else if (II.isStr((CharSequence)"crash")) {
            llvm.LLVM_BUILTIN_TRAP();
        } else if (II.isStr((CharSequence)"parser_crash")) {
            Token Crasher = new Token();
            Crasher.setKind((short)303);
            PP.EnterToken(Crasher);
        } else if (II.isStr((CharSequence)"llvm_fatal_error")) {
            llvm.report_fatal_error((CharSequence)"#pragma clang __debug llvm_fatal_error");
        } else if (II.isStr((CharSequence)"llvm_unreachable")) {
            llvm.llvm_unreachable_internal((String)"#pragma clang __debug llvm_unreachable");
        } else if (II.isStr((CharSequence)"overflow_stack")) {
            this.DebugOverflowStack();
        } else if (II.isStr((CharSequence)"handle_crash")) {
            CrashRecoveryContext CRC = CrashRecoveryContext.GetCurrent();
            if (CRC != null) {
                CRC.HandleCrash();
            }
        } else if (II.isStr((CharSequence)"captured")) {
            this.HandleCaptured(PP);
        } else {
            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)PP.Diag(Tok, 876L), (StringRef)II.getName()).$destroy();
        }
        PPCallbacks Callbacks = PP.getPPCallbacks();
        if (Callbacks != null) {
            Callbacks.PragmaDebug(Tok.getLocation(), II.getName());
        }
    }

    public void HandleCaptured(Preprocessor PP) {
        if (PP.isPreprocessedOutput()) {
            return;
        }
        Token Tok = new Token();
        PP.LexUnexpandedToken(Tok);
        if (Tok.isNot((short)2)) {
            ClangGlobals.$out_DiagnosticBuilder_T((DiagnosticBuilder)PP.Diag(Tok, 782L), (CharSequence)"pragma clang __debug captured").$destroy();
            return;
        }
        SourceLocation NameLoc = Tok.getLocation();
        Token[] Toks = new Token[]{new Token()};
        Toks[0].startToken();
        Toks[0].setKind((short)304);
        Toks[0].setLocation(NameLoc);
        PP.EnterTokenStream(Toks, 0, 1L, true, false);
    }

    @SuppressWarnings(value={"IL"})
    public void DebugOverflowStack() {
        this.DebugOverflowStack();
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }
}

