/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.ios;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListParser;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cordova.platforms.api.ProcessUtilities;
import org.netbeans.modules.cordova.platforms.spi.ProvisioningProfile;
import org.openide.util.Exceptions;

public class IOSProvisioningProfile
implements ProvisioningProfile {
    private String displayName = "Error";
    private String path;

    public IOSProvisioningProfile(String path) {
        try {
            this.path = path;
            String xml = ProcessUtilities.callProcess((String)"security", (boolean)true, (int)60000, (String[])new String[]{"cms", "-D", "-i", path});
            try {
                NSObject root = PropertyListParser.parse((byte[])xml.getBytes());
                if (root instanceof NSDictionary) {
                    this.displayName = ((NSDictionary)root).objectForKey("Name").toString();
                }
            }
            catch (Exception e) {
                Logger log = Logger.getLogger(IOSProvisioningProfile.class.getName());
                log.log(Level.INFO, "Failed to parse:\n{0}", xml);
                this.displayName = "Profile";
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.displayName;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + Objects.hashCode(this.path);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IOSProvisioningProfile other = (IOSProvisioningProfile)obj;
        return Objects.equals(this.path, other.path);
    }
}

