/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.data;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.glassfish.tooling.data.DataException;
import org.netbeans.modules.glassfish.tooling.logging.Logger;
import org.netbeans.modules.glassfish.tooling.utils.EnumUtils;

public enum GlassFishVersion {
    GF_1(1, 0, 0, 0),
    GF_2(2, 0, 0, 0),
    GF_2_1(2, 1, 0, 0),
    GF_2_1_1(2, 1, 1, 0),
    GF_3(3, 0, 0, 0),
    GF_3_0_1(3, 0, 1, 0),
    GF_3_1(3, 1, 0, 0),
    GF_3_1_1(3, 1, 1, 0),
    GF_3_1_2(3, 1, 2, 0),
    GF_3_1_2_2(3, 1, 2, 2),
    GF_3_1_2_3(3, 1, 2, 3),
    GF_3_1_2_4(3, 1, 2, 4),
    GF_3_1_2_5(3, 1, 2, 5),
    GF_4(4, 0, 0, 0),
    GF_4_0_1(4, 0, 1, 0),
    GF_4_1(4, 1, 0, 0),
    GF_4_1_1(4, 1, 1, 0),
    GF_DEVEL(0, 0, 0, 0);

    private static final Logger LOGGER;
    public static final int length;
    public static final char SEPARATOR = '.';
    public static final String SEPARATOR_PATTERN = "\\.";
    static final String GF_1_STR = "1";
    static final String[] GF_1_STR_NEXT;
    static final String GF_2_STR = "2";
    static final String[] GF_2_STR_NEXT;
    static final String GF_2_1_STR = "2.1";
    static final String[] GF_2_1_STR_NEXT;
    static final String GF_2_1_1_STR = "2.1.1";
    static final String[] GF_2_1_1_STR_NEXT;
    static final String GF_3_STR = "3";
    static final String[] GF_3_STR_NEXT;
    static final String GF_3_0_1_STR = "3.0.1";
    static final String[] GF_3_0_1_STR_NEXT;
    static final String GF_3_1_STR = "3.1";
    static final String[] GF_3_1_STR_NEXT;
    static final String GF_3_1_1_STR = "3.1.1";
    static final String[] GF_3_1_1_STR_NEXT;
    static final String GF_3_1_2_STR = "3.1.2";
    static final String[] GF_3_1_2_STR_NEXT;
    static final String GF_3_1_2_2_STR = "3.1.2.2";
    static final String GF_3_1_2_3_STR = "3.1.2.3";
    static final String GF_3_1_2_4_STR = "3.1.2.4";
    static final String GF_3_1_2_5_STR = "3.1.2.5";
    static final String GF_4_STR = "4";
    static final String[] GF_4_STR_NEXT;
    static final String GF_4_0_1_STR = "4.0.1";
    static final String[] GF_4_0_1_STR_NEXT;
    static final String GF_4_1_STR = "4.1";
    static final String[] GF_4_1_STR_NEXT;
    static final String GF_4_1_1_STR = "4.1.1";
    static final String[] GF_4_1_1_STR_NEXT;
    static final String GF_DEVEL_STR = "DEVELOPMENT";
    static final String[] GF_DEVEL_STR_NEXT;
    private static final Map<String, GlassFishVersion> stringValuesMap;
    private final short major;
    private final short minor;
    private final short update;
    private final short build;

    private static void initStringValuesMapFromArray(GlassFishVersion version, String[] values) {
        for (String value : values) {
            stringValuesMap.put(value, version);
        }
    }

    public static GlassFishVersion toValue(String versionStr) {
        if (versionStr != null) {
            GlassFishVersion version = stringValuesMap.get(versionStr.toUpperCase());
            if (version == null) {
                String[] versionNumbers = versionStr.split(SEPARATOR_PATTERN);
                for (int i = versionNumbers.length - 1; version == null && i > 0; --i) {
                    int versionStrLen = i - 1;
                    for (int j = 0; j < i; ++j) {
                        versionStrLen += versionNumbers[j].length();
                    }
                    StringBuilder sb = new StringBuilder(versionStrLen);
                    for (int j = 0; j < i; ++j) {
                        if (j > 0) {
                            sb.append('.');
                        }
                        sb.append(versionNumbers[j]);
                    }
                    version = stringValuesMap.get(sb.toString().toUpperCase());
                }
            }
            return version;
        }
        return null;
    }

    private GlassFishVersion(short major, short minor, short update, short build) {
        this.major = major;
        this.minor = minor;
        this.update = update;
        this.build = build;
    }

    public short getMajor() {
        return this.major;
    }

    public short getMinor() {
        return this.minor;
    }

    public short getUpdate() {
        return this.update;
    }

    public short getBuild() {
        return this.build;
    }

    public boolean equalsMajorMinor(GlassFishVersion version) {
        if (version == null) {
            return false;
        }
        return this.major == version.major && this.minor == version.minor;
    }

    public boolean equals(GlassFishVersion version) {
        if (version == null) {
            return false;
        }
        return this.major == version.major && this.minor == version.minor && this.update == version.update && this.build == version.build;
    }

    public static boolean eq(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.eq(v1, v2);
    }

    public static boolean ne(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.ne(v1, v2);
    }

    public static boolean lt(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.lt(v1, v2);
    }

    public static boolean le(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.le(v1, v2);
    }

    public static boolean gt(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.gt(v1, v2);
    }

    public static boolean ge(Enum<GlassFishVersion> v1, Enum<GlassFishVersion> v2) {
        return EnumUtils.ge(v1, v2);
    }

    public String toString() {
        String METHOD = "toString";
        switch (this) {
            case GF_1: {
                return GF_1_STR;
            }
            case GF_2: {
                return GF_2_STR;
            }
            case GF_2_1: {
                return GF_2_1_STR;
            }
            case GF_2_1_1: {
                return GF_2_1_1_STR;
            }
            case GF_3: {
                return GF_3_STR;
            }
            case GF_3_0_1: {
                return GF_3_0_1_STR;
            }
            case GF_3_1: {
                return GF_3_1_STR;
            }
            case GF_3_1_1: {
                return GF_3_1_1_STR;
            }
            case GF_3_1_2: {
                return GF_3_1_2_STR;
            }
            case GF_3_1_2_2: {
                return GF_3_1_2_2_STR;
            }
            case GF_3_1_2_3: {
                return GF_3_1_2_3_STR;
            }
            case GF_3_1_2_4: {
                return GF_3_1_2_4_STR;
            }
            case GF_3_1_2_5: {
                return GF_3_1_2_5_STR;
            }
            case GF_4: {
                return GF_4_STR;
            }
            case GF_4_0_1: {
                return GF_4_0_1_STR;
            }
            case GF_4_1: {
                return GF_4_1_STR;
            }
            case GF_4_1_1: {
                return GF_4_1_1_STR;
            }
            case GF_DEVEL: {
                return GF_DEVEL_STR;
            }
        }
        throw new DataException(LOGGER.excMsg("toString", "invalidVersion"));
    }

    public String toFullString() {
        StringBuilder sb = new StringBuilder(8);
        sb.append(Integer.toString(this.major));
        sb.append('.');
        sb.append(Integer.toString(this.minor));
        sb.append('.');
        sb.append(Integer.toString(this.update));
        sb.append('.');
        sb.append(Integer.toString(this.build));
        return sb.toString();
    }

    static {
        LOGGER = new Logger(GlassFishVersion.class);
        length = GlassFishVersion.values().length;
        GF_1_STR_NEXT = new String[]{"1.0", "1.0.0", "1.0.0.0"};
        GF_2_STR_NEXT = new String[]{"2.0", "2.0.0", "2.0.0.0"};
        GF_2_1_STR_NEXT = new String[]{"2.1.0", "2.1.0.0"};
        GF_2_1_1_STR_NEXT = new String[]{"2.1.1.0"};
        GF_3_STR_NEXT = new String[]{"3.0", "3.0.0", "3.0.0.0"};
        GF_3_0_1_STR_NEXT = new String[]{"3.0.1.0"};
        GF_3_1_STR_NEXT = new String[]{"3.1.0", "3.1.0.0"};
        GF_3_1_1_STR_NEXT = new String[]{"3.1.1.0"};
        GF_3_1_2_STR_NEXT = new String[]{"3.1.2.0"};
        GF_4_STR_NEXT = new String[]{"4.0", "4.0.0", "4.0.0.0"};
        GF_4_0_1_STR_NEXT = new String[]{"4.0.1.0"};
        GF_4_1_STR_NEXT = new String[]{"4.1.0", "4.1.0.0"};
        GF_4_1_1_STR_NEXT = new String[]{"4.1.1.0"};
        GF_DEVEL_STR_NEXT = new String[]{"0", "0.0", "0.0.0", "0.0.0.0"};
        stringValuesMap = new HashMap<String, GlassFishVersion>(2 * GlassFishVersion.values().length);
        for (GlassFishVersion state : GlassFishVersion.values()) {
            stringValuesMap.put(state.toString().toUpperCase(), state);
        }
        GlassFishVersion.initStringValuesMapFromArray(GF_1, GF_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_2, GF_2_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_2_1, GF_2_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_2_1_1, GF_2_1_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3, GF_3_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_0_1, GF_3_0_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_1, GF_3_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_1_1, GF_3_1_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_3_1_2, GF_3_1_2_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4, GF_4_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4_0_1, GF_4_0_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4_1, GF_4_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_4_1_1, GF_4_1_1_STR_NEXT);
        GlassFishVersion.initStringValuesMapFromArray(GF_DEVEL, GF_DEVEL_STR_NEXT);
    }
}

