/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBaseForm;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.HttpsToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.TransportToken;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SAMLAuthorizationOverSSL
extends ProfileBaseForm {
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox reqClientCertChBox;
    private JCheckBox reqSigConfChBox;
    private JComboBox samlVersionCombo;
    private JLabel samlVersionLabel;
    private JComboBox wssVersionCombo;
    private JLabel wssVersionLabel;

    public SAMLAuthorizationOverSSL(WSDLComponent comp, SecurityProfile secProfile) {
        super(comp, secProfile);
        this.initComponents();
        this.inSync = true;
        this.fillSamlCombo(this.samlVersionCombo);
        this.fillWssCombo(this.wssVersionCombo);
        this.fillLayoutCombo(this.layoutCombo);
        this.fillAlgoSuiteCombo(this.algoSuiteCombo);
        this.inSync = false;
        this.sync();
    }

    @Override
    protected void sync() {
        this.inSync = true;
        ExtensibilityElement secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        if (this.comp instanceof Binding) {
            WSDLComponent tokenKind = SecurityTokensModelHelper.getSupportingToken(this.comp, 1);
            WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
            String samlVersion = SecurityTokensModelHelper.getTokenProfileVersion(token);
            this.setCombo(this.samlVersionCombo, samlVersion);
        }
        this.setCombo(this.wssVersionCombo, SecurityPolicyModelHelper.isWss11(this.comp));
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)secBinding));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout(this.comp));
        this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation(this.comp));
        this.enableDisable();
        this.inSync = false;
    }

    @Override
    protected void enableDisable() {
        boolean wss11 = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
        this.reqSigConfChBox.setEnabled(wss11);
    }

    @Override
    public void setValue(JComponent source) {
        HttpsToken token;
        WSDLComponent tokenKind;
        if (this.inSync) {
            return;
        }
        ExtensibilityElement secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        SecurityPolicyModelHelper spmh = SecurityPolicyModelHelper.getInstance(this.cfgVersion);
        SecurityTokensModelHelper stmh = SecurityTokensModelHelper.getInstance(this.cfgVersion);
        AlgoSuiteModelHelper asmh = AlgoSuiteModelHelper.getInstance(this.cfgVersion);
        if (source.equals(this.reqClientCertChBox)) {
            tokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)secBinding, TransportToken.class);
            token = (HttpsToken)SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
            SecurityTokensModelHelper.setRequireClientCertificate(token, this.reqClientCertChBox.isSelected());
        }
        if (source.equals(this.reqSigConfChBox)) {
            spmh.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
        }
        if (source.equals(this.layoutCombo)) {
            spmh.setLayout((WSDLComponent)secBinding, (String)this.layoutCombo.getSelectedItem());
        }
        if (source.equals(this.algoSuiteCombo)) {
            asmh.setAlgorithmSuite((WSDLComponent)secBinding, (String)this.algoSuiteCombo.getSelectedItem());
        }
        if (source.equals(this.wssVersionCombo)) {
            boolean wss11 = ComboConstants.WSS11.equals(this.wssVersionCombo.getSelectedItem());
            WssElement wss = spmh.enableWss(this.comp, wss11);
            if (wss11) {
                spmh.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
            }
        }
        if (source.equals(this.samlVersionCombo) && this.comp instanceof Binding) {
            tokenKind = SecurityTokensModelHelper.getSupportingToken(this.comp, 1);
            token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
            stmh.setTokenProfileVersion((WSDLComponent)token, (String)this.samlVersionCombo.getSelectedItem());
        }
        this.enableDisable();
    }

    private void initComponents() {
        this.samlVersionLabel = new JLabel();
        this.samlVersionCombo = new JComboBox();
        this.reqSigConfChBox = new JCheckBox();
        this.reqClientCertChBox = new JCheckBox();
        this.wssVersionLabel = new JLabel();
        this.wssVersionCombo = new JComboBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.samlVersionLabel.setLabelFor(this.samlVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.samlVersionLabel, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_SamlVersion"));
        this.samlVersionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAMLAuthorizationOverSSL.this.samlVersionComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqSigConfChBox, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_RequireSigConfirmation"));
        this.reqSigConfChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqSigConfChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqSigConfChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAMLAuthorizationOverSSL.this.reqSigConfChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqClientCertChBox, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_RequireClientCertificate"));
        this.reqClientCertChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.reqClientCertChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqClientCertChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAMLAuthorizationOverSSL.this.reqClientCertChBoxActionPerformed(evt);
            }
        });
        this.wssVersionLabel.setLabelFor(this.wssVersionCombo);
        Mnemonics.setLocalizedText((JLabel)this.wssVersionLabel, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_WSSVersionLabel"));
        this.wssVersionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAMLAuthorizationOverSSL.this.wssVersionComboActionPerformed(evt);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAMLAuthorizationOverSSL.this.algoSuiteComboActionPerformed(evt);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(SAMLAuthorizationOverSSL.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SAMLAuthorizationOverSSL.this.layoutComboActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reqClientCertChBox).addComponent(this.reqSigConfChBox).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.samlVersionLabel).addComponent(this.wssVersionLabel).addComponent(this.algoSuiteLabel).addComponent(this.layoutLabel)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.samlVersionCombo, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent(this.wssVersionCombo, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent(this.algoSuiteCombo, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent(this.layoutCombo, GroupLayout.Alignment.LEADING, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(0, this.algoSuiteCombo, this.layoutCombo, this.samlVersionCombo, this.wssVersionCombo);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.samlVersionLabel).addComponent(this.samlVersionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.wssVersionLabel).addComponent(this.wssVersionCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.algoSuiteLabel).addComponent(this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.layoutLabel).addComponent(this.layoutCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reqClientCertChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reqSigConfChBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.algoSuiteCombo, this.layoutCombo, this.samlVersionCombo, this.wssVersionCombo);
    }

    private void reqSigConfChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.reqSigConfChBox);
    }

    private void reqClientCertChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.reqClientCertChBox);
    }

    private void wssVersionComboActionPerformed(ActionEvent evt) {
        this.setValue(this.wssVersionCombo);
    }

    private void samlVersionComboActionPerformed(ActionEvent evt) {
        this.setValue(this.samlVersionCombo);
    }

    private void layoutComboActionPerformed(ActionEvent evt) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent evt) {
        this.setValue(this.algoSuiteCombo);
    }
}

