/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranReformatter;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.netbeans.modules.options.editor.spi.PreviewProvider;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FmtOptions {
    public static final String expandTabToSpaces = "expand-tabs";
    public static final String tabSize = "tab-size";
    public static final String spacesPerTab = "spaces-per-tab";
    public static final String indentSize = "indent-shift-width";
    public static final String rightMargin = "text-limit-width";
    public static final String freeFormat = "freeFormat";
    public static final String autoDetect = "autoDetect";
    static final String CODE_STYLE_PROFILE = "CodeStyle";
    private static final String DEFAULT_PROFILE = "default";
    static final String PROJECT_PROFILE = "project";
    static final String usedProfile = "usedProfile";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static Map<String, String> defaults;

    private FmtOptions() {
    }

    public static int getDefaultAsInt(String key) {
        return Integer.parseInt(defaults.get(key));
    }

    public static boolean getDefaultAsBoolean(String key) {
        return Boolean.parseBoolean(defaults.get(key));
    }

    public static String getDefaultAsString(String key) {
        return defaults.get(key);
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static boolean isInteger(String optionID) {
        String value = defaults.get(optionID);
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static void createDefaults() {
        String[][] defaultValues = new String[][]{{expandTabToSpaces, TRUE}, {tabSize, "4"}, {spacesPerTab, "4"}, {indentSize, "4"}, {rightMargin, "80"}, {freeFormat, TRUE}, {autoDetect, TRUE}};
        defaults = new HashMap<String, String>();
        for (String[] strings : defaultValues) {
            defaults.put(strings[0], strings[1]);
        }
    }

    static {
        FmtOptions.createDefaults();
    }

    public static final class ProxyPreferences
    extends AbstractPreferences {
        private final Preferences[] delegates;

        public ProxyPreferences(Preferences ... delegates) {
            super(null, "");
            this.delegates = delegates;
        }

        @Override
        protected void putSpi(String key, String value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String getSpi(String key) {
            for (Preferences p : this.delegates) {
                String value = p.get(key, null);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        @Override
        protected void removeSpi(String key) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            HashSet<String> keys = new HashSet<String>();
            for (Preferences p : this.delegates) {
                keys.addAll(Arrays.asList(p.keys()));
            }
            return keys.toArray(new String[keys.size()]);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class PreviewPreferences
    extends AbstractPreferences {
        private final Map<String, Object> map = new HashMap<String, Object>();

        public PreviewPreferences() {
            super(null, "");
        }

        @Override
        protected void putSpi(String key, String value) {
            this.map.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return (String)this.map.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.map.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            String[] array = new String[this.map.keySet().size()];
            return this.map.keySet().toArray(array);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class CategorySupport
    implements ActionListener,
    DocumentListener,
    PreviewProvider,
    PreferencesCustomizer {
        public static final String OPTION_ID = "org.netbeans.modules.editor.cnd.fortran.options.FormatingOptions.ID";
        private static final int LOAD = 0;
        private static final int STORE = 1;
        private static final int ADD_LISTENERS = 2;
        private final String previewText;
        private final String id;
        protected final JPanel panel;
        private final List<JComponent> components = new LinkedList<JComponent>();
        private JEditorPane previewPane;
        private final Preferences preferences;
        private final Preferences previewPrefs;

        protected CategorySupport(Preferences preferences, String id, JPanel panel, String previewText, String[] ... forcedOptions) {
            this.preferences = preferences;
            this.id = id;
            this.panel = panel;
            this.previewText = previewText != null ? previewText : NbBundle.getMessage(FmtOptions.class, (String)"SAMPLE_Default");
            this.scan(panel, this.components);
            PreviewPreferences forcedPrefs = new PreviewPreferences();
            for (String[] option : forcedOptions) {
                ((Preferences)forcedPrefs).put(option[0], option[1]);
            }
            this.previewPrefs = new ProxyPreferences(preferences, forcedPrefs);
            this.loadFrom(preferences);
            this.addListeners();
        }

        private void addListeners() {
            this.scan(2, null);
        }

        private void loadFrom(Preferences preferences) {
            this.scan(0, preferences);
        }

        protected void storeTo(Preferences p) {
            this.scan(1, p);
        }

        protected void notifyChanged() {
            this.storeTo(this.preferences);
            this.refreshPreview();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.notifyChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.notifyChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.notifyChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.notifyChanged();
        }

        public JComponent getPreviewComponent() {
            if (this.previewPane == null) {
                this.previewPane = new JEditorPane();
                this.previewPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FmtOptions.class, (String)"AN_Preview"));
                this.previewPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FmtOptions.class, (String)"AD_Preview"));
                this.previewPane.putClientProperty("HighlightsLayerIncludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.SyntaxHighlighting$");
                this.previewPane.setEditorKit(CloneableEditorSupport.getEditorKit((String)"text/x-fortran"));
                this.previewPane.setEditable(false);
            }
            return this.previewPane;
        }

        public void refreshPreview() {
            JEditorPane jep = (JEditorPane)this.getPreviewComponent();
            try {
                int rm = this.previewPrefs.getInt(FmtOptions.rightMargin, FmtOptions.getDefaultAsInt(FmtOptions.rightMargin));
                jep.putClientProperty("TextLimitLine", rm);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            jep.setIgnoreRepaint(true);
            jep.setText(this.previewText);
            final BaseDocument bd = (BaseDocument)jep.getDocument();
            final FortranCodeStyle codeStyle = FortranCodeStyle.get((Document)bd, this.previewPrefs);
            codeStyle.setupLexerAttributes((Document)bd);
            bd.runAtomicAsUser(new Runnable(){

                @Override
                public void run() {
                    try {
                        new FortranReformatter((Document)bd, codeStyle).reformat();
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            jep.setIgnoreRepaint(false);
            jep.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            jep.repaint(100L);
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public String getDisplayName() {
            return this.panel.getName();
        }

        public String getId() {
            return this.id;
        }

        public HelpCtx getHelpCtx() {
            return null;
        }

        private void performOperation(int operation, JComponent jc, String optionID, Preferences p) {
            switch (operation) {
                case 0: {
                    this.loadData(jc, optionID, p);
                    break;
                }
                case 1: {
                    this.storeData(jc, optionID, p);
                    break;
                }
                case 2: {
                    this.addListener(jc);
                }
            }
        }

        private void scan(int what, Preferences p) {
            for (JComponent jc : this.components) {
                Object o = jc.getClientProperty(OPTION_ID);
                if (o instanceof String) {
                    this.performOperation(what, jc, (String)o, p);
                    continue;
                }
                if (!(o instanceof String[])) continue;
                for (String oid : (String[])o) {
                    this.performOperation(what, jc, oid, p);
                }
            }
        }

        private void scan(Container container, List<JComponent> components) {
            for (Component c : container.getComponents()) {
                JComponent jc;
                Object o;
                if (c instanceof JComponent && ((o = (jc = (JComponent)c).getClientProperty(OPTION_ID)) instanceof String || o instanceof String[])) {
                    components.add(jc);
                }
                if (!(c instanceof Container)) continue;
                this.scan((Container)c, components);
            }
        }

        private void loadData(JComponent jc, String optionID, Preferences node) {
            if (jc instanceof JTextField) {
                JTextField field = (JTextField)jc;
                field.setText(node.get(optionID, FmtOptions.getDefaultAsString(optionID)));
            } else if (jc instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)jc;
                boolean df = FmtOptions.getDefaultAsBoolean(optionID);
                checkBox.setSelected(node.getBoolean(optionID, df));
            } else if (jc instanceof JComboBox) {
                JComboBox cb = (JComboBox)jc;
                String value = node.get(optionID, FmtOptions.getDefaultAsString(optionID));
                ComboBoxModel model = this.createModel(value);
                cb.setModel(model);
                ComboItem item = CategorySupport.whichItem(value, model);
                cb.setSelectedItem(item);
            }
        }

        private void storeData(JComponent jc, String optionID, Preferences node) {
            if (jc instanceof JTextField) {
                JTextField field = (JTextField)jc;
                String text = field.getText();
                if (FmtOptions.isInteger(optionID)) {
                    try {
                        Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                }
                if (!optionID.equals(FmtOptions.tabSize) && !optionID.equals(FmtOptions.spacesPerTab) && !optionID.equals(FmtOptions.indentSize) && FmtOptions.getDefaultAsString(optionID).equals(text)) {
                    node.remove(optionID);
                } else {
                    node.put(optionID, text);
                }
            } else if (jc instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)jc;
                if (!optionID.equals(FmtOptions.expandTabToSpaces) && FmtOptions.getDefaultAsBoolean(optionID) == checkBox.isSelected()) {
                    node.remove(optionID);
                } else {
                    node.putBoolean(optionID, checkBox.isSelected());
                }
            } else if (jc instanceof JComboBox) {
                JComboBox cb = (JComboBox)jc;
                String value = ((ComboItem)cb.getSelectedItem()).value;
                if (FmtOptions.getDefaultAsString(optionID).equals(value)) {
                    node.remove(optionID);
                } else {
                    node.put(optionID, value);
                }
            }
        }

        private void addListener(JComponent jc) {
            if (jc instanceof JTextField) {
                JTextField field = (JTextField)jc;
                field.addActionListener(this);
                field.getDocument().addDocumentListener(this);
            } else if (jc instanceof JCheckBox) {
                JCheckBox checkBox = (JCheckBox)jc;
                checkBox.addActionListener(this);
            } else if (jc instanceof JComboBox) {
                JComboBox cb = (JComboBox)jc;
                cb.addActionListener(this);
            }
        }

        private ComboBoxModel createModel(String value) {
            return null;
        }

        private static ComboItem whichItem(String value, ComboBoxModel model) {
            for (int i = 0; i < model.getSize(); ++i) {
                ComboItem item = (ComboItem)model.getElementAt(i);
                if (!value.equals(item.value)) continue;
                return item;
            }
            return null;
        }

        private static class ComboItem {
            private String value;
            private final String displayName;

            public ComboItem(String value, String key) {
                this.value = value;
                this.displayName = NbBundle.getMessage(FmtOptions.class, (String)key);
            }

            public String toString() {
                return this.displayName;
            }
        }

        public static final class Factory
        implements PreferencesCustomizer.Factory {
            private final String id;
            private final Class<? extends JPanel> panelClass;
            private final String previewText;
            private final String[][] forcedOptions;

            public Factory(String id, Class<? extends JPanel> panelClass, String previewText, String[] ... forcedOptions) {
                this.id = id;
                this.panelClass = panelClass;
                this.previewText = previewText;
                this.forcedOptions = forcedOptions;
            }

            public PreferencesCustomizer create(Preferences preferences) {
                try {
                    return new CategorySupport(preferences, this.id, this.panelClass.newInstance(), this.previewText, this.forcedOptions);
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
    }
}

