/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.java.hints.errors;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Name;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class SearchModuleDependency
implements ErrorRule<Void> {
    private AtomicBoolean cancel = new AtomicBoolean(false);

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.doesnt.exist", "compiler.err.not.stmt"));
    }

    private boolean isHintEnabled() {
        return true;
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        TreePath parent;
        this.cancel.set(false);
        if (!this.isHintEnabled()) {
            return Collections.emptyList();
        }
        int errorPosition = offset + 1;
        if (errorPosition == -1) {
            return Collections.emptyList();
        }
        FileObject fileObject = info.getFileObject();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return Collections.emptyList();
        }
        NbModuleProject nbModuleProject = (NbModuleProject)project.getLookup().lookup(NbModuleProject.class);
        if (nbModuleProject == null) {
            return Collections.emptyList();
        }
        TreePath path = info.getTreeUtilities().pathFor(errorPosition);
        if (path.getParentPath() == null) {
            return Collections.emptyList();
        }
        Tree leaf = path.getParentPath().getLeaf();
        switch (leaf.getKind()) {
            case METHOD_INVOCATION: {
                MethodInvocationTree mit = (MethodInvocationTree)leaf;
                if (!mit.getTypeArguments().contains(path.getLeaf())) {
                    return Collections.emptyList();
                }
            }
            case PARAMETERIZED_TYPE: {
                leaf = path.getParentPath().getParentPath().getLeaf();
                break;
            }
            case ARRAY_TYPE: {
                leaf = path.getParentPath().getParentPath().getLeaf();
            }
        }
        switch (leaf.getKind()) {
            case VARIABLE: {
                Name typeName = null;
                VariableTree variableTree = (VariableTree)leaf;
                if (variableTree.getType() != null) {
                    switch (variableTree.getType().getKind()) {
                        case IDENTIFIER: {
                            typeName = ((IdentifierTree)variableTree.getType()).getName();
                            break;
                        }
                        case PARAMETERIZED_TYPE: {
                            Tree ptt = (ParameterizedTypeTree)variableTree.getType();
                            if (ptt.getType() == null || ptt.getType().getKind() != Tree.Kind.IDENTIFIER) break;
                            typeName = ((IdentifierTree)ptt.getType()).getName();
                            break;
                        }
                        case ARRAY_TYPE: {
                            Tree ptt = (ArrayTypeTree)variableTree.getType();
                            if (ptt.getType() == null || ptt.getType().getKind() != Tree.Kind.IDENTIFIER) break;
                            typeName = ((IdentifierTree)ptt.getType()).getName();
                        }
                    }
                }
                ExpressionTree initializer = variableTree.getInitializer();
                if (typeName == null || initializer == null) break;
                Name itName = null;
                switch (initializer.getKind()) {
                    case NEW_CLASS: {
                        NewClassTree classTree = (NewClassTree)initializer;
                        ExpressionTree identifier = classTree.getIdentifier();
                        if (identifier != null) {
                            switch (identifier.getKind()) {
                                case IDENTIFIER: {
                                    itName = ((IdentifierTree)identifier).getName();
                                    break;
                                }
                                case PARAMETERIZED_TYPE: {
                                    ParameterizedTypeTree ptt = (ParameterizedTypeTree)((Object)identifier);
                                    if (ptt.getType() == null || ptt.getType().getKind() != Tree.Kind.IDENTIFIER) break;
                                    itName = ((IdentifierTree)ptt.getType()).getName();
                                }
                            }
                        }
                        break;
                    }
                    case NEW_ARRAY: {
                        NewArrayTree arrayTree = (NewArrayTree)initializer;
                        Tree type = arrayTree.getType();
                        if (type == null || !type.getKind().equals((Object)Tree.Kind.IDENTIFIER)) break;
                        itName = ((IdentifierTree)type).getName();
                    }
                }
                if (!typeName.equals(itName)) break;
                return Collections.emptyList();
            }
        }
        String simpleOrQualifiedName = null;
        TreePath p = path;
        while (p != null && (parent = p.getParentPath()) != null) {
            Tree.Kind parentKind = parent.getLeaf().getKind();
            if (parentKind == Tree.Kind.IMPORT) {
                simpleOrQualifiedName = p.getLeaf().toString();
                break;
            }
            if (parentKind != Tree.Kind.MEMBER_SELECT && parentKind != Tree.Kind.IDENTIFIER) break;
            p = parent;
        }
        if (simpleOrQualifiedName == null) {
            try {
                Token ident = SearchModuleDependency.findUnresolvedElementToken(info, offset);
                if (ident == null) {
                    return Collections.emptyList();
                }
                simpleOrQualifiedName = ident.text().toString();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
                return Collections.emptyList();
            }
        }
        if (this.cancel.get()) {
            return Collections.emptyList();
        }
        if (simpleOrQualifiedName.endsWith(".*")) {
            simpleOrQualifiedName = simpleOrQualifiedName.substring(0, simpleOrQualifiedName.length() - ".*".length());
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        fixes.add((Fix)new OpenDependencyDialogFix(nbModuleProject, simpleOrQualifiedName, info, path));
        return fixes;
    }

    private static Token findUnresolvedElementToken(CompilationInfo info, int offset) throws IOException {
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() == JavaTokenId.DOT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.LT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.NEW) {
                boolean cont = ts.moveNext();
                while (cont && ts.token().id() == JavaTokenId.WHITESPACE) {
                    cont = ts.moveNext();
                }
                if (!cont) {
                    return null;
                }
                t = ts.token();
            }
            if (t.id() == JavaTokenId.IDENTIFIER) {
                return ts.offsetToken();
            }
        }
        return null;
    }

    public String getId() {
        return "NBM_MISSING_CLASS_NBMANT";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SearchModuleDependency.class, (String)"LBL_Module_Dependency_Search_DisplayName");
    }

    public void cancel() {
        this.cancel.set(true);
    }

    static final class OpenDependencyDialogFix
    implements EnhancedFix {
        private NbModuleProject project;
        private String clazz;
        private CompilationInfo info;
        private TreePath path;

        public OpenDependencyDialogFix(NbModuleProject project, String clazz, CompilationInfo info, TreePath path) {
            this.project = project;
            this.clazz = clazz;
            this.info = info;
            this.path = path;
        }

        public CharSequence getSortText() {
            return this.getText();
        }

        public String getText() {
            return NbBundle.getMessage(OpenDependencyDialogFix.class, (String)"FIX_Module_Dependency_Search", (Object)this.clazz);
        }

        public ChangeInfo implement() throws Exception {
            SingleModuleProperties props = SingleModuleProperties.getInstance(this.project);
            final ModuleDependency[] newDeps = AddModulePanel.selectDependencies(props, this.clazz);
            AtomicBoolean cancel = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProjectXMLManager pxm = new ProjectXMLManager(OpenDependencyDialogFix.this.project);
                    try {
                        pxm.addDependencies(new HashSet<ModuleDependency>(Arrays.asList(newDeps)));
                        ProjectManager.getDefault().saveProject((Project)OpenDependencyDialogFix.this.project);
                    }
                    catch (IOException e) {
                    }
                    catch (ProjectXMLManager.CyclicDependencyException ex) {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)ex.getLocalizedMessage(), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    }
                    int occurences = 0;
                    String fqnIter = "";
                    for (ModuleDependency depIter : newDeps) {
                        for (String publPkgClassNameIter : depIter.getModuleEntry().getPublicClassNames()) {
                            if (!publPkgClassNameIter.endsWith("." + OpenDependencyDialogFix.this.clazz)) continue;
                            fqnIter = publPkgClassNameIter;
                            ++occurences;
                        }
                    }
                    if (occurences == 1) {
                        final String fqn = fqnIter;
                        JavaSource js = JavaSource.forFileObject((FileObject)OpenDependencyDialogFix.this.info.getFileObject());
                        if (js != null) {
                            try {
                                js.runWhenScanFinished((Task)new Task<CompilationController>(){

                                    public void run(CompilationController cc) throws Exception {
                                        try {
                                            SourceUtils.resolveImport((CompilationInfo)OpenDependencyDialogFix.this.info, (TreePath)OpenDependencyDialogFix.this.path, (String)fqn);
                                        }
                                        catch (NullPointerException ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                        }
                                        catch (IOException ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                        }
                                    }
                                }, true);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
            }, (String)NbBundle.getMessage(SearchModuleDependency.class, (String)"FIX_Module_Dependency_UpdatingDependencies"), (AtomicBoolean)cancel, (boolean)false);
            return null;
        }
    }
}

