/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicInfoVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewNbModuleWizardIterator;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class TypeChooserPanelImpl
extends JPanel
implements PropertyChangeListener {
    public static final String IS_STANDALONE_OR_SUITE_COMPONENT = "tc_isStandaloneOrSuiteComp";
    public static final String SUITE_ROOT = "tc_suiteRoot";
    public static final String ACTIVE_PLATFORM_ID = "tc_activePlatform_id";
    public static final String ACTIVE_NB_PLATFORM = "tc_activeNBPlatform";
    public static final String IS_NETBEANS_ORG = "isNetBeansOrg";
    public static final String PROJECT_FOLDER = "tc_projectFolderForTypeChooser";
    private ButtonModel lastSelectedType;
    private static String lastSelectedSuite;
    private boolean moduleTypeGroupAttached = false;
    private WizardDescriptor settings;
    private NewNbModuleWizardIterator.Type wizardType;
    private static final Logger LOG;
    private static int validityCounter;
    private int validityId;
    private boolean internalUpdate = false;
    private JButton browseSuiteButton;
    private JLabel chooserFiller;
    private JButton managePlatform;
    private JLabel moduleSuite;
    private JComboBox moduleSuiteValue;
    private ButtonGroup moduleTypeGroup;
    private JLabel platform;
    private JComboBox platformValue;
    private JRadioButton standAloneModule;
    private JRadioButton suiteComponent;
    private JPanel typeChooserPanel;

    public TypeChooserPanelImpl(WizardDescriptor settings) {
        this();
        this.settings = settings;
        this.attachModuleTypeGroup();
        this.storeInitialValuesToWD(this.getSettings());
        this.attachPropertyChangeListener(this.getSettings());
    }

    TypeChooserPanelImpl() {
        this.init(null);
    }

    TypeChooserPanelImpl(NewNbModuleWizardIterator.Type wizardType) {
        this.init(wizardType);
    }

    TypeChooserPanelImpl(WizardDescriptor settings, NewNbModuleWizardIterator.Type wizardType) {
        this(wizardType);
        this.settings = settings;
        this.wizardType = wizardType;
        this.storeInitialValuesToWD(this.getSettings());
        this.attachPropertyChangeListener(this.getSettings());
        switch (wizardType) {
            case SUITE: 
            case APPLICATION: {
                this.detachModuleTypeGroup();
                break;
            }
            case LIBRARY_MODULE: {
                this.moduleSuite.setText(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"LBL_Add_to_Suite"));
                this.suiteComponent.setSelected(true);
                ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(this.getSettings(), false);
                if (this.moduleSuiteValue.getItemCount() <= 0) break;
                this.restoreSelectedSuite();
                break;
            }
            default: {
                if (this.moduleSuiteValue.getItemCount() <= 0) break;
                this.restoreSelectedSuite();
                this.suiteComponent.setSelected(true);
            }
        }
    }

    protected static JComboBox getDefaultSuitesComboBox() {
        return PlatformComponentFactory.getSuitesComboBox();
    }

    private boolean isStandAlone() {
        return this.standAloneModule.isSelected();
    }

    private boolean isSuiteComponent() {
        return this.suiteComponent.isSelected();
    }

    private String getSelectedSuite() {
        return (String)this.moduleSuiteValue.getSelectedItem();
    }

    private boolean isNetBeansOrgFolder() {
        File folder = ModuleTypePanelExtended.getProjectFolder(this.getSettings());
        if (folder != null) {
            boolean ret = BasicInfoVisualPanel.isNetBeansOrgFolder(folder);
            LOG.log(Level.FINER, "isNetBeansOrgFolder '" + folder + "'? " + (ret ? "YES" : "NO"));
            return ret;
        }
        LOG.log(Level.FINER, "isNetBeansOrgFolder 'null'? NO");
        return false;
    }

    private String getSelectedPlatformId() {
        Object selected = this.platformValue.getSelectedItem();
        if (selected != null) {
            return ((NbPlatform)this.platformValue.getSelectedItem()).getID();
        }
        return null;
    }

    private NbPlatform getSelectedNbPlatform() {
        Object selected = this.platformValue.getSelectedItem();
        if (selected != null) {
            return (NbPlatform)this.platformValue.getSelectedItem();
        }
        return null;
    }

    protected void setComponentsVisibility(boolean isSuiteComponentWizard, boolean isLibraryWizard) {
        this.suiteComponent.setVisible(!isLibraryWizard);
        this.platform.setVisible(!isLibraryWizard);
        this.platformValue.setVisible(!isLibraryWizard);
        this.managePlatform.setVisible(!isLibraryWizard);
        this.standAloneModule.setVisible(!isLibraryWizard);
        this.standAloneModule.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
        this.platform.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
        this.platformValue.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
        this.managePlatform.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
        this.suiteComponent.setVisible(!isSuiteComponentWizard && !isLibraryWizard);
    }

    private void updateEnabled() {
        boolean isNetBeansOrg = this.isNetBeansOrgFolder();
        this.standAloneModule.setEnabled(!isNetBeansOrg);
        this.suiteComponent.setEnabled(!isNetBeansOrg);
        boolean standalone = this.isStandAlone();
        boolean suiteModuleSelected = this.isSuiteComponent();
        this.platform.setEnabled(standalone);
        this.platformValue.setEnabled(standalone);
        this.managePlatform.setEnabled(standalone);
        this.moduleSuite.setEnabled(suiteModuleSelected);
        this.moduleSuiteValue.setEnabled(suiteModuleSelected && !this.isOneSuiteDedicatedMode());
        this.browseSuiteButton.setEnabled(suiteModuleSelected && !this.isOneSuiteDedicatedMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectFolderIsUpdated() {
        if (this.internalUpdate || validityCounter != this.validityId) {
            return;
        }
        try {
            this.internalUpdate = true;
            if (TypeChooserPanelImpl.isSuiteWizard(this.getWizardType()) || this.isNetBeansOrgFolder()) {
                LOG.log(Level.FINE, "projectFolderIsUpdated detaching module type group");
                this.detachModuleTypeGroup();
            } else {
                LOG.log(Level.FINE, "projectFolderIsUpdated attaching module type group");
                this.attachModuleTypeGroup();
            }
            this.updateEnabled();
            boolean nbOrg = this.isNetBeansOrgFolder();
            ModuleTypePanelExtended.setIsNetBeansOrg(this.getSettings(), nbOrg);
            ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(this.getSettings(), nbOrg ? null : Boolean.valueOf(this.isStandAlone()));
        }
        finally {
            this.internalUpdate = false;
        }
    }

    private void storeInitialValuesToWD(WizardDescriptor settings) {
        ModuleTypePanelExtended.setIsNetBeansOrg(settings, this.isNetBeansOrgFolder());
        ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(settings, this.isStandAlone());
        ModuleTypePanelExtended.setSuiteRoot(settings, this.getSelectedSuite());
        ModuleTypePanelExtended.setActivePlatformId(settings, this.getSelectedPlatformId());
        ModuleTypePanelExtended.setActiveNbPlatform(settings, this.getSelectedNbPlatform());
    }

    private void attachPropertyChangeListener(WizardDescriptor settings) {
        settings.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)settings));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (PROJECT_FOLDER.equals(name)) {
            this.projectFolderIsUpdated();
        }
    }

    private void detachModuleTypeGroup() {
        if (this.moduleTypeGroupAttached) {
            this.lastSelectedType = this.moduleTypeGroup.getSelection();
            this.moduleTypeGroup.remove(this.standAloneModule);
            this.moduleTypeGroup.remove(this.suiteComponent);
            this.standAloneModule.setSelected(false);
            this.suiteComponent.setSelected(false);
            this.moduleTypeGroupAttached = false;
        }
    }

    protected void attachModuleTypeGroup() {
        if (!this.moduleTypeGroupAttached) {
            this.moduleTypeGroup.add(this.standAloneModule);
            this.moduleTypeGroup.add(this.suiteComponent);
            if (TypeChooserPanelImpl.isLibraryWizard(this.getWizardType())) {
                this.suiteComponent.setSelected(true);
            } else {
                this.moduleTypeGroup.setSelected(this.lastSelectedType, true);
            }
            this.moduleTypeGroupAttached = true;
        }
    }

    private void init(NewNbModuleWizardIterator.Type wizardType) {
        this.validityId = ++validityCounter;
        this.initComponents();
        BasicInfoVisualPanel.initPlatformCombo(this.platformValue);
        if (this.moduleSuiteValue.getItemCount() > 0) {
            this.restoreSelectedSuite();
            if (wizardType != NewNbModuleWizardIterator.Type.APPLICATION && wizardType != NewNbModuleWizardIterator.Type.SUITE) {
                this.suiteComponent.setSelected(true);
            }
        }
    }

    private void restoreSelectedSuite() {
        String preferredSuiteDir = this.getPreferredSuiteDir();
        if (preferredSuiteDir != null) {
            lastSelectedSuite = preferredSuiteDir;
        }
        if (lastSelectedSuite != null) {
            int max = this.moduleSuiteValue.getModel().getSize();
            for (int i = 0; i < max; ++i) {
                if (!lastSelectedSuite.equals(this.moduleSuiteValue.getModel().getElementAt(i))) continue;
                this.moduleSuiteValue.setSelectedItem(lastSelectedSuite);
                break;
            }
        }
    }

    private String getPreferredSuiteDir() {
        if (this.getSettings() != null) {
            return (String)this.getSettings().getProperty("preferredSuiteDir");
        }
        return null;
    }

    private boolean isOneSuiteDedicatedMode() {
        Boolean b = false;
        if (this.getSettings() != null) {
            b = (Boolean)this.getSettings().getProperty("oneSuiteDedicatedMode");
        }
        return b != null ? b : false;
    }

    private void initComponents() {
        this.moduleTypeGroup = new ButtonGroup();
        this.typeChooserPanel = new JPanel();
        this.standAloneModule = new JRadioButton();
        this.platform = new JLabel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.managePlatform = new JButton();
        this.suiteComponent = new JRadioButton();
        this.moduleSuite = new JLabel();
        this.moduleSuiteValue = TypeChooserPanelImpl.getDefaultSuitesComboBox();
        this.browseSuiteButton = new JButton();
        this.chooserFiller = new JLabel();
        this.setLayout(new BorderLayout());
        this.typeChooserPanel.setLayout(new GridBagLayout());
        this.moduleTypeGroup.add(this.standAloneModule);
        this.standAloneModule.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.standAloneModule, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"CTL_StandaloneModule"));
        this.standAloneModule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TypeChooserPanelImpl.this.standAloneModuleTypeChanged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.typeChooserPanel.add((Component)this.standAloneModule, gridBagConstraints);
        this.standAloneModule.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_StandAloneModule"));
        this.standAloneModule.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_StandAloneModule"));
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 0, 12);
        this.typeChooserPanel.add((Component)this.platform, gridBagConstraints);
        this.platformValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TypeChooserPanelImpl.this.platformChosen(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.typeChooserPanel.add((Component)this.platformValue, gridBagConstraints);
        this.platformValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_PlatformValue"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_PlatformValue"));
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatform, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"CTL_ManagePlatforms_g"));
        this.managePlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TypeChooserPanelImpl.this.managePlatformActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.typeChooserPanel.add((Component)this.managePlatform, gridBagConstraints);
        this.managePlatform.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_ManagePlatform"));
        this.managePlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_ManagePlatform"));
        this.moduleTypeGroup.add(this.suiteComponent);
        Mnemonics.setLocalizedText((AbstractButton)this.suiteComponent, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"CTL_AddToModuleSuite"));
        this.suiteComponent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TypeChooserPanelImpl.this.suiteComponentTypeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.typeChooserPanel.add((Component)this.suiteComponent, gridBagConstraints);
        this.suiteComponent.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_SuiteModule"));
        this.suiteComponent.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_SuiteModule"));
        this.moduleSuite.setLabelFor(this.moduleSuiteValue);
        Mnemonics.setLocalizedText((JLabel)this.moduleSuite, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"LBL_ModuleSuite"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 12);
        this.typeChooserPanel.add((Component)this.moduleSuite, gridBagConstraints);
        this.moduleSuiteValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TypeChooserPanelImpl.this.moduleSuiteChosen(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.typeChooserPanel.add((Component)this.moduleSuiteValue, gridBagConstraints);
        this.moduleSuiteValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_ModuleSuiteValue"));
        this.moduleSuiteValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_ModuleSuiteValue"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseSuiteButton, (String)NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"CTL_BrowseButton_w"));
        this.browseSuiteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TypeChooserPanelImpl.this.browseModuleSuite(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.typeChooserPanel.add((Component)this.browseSuiteButton, gridBagConstraints);
        this.browseSuiteButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_BrowseSuiteButton"));
        this.browseSuiteButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TypeChooserPanelImpl.class, (String)"ACS_CTL_BrowseSuiteButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.typeChooserPanel.add((Component)this.chooserFiller, gridBagConstraints);
        this.add((Component)this.typeChooserPanel, "Center");
    }

    private void standAloneModuleTypeChanged(ActionEvent evt) {
        ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(this.getSettings(), this.isStandAlone());
        this.updateEnabled();
    }

    private void platformChosen(ActionEvent evt) {
        ModuleTypePanelExtended.setActivePlatformId(this.getSettings(), this.getSelectedPlatformId());
        ModuleTypePanelExtended.setActiveNbPlatform(this.getSettings(), this.getSelectedNbPlatform());
        this.updateEnabled();
    }

    private void managePlatformActionPerformed(ActionEvent evt) {
        this.managePlatform(this.platformValue);
        ModuleTypePanelExtended.setActivePlatformId(this.getSettings(), this.getSelectedPlatformId());
        ModuleTypePanelExtended.setActiveNbPlatform(this.getSettings(), this.getSelectedNbPlatform());
        this.updateEnabled();
    }

    private void managePlatform(JComboBox platformCombo) {
        NbPlatformCustomizer.showCustomizer();
        platformCombo.setModel(new PlatformComponentFactory.NbPlatformListModel());
        platformCombo.requestFocus();
    }

    private void suiteComponentTypeChanged(ActionEvent evt) {
        ModuleTypePanelExtended.setIsStandaloneOrSuiteComponent(this.getSettings(), this.isStandAlone());
        this.updateEnabled();
    }

    private void moduleSuiteChosen(ActionEvent evt) {
        String suite;
        lastSelectedSuite = suite = (String)this.moduleSuiteValue.getSelectedItem();
        ModuleTypePanelExtended.setSuiteRoot(this.getSettings(), this.getSelectedSuite());
        this.updateEnabled();
    }

    private void browseModuleSuite(ActionEvent evt) {
        JFileChooser chooser = ProjectChooser.projectChooser();
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            File projectDir = chooser.getSelectedFile();
            ApisupportAntUIUtils.setProjectChooserDirParent(projectDir);
            try {
                Project suite = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)projectDir));
                if (suite != null) {
                    String suiteDir = SuiteUtils.getSuiteDirectoryPath(suite);
                    if (suiteDir != null) {
                        PlatformComponentFactory.addUserSuite(suiteDir);
                        this.moduleSuiteValue.addItem(suiteDir);
                        this.moduleSuiteValue.setSelectedItem(suiteDir);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_NotRegularSuite", (Object)ProjectUtils.getInformation((Project)suite).getDisplayName())));
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(16, (Throwable)e);
            }
        }
    }

    protected WizardDescriptor getSettings() {
        return this.settings;
    }

    private NewNbModuleWizardIterator.Type getWizardType() {
        return this.wizardType;
    }

    private static boolean isSuiteWizard(NewNbModuleWizardIterator.Type type) {
        return type != null ? NewNbModuleWizardIterator.isSuiteWizard(type) : false;
    }

    private static boolean isLibraryWizard(NewNbModuleWizardIterator.Type type) {
        return type != null ? NewNbModuleWizardIterator.isLibraryWizard(type) : false;
    }

    static {
        LOG = Logger.getLogger(TypeChooserPanelImpl.class.getName());
        validityCounter = 0;
    }

    private static class ModuleTypePanelExtended {
        private ModuleTypePanelExtended() {
        }

        static void setIsStandaloneOrSuiteComponent(WizardDescriptor settings, Boolean value) {
            if (settings != null && (value != null || settings.getProperty(TypeChooserPanelImpl.IS_STANDALONE_OR_SUITE_COMPONENT) != null)) {
                LOG.log(Level.FINE, "setIsStandaloneOrSuiteComponent: " + (value == null ? "NULL" : (value != false ? "TRUE" : "FALSE")));
                settings.putProperty(TypeChooserPanelImpl.IS_STANDALONE_OR_SUITE_COMPONENT, (Object)value);
            }
        }

        static void setIsNetBeansOrg(WizardDescriptor settings, Boolean value) {
            if (settings != null) {
                LOG.log(Level.FINE, "setIsNetBeansOrg: " + (value == null ? "NULL" : (value != false ? "TRUE" : "FALSE")));
                settings.putProperty(TypeChooserPanelImpl.IS_NETBEANS_ORG, (Object)value);
            }
        }

        static void setActivePlatformId(WizardDescriptor settings, String value) {
            if (settings != null) {
                settings.putProperty(TypeChooserPanelImpl.ACTIVE_PLATFORM_ID, (Object)value);
            }
        }

        static void setActiveNbPlatform(WizardDescriptor settings, NbPlatform value) {
            if (settings != null) {
                settings.putProperty(TypeChooserPanelImpl.ACTIVE_NB_PLATFORM, (Object)value);
            }
        }

        static void setSuiteRoot(WizardDescriptor settings, String value) {
            if (settings != null) {
                settings.putProperty(TypeChooserPanelImpl.SUITE_ROOT, (Object)value);
            }
        }

        static File getProjectFolder(WizardDescriptor settings) {
            Object value;
            if (settings != null && (value = settings.getProperty(TypeChooserPanelImpl.PROJECT_FOLDER)) != null && value instanceof File) {
                return (File)value;
            }
            return null;
        }
    }
}

