/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.bower.exec;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.bower.exec.Bundle;
import org.netbeans.modules.javascript.bower.file.BowerJson;
import org.netbeans.modules.javascript.bower.options.BowerOptions;
import org.netbeans.modules.javascript.bower.options.BowerOptionsValidator;
import org.netbeans.modules.javascript.bower.util.BowerUtils;
import org.netbeans.modules.javascript.bower.util.FileUtils;
import org.netbeans.modules.javascript.bower.util.StringUtils;
import org.netbeans.modules.web.common.api.ExternalExecutable;
import org.netbeans.modules.web.common.api.ValidationResult;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public class BowerExecutable {
    private static final Logger LOGGER = Logger.getLogger(BowerExecutable.class.getName());
    public static final String BOWER_NAME = Utilities.isWindows() ? "bower.cmd" : "bower";
    public static final String SAVE_PARAM = "--save";
    public static final String SAVE_DEV_PARAM = "--save-dev";
    private static final String INSTALL_PARAM = "install";
    private static final String UNINSTALL_PARAM = "uninstall";
    protected final Project project;
    protected final String bowerPath;

    BowerExecutable(String bowerPath, @NullAllowed Project project) {
        assert (bowerPath != null);
        this.bowerPath = bowerPath;
        this.project = project;
    }

    @CheckForNull
    public static BowerExecutable getDefault(@NullAllowed Project project, boolean showOptions) {
        ValidationResult result = new BowerOptionsValidator().validateBower().getResult();
        if (BowerExecutable.validateResult(result) != null) {
            if (showOptions) {
                OptionsDisplayer.getDefault().open("Html5/Bower");
            }
            return null;
        }
        return BowerExecutable.createExecutable(BowerOptions.getInstance().getBower(), project);
    }

    private static BowerExecutable createExecutable(String bower, Project project) {
        if (Utilities.isMac()) {
            return new MacBowerExecutable(bower, project);
        }
        return new BowerExecutable(bower, project);
    }

    String getCommand() {
        return this.bowerPath;
    }

    @CheckForNull
    public Future<Integer> install(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = BowerUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.BowerExecutable_install(projectName)).additionalParameters(this.getInstallParams(args)).run(this.getDescriptor());
        assert (task != null) : this.bowerPath;
        return task;
    }

    @CheckForNull
    public Future<Integer> uninstall(String ... args) {
        assert (!EventQueue.isDispatchThread());
        assert (this.project != null);
        String projectName = BowerUtils.getProjectDisplayName(this.project);
        Future task = this.getExecutable(Bundle.BowerExecutable_uninstall(projectName)).additionalParameters(this.getUninstallParams(args)).run(this.getDescriptor());
        assert (task != null) : this.bowerPath;
        return task;
    }

    @CheckForNull
    public JSONObject list() {
        ArrayList<String> params = new ArrayList<String>();
        params.add("list");
        params.add("--json");
        params.add("--offline");
        JSONObject info = null;
        try {
            StringBuilderInputProcessorFactory factory = new StringBuilderInputProcessorFactory();
            this.getExecutable("bower list").additionalParameters(this.getParams(params)).redirectErrorStream(false).runAndWait(BowerExecutable.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)factory, "");
            String result = factory.getResult();
            info = (JSONObject)new JSONParser().parse(result);
        }
        catch (ExecutionException | ParseException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return info;
    }

    @CheckForNull
    public JSONArray search(String searchTerm) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("search");
        params.add("--json");
        params.add(searchTerm);
        JSONArray result = null;
        StringBuilderInputProcessorFactory factory = new StringBuilderInputProcessorFactory();
        try {
            Integer exitCode = this.getExecutable("bower search").additionalParameters(this.getParams(params)).redirectErrorStream(false).runAndWait(BowerExecutable.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)factory, "");
            String rawResult = factory.getResult();
            if (exitCode != null && exitCode == 0) {
                result = (JSONArray)new JSONParser().parse(rawResult);
            }
        }
        catch (ExecutionException | ParseException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return result;
    }

    @CheckForNull
    public JSONObject info(String packageName) {
        ArrayList<String> params = new ArrayList<String>();
        params.add("info");
        params.add("--json");
        params.add(packageName);
        JSONObject info = null;
        try {
            StringBuilderInputProcessorFactory factory = new StringBuilderInputProcessorFactory();
            Integer exitCode = this.getExecutable("bower info").additionalParameters(this.getParams(params)).redirectErrorStream(false).environmentVariables(this.doNotAskForPasswordEnvironmentVariables()).runAndWait(BowerExecutable.getSilentDescriptor(), (ExecutionDescriptor.InputProcessorFactory2)factory, "");
            String result = factory.getResult();
            if (exitCode != null && exitCode == 0) {
                info = (JSONObject)new JSONParser().parse(result);
            }
        }
        catch (ExecutionException | ParseException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        return info;
    }

    private Map<String, String> doNotAskForPasswordEnvironmentVariables() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("SSH_ASKPASS", "echo");
        map.put("GIT_ASKPASS", "echo");
        return map;
    }

    private ExternalExecutable getExecutable(String title) {
        assert (title != null);
        return new ExternalExecutable(this.getCommand()).workDir(this.getWorkDir()).displayName(title).optionsPath("Html5/Bower").noOutput(false);
    }

    private ExecutionDescriptor getDescriptor() {
        assert (this.project != null);
        return ExternalExecutable.DEFAULT_EXECUTION_DESCRIPTOR.optionsPath("Html5/Bower").outLineBased(true).errLineBased(true);
    }

    private static ExecutionDescriptor getSilentDescriptor() {
        return new ExecutionDescriptor().inputOutput(InputOutput.NULL).inputVisible(false).frontWindow(false).showProgress(false).charset(StandardCharsets.UTF_8);
    }

    private File getWorkDir() {
        if (this.project == null) {
            return FileUtils.TMP_DIR;
        }
        BowerJson bowerJson = new BowerJson(this.project.getProjectDirectory());
        if (bowerJson.exists()) {
            return new File(bowerJson.getPath()).getParentFile();
        }
        File workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        assert (workDir != null) : this.project.getProjectDirectory();
        return workDir;
    }

    private List<String> getInstallParams(String ... args) {
        ArrayList<String> params = new ArrayList<String>(args.length + 1);
        params.add(INSTALL_PARAM);
        params.addAll(this.getArgsParams(args));
        return this.getParams(params);
    }

    private List<String> getUninstallParams(String ... args) {
        ArrayList<String> params = new ArrayList<String>(args.length + 1);
        params.add(UNINSTALL_PARAM);
        params.addAll(this.getArgsParams(args));
        return this.getParams(params);
    }

    private List<String> getArgsParams(String[] args) {
        return Arrays.asList(args);
    }

    List<String> getParams(List<String> params) {
        assert (params != null);
        return params;
    }

    @CheckForNull
    private static String validateResult(ValidationResult result) {
        if (result.isFaultless()) {
            return null;
        }
        if (result.hasErrors()) {
            return result.getFirstErrorMessage();
        }
        return result.getFirstWarningMessage();
    }

    private static final class StringBuilderInputProcessorFactory
    implements ExecutionDescriptor.InputProcessorFactory2 {
        private final StringBuilder result = new StringBuilder();

        private StringBuilderInputProcessorFactory() {
        }

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return new InputProcessor(){

                public void processInput(char[] chars) throws IOException {
                    StringBuilderInputProcessorFactory.this.result.append(chars);
                }

                public void reset() throws IOException {
                    StringBuilderInputProcessorFactory.this.result.setLength(0);
                }

                public void close() throws IOException {
                }
            };
        }

        String getResult() {
            return this.result.toString();
        }
    }

    private static final class MacBowerExecutable
    extends BowerExecutable {
        private static final String BASH_COMMAND = "/bin/bash -lc";

        MacBowerExecutable(String bowerPath, Project project) {
            super(bowerPath, project);
        }

        @Override
        String getCommand() {
            return BASH_COMMAND;
        }

        @Override
        List<String> getParams(List<String> params) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("\"");
            sb.append(this.bowerPath);
            sb.append("\" \"");
            sb.append(StringUtils.implode(super.getParams(params), "\" \""));
            sb.append("\"");
            return Collections.singletonList(sb.toString());
        }
    }
}

