/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.html.editor.lib.api.HelpResolver;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.CharSequences;

public class HtmlDocumentation
implements HelpResolver {
    static final String SECTIONS_PATTERN_CODE = "<h\\d\\s*?id=['\\\"]?([\\w\\d-_,:]*)['\\\"]?[^\\>]*>";
    static final Pattern SECTIONS_PATTERN = Pattern.compile("<h\\d\\s*?id=['\\\"]?([\\w\\d-_,:]*)['\\\"]?[^\\>]*>");
    private static final String DOC_ZIP_FILE_NAME = "docs/html5doc.zip";
    private static URL DOC_ZIP_URL;
    private static final String HELP_PREFIX = "<html><head><title>help</title></head><body>";
    private static final HtmlDocumentation SINGLETON;
    static long url_read_time;
    static long pattern_search_time;
    private static Map<String, String> HELP_FILES_CACHE;
    private static Map<URL, OffsetRange> HELP_LINKS_CACHE;

    public static void setupDocumentationForUnitTests() {
        System.setProperty("netbeans.dirs", System.getProperty("cluster.path.final"));
    }

    public static HtmlDocumentation getDefault() {
        return SINGLETON;
    }

    static URL getZipURL() {
        if (DOC_ZIP_URL == null) {
            File file = InstalledFileLocator.getDefault().locate(DOC_ZIP_FILE_NAME, null, false);
            if (file != null) {
                try {
                    URL url = file.toURI().toURL();
                    DOC_ZIP_URL = FileUtil.getArchiveRoot((URL)url);
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(HtmlDocumentation.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                Logger.getAnonymousLogger().warning(String.format("Cannot locate the %s documentation file.", DOC_ZIP_FILE_NAME));
            }
        }
        return DOC_ZIP_URL;
    }

    public URL resolveLink(URL baseURL, String relativeLink) {
        String link = null;
        String base = baseURL.toExternalForm();
        if (relativeLink.startsWith("#")) {
            int hashIdx = base.indexOf(35);
            if (hashIdx != -1) {
                base = base.substring(0, hashIdx);
            }
            link = base + relativeLink;
        } else {
            link = HtmlDocumentation.getZipURL() + relativeLink;
        }
        try {
            return new URI(link).toURL();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(HtmlDocumentation.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HtmlDocumentation.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public URL resolveLink(String relativeLink) {
        if (relativeLink == null) {
            return null;
        }
        URL zipURL = HtmlDocumentation.getZipURL();
        if (zipURL == null) {
            return null;
        }
        try {
            return new URI(zipURL.toExternalForm() + relativeLink).toURL();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(HtmlDocumentation.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HtmlDocumentation.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public String getHelpContent(URL url) {
        return this.getSectionContent(url, null);
    }

    static String getContentAsString(URL url, Charset charset) {
        String filePath = url.getPath();
        String cachedContent = HELP_FILES_CACHE.get(filePath);
        if (cachedContent != null) {
            return cachedContent;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try {
            int read;
            URLConnection con = url.openConnection();
            con.connect();
            InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(con.getInputStream()), charset);
            char[] buf = new char[2048];
            StringBuilder content = new StringBuilder();
            while ((read = r.read(buf)) != -1) {
                content.append(buf, 0, read);
            }
            ((Reader)r).close();
            String strContent = content.toString();
            HELP_FILES_CACHE.put(filePath, strContent);
            return strContent;
        }
        catch (IOException ex) {
            Logger.getLogger(HtmlDocumentation.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String getSectionContent(URL url, Charset charset) {
        long a = System.currentTimeMillis();
        String content = HtmlDocumentation.getContentAsString(url, charset);
        long b = System.currentTimeMillis();
        String surl = url.toExternalForm();
        int hashIndex = surl.indexOf(35);
        if (hashIndex == -1) {
            return content;
        }
        OffsetRange range = HELP_LINKS_CACHE.get(url);
        if (range != null) {
            return this.buildHelpText(content, range);
        }
        String sectionName = surl.substring(hashIndex + 1);
        Matcher matcher = SECTIONS_PATTERN.matcher(content);
        int from = -1;
        int to = -1;
        LinkedList<Integer> groupIndexes = new LinkedList<Integer>();
        while (matcher.find()) {
            groupIndexes.add(matcher.start());
            if (matcher.group(1).equals(sectionName)) {
                from = matcher.start();
                continue;
            }
            if (from == -1) continue;
            to = matcher.start();
            break;
        }
        if (to == -1) {
            to = content.length();
        }
        long c = System.currentTimeMillis();
        url_read_time = b - a;
        pattern_search_time = c - b;
        if (from != -1) {
            return this.buildAndCacheHelpText(content, new OffsetRange(from, to), url);
        }
        int lastgi = -1;
        Iterator i$ = groupIndexes.iterator();
        while (i$.hasNext()) {
            int gi = (Integer)i$.next();
            if (lastgi != -1) {
                CharSequence sub = content.subSequence(lastgi, gi);
                int index = CharSequences.indexOf((CharSequence)sub, (CharSequence)String.format("<dfn id=%s", sectionName));
                if (index != -1) {
                    return this.buildAndCacheHelpText(content, new OffsetRange(lastgi, gi), url);
                }
            }
            lastgi = gi;
        }
        return null;
    }

    private String buildAndCacheHelpText(String helpFileContent, OffsetRange strippedArea, URL url) {
        HELP_LINKS_CACHE.put(url, strippedArea);
        return this.buildHelpText(helpFileContent, strippedArea);
    }

    private String buildHelpText(String helpFileContent, OffsetRange strippedArea) {
        return HELP_PREFIX + helpFileContent.subSequence(strippedArea.from, strippedArea.to);
    }

    static {
        SINGLETON = new HtmlDocumentation();
        HELP_FILES_CACHE = new WeakHashMap<String, String>();
        HELP_LINKS_CACHE = new WeakHashMap<URL, OffsetRange>();
    }

    private static class OffsetRange {
        public int from;
        public int to;

        public OffsetRange(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }
}

