/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.optional;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.api.extexecution.base.BaseExecutionDescriptor;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.print.InputProcessors;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.modules.j2ee.deployment.plugins.api.CommonServerBridge;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerSupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.optional.ErrorLineConvertor;
import org.netbeans.modules.j2ee.weblogic9.optional.NonProxyHostsHelper;
import org.netbeans.modules.j2ee.weblogic9.optional.WLServerProgress;
import org.netbeans.modules.weblogic.common.api.RuntimeListener;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.netbeans.modules.weblogic.common.api.WebLogicRuntime;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class WLStartServer
extends StartServer {
    private static final String JAVA_VENDOR_VARIABLE = "JAVA_VENDOR";
    private static final String JAVA_OPTIONS_VARIABLE = "JAVA_OPTIONS";
    private static final String MEMORY_OPTIONS_VARIABLE = "USER_MEM_ARGS";
    private static final Logger LOGGER = Logger.getLogger(WLStartServer.class.getName());
    private static Set<String> SERVERS_IN_DEBUG;
    private final WLDeploymentManager dm;

    public WLStartServer(WLDeploymentManager dm) {
        this.dm = dm;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        return new ServerDebugInfo(this.dm.getHost(), Integer.valueOf(this.dm.getInstanceProperties().getProperty("debuggerPort")).intValue());
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public boolean isDebuggable(Target target) {
        if (!this.dm.isRemote() && !WLStartServer.isServerInDebug(this.dm.getUri())) {
            return false;
        }
        if (!this.isRunning()) {
            return false;
        }
        return !this.dm.isRemote() || Boolean.valueOf(this.dm.getInstanceProperties().getProperty("remoteDebug")) != false;
    }

    public boolean isRunning() {
        WebLogicRuntime runtime = WebLogicRuntime.getInstance((WebLogicConfiguration)this.dm.getCommonConfiguration());
        return runtime.isRunning();
    }

    public boolean needsStartForAdminConfig() {
        return true;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForTargetList() {
        return true;
    }

    public ProgressObject startDebugging(Target target) {
        LOGGER.log(Level.FINER, "Starting server in debug mode");
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        String uri = this.dm.getUri();
        WebLogicRuntime runtime = WebLogicRuntime.getInstance((WebLogicConfiguration)this.dm.getCommonConfiguration());
        runtime.start((BaseExecutionDescriptor.InputProcessorFactory)new DefaultInputProcessorFactory(uri, false), (BaseExecutionDescriptor.InputProcessorFactory)new DefaultInputProcessorFactory(uri, true), (RuntimeListener)new StartListener(this.dm, serverName, serverProgress), WLStartServer.getStartDebugVariables(this.dm), null);
        WLStartServer.addServerInDebug(uri);
        return serverProgress;
    }

    public ProgressObject startDeploymentManager() {
        LOGGER.log(Level.FINER, "Starting server");
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        String uri = this.dm.getUri();
        WebLogicRuntime runtime = WebLogicRuntime.getInstance((WebLogicConfiguration)this.dm.getCommonConfiguration());
        runtime.start((BaseExecutionDescriptor.InputProcessorFactory)new DefaultInputProcessorFactory(uri, false), (BaseExecutionDescriptor.InputProcessorFactory)new DefaultInputProcessorFactory(uri, true), (RuntimeListener)new StartListener(this.dm, serverName, serverProgress), WLStartServer.getStartVariables(this.dm), null);
        WLStartServer.removeServerInDebug(uri);
        return serverProgress;
    }

    public ProgressObject startProfiling(Target target) {
        LOGGER.log(Level.FINER, "Starting server in profiling mode");
        final WLServerProgress serverProgress = new WLServerProgress((Object)this);
        final String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        String uri = this.dm.getUri();
        final WebLogicRuntime runtime = WebLogicRuntime.getInstance((WebLogicConfiguration)this.dm.getCommonConfiguration());
        runtime.start((BaseExecutionDescriptor.InputProcessorFactory)new DefaultInputProcessorFactory(uri, false), (BaseExecutionDescriptor.InputProcessorFactory)new DefaultInputProcessorFactory(uri, true), (RuntimeListener)new StartListener(this.dm, serverName, serverProgress){

            @Override
            public void onExit() {
                int state = ProfilerSupport.getState();
                if (state == 0) {
                    serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_PROFILED_SERVER_FAILED", (Object)serverName));
                    runtime.kill();
                }
            }
        }, WLStartServer.getStartProfileVariables(this.dm), new WebLogicRuntime.RunningCondition(){

            public boolean isRunning() {
                int state = ProfilerSupport.getState();
                return state == 2 || state == 3 || state == 4;
            }
        });
        WLStartServer.removeServerInDebug(uri);
        return serverProgress;
    }

    public ProgressObject stopDeploymentManager() {
        LOGGER.log(Level.FINER, "Stopping server");
        WLServerProgress serverProgress = new WLServerProgress((Object)this);
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        String uri = this.dm.getUri();
        WebLogicRuntime runtime = WebLogicRuntime.getInstance((WebLogicConfiguration)this.dm.getCommonConfiguration());
        runtime.stop((BaseExecutionDescriptor.InputProcessorFactory)new DefaultInputProcessorFactory(uri, false), (BaseExecutionDescriptor.InputProcessorFactory)new DefaultInputProcessorFactory(uri, true), (RuntimeListener)new StopListener(this.dm, serverName, serverProgress));
        WLStartServer.removeServerInDebug(uri);
        return serverProgress;
    }

    public boolean supportsStartDeploymentManager() {
        return !this.dm.isRemote();
    }

    public boolean supportsStartProfiling(Target target) {
        return !this.dm.isRemote();
    }

    public boolean supportsStartDebugging(Target target) {
        return this.supportsStartDeploymentManager();
    }

    public boolean needsRestart(Target target) {
        return this.dm.isRestartNeeded();
    }

    private static synchronized void addServerInDebug(String uri) {
        if (SERVERS_IN_DEBUG == null) {
            SERVERS_IN_DEBUG = new HashSet<String>(1);
        }
        SERVERS_IN_DEBUG.add(uri);
    }

    private static synchronized void removeServerInDebug(String uri) {
        if (SERVERS_IN_DEBUG == null) {
            return;
        }
        SERVERS_IN_DEBUG.remove(uri);
    }

    private static synchronized boolean isServerInDebug(String uri) {
        return SERVERS_IN_DEBUG != null && SERVERS_IN_DEBUG.contains(uri);
    }

    private static Map<String, String> getStartVariables(WLDeploymentManager dm) {
        String memoryOptions;
        String vendor;
        HashMap<String, String> ret = new HashMap<String, String>();
        String javaOpts = dm.getInstanceProperties().getProperty("java_opts");
        StringBuilder sb = new StringBuilder(javaOpts != null && javaOpts.trim().length() > 0 ? javaOpts.trim() : "");
        for (StartupExtender args : StartupExtender.getExtenders((Lookup)Lookups.singleton((Object)CommonServerBridge.getCommonInstance((String)dm.getUri())), (StartupExtender.StartMode)StartupExtender.StartMode.NORMAL)) {
            for (String singleArg : args.getArguments()) {
                sb.append(' ').append(singleArg);
            }
        }
        WLStartServer.configureProxy(dm.getInstanceProperties(), ret, sb);
        if (sb.length() > 0) {
            ret.put(JAVA_OPTIONS_VARIABLE, sb.toString());
        }
        if ((vendor = dm.getInstanceProperties().getProperty("vendor")) != null && vendor.trim().length() > 0) {
            ret.put(JAVA_VENDOR_VARIABLE, vendor.trim());
        }
        if ((memoryOptions = dm.getInstanceProperties().getProperty("mem_opts")) != null && memoryOptions.trim().length() > 0) {
            ret.put(MEMORY_OPTIONS_VARIABLE, memoryOptions.trim());
        }
        return ret;
    }

    private static Map<String, String> getStartDebugVariables(WLDeploymentManager dm) {
        HashMap<String, String> ret = new HashMap<String, String>();
        int debugPort = 4000;
        debugPort = Integer.parseInt(dm.getInstanceProperties().getProperty("debuggerPort"));
        StringBuilder javaOptsBuilder = new StringBuilder();
        String javaOpts = dm.getInstanceProperties().getProperty("java_opts");
        if (javaOpts != null && javaOpts.trim().length() > 0) {
            javaOptsBuilder.append(javaOpts.trim());
        }
        if (javaOptsBuilder.length() > 0) {
            javaOptsBuilder.append(" ");
        }
        javaOptsBuilder.append("-Xdebug -Xnoagent -Djava.compiler=none ");
        javaOptsBuilder.append("-Xrunjdwp:server=y,suspend=n,transport=dt_socket,address=");
        javaOptsBuilder.append(debugPort);
        for (StartupExtender args : StartupExtender.getExtenders((Lookup)Lookups.singleton((Object)CommonServerBridge.getCommonInstance((String)dm.getUri())), (StartupExtender.StartMode)StartupExtender.StartMode.DEBUG)) {
            for (String singleArg : args.getArguments()) {
                javaOptsBuilder.append(' ').append(singleArg);
            }
        }
        WLStartServer.configureProxy(dm.getInstanceProperties(), ret, javaOptsBuilder);
        ret.put(JAVA_OPTIONS_VARIABLE, javaOptsBuilder.toString());
        return ret;
    }

    private static Map<String, String> getStartProfileVariables(WLDeploymentManager dm) {
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuilder javaOptsBuilder = new StringBuilder();
        String javaOpts = dm.getInstanceProperties().getProperty("java_opts");
        if (javaOpts != null && javaOpts.trim().length() > 0) {
            javaOptsBuilder.append(" ");
            javaOptsBuilder.append(javaOpts.trim());
        }
        for (StartupExtender args : StartupExtender.getExtenders((Lookup)Lookups.singleton((Object)CommonServerBridge.getCommonInstance((String)dm.getUri())), (StartupExtender.StartMode)StartupExtender.StartMode.PROFILE)) {
            for (String singleArg : args.getArguments()) {
                javaOptsBuilder.append(' ').append(singleArg);
            }
        }
        WLStartServer.configureProxy(dm.getInstanceProperties(), ret, javaOptsBuilder);
        String toAdd = javaOptsBuilder.toString().trim();
        if (!toAdd.isEmpty()) {
            ret.put(JAVA_OPTIONS_VARIABLE, toAdd);
        }
        return ret;
    }

    private static void configureProxy(InstanceProperties props, Map<String, String> env, StringBuilder javaOpts) {
        if (Boolean.valueOf(props.getProperty("proxy_enabled")).booleanValue()) {
            WLStartServer.configureProxy(javaOpts);
        } else {
            env.put("http_proxy", "");
        }
    }

    private static StringBuilder configureProxy(StringBuilder sb) {
        String[] PROXY_PROPS;
        for (String prop : PROXY_PROPS = new String[]{"http.proxyHost", "http.proxyPort", "https.proxyHost", "https.proxyPort"}) {
            String value;
            if (sb.indexOf(prop) >= 0 || (value = System.getProperty(prop)) == null) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(" -D").append(prop).append("=").append(value);
        }
        WLStartServer.appendNonProxyHosts(sb);
        return sb;
    }

    private static StringBuilder appendNonProxyHosts(StringBuilder sb) {
        String nonProxyHosts;
        if (sb.indexOf("http.nonProxyHosts") < 0 && !(nonProxyHosts = NonProxyHostsHelper.getNonProxyHosts()).isEmpty()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append("-D");
            sb.append("http.nonProxyHosts");
            sb.append("=");
            sb.append('\"').append(nonProxyHosts).append('\"');
        }
        return sb;
    }

    private static class StopListener
    implements RuntimeListener {
        private final WLDeploymentManager dm;
        private final String serverName;
        private final WLServerProgress serverProgress;

        public StopListener(WLDeploymentManager dm, String serverName, WLServerProgress serverProgress) {
            this.dm = dm;
            this.serverName = serverName;
            this.serverProgress = serverProgress;
        }

        public void onStart() {
            this.serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)this.serverName));
        }

        public void onFinish() {
            this.serverProgress.notifyStop(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STOPPED", (Object)this.serverName));
        }

        public void onFail() {
            this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_FAILED", (Object)this.serverName));
        }

        public void onProcessStart() {
            InputOutput io = UISupport.getServerIO((String)this.dm.getUri());
            if (io == null) {
                return;
            }
            this.dm.getLogManager().stop();
            try {
                io.getOut().reset();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            io.select();
        }

        public void onProcessFinish() {
            InputOutput io = UISupport.getServerIO((String)this.dm.getUri());
            if (io != null) {
                io.getOut().close();
                io.getErr().close();
            }
        }

        public void onRunning() {
            this.serverProgress.notifyStop(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)this.serverName));
        }

        public void onTimeout() {
            this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_TIMEOUT"));
        }

        public void onInterrupted() {
            this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_INTERRUPTED"));
        }

        public void onException(Exception ex) {
            LOGGER.log(Level.WARNING, null, ex);
            this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_STOP_SERVER_FAILED", (Object)this.serverName));
        }

        public void onExit() {
        }
    }

    private static class StartListener
    implements RuntimeListener {
        private final WLDeploymentManager dm;
        private final String serverName;
        private final WLServerProgress serverProgress;

        public StartListener(WLDeploymentManager dm, String serverName, WLServerProgress serverProgress) {
            this.dm = dm;
            this.serverName = serverName;
            this.serverProgress = serverProgress;
        }

        public void onStart() {
            this.serverProgress.notifyStart(StateType.RUNNING, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)this.serverName));
        }

        public void onFinish() {
        }

        public void onFail() {
            this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_FAILED", (Object)this.serverName));
        }

        public void onProcessStart() {
            InputOutput io = UISupport.getServerIO((String)this.dm.getUri());
            if (io == null) {
                return;
            }
            this.dm.getLogManager().stop();
            try {
                io.getOut().reset();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            io.select();
        }

        public void onProcessFinish() {
            InputOutput io = UISupport.getServerIO((String)this.dm.getUri());
            if (io != null) {
                io.getOut().close();
                io.getErr().close();
            }
        }

        public void onRunning() {
            this.dm.setRestartNeeded(false);
            this.serverProgress.notifyStart(StateType.COMPLETED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_SERVER_STARTED", (Object)this.serverName));
        }

        public void onTimeout() {
            this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_TIMEOUT"));
        }

        public void onInterrupted() {
            this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_INTERRUPTED"));
        }

        public void onException(Exception ex) {
            LOGGER.log(Level.WARNING, null, ex);
            this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WLStartServer.class, (String)"MSG_START_SERVER_FAILED", (Object)this.serverName));
        }

        public void onExit() {
        }
    }

    private static class DefaultInputProcessorFactory
    implements BaseExecutionDescriptor.InputProcessorFactory {
        private final String uri;
        private final boolean error;

        public DefaultInputProcessorFactory(String uri, boolean error) {
            this.uri = uri;
            this.error = error;
        }

        public InputProcessor newInputProcessor() {
            InputOutput io = UISupport.getServerIO((String)this.uri);
            if (io == null) {
                return null;
            }
            return InputProcessors.printing((OutputWriter)(this.error ? io.getErr() : io.getOut()), (LineConvertor)new ErrorLineConvertor(), (boolean)true);
        }
    }
}

