/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.nodes;

import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.modules.j2ee.weblogic9.ui.nodes.PropertyDocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class CustomizerJVM
extends JPanel {
    private static final long serialVersionUID = 3411155308004602121L;
    private final WLDeploymentManager manager;
    private JCheckBox debugModeCheckBox;
    private JTextField javaHome;
    private JLabel javaHomeLabel;
    private JTextField memoryOptions;
    private JLabel memoryOptionsCommentLabel;
    private JLabel memoryOptionsLabel;
    private JLabel noteChangesLabel;
    private JLabel portLabel;
    private JSpinner portSpinner;
    private JCheckBox proxyCheckBox;
    private JLabel vendorLabel;
    private JComboBox vendorName;
    private JTextField vmOptions;
    private JLabel vmOptionsLabel;
    private JLabel vmOptionsSampleLabel;

    CustomizerJVM(WLDeploymentManager manager) {
        this.manager = manager;
        this.initComponents();
        this.initValues();
    }

    private void initValues() {
        String memOpts;
        WLPluginProperties.JvmVendor vendor = WLPluginProperties.JvmVendor.fromPropertiesString(this.manager.getInstanceProperties().getProperty("vendor"));
        ArrayList<WLPluginProperties.JvmVendor> vendors = new ArrayList<WLPluginProperties.JvmVendor>(5);
        Properties runtimeProps = WLPluginProperties.getRuntimeProperties(this.manager.getInstanceProperties().getProperty("domainRoot"));
        final String beaHome = runtimeProps.getProperty("bea_java_home");
        final String sunHome = runtimeProps.getProperty("sun_java_home");
        final Properties javaHomeProps = (Properties)runtimeProps.get("java_home");
        if (beaHome != null && beaHome.trim().length() > 0) {
            vendors.add(WLPluginProperties.JvmVendor.ORACLE);
        }
        if (sunHome != null && sunHome.trim().length() > 0) {
            vendors.add(WLPluginProperties.JvmVendor.SUN);
        }
        vendors.add(WLPluginProperties.JvmVendor.DEFAULT);
        Enumeration<Object> keys = javaHomeProps.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.length() <= 0 || key.equals(WLPluginProperties.JvmVendor.SUN.toPropertiesString()) || key.equals(WLPluginProperties.JvmVendor.ORACLE.toPropertiesString())) continue;
            vendors.add(WLPluginProperties.JvmVendor.fromPropertiesString(key));
        }
        this.vendorName.setModel(new DefaultComboBoxModel<Object>(vendors.toArray()));
        this.vendorName.setSelectedItem(vendor);
        if (vendor == WLPluginProperties.JvmVendor.DEFAULT) {
            this.javaHome.setText(javaHomeProps.getProperty(""));
        } else if (vendor == WLPluginProperties.JvmVendor.ORACLE) {
            this.javaHome.setText(beaHome);
        } else if (vendor == WLPluginProperties.JvmVendor.SUN) {
            this.javaHome.setText(sunHome);
        } else {
            this.javaHome.setText(javaHomeProps.getProperty(vendor.toPropertiesString()));
        }
        this.vendorName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                WLPluginProperties.JvmVendor item = (WLPluginProperties.JvmVendor)event.getItem();
                if (item == WLPluginProperties.JvmVendor.DEFAULT) {
                    CustomizerJVM.this.javaHome.setText(javaHomeProps.getProperty(""));
                } else if (item == WLPluginProperties.JvmVendor.ORACLE) {
                    CustomizerJVM.this.javaHome.setText(beaHome);
                } else if (item == WLPluginProperties.JvmVendor.SUN) {
                    CustomizerJVM.this.javaHome.setText(sunHome);
                } else {
                    CustomizerJVM.this.javaHome.setText(javaHomeProps.getProperty(item.toPropertiesString()));
                }
                CustomizerJVM.this.manager.getInstanceProperties().setProperty("vendor", item.toPropertiesString());
            }
        });
        String javaOpts = this.manager.getInstanceProperties().getProperty("java_opts");
        if (javaOpts != null) {
            this.vmOptions.setText(javaOpts.trim());
        }
        if ((memOpts = this.manager.getInstanceProperties().getProperty("mem_opts")) != null) {
            this.memoryOptions.setText(memOpts.trim());
        }
        this.vmOptions.getDocument().addDocumentListener(new PropertyDocumentListener(this.manager, "java_opts", this.vmOptions));
        this.memoryOptions.getDocument().addDocumentListener(new PropertyDocumentListener(this.manager, "mem_opts", this.memoryOptions));
        this.proxyCheckBox.setEnabled(!this.manager.isRemote());
        this.proxyCheckBox.setSelected(!this.manager.isRemote() && Boolean.valueOf(this.manager.getInstanceProperties().getProperty("proxy_enabled")) != false);
        this.proxyCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CustomizerJVM.this.manager.getInstanceProperties().setProperty("proxy_enabled", Boolean.TRUE.toString());
                } else if (e.getStateChange() == 2) {
                    CustomizerJVM.this.manager.getInstanceProperties().setProperty("proxy_enabled", Boolean.FALSE.toString());
                }
            }
        });
        this.debugModeCheckBox.setEnabled(this.manager.isRemote());
        this.debugModeCheckBox.setSelected(!this.manager.isRemote() || Boolean.valueOf(this.manager.getInstanceProperties().getProperty("remoteDebug")) != false);
        this.debugModeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CustomizerJVM.this.portSpinner.setEnabled(true);
                    CustomizerJVM.this.manager.getInstanceProperties().setProperty("remoteDebug", Boolean.TRUE.toString());
                } else if (e.getStateChange() == 2) {
                    CustomizerJVM.this.portSpinner.setEnabled(false);
                    CustomizerJVM.this.manager.getInstanceProperties().setProperty("remoteDebug", Boolean.FALSE.toString());
                }
            }
        });
        this.portSpinner.setEnabled(!this.manager.isRemote() || this.debugModeCheckBox.isSelected());
        final SpinnerNumberModel debugPortModel = new SpinnerNumberModel(Integer.parseInt(this.manager.getInstanceProperties().getProperty("debuggerPort")), 0, 65535, 1);
        debugPortModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CustomizerJVM.this.manager.getInstanceProperties().setProperty("debuggerPort", ((Integer)debugPortModel.getValue()).toString());
            }
        });
        this.portSpinner.setModel(debugPortModel);
        this.portSpinner.setEditor(new JSpinner.NumberEditor(this.portSpinner, "#"));
        JFormattedTextField portSpinnerTextField = ((JSpinner.NumberEditor)this.portSpinner.getEditor()).getTextField();
        Font font = portSpinnerTextField.getFont();
        this.portSpinner.setFont(font);
        this.vendorName.setEnabled(!this.manager.isRemote());
        this.vmOptions.setEnabled(!this.manager.isRemote());
        this.memoryOptions.setEnabled(!this.manager.isRemote());
        this.noteChangesLabel.setVisible(!this.manager.isRemote());
        if (this.manager.isRemote()) {
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    CustomizerJVM.this.manager.getInstanceProperties().refreshServerInstance();
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
        }
    }

    private void initComponents() {
        this.javaHomeLabel = new JLabel();
        this.javaHome = new JTextField();
        this.vmOptionsLabel = new JLabel();
        this.noteChangesLabel = new JLabel();
        this.vmOptions = new JTextField();
        this.vmOptionsSampleLabel = new JLabel();
        this.vendorLabel = new JLabel();
        this.vendorName = new JComboBox();
        this.memoryOptions = new JTextField();
        this.memoryOptionsLabel = new JLabel();
        this.memoryOptionsCommentLabel = new JLabel();
        this.portLabel = new JLabel();
        this.portSpinner = new JSpinner();
        this.debugModeCheckBox = new JCheckBox();
        this.proxyCheckBox = new JCheckBox();
        this.javaHomeLabel.setLabelFor(this.javaHome);
        Mnemonics.setLocalizedText((JLabel)this.javaHomeLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_JavaHome"));
        this.javaHome.setEditable(false);
        this.vmOptionsLabel.setLabelFor(this.vmOptions);
        Mnemonics.setLocalizedText((JLabel)this.vmOptionsLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_VmOptions"));
        Mnemonics.setLocalizedText((JLabel)this.noteChangesLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"CustomizerJVM.noteChangesLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.vmOptionsSampleLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_VmOptionsSample"));
        this.vendorLabel.setLabelFor(this.vendorName);
        Mnemonics.setLocalizedText((JLabel)this.vendorLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_JvmVendor"));
        this.memoryOptionsLabel.setLabelFor(this.memoryOptions);
        Mnemonics.setLocalizedText((JLabel)this.memoryOptionsLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_VmMemoryOptions"));
        Mnemonics.setLocalizedText((JLabel)this.memoryOptionsCommentLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"LBL_VmMemoryOptionsComment"));
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"CustomizerJVM.portLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.debugModeCheckBox, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"CustomizerJVM.debugModeCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.proxyCheckBox, (String)NbBundle.getMessage(CustomizerJVM.class, (String)"CustomizerJVM.proxyCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.noteChangesLabel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.vendorLabel).addComponent(this.javaHomeLabel).addComponent(this.vmOptionsLabel).addComponent(this.memoryOptionsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaHome).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.memoryOptionsCommentLabel).addComponent(this.vmOptionsSampleLabel).addComponent(this.vendorName, -2, 161, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.vmOptions).addComponent(this.memoryOptions)).addGap(12, 12, 12)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.portLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portSpinner, -2, -1, -2)).addComponent(this.debugModeCheckBox).addComponent(this.proxyCheckBox)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vendorLabel).addComponent(this.vendorName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.javaHomeLabel).addComponent(this.javaHome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.vmOptionsLabel).addComponent(this.vmOptions, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.vmOptionsSampleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.memoryOptionsLabel).addComponent(this.memoryOptions, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.memoryOptionsCommentLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.proxyCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debugModeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portLabel).addComponent(this.portSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.noteChangesLabel).addContainerGap()));
        this.javaHomeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_JavaHome"));
        this.javaHome.getAccessibleContext().setAccessibleName(this.javaHomeLabel.getAccessibleContext().getAccessibleName());
        this.javaHome.getAccessibleContext().setAccessibleDescription(this.javaHomeLabel.getAccessibleContext().getAccessibleDescription());
        this.vmOptionsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_VmOptions"));
        this.vmOptionsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_VmOptions"));
        this.noteChangesLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_Note"));
        this.noteChangesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSD_Note"));
        this.vmOptions.getAccessibleContext().setAccessibleName(this.vmOptionsLabel.getAccessibleContext().getAccessibleName());
        this.vmOptions.getAccessibleContext().setAccessibleDescription(this.vmOptionsLabel.getAccessibleContext().getAccessibleDescription());
        this.vmOptionsSampleLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_VmOptionsSample"));
        this.vmOptionsSampleLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSD_VmOptionsSample"));
        this.vendorLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_Vendor"));
        this.vendorLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSD_Vendor"));
        this.vendorName.getAccessibleContext().setAccessibleName(this.vendorLabel.getAccessibleContext().getAccessibleName());
        this.vendorName.getAccessibleContext().setAccessibleDescription(this.vendorLabel.getAccessibleContext().getAccessibleDescription());
        this.memoryOptions.getAccessibleContext().setAccessibleName(this.memoryOptionsLabel.getAccessibleContext().getAccessibleName());
        this.memoryOptions.getAccessibleContext().setAccessibleDescription(this.memoryOptionsLabel.getAccessibleContext().getAccessibleDescription());
        this.memoryOptionsLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSN_VmMemoryOptions"));
        this.memoryOptionsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJVM.class, (String)"ACSD_VmMemoryOptions"));
    }
}

