/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.db.api.metadata.DBConnMetadataModelManager;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.Tuple;
import org.netbeans.modules.db.metadata.model.api.View;
import org.netbeans.modules.db.sql.analyzer.CreateStatement;
import org.netbeans.modules.db.sql.analyzer.DeleteStatement;
import org.netbeans.modules.db.sql.analyzer.InsertStatement;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.analyzer.SQLStatement;
import org.netbeans.modules.db.sql.analyzer.SQLStatementAnalyzer;
import org.netbeans.modules.db.sql.analyzer.SQLStatementKind;
import org.netbeans.modules.db.sql.analyzer.SelectStatement;
import org.netbeans.modules.db.sql.analyzer.TablesClause;
import org.netbeans.modules.db.sql.analyzer.UpdateStatement;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionEnv;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionItems;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SQLCompletionQuery
extends AsyncCompletionQuery {
    private static final Logger LOGGER = Logger.getLogger(SQLCompletionQuery.class.getName());
    private final DatabaseConnection dbconn;
    private Metadata metadata;
    private SQLCompletionEnv env;
    private SQLIdentifiers.Quoter quoter;
    private SQLStatement statement;
    private TablesClause tablesClause;
    private boolean includeViews = false;
    private int anchorOffset = -1;
    private int substitutionOffset = 0;
    private SQLCompletionItems items;
    private SQLStatement.Context context;
    private Identifier ident;

    public SQLCompletionQuery(DatabaseConnection dbconn) {
        this.dbconn = dbconn;
    }

    protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
        this.doQuery(SQLCompletionEnv.forDocument(doc, caretOffset));
        if (this.items != null) {
            this.items.fill(resultSet);
        }
        if (this.anchorOffset != -1) {
            resultSet.setAnchorOffset(this.env.getStatementOffset() + this.anchorOffset);
        }
        resultSet.finish();
    }

    public void query(SQLCompletionResultSet resultSet, SQLCompletionEnv newEnv) {
        this.doQuery(newEnv);
        if (this.items != null) {
            this.items.fill(resultSet);
        }
        if (this.anchorOffset != -1) {
            resultSet.setAnchorOffset(newEnv.getStatementOffset() + this.anchorOffset);
        }
    }

    private void doQuery(final SQLCompletionEnv newEnv) {
        try {
            DBConnMetadataModelManager.get((DatabaseConnection)this.dbconn).runReadAction((Action)new Action<Metadata>(){

                public void run(Metadata metadata) {
                    Connection conn = SQLCompletionQuery.this.dbconn.getJDBCConnection();
                    if (conn == null) {
                        return;
                    }
                    SQLIdentifiers.Quoter quoter = null;
                    try {
                        DatabaseMetaData dmd = conn.getMetaData();
                        quoter = SQLIdentifiers.createQuoter((DatabaseMetaData)dmd);
                    }
                    catch (SQLException e) {
                        throw new MetadataException((Throwable)e);
                    }
                    SQLCompletionQuery.this.doQuery(newEnv, metadata, quoter);
                }
            });
        }
        catch (MetadataModelException e) {
            SQLCompletionQuery.reportError(e);
        }
    }

    SQLCompletionItems doQuery(SQLCompletionEnv env, Metadata metadata, SQLIdentifiers.Quoter quoter) {
        this.env = env;
        this.metadata = metadata;
        this.quoter = quoter;
        this.anchorOffset = -1;
        this.substitutionOffset = 0;
        this.items = new SQLCompletionItems(quoter, env.getSubstitutionHandler());
        if (env.getTokenSequence().isEmpty()) {
            this.completeKeyword("SELECT", "INSERT", "DELETE", "DROP", "UPDATE", "CREATE");
            return this.items;
        }
        this.statement = SQLStatementAnalyzer.analyze(env.getTokenSequence(), quoter);
        if (this.statement == null) {
            this.completeKeyword("SELECT", "INSERT", "DELETE", "DROP", "UPDATE", "CREATE");
            return this.items;
        }
        if (this.statement.getKind() == SQLStatementKind.CREATE && ((CreateStatement)this.statement).hasBody()) {
            this.completeCreateBody();
            return this.items;
        }
        this.context = this.statement.getContextAtOffset(env.getCaretOffset());
        if (this.context == null) {
            this.completeKeyword("SELECT", "INSERT", "DELETE", "DROP", "UPDATE", "CREATE");
            return this.items;
        }
        this.ident = this.findIdentifier();
        if (this.ident == null) {
            this.completeKeyword(this.context);
            return this.items;
        }
        this.anchorOffset = this.ident.anchorOffset;
        this.substitutionOffset = this.ident.substitutionOffset;
        SQLStatementKind kind = this.statement.getKind();
        switch (kind) {
            case SELECT: {
                this.completeSelect();
                break;
            }
            case INSERT: {
                this.completeInsert();
                break;
            }
            case DROP: {
                this.completeDrop();
                break;
            }
            case UPDATE: {
                this.completeUpdate();
                break;
            }
            case DELETE: {
                this.completeDelete();
                break;
            }
            case CREATE: {
                this.completeCreate();
            }
        }
        return this.items;
    }

    private void completeCreate() {
        CreateStatement createStatement = (CreateStatement)this.statement;
        this.tablesClause = createStatement.getTablesInEffect(this.env.getCaretOffset());
        switch (this.context) {
            case CREATE: 
            case CREATE_DATABASE: 
            case CREATE_FUNCTION: 
            case CREATE_PROCEDURE: 
            case CREATE_SCHEMA: 
            case CREATE_TABLE: 
            case CREATE_TEMPORARY_TABLE: 
            case CREATE_VIEW: 
            case CREATE_VIEW_AS: {
                this.completeKeyword(this.context);
                break;
            }
            default: {
                this.completeSelect();
            }
        }
    }

    private void completeSelect() {
        SelectStatement selectStatement = (SelectStatement)this.statement;
        this.tablesClause = selectStatement.getTablesInEffect(this.env.getCaretOffset());
        this.includeViews = true;
        switch (this.context) {
            case SELECT: {
                this.completeColumn(this.ident);
                break;
            }
            case FROM: {
                this.completeTuple(this.ident);
                break;
            }
            case JOIN_CONDITION: {
                this.completeColumnWithDefinedTuple(this.ident);
                break;
            }
            case WHERE: {
                if (this.tablesClause != null) {
                    this.completeColumnWithDefinedTuple(this.ident);
                    break;
                }
                this.completeColumn(this.ident);
                break;
            }
            case ORDER: 
            case GROUP: {
                this.completeKeyword(this.context);
                break;
            }
            default: {
                if (this.tablesClause == null) break;
                this.completeColumnWithDefinedTuple(this.ident);
            }
        }
    }

    private void completeInsert() {
        InsertStatement insertStatement = (InsertStatement)this.statement;
        this.tablesClause = insertStatement.getTablesInEffect(this.env.getCaretOffset());
        this.includeViews = false;
        switch (this.context) {
            case INSERT: {
                this.completeKeyword(this.context);
                break;
            }
            case INSERT_INTO: {
                this.completeTuple(this.ident);
                break;
            }
            case COLUMNS: {
                this.insideColumns(this.ident, this.resolveTuple(insertStatement.getTable()));
                break;
            }
            case VALUES: {
                break;
            }
            default: {
                if (!insertStatement.getSubqueries().isEmpty()) {
                    this.completeSelect();
                    break;
                }
                if (this.tablesClause == null) break;
                this.completeColumnWithDefinedTuple(this.ident);
            }
        }
    }

    private void completeDrop() {
        this.includeViews = false;
        switch (this.context) {
            case DROP: {
                this.completeKeyword(this.context);
                break;
            }
            case DROP_TABLE: {
                this.completeTuple(this.ident);
                break;
            }
        }
    }

    private void completeUpdate() {
        UpdateStatement updateStatement = (UpdateStatement)this.statement;
        this.tablesClause = updateStatement.getTablesInEffect(this.env.getCaretOffset());
        this.includeViews = false;
        switch (this.context) {
            case UPDATE: {
                this.completeTuple(this.ident);
                break;
            }
            case JOIN_CONDITION: {
                this.completeColumnWithDefinedTuple(this.ident);
                break;
            }
            case SET: {
                this.completeColumn(this.ident);
                break;
            }
            default: {
                if (!updateStatement.getSubqueries().isEmpty()) {
                    this.completeSelect();
                    break;
                }
                if (this.tablesClause == null) break;
                this.completeColumnWithDefinedTuple(this.ident);
            }
        }
    }

    private void completeDelete() {
        DeleteStatement deleteStatement = (DeleteStatement)this.statement;
        this.tablesClause = deleteStatement.getTablesInEffect(this.env.getCaretOffset());
        this.includeViews = false;
        switch (this.context) {
            case DELETE: {
                this.completeKeyword(this.context);
                this.completeTuple(this.ident);
                break;
            }
            case FROM: {
                this.completeTuple(this.ident);
                break;
            }
            case JOIN_CONDITION: {
                this.completeColumnWithDefinedTuple(this.ident);
                break;
            }
            case WHERE: {
                if (this.tablesClause != null) {
                    this.completeColumnWithDefinedTuple(this.ident);
                    break;
                }
                this.completeColumn(this.ident);
                break;
            }
            default: {
                if (this.tablesClause == null) break;
                this.completeColumnWithDefinedTuple(this.ident);
            }
        }
    }

    private void completeCreateBody() {
        CreateStatement createStatement = (CreateStatement)this.statement;
        String body = this.env.getStatement().substring(createStatement.getBodyStartOffset(), createStatement.getBodyEndOffset());
        int caretOffset = this.env.getCaretOffset() - createStatement.getBodyStartOffset();
        int scriptOffset = this.env.getStatementOffset() + createStatement.getBodyStartOffset();
        this.doQuery(SQLCompletionEnv.forScript(body, caretOffset, scriptOffset), this.metadata, this.quoter);
        this.anchorOffset += scriptOffset;
    }

    private void completeKeyword(SQLStatement.Context context) {
        switch (context) {
            case SELECT: {
                this.completeKeyword("FROM");
                break;
            }
            case DELETE: {
                this.completeKeyword("FROM");
                break;
            }
            case INSERT: {
                this.completeKeyword("INTO");
                break;
            }
            case INSERT_INTO: 
            case COLUMNS: {
                this.completeKeyword("VALUES");
                break;
            }
            case FROM: {
                this.completeKeyword("WHERE", "GROUP", "ORDER");
                break;
            }
            case UPDATE: {
                this.completeKeyword("SET");
                break;
            }
            case JOIN_CONDITION: {
                this.completeKeyword("WHERE");
                break;
            }
            case SET: {
                this.completeKeyword("WHERE");
                break;
            }
            case WHERE: {
                this.completeKeyword("GROUP", "ORDER");
                break;
            }
            case ORDER: 
            case GROUP: {
                this.completeKeyword("BY");
                break;
            }
            case GROUP_BY: {
                this.completeKeyword("HAVING");
                break;
            }
            case DROP: {
                this.completeKeyword("TABLE");
                break;
            }
            case VALUES: 
            case DROP_TABLE: 
            case HAVING: 
            case ORDER_BY: {
                break;
            }
            case CREATE: {
                this.completeKeyword("PROCEDURE", "FUNCTION", "TABLE", "DATABASE", "SCHEMA", "TEMPORARY", "VIEW");
                break;
            }
            case CREATE_TEMPORARY_TABLE: {
                this.completeKeyword("TABLE");
                break;
            }
            case CREATE_VIEW: {
                this.completeKeyword("AS");
                break;
            }
            case CREATE_VIEW_AS: {
                this.completeKeyword("SELECT");
            }
        }
    }

    private void completeKeyword(String ... keywords) {
        Arrays.sort(keywords);
        Symbol prefix = this.findPrefix();
        this.anchorOffset = this.substitutionOffset = prefix.substitutionOffset;
        this.items.addKeywords(prefix.lastPrefix, this.substitutionOffset, keywords);
    }

    private void completeColumn(Identifier ident) {
        if (ident.fullyTypedIdent.isEmpty()) {
            this.completeColumnSimpleIdent(ident.lastPrefix, ident.quoted);
        } else {
            this.completeColumnQualIdent(ident.fullyTypedIdent, ident.lastPrefix, ident.quoted);
        }
    }

    private void insideColumns(Identifier ident, Tuple tuple) {
        if (ident.fullyTypedIdent.isEmpty()) {
            if (tuple == null) {
                this.completeColumnWithTupleIfSimpleIdent(ident.lastPrefix, ident.quoted);
            } else {
                this.items.addColumns(tuple, ident.lastPrefix, ident.quoted, this.substitutionOffset);
            }
        } else if (tuple == null) {
            this.completeColumnWithTupleIfQualIdent(ident.fullyTypedIdent, ident.lastPrefix, ident.quoted);
        } else {
            this.items.addColumns(tuple, ident.lastPrefix, ident.quoted, this.substitutionOffset);
        }
    }

    private void completeTuple(Identifier ident) {
        if (ident.fullyTypedIdent.isEmpty()) {
            this.completeTupleSimpleIdent(ident.lastPrefix, ident.quoted);
        } else {
            this.completeTupleQualIdent(ident.fullyTypedIdent, ident.lastPrefix, ident.quoted);
        }
    }

    private void completeColumnWithDefinedTuple(Identifier ident) {
        if (ident.fullyTypedIdent.isEmpty()) {
            this.completeSimpleIdentBasedOnFromClause(ident.lastPrefix, ident.quoted);
        } else {
            this.completeQualIdentBasedOnFromClause(ident.fullyTypedIdent, ident.lastPrefix, ident.quoted);
        }
    }

    private void completeColumnSimpleIdent(String typedPrefix, boolean quoted) {
        if (!(this.tablesClause == null || this.tablesClause.getUnaliasedTableNames().isEmpty() && this.tablesClause.getAliasedTableNames().isEmpty())) {
            this.completeSimpleIdentBasedOnFromClause(typedPrefix, quoted);
        } else {
            Schema defaultSchema = this.metadata.getDefaultSchema();
            if (defaultSchema != null) {
                if (typedPrefix != null) {
                    for (Table table : defaultSchema.getTables()) {
                        this.items.addColumns((Tuple)table, typedPrefix, quoted, this.substitutionOffset);
                    }
                    if (this.includeViews) {
                        for (View view : defaultSchema.getViews()) {
                            this.items.addColumns((Tuple)view, typedPrefix, quoted, this.substitutionOffset);
                        }
                    }
                }
                this.items.addTables(defaultSchema, null, typedPrefix, quoted, this.substitutionOffset);
                if (this.includeViews) {
                    this.items.addViews(defaultSchema, null, typedPrefix, quoted, this.substitutionOffset);
                }
            }
            Catalog defaultCatalog = this.metadata.getDefaultCatalog();
            this.items.addSchemas(defaultCatalog, null, typedPrefix, quoted, this.substitutionOffset);
            this.items.addCatalogs(this.metadata, null, typedPrefix, quoted, this.substitutionOffset);
        }
    }

    private void completeColumnWithTupleIfSimpleIdent(String typedPrefix, boolean quoted) {
        Schema defaultSchema = this.metadata.getDefaultSchema();
        if (defaultSchema != null) {
            if (typedPrefix != null) {
                for (Table table : defaultSchema.getTables()) {
                    this.items.addColumnsWithTupleName((Tuple)table, null, typedPrefix, quoted, this.substitutionOffset - 1);
                }
                if (this.includeViews) {
                    for (View view : defaultSchema.getViews()) {
                        this.items.addColumnsWithTupleName((Tuple)view, null, typedPrefix, quoted, this.substitutionOffset - 1);
                    }
                }
            } else {
                this.items.addTablesAtInsertInto(defaultSchema, null, null, typedPrefix, quoted, this.substitutionOffset - 1);
                if (this.includeViews) {
                    this.items.addViewsAtInsertInto(defaultSchema, null, null, typedPrefix, quoted, this.substitutionOffset - 1);
                }
            }
        }
        Catalog defaultCatalog = this.metadata.getDefaultCatalog();
        this.items.addSchemas(defaultCatalog, null, typedPrefix, quoted, this.substitutionOffset);
        this.items.addCatalogs(this.metadata, null, typedPrefix, quoted, this.substitutionOffset);
    }

    private void completeColumnWithTupleIfQualIdent(QualIdent fullyTypedIdent, String lastPrefix, boolean quoted) {
        Catalog catalog;
        Schema schema;
        Tuple tuple = this.resolveTuple(fullyTypedIdent);
        if (tuple != null) {
            this.items.addColumnsWithTupleName(tuple, fullyTypedIdent, lastPrefix, quoted, this.substitutionOffset - 1);
        }
        if ((schema = this.resolveSchema(fullyTypedIdent)) != null) {
            this.items.addTablesAtInsertInto(schema, fullyTypedIdent, null, lastPrefix, quoted, this.substitutionOffset - 1);
            if (this.includeViews) {
                this.items.addViewsAtInsertInto(schema, fullyTypedIdent, null, lastPrefix, quoted, this.substitutionOffset - 1);
            }
        }
        if ((catalog = this.resolveCatalog(fullyTypedIdent)) != null) {
            this.completeCatalog(catalog, lastPrefix, quoted);
        }
    }

    private void completeColumnQualIdent(QualIdent fullyTypedIdent, String lastPrefix, boolean quoted) {
        if (!(this.tablesClause == null || this.tablesClause.getUnaliasedTableNames().isEmpty() && this.tablesClause.getAliasedTableNames().isEmpty())) {
            this.completeQualIdentBasedOnFromClause(fullyTypedIdent, lastPrefix, quoted);
        } else {
            Catalog catalog;
            Schema schema;
            Tuple tuple = this.resolveTuple(fullyTypedIdent);
            if (tuple != null) {
                this.items.addColumns(tuple, lastPrefix, quoted, this.substitutionOffset);
            }
            if ((schema = this.resolveSchema(fullyTypedIdent)) != null) {
                this.items.addTables(schema, null, lastPrefix, quoted, this.substitutionOffset);
                if (this.includeViews) {
                    this.items.addViews(schema, null, lastPrefix, quoted, this.substitutionOffset);
                }
            }
            if ((catalog = this.resolveCatalog(fullyTypedIdent)) != null) {
                this.completeCatalog(catalog, lastPrefix, quoted);
            }
        }
    }

    private void completeTupleSimpleIdent(String typedPrefix, boolean quoted) {
        Schema defaultSchema = this.metadata.getDefaultSchema();
        if (defaultSchema != null) {
            this.items.addTables(defaultSchema, null, typedPrefix, quoted, this.substitutionOffset);
            if (this.includeViews) {
                this.items.addViews(defaultSchema, null, typedPrefix, quoted, this.substitutionOffset);
            }
        }
        Catalog defaultCatalog = this.metadata.getDefaultCatalog();
        this.items.addSchemas(defaultCatalog, null, typedPrefix, quoted, this.substitutionOffset);
        this.items.addCatalogs(this.metadata, null, typedPrefix, quoted, this.substitutionOffset);
    }

    private void completeTupleQualIdent(QualIdent fullyTypedIdent, String lastPrefix, boolean quoted) {
        Catalog catalog;
        Schema schema = this.resolveSchema(fullyTypedIdent);
        if (schema != null) {
            this.items.addTables(schema, null, lastPrefix, quoted, this.substitutionOffset);
            if (this.includeViews) {
                this.items.addViews(schema, null, lastPrefix, quoted, this.substitutionOffset);
            }
        }
        if ((catalog = this.resolveCatalog(fullyTypedIdent)) != null) {
            this.completeCatalog(catalog, lastPrefix, quoted);
        }
    }

    private void completeSimpleIdentBasedOnFromClause(String typedPrefix, boolean quoted) {
        assert (this.tablesClause != null);
        Set<QualIdent> tupleNames = this.tablesClause.getUnaliasedTableNames();
        Set<Tuple> tuples = this.resolveTuples(tupleNames);
        TreeSet<QualIdent> allTupleNames = new TreeSet<QualIdent>(tupleNames);
        LinkedHashSet<Tuple> allTuples = new LinkedHashSet<Tuple>(tuples);
        Map<String, QualIdent> aliases = this.tablesClause.getAliasedTableNames();
        for (Map.Entry<String, QualIdent> entry : aliases.entrySet()) {
            QualIdent tupleName = entry.getValue();
            allTupleNames.add(tupleName);
            Tuple tuple = this.resolveTuple(tupleName);
            if (tuple == null) continue;
            allTuples.add(tuple);
        }
        TreeMap<String, QualIdent> sortedAliases = new TreeMap<String, QualIdent>(aliases);
        this.items.addAliases(sortedAliases, typedPrefix, quoted, this.substitutionOffset);
        for (Tuple tuple : allTuples) {
            this.items.addColumns(tuple, typedPrefix, quoted, this.substitutionOffset);
        }
        Schema defaultSchema = this.metadata.getDefaultSchema();
        if (defaultSchema != null) {
            TreeSet<String> simpleTupleNames = new TreeSet<String>();
            for (Tuple tuple : tuples) {
                if (!tuple.getParent().isDefault()) continue;
                simpleTupleNames.add(tuple.getName());
            }
            this.items.addTables(defaultSchema, simpleTupleNames, typedPrefix, quoted, this.substitutionOffset);
            if (this.includeViews) {
                this.items.addViews(defaultSchema, simpleTupleNames, typedPrefix, quoted, this.substitutionOffset);
            }
        }
        TreeSet<String> schemaNames = new TreeSet<String>();
        TreeSet<String> catalogNames = new TreeSet<String>();
        for (Tuple tuple : tuples) {
            Schema schema = tuple.getParent();
            Catalog catalog = schema.getParent();
            if (!schema.isDefault() && !schema.isSynthetic() && catalog.isDefault()) {
                schemaNames.add(schema.getName());
            }
            if (catalog.isDefault()) continue;
            catalogNames.add(catalog.getName());
        }
        Catalog defaultCatalog = this.metadata.getDefaultCatalog();
        this.items.addSchemas(defaultCatalog, schemaNames, typedPrefix, quoted, this.substitutionOffset);
        this.items.addCatalogs(this.metadata, catalogNames, typedPrefix, quoted, this.substitutionOffset);
    }

    private void completeQualIdentBasedOnFromClause(QualIdent fullyTypedIdent, String lastPrefix, boolean quoted) {
        Catalog catalog;
        Schema schema;
        assert (this.tablesClause != null);
        Set<Tuple> tuples = this.resolveTuples(this.tablesClause.getUnaliasedTableNames());
        Tuple foundTuple = this.resolveTuple(fullyTypedIdent);
        if (foundTuple == null || !tuples.contains(foundTuple)) {
            QualIdent aliasedTupleName;
            foundTuple = null;
            if (fullyTypedIdent.isSimple() && (aliasedTupleName = this.tablesClause.getTableNameByAlias(fullyTypedIdent.getSimpleName())) != null) {
                foundTuple = this.resolveTuple(aliasedTupleName);
            }
        }
        if (foundTuple != null) {
            this.items.addColumns(foundTuple, lastPrefix, quoted, this.substitutionOffset);
        }
        if ((schema = this.resolveSchema(fullyTypedIdent)) != null) {
            TreeSet<String> tupleNames = new TreeSet<String>();
            for (Tuple tuple : tuples) {
                if (!tuple.getParent().equals(schema)) continue;
                tupleNames.add(tuple.getName());
            }
            this.items.addTables(schema, tupleNames, lastPrefix, quoted, this.substitutionOffset);
            if (this.includeViews) {
                this.items.addViews(schema, tupleNames, lastPrefix, quoted, this.substitutionOffset);
            }
        }
        if ((catalog = this.resolveCatalog(fullyTypedIdent)) != null) {
            TreeSet<String> syntheticSchemaTupleNames = new TreeSet<String>();
            TreeSet<String> schemaNames = new TreeSet<String>();
            for (Tuple tuple : tuples) {
                schema = tuple.getParent();
                if (!schema.getParent().equals(catalog)) continue;
                if (!schema.isSynthetic()) {
                    schemaNames.add(schema.getName());
                    continue;
                }
                syntheticSchemaTupleNames.add(tuple.getName());
            }
            this.items.addSchemas(catalog, schemaNames, lastPrefix, quoted, this.substitutionOffset);
            this.items.addTables(catalog.getSyntheticSchema(), syntheticSchemaTupleNames, lastPrefix, quoted, this.substitutionOffset);
            if (this.includeViews) {
                this.items.addViews(catalog.getSyntheticSchema(), syntheticSchemaTupleNames, lastPrefix, quoted, this.substitutionOffset);
            }
        }
    }

    private void completeCatalog(Catalog catalog, String prefix, boolean quoted) {
        this.items.addSchemas(catalog, null, prefix, quoted, this.substitutionOffset);
        Schema syntheticSchema = catalog.getSyntheticSchema();
        if (syntheticSchema != null) {
            this.items.addTables(syntheticSchema, null, prefix, quoted, this.substitutionOffset);
            if (this.includeViews) {
                this.items.addViews(syntheticSchema, null, prefix, quoted, this.substitutionOffset);
            }
        }
    }

    private Catalog resolveCatalog(QualIdent catalogName) {
        if (catalogName.isSimple()) {
            return this.metadata.getCatalog(catalogName.getSimpleName());
        }
        return null;
    }

    private Schema resolveSchema(QualIdent schemaName) {
        Schema schema = null;
        switch (schemaName.size()) {
            case 1: {
                Catalog catalog = this.metadata.getDefaultCatalog();
                schema = catalog.getSchema(schemaName.getSimpleName());
                break;
            }
            case 2: {
                Catalog catalog = this.metadata.getCatalog(schemaName.getFirstQualifier());
                if (catalog == null) break;
                schema = catalog.getSchema(schemaName.getSimpleName());
            }
        }
        return schema;
    }

    private Tuple resolveTuple(QualIdent tupleName) {
        if (tupleName == null) {
            return null;
        }
        Tuple tuple = null;
        switch (tupleName.size()) {
            case 1: {
                Schema schema = this.metadata.getDefaultSchema();
                if (schema == null) break;
                return this.getTuple(schema, tupleName);
            }
            case 2: {
                Catalog catalog = this.metadata.getDefaultCatalog();
                Schema schema = catalog.getSchema(tupleName.getFirstQualifier());
                if (schema != null && (tuple = this.getTuple(schema, tupleName)) != null) {
                    return tuple;
                }
                catalog = this.metadata.getCatalog(tupleName.getFirstQualifier());
                if (catalog == null || (schema = catalog.getSyntheticSchema()) == null) break;
                return this.getTuple(schema, tupleName);
            }
            case 3: {
                Schema schema;
                Catalog catalog = this.metadata.getCatalog(tupleName.getFirstQualifier());
                if (catalog == null || (schema = catalog.getSchema(tupleName.getSecondQualifier())) == null) break;
                return this.getTuple(schema, tupleName);
            }
        }
        return null;
    }

    private Tuple getTuple(Schema schema, QualIdent tupleName) {
        View view;
        Table table = schema.getTable(tupleName.getSimpleName());
        if (table != null) {
            return table;
        }
        if (this.includeViews && (view = schema.getView(tupleName.getSimpleName())) != null) {
            return view;
        }
        return null;
    }

    private Set<Tuple> resolveTuples(Set<QualIdent> tupleNames) {
        LinkedHashSet<Tuple> result = new LinkedHashSet<Tuple>(tupleNames.size());
        for (QualIdent tupleName : tupleNames) {
            Tuple tuple = this.resolveTuple(tupleName);
            if (tuple == null) continue;
            result.add(tuple);
        }
        return result;
    }

    private Symbol findPrefix() {
        TokenSequence<SQLTokenId> seq = this.env.getTokenSequence();
        int caretOffset = this.env.getCaretOffset();
        String prefix = null;
        if (seq.move(caretOffset) > 0 ? !seq.moveNext() && !seq.movePrevious() : !seq.movePrevious()) {
            return new Symbol(null, caretOffset, caretOffset);
        }
        switch ((SQLTokenId)seq.token().id()) {
            case WHITESPACE: 
            case COMMA: 
            case RPAREN: {
                return new Symbol(null, caretOffset, caretOffset);
            }
        }
        int offset = caretOffset - seq.offset();
        prefix = offset > 0 && offset < seq.token().length() ? seq.token().text().subSequence(0, offset).toString() : seq.token().text().toString();
        return new Symbol(prefix, seq.offset(), seq.offset());
    }

    private Identifier findIdentifier() {
        TokenSequence<SQLTokenId> seq = this.env.getTokenSequence();
        int caretOffset = this.env.getCaretOffset();
        ArrayList<String> parts = new ArrayList<String>();
        if (seq.move(caretOffset) > 0 ? !seq.moveNext() && !seq.movePrevious() : !seq.movePrevious()) {
            return null;
        }
        switch ((SQLTokenId)seq.token().id()) {
            case RPAREN: 
            case LINE_COMMENT: 
            case BLOCK_COMMENT: 
            case INT_LITERAL: 
            case DOUBLE_LITERAL: 
            case STRING: 
            case INCOMPLETE_STRING: {
                return null;
            }
        }
        boolean incomplete = false;
        boolean wasDot = false;
        int lastPrefixOffset = -1;
        block13: do {
            block3 : switch ((SQLTokenId)seq.token().id()) {
                case DOT: {
                    if (parts.isEmpty()) {
                        lastPrefixOffset = caretOffset;
                        incomplete = true;
                    }
                    wasDot = true;
                    break;
                }
                case IDENTIFIER: 
                case INCOMPLETE_IDENTIFIER: 
                case KEYWORD: {
                    if (wasDot || parts.isEmpty()) {
                        String part;
                        if (parts.isEmpty() && lastPrefixOffset == -1) {
                            lastPrefixOffset = seq.offset();
                        }
                        wasDot = false;
                        int offset = caretOffset - seq.offset();
                        String tokenText = seq.token().text().toString();
                        if (offset > 0 && offset < seq.token().length()) {
                            String quoteString = this.quoter.getQuoteString();
                            if (tokenText.startsWith(quoteString) && tokenText.endsWith(quoteString) && offset == tokenText.length() - 1) {
                                part = tokenText.substring(1, offset);
                                ++lastPrefixOffset;
                            } else {
                                part = tokenText.substring(0, offset);
                            }
                        } else {
                            part = tokenText;
                        }
                        parts.add(part);
                        break;
                    }
                    return null;
                }
                case WHITESPACE: 
                case LINE_COMMENT: 
                case BLOCK_COMMENT: {
                    if (!seq.movePrevious()) break block13;
                    switch ((SQLTokenId)seq.token().id()) {
                        case RPAREN: 
                        case INT_LITERAL: 
                        case DOUBLE_LITERAL: 
                        case STRING: 
                        case INCOMPLETE_STRING: 
                        case IDENTIFIER: {
                            return null;
                        }
                        case OPERATOR: {
                            if (!seq.token().text().toString().equals("*") || !seq.movePrevious()) break;
                            if (seq.movePrevious()) {
                                if (seq.token().text().toString().equalsIgnoreCase("SELECT")) {
                                    return null;
                                }
                                seq.moveNext();
                            }
                            seq.moveNext();
                            break;
                        }
                        case DOT: {
                            seq.moveNext();
                            break block3;
                        }
                    }
                    break block13;
                }
                default: {
                    break block13;
                }
            }
        } while (seq.movePrevious());
        Collections.reverse(parts);
        return this.createIdentifier(parts, incomplete, lastPrefixOffset >= 0 ? lastPrefixOffset : caretOffset);
    }

    private Identifier createIdentifier(List<String> parts, boolean incomplete, int lastPrefixOffset) {
        String lastPrefix = null;
        boolean quoted = false;
        int substOffset = lastPrefixOffset;
        if (parts.isEmpty()) {
            if (incomplete) {
                return null;
            }
        } else {
            if (!incomplete) {
                lastPrefix = parts.remove(parts.size() - 1);
                String quoteString = this.quoter.getQuoteString();
                if (quoteString.length() > 0 && lastPrefix.startsWith(quoteString)) {
                    if (lastPrefix.endsWith(quoteString) && lastPrefix.length() > quoteString.length()) {
                        return null;
                    }
                    int lastPrefixLength = lastPrefix.length();
                    lastPrefix = this.quoter.unquote(lastPrefix);
                    lastPrefixOffset += lastPrefixLength - lastPrefix.length();
                    quoted = true;
                } else if (quoteString.length() > 0 && lastPrefix.endsWith(quoteString)) {
                    return null;
                }
            }
            for (int i = 0; i < parts.size(); ++i) {
                String unquoted = this.quoter.unquote(parts.get(i));
                if (unquoted.length() == 0) {
                    return null;
                }
                parts.set(i, unquoted);
            }
        }
        return new Identifier(new QualIdent(parts), lastPrefix, quoted, lastPrefixOffset, substOffset);
    }

    private static void reportError(MetadataModelException e) {
        LOGGER.log(Level.INFO, null, e);
        String error = e.getMessage();
        String message = error != null ? NbBundle.getMessage(SQLCompletionQuery.class, (String)"MSG_Error", (Object)error) : NbBundle.getMessage(SQLCompletionQuery.class, (String)"MSG_ErrorNoMessage");
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    private static final class Identifier
    extends Symbol {
        final QualIdent fullyTypedIdent;
        final boolean quoted;

        private Identifier(QualIdent fullyTypedIdent, String lastPrefix, boolean quoted, int anchorOffset, int substitutionOffset) {
            super(lastPrefix, anchorOffset, substitutionOffset);
            this.fullyTypedIdent = fullyTypedIdent;
            this.quoted = quoted;
        }
    }

    private static class Symbol {
        final String lastPrefix;
        final int anchorOffset;
        final int substitutionOffset;

        private Symbol(String lastPrefix, int anchorOffset, int substitutionOffset) {
            this.lastPrefix = lastPrefix;
            this.anchorOffset = anchorOffset;
            this.substitutionOffset = substitutionOffset;
        }
    }
}

