/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;

final class JCStoreGroup
extends StoreGroup {
    private final Map<String, ExtDocument> models = new HashMap<String, ExtDocument>();
    private DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            JCStoreGroup.this.documentModified(e.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JCStoreGroup.this.documentModified(e.getDocument());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JCStoreGroup.this.documentModified(e.getDocument());
        }
    };
    private final Set<String> modified = new HashSet<String>();
    static final Pattern NESTED_PROP_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    JCStoreGroup() {
    }

    private void documentModified(Document d) {
        for (Map.Entry<String, ExtDocument> en : this.models.entrySet()) {
            String key = en.getKey();
            Document val = en.getValue();
            if (d != val) continue;
            this.modified.add(key);
            break;
        }
    }

    private void checkModelDoesNotExist(String propertyName) {
        if (this.models.get(propertyName) != null) {
            throw new IllegalArgumentException("Model for property " + propertyName + "already exists.");
        }
    }

    private String resolve(String key, String value, PropertyEvaluator eval) {
        if (value != null && value.equals("${" + key + "}")) {
            return key;
        }
        StringBuilder sb = new StringBuilder(value);
        Matcher m = NESTED_PROP_PATTERN.matcher(sb);
        while (m.find()) {
            String replacement;
            String resolveKey = m.group(1);
            if (resolveKey.equals(key) || (replacement = eval.evaluate(resolveKey)) == null) continue;
            int start = m.start();
            int end = m.end();
            sb.replace(start, end, replacement);
            m = NESTED_PROP_PATTERN.matcher(sb);
        }
        return sb.toString().trim();
    }

    public Document createResolvingDocument(PropertyEvaluator evaluator, String propertyName, String ... substitutions) {
        this.checkModelDoesNotExist(propertyName);
        String value = evaluator.getProperty(propertyName);
        if (value == null) {
            value = "";
        }
        value = this.resolve(propertyName, value, evaluator);
        value = value.replace(File.separatorChar, '/');
        try {
            ExtDocument d = new ExtDocument(evaluator, substitutions);
            d.remove(0, d.getLength());
            d.insertString(0, value, null);
            d.addDocumentListener(this.documentListener);
            this.models.put(propertyName, d);
            return d;
        }
        catch (BadLocationException e) {
            assert (false) : "Bad location exception from new document.";
            return new PlainDocument();
        }
    }

    public void store(EditableProperties editableProperties) {
        super.store(editableProperties);
        for (String name : this.modified) {
            ExtDocument doc = this.models.get(name);
            doc.store(editableProperties, name);
        }
    }

    private static final class ExtDocument
    extends PlainDocument {
        private final String[] propNames;
        private final PropertyEvaluator eval;

        ExtDocument(PropertyEvaluator eval, String ... propNames) {
            this.propNames = propNames;
            this.eval = eval;
        }

        void store(EditableProperties props, String name) {
            String txt;
            try {
                txt = this.getText(0, this.getLength());
                for (String key : this.propNames) {
                    String val = this.eval.getProperty(key);
                    if (!txt.startsWith(val)) continue;
                    txt = "${" + key + "}" + txt.substring(val.length());
                }
                txt = txt.replace('\\', '/');
            }
            catch (BadLocationException e) {
                txt = "";
            }
            props.setProperty(name, txt);
        }
    }
}

