/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.EntityClassScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeFactory;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeImplementation;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopeProvider;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceScopesProvider;
import org.netbeans.modules.j2ee.persistence.spi.support.EntityMappingsMetadataModelHelper;
import org.netbeans.modules.j2ee.persistence.spi.support.PersistenceScopesHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class J2SEPersistenceProvider
implements PersistenceLocationProvider,
PersistenceScopeProvider,
PersistenceScopesProvider,
EntityClassScopeProvider,
PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(J2SEPersistenceProvider.class.getName(), 1, false, false);
    private final J2SEProject project;
    private final ClassPathProviderImpl cpProvider;
    private final ScopeImpl scopeImpl = new ScopeImpl();
    private final PersistenceScope persistenceScope = PersistenceScopeFactory.createPersistenceScope((PersistenceScopeImplementation)this.scopeImpl);
    private final EntityClassScope entityClassScope = EntityClassScopeFactory.createEntityClassScope((EntityClassScopeImplementation)this.scopeImpl);
    private final PersistenceScopesHelper scopesHelper = new PersistenceScopesHelper();
    private final EntityMappingsMetadataModelHelper modelHelper;
    private final PropertyChangeListener scopeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object newV = evt.getNewValue();
            if (Boolean.TRUE.equals(newV)) {
                J2SEPersistenceProvider.this.puChanged();
            }
        }
    };
    private ClassPath projectSourcesClassPath;

    public J2SEPersistenceProvider(J2SEProject project, ClassPathProviderImpl cpProvider) {
        this.project = project;
        this.cpProvider = cpProvider;
        this.modelHelper = this.createEntityMappingsHelper();
        project.getSourceRoots().addPropertyChangeListener((PropertyChangeListener)this);
        this.sourcesChanged();
    }

    public FileObject getLocation() {
        return this.getMetaInfFolder();
    }

    public FileObject createLocation() throws IOException {
        FileObject root = this.getFirstSourceRoot();
        if (root == null) {
            throw new IOException("There are no source roots in the project or the first source root does not exist.");
        }
        FileObject metaInf = root.getFileObject("META-INF");
        if (metaInf != null) {
            if (!metaInf.isFolder()) {
                throw new IOException("The META-INF directory exists, but is not a folder.");
            }
        } else {
            metaInf = root.createFolder("META-INF");
        }
        return metaInf;
    }

    public PersistenceScope findPersistenceScope(FileObject fo) {
        Project proj = FileOwnerQuery.getOwner((FileObject)fo);
        if (proj != null) {
            J2SEPersistenceProvider provider = (J2SEPersistenceProvider)proj.getLookup().lookup(J2SEPersistenceProvider.class);
            return provider.getPersistenceScope();
        }
        return null;
    }

    public EntityClassScope findEntityClassScope(FileObject fo) {
        Project proj = FileOwnerQuery.getOwner((FileObject)fo);
        if (proj != null) {
            J2SEPersistenceProvider provider = (J2SEPersistenceProvider)proj.getLookup().lookup(J2SEPersistenceProvider.class);
            return provider.getEntityClassScope();
        }
        return null;
    }

    public PersistenceScopes getPersistenceScopes() {
        return this.scopesHelper.getPersistenceScopes();
    }

    private FileObject getFirstSourceRoot() {
        for (URL url : this.project.getSourceRoots().getRootURLs()) {
            FileObject fo = URLMapper.findFileObject((URL)url);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    private FileObject getMetaInfFolder() {
        for (URL url : this.project.getSourceRoots().getRootURLs()) {
            FileObject metaInf;
            FileObject fo = URLMapper.findFileObject((URL)url);
            if (fo == null || (metaInf = fo.getFileObject("META-INF")) == null || !metaInf.isFolder()) continue;
            return metaInf;
        }
        return null;
    }

    private PersistenceScope getPersistenceScope() {
        FileObject persistenceXml = this.persistenceScope.getPersistenceXml();
        if (persistenceXml != null && persistenceXml.isValid()) {
            return this.persistenceScope;
        }
        return null;
    }

    private EntityClassScope getEntityClassScope() {
        return this.entityClassScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getProjectSourcesClassPath() {
        J2SEPersistenceProvider j2SEPersistenceProvider = this;
        synchronized (j2SEPersistenceProvider) {
            if (this.projectSourcesClassPath == null) {
                this.projectSourcesClassPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{this.cpProvider.getProjectSourcesClassPath("classpath/source"), this.cpProvider.getProjectSourcesClassPath("classpath/compile")});
            }
            return this.projectSourcesClassPath;
        }
    }

    private EntityMappingsMetadataModelHelper createEntityMappingsHelper() {
        return EntityMappingsMetadataModelHelper.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.sourcesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sourcesChanged() {
        File persistenceXmlFile = null;
        FileObject metaInf = this.getMetaInfFolder();
        if (metaInf != null) {
            File metaInfFile = FileUtil.toFile((FileObject)metaInf);
            if (metaInfFile != null) {
                persistenceXmlFile = new File(metaInfFile, "persistence.xml");
            }
        } else {
            FileObject firstSourceRoot = this.getFirstSourceRoot();
            if (firstSourceRoot != null) {
                File sourceRootFile = FileUtil.toFile((FileObject)firstSourceRoot);
                persistenceXmlFile = new File(sourceRootFile, "META-INF/persistence.xml");
            }
        }
        J2SEPersistenceProvider j2SEPersistenceProvider = this;
        synchronized (j2SEPersistenceProvider) {
            if (persistenceXmlFile != null) {
                this.scopesHelper.changePersistenceScope(this.persistenceScope, persistenceXmlFile);
                this.modelHelper.changePersistenceXml(persistenceXmlFile);
                this.scopesHelper.getPersistenceScopes().addPropertyChangeListener(this.scopeListener);
            } else {
                this.scopesHelper.changePersistenceScope(null, null);
                this.modelHelper.changePersistenceXml(null);
            }
        }
    }

    private void puChanged() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                ProjectManager.mutex().writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        Sources sources;
                        SourceGroup[] groups;
                        SourceGroup firstGroup;
                        FileObject fo;
                        ClassPath compile;
                        String approperties;
                        EditableProperties prop = J2SEPersistenceProvider.this.project.getUpdateHelper().getProperties("nbproject/project.properties");
                        String ap = prop.getProperty("annotation.processing.processors.list");
                        boolean changed = false;
                        if (ap == null) {
                            ap = "";
                        }
                        if ((approperties = prop.getProperty("annotation.processing.processor.options")) == null) {
                            approperties = "";
                        }
                        if (approperties.indexOf("eclipselink.canonicalmodel.use_static_factory") == -1) {
                            String toadd = (approperties.length() > 0 ? " " : "") + "-Aeclipselink.canonicalmodel.use_static_factory=false";
                            approperties = approperties + toadd;
                            prop.setProperty("annotation.processing.processor.options", approperties);
                            changed = true;
                        }
                        if (ap.length() > 0 && ap.indexOf("org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProcessor") == -1 && (compile = ClassPath.getClassPath((FileObject)(fo = (firstGroup = (groups = (sources = ProjectUtils.getSources((Project)J2SEPersistenceProvider.this.project)).getSourceGroups("java"))[0]).getRootFolder()), (String)"classpath/processor")).findResource("org/eclipse/persistence/internal/jpa/modelgen/CanonicalModelProcessor.class") != null) {
                            boolean turnOn = (ap = ap.trim()).length() == 0;
                            ap = ap + (ap.length() > 0 ? "," : "") + "org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProcessor";
                            prop.setProperty("annotation.processing.processors.list", ap);
                            if (turnOn) {
                                prop.setProperty("annotation.processing.run.all.processors", "false");
                            }
                            changed = true;
                        }
                        if (!J2SEProjectUtil.isTrue(prop.getProperty("annotation.processing.enabled"))) {
                            prop.setProperty("annotation.processing.enabled", "true");
                            changed = true;
                        }
                        if (changed) {
                            J2SEPersistenceProvider.this.project.getUpdateHelper().putProperties("nbproject/project.properties", prop);
                            try {
                                ProjectManager.getDefault().saveProject((Project)J2SEPersistenceProvider.this.project);
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (IllegalArgumentException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            }
        });
    }

    private final class ScopeImpl
    implements PersistenceScopeImplementation,
    EntityClassScopeImplementation {
        private ScopeImpl() {
        }

        public FileObject getPersistenceXml() {
            FileObject location = J2SEPersistenceProvider.this.getLocation();
            if (location == null) {
                return null;
            }
            return location.getFileObject("persistence.xml");
        }

        public ClassPath getClassPath() {
            return J2SEPersistenceProvider.this.getProjectSourcesClassPath();
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(String persistenceUnitName) {
            return J2SEPersistenceProvider.this.modelHelper.getEntityMappingsModel(persistenceUnitName);
        }

        public MetadataModel<EntityMappingsMetadata> getEntityMappingsModel(boolean withDeps) {
            return J2SEPersistenceProvider.this.modelHelper.getDefaultEntityMappingsModel(withDeps);
        }
    }
}

