/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.cpu.SnapshotCPUView;
import org.netbeans.lib.profiler.ui.memory.SnapshotMemoryView;
import org.netbeans.lib.profiler.ui.swing.ExportUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SnapshotInfoAction;
import org.netbeans.modules.profiler.SnapshotsListener;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.api.ActionsSupport;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.spi.actions.AbstractSavable;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class SnapshotResultsWindow
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY_CPU = "CpuSnapshot.HelpCtx";
    private static final String HELP_CTX_KEY_MEM = "MemorySnapshot.HelpCtx";
    private static final Image WINDOW_ICON_CPU = Icons.getImage((String)"ProfilerIcons.Cpu");
    private static final Image WINDOWS_ICON_FRAGMENT = Icons.getImage((String)"ProfilerIcons.Fragment");
    private static final Image WINDOWS_ICON_MEMORY = Icons.getImage((String)"ProfilerIcons.Memory");
    private static final HashMap windowsList = new HashMap();
    private LoadedSnapshot snapshot;
    private InstanceContent ic = new InstanceContent();
    private SavePerformer savePerformer = new SavePerformer();
    private JPanel displayedPanel;
    private String tabName = "";
    private SnapshotListener listener;
    private boolean forcedClose = false;
    private HelpCtx helpCtx = HelpCtx.DEFAULT_HELP;

    public SnapshotResultsWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public SnapshotResultsWindow(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.ic));
        this.ic.add((Object)this.getActionMap());
        this.snapshot = ls;
        this.updateSaveState();
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.refreshTabName();
        switch (this.snapshot.getType()) {
            case 1: {
                this.setIcon(WINDOW_ICON_CPU);
                this.helpCtx = new HelpCtx(HELP_CTX_KEY_CPU);
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_CpuSnapshotAccessDescr());
                this.setupCPUResultsView();
                break;
            }
            case 4: 
            case 8: 
            case 16: {
                this.setIcon(WINDOWS_ICON_MEMORY);
                this.helpCtx = new HelpCtx(HELP_CTX_KEY_MEM);
                this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotResultsWindow_MemorySnapshotAccessDescr());
                this.setupMemoryResultsView();
            }
        }
        if (this.displayedPanel != null) {
            this.add(this.displayedPanel, "Center");
        }
        this.listener = (SnapshotListener)Lookup.getDefault().lookup(SnapshotListener.class);
        this.listener.registerSnapshotResultsWindow(this);
    }

    public static synchronized void closeAllWindows() {
        Collection windows = windowsList.values();
        if (!windows.isEmpty()) {
            SnapshotResultsWindow[] toClose = new SnapshotResultsWindow[windows.size()];
            windows.toArray(toClose);
            for (int i = 0; i < toClose.length; ++i) {
                SnapshotResultsWindow snapshotResultsWindow = toClose[i];
                snapshotResultsWindow.forcedClose();
            }
        }
    }

    public static synchronized void closeWindow(LoadedSnapshot snapshot) {
        SnapshotResultsWindow win = (SnapshotResultsWindow)((Object)windowsList.get(snapshot));
        if (win != null) {
            win.forcedClose();
        }
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot ls) {
        return SnapshotResultsWindow.get(ls, -1, false);
    }

    public static synchronized SnapshotResultsWindow get(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        SnapshotResultsWindow win = (SnapshotResultsWindow)((Object)windowsList.get(ls));
        if (win == null) {
            win = new SnapshotResultsWindow(ls, sortingColumn, sortingOrder);
            windowsList.put(ls, win);
        }
        return win;
    }

    public static synchronized boolean hasSnapshotWindow(LoadedSnapshot ls) {
        return windowsList.get(ls) != null;
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return this.helpCtx;
    }

    public boolean canClose() {
        File file = this.snapshot.getFile();
        if (file != null) {
            this.putClientProperty("nb.recent.file.path", file);
        }
        if (this.forcedClose) {
            this.savePerformer.remove();
            return true;
        }
        if (this.snapshot.isSaved()) {
            return true;
        }
        Boolean ret = ProfilerDialogs.displayCancellableConfirmationDNSA((String)Bundle.SnapshotResultsWindow_SaveSnapshotDialogMsg(), null, null, (String)"org.netbeans.modules.profiler.SnapshotResultsWindow.canClose", (boolean)false);
        if (Boolean.TRUE.equals(ret)) {
            try {
                this.savePerformer.save();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }
        if (Boolean.FALSE.equals(ret)) {
            this.savePerformer.remove();
            return true;
        }
        return false;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.displayedPanel;
    }

    public void refreshTabName() {
        this.tabName = ResultsManager.getDefault().getSnapshotDisplayName(this.snapshot);
        File snapshotFile = this.snapshot.getFile();
        if (snapshotFile != null) {
            this.setToolTipText(snapshotFile.getAbsolutePath());
        }
        this.updateTitle();
    }

    public void updateTitle() {
        if (this.snapshot.isSaved()) {
            this.setName(this.tabName);
        } else {
            this.setName(this.tabName + " *");
        }
        if (this.snapshot.getFile() != null) {
            this.setToolTipText(this.snapshot.getFile().getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void componentClosed() {
        Class<SnapshotResultsWindow> clazz = SnapshotResultsWindow.class;
        synchronized (SnapshotResultsWindow.class) {
            windowsList.remove(this.snapshot);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ResultsManager.getDefault().closeSnapshot(this.snapshot);
            this.snapshot = null;
            this.listener.unregisterSnapshotResultsWindow(this);
            return;
        }
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    boolean setRefSnapshot(LoadedSnapshot ls) {
        ResultsSnapshot s;
        ResultsSnapshot resultsSnapshot = s = ls == null ? null : ls.getSnapshot();
        if (this.displayedPanel instanceof SnapshotCPUView && s instanceof CPUResultsSnapshot) {
            ((SnapshotCPUView)this.displayedPanel).setRefSnapshot((CPUResultsSnapshot)s);
            return true;
        }
        if (this.displayedPanel instanceof SnapshotMemoryView && s instanceof MemoryResultsSnapshot) {
            ((SnapshotMemoryView)this.displayedPanel).setRefSnapshot((MemoryResultsSnapshot)s);
            return true;
        }
        return false;
    }

    private void setupCPUResultsView() {
        ResultsSnapshot _snapshot = this.snapshot.getSnapshot();
        if (_snapshot instanceof CPUResultsSnapshot) {
            CPUResultsSnapshot s = (CPUResultsSnapshot)_snapshot;
            boolean sampling = this.snapshot.getSettings().getCPUProfilingType() == 2;
            SaveSnapshotAction aSave = new SaveSnapshotAction(this.snapshot);
            CompareSnapshotsAction aCompare = new CompareSnapshotsAction(this.snapshot);
            SnapshotInfoAction aInfo = new SnapshotInfoAction(this.snapshot);
            ExportUtils.Exportable exporter = ResultsManager.getDefault().createSnapshotExporter(this.snapshot);
            final SnapshotCPUView _cpuSnapshot = new SnapshotCPUView(s, sampling, aSave, aCompare, aInfo, exporter){

                protected boolean showSourceSupported() {
                    return GoToSource.isAvailable();
                }

                protected void showSource(ClientUtils.SourceCodeSelection value) {
                    Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                    String className = value.getClassName();
                    String methodName = value.getMethodName();
                    String methodSig = value.getMethodSignature();
                    GoToSource.openSource((Lookup.Provider)project, (String)className, (String)methodName, (String)methodSig);
                }

                protected void selectForProfiling(final ClientUtils.SourceCodeSelection value) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                            String name = "*".equals(value.getMethodName()) ? Bundle.SnapshotResultsWindow_ProfileClass() : Bundle.SnapshotResultsWindow_ProfileMethod();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{value}), project, name);
                        }
                    });
                }
            };
            aCompare.setPerformer(new CompareSnapshotsAction.Performer(){

                @Override
                public void compare(LoadedSnapshot snapshot) {
                    _cpuSnapshot.setRefSnapshot((CPUResultsSnapshot)snapshot.getSnapshot());
                }
            });
            this.registerActions((JComponent)_cpuSnapshot);
            this.displayedPanel = _cpuSnapshot;
        }
    }

    private void setupMemoryResultsView() {
        ResultsSnapshot _snapshot = this.snapshot.getSnapshot();
        if (_snapshot instanceof MemoryResultsSnapshot) {
            List<String> filter;
            Object f = this.snapshot.getSettings().getSelectedInstrumentationFilter();
            SimpleFilter sf = f instanceof SimpleFilter ? (SimpleFilter)f : null;
            String value = sf == null ? null : sf.getFilterValue();
            List<String> list = filter = value == null || value.isEmpty() ? null : Arrays.asList(FilterUtils.getSeparateFilters((String)value));
            if (filter != null && filter.isEmpty()) {
                filter = null;
            }
            MemoryResultsSnapshot s = (MemoryResultsSnapshot)_snapshot;
            SaveSnapshotAction aSave = new SaveSnapshotAction(this.snapshot);
            CompareSnapshotsAction aCompare = new CompareSnapshotsAction(this.snapshot);
            SnapshotInfoAction aInfo = new SnapshotInfoAction(this.snapshot);
            ExportUtils.Exportable exporter = ResultsManager.getDefault().createSnapshotExporter(this.snapshot);
            final SnapshotMemoryView _memorySnapshot = new SnapshotMemoryView(s, filter, aSave, aCompare, aInfo, exporter){

                protected boolean showSourceSupported() {
                    return GoToSource.isAvailable();
                }

                protected void showSource(ClientUtils.SourceCodeSelection value) {
                    Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                    String className = value.getClassName();
                    String methodName = value.getMethodName();
                    String methodSig = value.getMethodSignature();
                    GoToSource.openSource((Lookup.Provider)project, (String)className, (String)methodName, (String)methodSig);
                }

                protected void selectForProfiling(final ClientUtils.SourceCodeSelection value) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            Lookup.Provider project = SnapshotResultsWindow.this.snapshot.getProject();
                            ProfilerSession.findAndConfigure(Lookups.fixed((Object[])new Object[]{value}), project, Bundle.SnapshotResultsWindow_ProfileClass());
                        }
                    });
                }
            };
            aCompare.setPerformer(new CompareSnapshotsAction.Performer(){

                @Override
                public void compare(LoadedSnapshot snapshot) {
                    _memorySnapshot.setRefSnapshot((MemoryResultsSnapshot)snapshot.getSnapshot());
                }
            });
            this.registerActions((JComponent)_memorySnapshot);
            this.displayedPanel = _memorySnapshot;
        }
    }

    private void forcedClose() {
        this.forcedClose = true;
        this.close();
    }

    private void registerActions(final JComponent view) {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        String filterKey = "filter-action-key";
        AbstractAction filterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = view.getActionMap().get("filter-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
        String findKey = "find-action-key";
        AbstractAction findAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Action action = view.getActionMap().get("find-action-key");
                if (action != null && action.isEnabled()) {
                    action.actionPerformed(e);
                }
            }
        };
        ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
    }

    private void updateSaveState() {
        if (this.snapshot != null) {
            if (this.snapshot.isSaved()) {
                this.savePerformer.remove();
            } else {
                this.savePerformer.add();
            }
        } else {
            this.savePerformer.remove();
        }
    }

    private class SavePerformer
    extends AbstractSavable {
        private SavePerformer() {
        }

        private void add() {
            this.register();
            SnapshotResultsWindow.this.ic.add((Object)this);
        }

        private void remove() {
            this.unregister();
            SnapshotResultsWindow.this.ic.remove((Object)this);
        }

        protected String findDisplayName() {
            return SnapshotResultsWindow.this.tabName;
        }

        protected void handleSave() {
            LoadedSnapshot toSave = SnapshotResultsWindow.this.snapshot;
            if (toSave == null) {
                return;
            }
            ResultsManager.getDefault().saveSnapshot(toSave);
            SnapshotResultsWindow.this.ic.remove((Object)this);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }

    public static interface FindPerformer {
        public void performFind();

        public void performFindNext();

        public void performFindPrevious();
    }

    public static class SnapshotListener
    implements SnapshotsListener {
        List<SnapshotResultsWindow> registeredWindows;

        void registerSnapshotResultsWindow(SnapshotResultsWindow w) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.registeredWindows == null) {
                this.registeredWindows = new ArrayList<SnapshotResultsWindow>();
            }
            this.registeredWindows.add(w);
        }

        void unregisterSnapshotResultsWindow(SnapshotResultsWindow w) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.registeredWindows != null) {
                this.registeredWindows.remove((Object)w);
            }
        }

        @Override
        public void snapshotLoaded(LoadedSnapshot snapshot) {
        }

        @Override
        public void snapshotRemoved(LoadedSnapshot snapshot) {
        }

        @Override
        public void snapshotSaved(LoadedSnapshot snapshot) {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.registeredWindows != null) {
                for (SnapshotResultsWindow w : this.registeredWindows) {
                    if (w.snapshot != snapshot) continue;
                    w.updateSaveState();
                }
            }
        }

        @Override
        public void snapshotTaken(LoadedSnapshot snapshot) {
        }
    }
}

