/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.elements;

import java.util.EnumSet;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.plugins.CsmWhereUsedFilters;
import org.netbeans.modules.cnd.refactoring.support.ElementGrip;
import org.netbeans.modules.cnd.refactoring.support.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.FiltersManager;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class CsmRefactoringElementImpl
extends SimpleRefactoringElementImplementation
implements FiltersManager.Filterable {
    private static final boolean LAZY = false;
    private final CsmReference elem;
    private final PositionBounds bounds;
    private final FileObject fo;
    private String displayText;
    private final Object enclosing;
    private final boolean isDecl;
    private final boolean isScope;
    private final boolean isInMacros;
    private final boolean isInDeadCode;
    private final boolean isInComments;

    public CsmRefactoringElementImpl(PositionBounds bounds, CsmReference elem, FileObject fo, String displayText) {
        this.elem = elem;
        this.bounds = bounds;
        this.fo = fo;
        assert (displayText != null);
        this.displayText = displayText;
        ElementGrip composite = ElementGripFactory.getDefault().putInComposite(fo, (CsmOffsetable)elem);
        if (composite == null) {
            composite = fo;
        }
        this.enclosing = composite;
        this.isDecl = CsmReferenceResolver.getDefault().isKindOf(elem, EnumSet.of(CsmReferenceKind.DECLARATION, CsmReferenceKind.DEFINITION));
        this.isScope = this.isScope(elem);
        this.isInMacros = CsmReferenceResolver.getDefault().isKindOf(elem, EnumSet.of(CsmReferenceKind.IN_PREPROCESSOR_DIRECTIVE));
        this.isInDeadCode = CsmReferenceResolver.getDefault().isKindOf(elem, EnumSet.of(CsmReferenceKind.IN_DEAD_BLOCK));
        this.isInComments = CsmReferenceResolver.getDefault().isKindOf(elem, EnumSet.of(CsmReferenceKind.COMMENT));
    }

    private boolean isScope(CsmReference ref) {
        CsmFile csmFile = ref.getContainingFile();
        int stToken = ref.getStartOffset();
        int endToken = ref.getEndOffset();
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)csmFile);
        StyledDocument stDoc = CsmUtilities.openDocument((CloneableEditorSupport)ces);
        if (stDoc instanceof BaseDocument) {
            BaseDocument doc = (BaseDocument)stDoc;
            try {
                int startLine = LineDocumentUtils.getLineFirstNonWhitespace((LineDocument)doc, (int)stToken);
                int endLine = LineDocumentUtils.getLineLastNonWhitespace((LineDocument)doc, (int)endToken) + 1;
                String restText = doc.getText(endToken, endLine - startLine).trim();
                return restText.startsWith("::");
            }
            catch (BadLocationException ex) {
                // empty catch block
            }
        }
        return false;
    }

    public String getText() {
        return this.elem.getText().toString();
    }

    public String getDisplayText() {
        if (this.displayText == null) {
            // empty if block
        }
        return this.displayText;
    }

    public void performChange() {
    }

    public Lookup getLookup() {
        if (this.isInComments) {
            ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/refactoring/resources/found_item_comment.png", (boolean)false);
            return Lookups.fixed((Object[])new Object[]{this.elem, this.enclosing, icon});
        }
        return Lookups.fixed((Object[])new Object[]{this.elem, this.enclosing});
    }

    public FileObject getParentFile() {
        return this.fo;
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String toString() {
        return "{bounds=" + this.bounds + ", displayText=" + this.displayText + ", enclosing=" + this.enclosing + ", fo=" + this.fo + '}';
    }

    public static RefactoringElementImplementation create(CsmReference ref, boolean nameInBold) {
        CsmFile csmFile = ref.getContainingFile();
        FileObject fo = CsmUtilities.getFileObject((CsmFile)csmFile);
        PositionBounds bounds = CsmUtilities.createPositionBounds((CsmOffsetable)ref);
        String displayText = CsmReferenceSupport.getContextLineHtml((CsmReference)ref, (boolean)nameInBold).toString();
        return new CsmRefactoringElementImpl(bounds, ref, fo, displayText);
    }

    public boolean filter(FiltersManager manager) {
        if (this.isDecl && !manager.isSelected(CsmWhereUsedFilters.DECLARATIONS.getKey())) {
            return false;
        }
        if (this.isScope && !manager.isSelected(CsmWhereUsedFilters.SCOPE.getKey())) {
            return false;
        }
        if (this.isInMacros && !manager.isSelected(CsmWhereUsedFilters.MACROS.getKey())) {
            return false;
        }
        if (this.isInDeadCode && !manager.isSelected(CsmWhereUsedFilters.DEAD_CODE.getKey())) {
            return false;
        }
        return !this.isInComments || manager.isSelected(CsmWhereUsedFilters.COMMENTS.getKey());
    }
}

