/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmTypeAlias;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmVirtualInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.RefactoringModule;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient CsmObject origObject;
    private transient CsmUID<CsmObject> refObjectUID;
    private final transient ChangeListener parent;
    private String name;
    private Scope defaultScope;
    private volatile boolean initialized = false;
    private CsmClass methodDeclaringSuperClass = null;
    private CsmClass methodDeclaringClass = null;
    private CsmMethod baseVirtualMethod = null;
    private ButtonGroup buttonGroup;
    private JRadioButton c_directOnly;
    private JRadioButton c_subclasses;
    private JRadioButton c_usages;
    private JPanel classesPanel;
    private JPanel commentsPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel label;
    private JCheckBox m_isBaseClass;
    private JCheckBox m_overriders;
    private JCheckBox m_usages;
    private JPanel methodsPanel;
    private JComboBox scope;
    private JLabel scopeLabel;
    private JPanel scopePanel;
    private JCheckBox searchInComments;

    public WhereUsedPanel(String name, CsmObject csmObject, ChangeListener parent) {
        this.setName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed"));
        this.origObject = csmObject;
        this.parent = parent;
        this.name = name;
        this.defaultScope = Scope.CURRENT;
        this.initComponents();
    }

    public CsmProject getScopeProject() {
        if (this.defaultScope == Scope.ALL) {
            return null;
        }
        if (this.defaultScope == Scope.CURRENT) {
            return ((ProjectScope)this.scope.getItemAt(1)).getProject();
        }
        assert (this.defaultScope == Scope.USER_SPECIFIED);
        return ((ProjectScope)this.scope.getSelectedItem()).getProject();
    }

    String getBaseMethodDescription() {
        if (this.baseVirtualMethod != null) {
            String functionDisplayName = this.baseVirtualMethod.getSignature().toString();
            String displayClassName = this.methodDeclaringSuperClass.getName().toString();
            return this.getString("DSC_MethodUsages", functionDisplayName, displayClassName);
        }
        return this.name;
    }

    CsmClass getMethodDeclaringClass() {
        return this.isMethodFromBaseClass() ? this.methodDeclaringSuperClass : this.methodDeclaringClass;
    }

    public void uninitialize() {
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        try {
            CsmCacheManager.enter();
            this.initializeImpl();
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    private void initializeImpl() {
        String labelText;
        ProjectScope allProjects;
        ArrayList<ProjectScope> currentProjects;
        CsmFile refObjFile;
        if (this.initialized) {
            return;
        }
        this.initFields();
        CsmObject refObject = this.getReferencedObject();
        CsmProject refObjectPrj = null;
        if (CsmKindUtilities.isOffsetable((Object)refObject) && (refObjFile = ((CsmOffsetable)refObject).getContainingFile()) != null) {
            refObjectPrj = refObjFile.getProject();
        }
        if (refObject != null && !CsmKindUtilities.isLocalVariable((CsmObject)refObject)) {
            Collection<Project> ps = CsmRefactoringUtils.getContextProjects(this.origObject);
            if (!ps.isEmpty()) {
                this.defaultScope = Scope.USER_SPECIFIED;
                currentProjects = new ArrayList<ProjectScope>();
                Icon icon = null;
                for (Project p : ps) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                    icon = pi.getIcon();
                    CsmProject prj = CsmModelAccessor.getModel().getProject((Object)p);
                    ProjectScope prjScope = new ProjectScope(new JLabel(pi.getDisplayName(), icon, 2), prj);
                    currentProjects.add(prjScope);
                }
                allProjects = new ProjectScope(new JLabel(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_AllProjects"), icon, 2), null);
            } else {
                this.defaultScope = Scope.ALL;
                currentProjects = null;
                allProjects = null;
            }
        } else if (CsmKindUtilities.isLocalVariable((CsmObject)refObject) && refObjectPrj != null) {
            this.defaultScope = Scope.CURRENT;
            ProjectScope prjScope = new ProjectScope(null, refObjectPrj);
            currentProjects = new ArrayList();
            currentProjects.add(prjScope);
            allProjects = null;
        } else {
            this.defaultScope = Scope.ALL;
            currentProjects = null;
            allProjects = null;
        }
        String _isBaseClassText = null;
        boolean _needVirtualMethodPanel = false;
        boolean _needClassPanel = false;
        if (CsmKindUtilities.isMethod((CsmObject)refObject)) {
            CsmMethod method = (CsmMethod)CsmBaseUtilities.getFunctionDeclaration((CsmFunction)((CsmFunction)refObject));
            String functionDisplayName = CsmDisplayUtilities.htmlize((CharSequence)method.getSignature().toString());
            this.methodDeclaringClass = method.getContainingClass();
            String displayClassName = this.methodDeclaringClass.getName().toString();
            labelText = this.getString("DSC_MethodUsages", functionDisplayName, displayClassName);
            CsmVirtualInfoQuery query = CsmVirtualInfoQuery.getDefault();
            if (query.isVirtual(method)) {
                Collection baseMethods = query.getTopmostBaseDeclarations(method);
                CsmMethod csmMethod = this.baseVirtualMethod = baseMethods.isEmpty() ? method : (CsmMethod)baseMethods.iterator().next();
                assert (this.baseVirtualMethod != null) : "virtual method must have start virtual declaration";
                this.methodDeclaringSuperClass = this.baseVirtualMethod.getContainingClass();
                if (!method.equals(this.baseVirtualMethod)) {
                    _isBaseClassText = this.getString("LBL_UsagesOfBaseClass", this.methodDeclaringSuperClass.getName().toString());
                }
                _needVirtualMethodPanel = true;
            }
        } else if (CsmKindUtilities.isFunction((CsmObject)refObject)) {
            String functionFQN = ((CsmFunction)refObject).getSignature().toString();
            functionFQN = CsmDisplayUtilities.htmlize((CharSequence)functionFQN);
            labelText = this.getString("DSC_FunctionUsages", functionFQN);
        } else if (CsmKindUtilities.isClass((CsmObject)refObject)) {
            CsmDeclaration.Kind classKind = ((CsmDeclaration)refObject).getKind();
            String key = classKind == CsmDeclaration.Kind.STRUCT ? "DSC_StructUsages" : (classKind == CsmDeclaration.Kind.UNION ? "DSC_UnionUsages" : "DSC_ClassUsages");
            labelText = this.getString(key, ((CsmClassifier)refObject).getQualifiedName().toString());
            _needClassPanel = true;
        } else if (CsmKindUtilities.isTypedef((CsmObject)refObject)) {
            String tdName = ((CsmTypedef)refObject).getQualifiedName().toString();
            labelText = this.getString("DSC_TypedefUsages", tdName);
        } else if (CsmKindUtilities.isTypeAlias((CsmObject)refObject)) {
            String taName = ((CsmTypeAlias)refObject).getQualifiedName().toString();
            labelText = this.getString("DSC_TypeAliasUsages", taName);
        } else if (CsmKindUtilities.isEnum((CsmObject)refObject)) {
            labelText = this.getString("DSC_EnumUsages", ((CsmEnum)refObject).getQualifiedName().toString());
        } else if (CsmKindUtilities.isEnumerator((Object)refObject)) {
            CsmEnumerator enmtr = (CsmEnumerator)refObject;
            labelText = this.getString("DSC_EnumeratorUsages", enmtr.getName().toString(), enmtr.getEnumeration().getName().toString());
        } else if (CsmKindUtilities.isField((CsmObject)refObject)) {
            String fieldName = ((CsmField)refObject).getName().toString();
            String displayClassName = ((CsmField)refObject).getContainingClass().getName().toString();
            labelText = this.getString("DSC_FieldUsages", fieldName, displayClassName);
        } else if (CsmKindUtilities.isVariable((CsmObject)refObject)) {
            String varName = ((CsmVariable)refObject).getName().toString();
            labelText = this.getString("DSC_VariableUsages", varName);
        } else if (CsmKindUtilities.isFile((CsmObject)refObject)) {
            String fileName = ((CsmFile)refObject).getName().toString();
            labelText = this.getString("DSC_FileUsages", fileName);
        } else if (CsmKindUtilities.isNamespace((Object)refObject)) {
            String nsName = ((CsmNamespace)refObject).getQualifiedName().toString();
            labelText = this.getString("DSC_NamespaceUsages", nsName);
        } else if (CsmKindUtilities.isMacro((CsmObject)refObject)) {
            StringBuilder macroName = new StringBuilder(((CsmMacro)refObject).getName());
            if (((CsmMacro)refObject).getParameters() != null) {
                macroName.append("(");
                Iterator params = ((CsmMacro)refObject).getParameters().iterator();
                if (params.hasNext()) {
                    macroName.append((CharSequence)params.next());
                    while (params.hasNext()) {
                        macroName.append(", ");
                        macroName.append((CharSequence)params.next());
                    }
                }
                macroName.append(")");
            }
            labelText = this.getString("DSC_MacroUsages", macroName.toString());
        } else {
            labelText = CsmKindUtilities.isQualified((CsmObject)refObject) ? ((CsmQualifiedNamedElement)refObject).getQualifiedName().toString() : (refObject != null ? this.name : this.getString("DSC_ElNotAvail", this.name));
        }
        if (refObject != null) {
            this.name = labelText;
        }
        final String isBaseClassText = _isBaseClassText;
        final boolean showMethodPanel = _needVirtualMethodPanel;
        final boolean showClassPanel = _needClassPanel;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WhereUsedPanel.this.remove(WhereUsedPanel.this.classesPanel);
                WhereUsedPanel.this.remove(WhereUsedPanel.this.methodsPanel);
                WhereUsedPanel.this.label.setText(labelText);
                if (showMethodPanel) {
                    WhereUsedPanel.this.add((Component)WhereUsedPanel.this.methodsPanel, "Center");
                    WhereUsedPanel.this.methodsPanel.setVisible(true);
                    if (isBaseClassText != null) {
                        Mnemonics.setLocalizedText((AbstractButton)WhereUsedPanel.this.m_isBaseClass, (String)isBaseClassText);
                        WhereUsedPanel.this.m_isBaseClass.setVisible(true);
                        WhereUsedPanel.this.m_isBaseClass.setSelected(true);
                    } else {
                        WhereUsedPanel.this.m_isBaseClass.setVisible(false);
                        WhereUsedPanel.this.m_isBaseClass.setSelected(false);
                    }
                } else if (showClassPanel) {
                    WhereUsedPanel.this.add((Component)WhereUsedPanel.this.classesPanel, "Center");
                    WhereUsedPanel.this.classesPanel.setVisible(true);
                }
                if (currentProjects != null) {
                    Object[] model = new Object[currentProjects.size() + 1];
                    model[0] = allProjects;
                    for (int i = 0; i < currentProjects.size(); ++i) {
                        model[i + 1] = currentProjects.get(i);
                    }
                    WhereUsedPanel.this.scope.setModel(new DefaultComboBoxModel<Object>(model));
                    WhereUsedPanel.this.scope.setRenderer(new JLabelRenderer());
                    if (WhereUsedPanel.this.defaultScope == Scope.CURRENT) {
                        WhereUsedPanel.this.scopePanel.setVisible(false);
                        WhereUsedPanel.this.scope.setSelectedIndex(1);
                    } else {
                        int defaultItem = RefactoringModule.getOption("whereUsed.scope", 0);
                        WhereUsedPanel.this.scope.setSelectedIndex(defaultItem);
                    }
                } else {
                    WhereUsedPanel.this.scopePanel.setVisible(false);
                }
                WhereUsedPanel.this.validate();
            }
        });
        this.initialized = true;
    }

    CsmMethod getBaseMethod() {
        return this.baseVirtualMethod;
    }

    CsmObject getReferencedObject() {
        return this.refObjectUID == null ? null : (CsmObject)this.refObjectUID.getObject();
    }

    String getDescription() {
        return this.name;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.methodsPanel = new JPanel();
        this.m_isBaseClass = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.m_overriders = new JCheckBox();
        this.m_usages = new JCheckBox();
        this.classesPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.c_subclasses = new JRadioButton();
        this.c_usages = new JRadioButton();
        this.c_directOnly = new JRadioButton();
        this.commentsPanel = new JPanel();
        this.label = new JLabel();
        this.searchInComments = new JCheckBox();
        this.scopePanel = new JPanel();
        this.scopeLabel = new JLabel();
        this.scope = new JComboBox();
        this.setLayout(new BorderLayout());
        this.methodsPanel.setLayout(new GridBagLayout());
        this.m_isBaseClass.setSelected(true);
        this.m_isBaseClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_isBaseClassActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_isBaseClass, gridBagConstraints);
        this.m_isBaseClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_isBaseClass"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.methodsPanel.add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.m_overriders, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_overridersActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_overriders, gridBagConstraints);
        this.m_overriders.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindOverridingMethods"));
        this.m_overriders.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_overriders"));
        this.m_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.m_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.setMargin(new Insets(10, 2, 2, 2));
        this.m_usages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.m_usagesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.methodsPanel.add((Component)this.m_usages, gridBagConstraints);
        this.m_usages.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.m_usages.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_usages"));
        this.add((Component)this.methodsPanel, "Center");
        this.classesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.classesPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.buttonGroup.add(this.c_subclasses);
        Mnemonics.setLocalizedText((AbstractButton)this.c_subclasses, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindAllSubtypes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_subclasses, gridBagConstraints);
        this.c_subclasses.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_subclasses"));
        this.buttonGroup.add(this.c_usages);
        this.c_usages.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.c_usages, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindUsages"));
        this.c_usages.setMargin(new Insets(4, 2, 2, 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_usages, gridBagConstraints);
        this.c_usages.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_usages"));
        this.buttonGroup.add(this.c_directOnly);
        Mnemonics.setLocalizedText((AbstractButton)this.c_directOnly, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_FindDirectSubtypesOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.classesPanel.add((Component)this.c_directOnly, gridBagConstraints);
        this.c_directOnly.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(WhereUsedPanel.class).getString("ACSD_directOnly"));
        this.add((Component)this.classesPanel, "Center");
        this.commentsPanel.setLayout(new BorderLayout());
        this.commentsPanel.add((Component)this.label, "North");
        this.searchInComments.setSelected(RefactoringModule.getOption("searchInComments.whereUsed", Boolean.FALSE));
        Mnemonics.setLocalizedText((AbstractButton)this.searchInComments, (String)NbBundle.getBundle(WhereUsedPanel.class).getString("LBL_SearchInComents"));
        this.searchInComments.setMargin(new Insets(10, 14, 2, 2));
        this.searchInComments.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WhereUsedPanel.this.searchInCommentsItemStateChanged(evt);
            }
        });
        this.commentsPanel.add((Component)this.searchInComments, "Center");
        this.searchInComments.getAccessibleContext().setAccessibleDescription(this.searchInComments.getText());
        this.add((Component)this.commentsPanel, "North");
        this.scopeLabel.setDisplayedMnemonic(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_Scope_MNEM").charAt(0));
        this.scopeLabel.setLabelFor(this.scope);
        this.scopeLabel.setText(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_Scope"));
        this.scope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WhereUsedPanel.this.scopeActionPerformed(evt);
            }
        });
        GroupLayout scopePanelLayout = new GroupLayout(this.scopePanel);
        this.scopePanel.setLayout(scopePanelLayout);
        scopePanelLayout.setHorizontalGroup(scopePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(scopePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.scopeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scope, 0, 296, Short.MAX_VALUE).addContainerGap()));
        scopePanelLayout.setVerticalGroup(scopePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scopeLabel).addComponent(this.scope, -2, 20, Short.MAX_VALUE));
        this.add((Component)this.scopePanel, "Last");
    }

    private void searchInCommentsItemStateChanged(ItemEvent evt) {
        Boolean b = evt.getStateChange() == 1 ? Boolean.TRUE : Boolean.FALSE;
        RefactoringModule.setOption("searchInComments.whereUsed", b);
    }

    private void m_isBaseClassActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_overridersActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void m_usagesActionPerformed(ActionEvent evt) {
        this.parent.stateChanged(null);
    }

    private void scopeActionPerformed(ActionEvent evt) {
        RefactoringModule.setOption("whereUsed.scope", this.scope.getSelectedIndex());
    }

    public boolean isMethodFromBaseClass() {
        return this.m_isBaseClass.isSelected();
    }

    public boolean isMethodOverriders() {
        return this.m_overriders.isSelected();
    }

    public boolean isClassSubTypes() {
        return this.c_subclasses.isSelected();
    }

    public boolean isClassSubTypesDirectOnly() {
        return this.c_directOnly.isSelected();
    }

    public boolean isMethodFindUsages() {
        return this.m_usages.isSelected();
    }

    public boolean isClassFindUsages() {
        return this.c_usages.isSelected();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension orig = super.getPreferredSize();
        return new Dimension(orig.width + 30, orig.height + 80);
    }

    public boolean isSearchInComments() {
        return this.searchInComments.isSelected();
    }

    public Component getComponent() {
        return this;
    }

    boolean isVirtualMethod() {
        return this.baseVirtualMethod != null;
    }

    boolean isClass() {
        return CsmKindUtilities.isClass((CsmObject)this.getReferencedObject());
    }

    private void initFields() {
        CsmObject refObject = this.getReferencedElement(this.origObject);
        this.refObjectUID = CsmRefactoringUtils.getHandler(refObject);
        this.name = this.getSearchElementName(refObject, this.name);
    }

    private CsmObject getReferencedElement(CsmObject csmObject) {
        CsmObject out = csmObject instanceof CsmReference ? this.getReferencedElement(((CsmReference)csmObject).getReferencedObject()) : csmObject;
        return CsmRefactoringUtils.convertToCsmObjectIfNeeded(out);
    }

    private String getSearchElementName(CsmObject csmObj, String defaultName) {
        String objName;
        if (CsmKindUtilities.isNamedElement((CsmObject)csmObj)) {
            objName = ((CsmNamedElement)csmObj).getName().toString();
        } else {
            System.err.println("Unhandled name for object " + csmObj);
            objName = defaultName;
        }
        return objName;
    }

    private CsmMethod getOriginalVirtualMethod(CsmMethod csmMethod) {
        return csmMethod;
    }

    private String getString(String key) {
        return NbBundle.getBundle(WhereUsedPanel.class).getString(key);
    }

    private String getString(String key, String value) {
        return NbBundle.getMessage(WhereUsedPanel.class, (String)key, (Object)value);
    }

    private String getString(String key, String value1, String value2) {
        return NbBundle.getMessage(WhereUsedPanel.class, (String)key, (Object)value1, (Object)value2);
    }

    private static class JLabelRenderer
    extends JLabel
    implements ListCellRenderer {
        public JLabelRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (value != null && ((ProjectScope)value).getLabel() != null) {
                this.setText(((ProjectScope)value).getLabel().getText());
                this.setIcon(((ProjectScope)value).getLabel().getIcon());
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private static final class ProjectScope {
        JLabel label;
        CsmProject project;

        public ProjectScope(JLabel label, CsmProject project) {
            this.label = label;
            this.project = project;
        }

        public CsmProject getProject() {
            return this.project;
        }

        public JLabel getLabel() {
            return this.label;
        }

        public String toString() {
            return this.label == null ? "null" : this.label.getText();
        }
    }

    public static enum Scope {
        ALL,
        CURRENT,
        USER_SPECIFIED;

    }
}

