/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Utilities;

public class JSUtils {
    private static final Logger LOG = Logger.getLogger(JSUtils.class.getName());
    public static final String JS_MIME_TYPE = "text/javascript";

    public static Line getCurrentLine() {
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (fo == null) {
            return null;
        }
        if (!JS_MIME_TYPE.equalsIgnoreCase(fo.getMIMEType())) {
            return null;
        }
        return EditorContextDispatcher.getDefault().getCurrentLine();
    }

    public static Line getLine(String filePath, int lineNumber) {
        if (filePath == null || lineNumber < 0) {
            return null;
        }
        FileObject fileObject = null;
        URI uri = URI.create(filePath);
        if (uri.isAbsolute()) {
            URL url;
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException muex) {
                LOG.log(Level.INFO, "Cannot resolve " + filePath, muex);
                return null;
            }
            fileObject = URLMapper.findFileObject((URL)url);
        }
        if (fileObject == null) {
            File file = filePath.startsWith("file:/") ? Utilities.toFile((URI)uri) : new File(filePath);
            fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        if (fileObject == null) {
            LOG.log(Level.INFO, "Cannot resolve \"{0}\"", filePath);
            return null;
        }
        LineCookie lineCookie = JSUtils.getLineCookie(fileObject);
        if (lineCookie == null) {
            LOG.log(Level.INFO, "No line cookie for \"{0}\"", fileObject);
            return null;
        }
        try {
            return lineCookie.getLineSet().getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ioob) {
            List lines = lineCookie.getLineSet().getLines();
            if (lines.size() > 0) {
                return (Line)lines.get(lines.size() - 1);
            }
            return null;
        }
    }

    public static Line getLine(FileObject fileObject, int lineNumber) {
        Line.Set ls;
        LineCookie lineCookie;
        if (fileObject != null && (lineCookie = JSUtils.getLineCookie(fileObject)) != null && (ls = lineCookie.getLineSet()) != null) {
            try {
                return ls.getCurrent(lineNumber - 1);
            }
            catch (IndexOutOfBoundsException ioob) {
                List lines = ls.getLines();
                if (lines.size() > 0) {
                    return (Line)lines.get(lines.size() - 1);
                }
                return null;
            }
        }
        return null;
    }

    public static LineCookie getLineCookie(FileObject fo) {
        LineCookie result = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject != null) {
                result = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getFileName(JSLineBreakpoint b) {
        FileObject fo = (FileObject)b.getLine().getLookup().lookup(FileObject.class);
        if (fo != null) {
            return fo.getNameExt();
        }
        URL url = b.getURL();
        String fileName = url.getPath();
        int i = fileName.lastIndexOf(47);
        if (i < 0) {
            i = fileName.lastIndexOf(File.separatorChar);
        }
        if (i >= 0) {
            fileName = fileName.substring(i + 1);
        }
        return fileName;
    }
}

