/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.debug.annotation;

import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.javascript2.debug.annotation.Bundle;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.ErrorManager;
import org.openide.text.Annotatable;

public final class LineBreakpointAnnotation
extends BreakpointAnnotation {
    public static final String BREAKPOINT_ANNOTATION_TYPE = "Breakpoint";
    public static final String DISABLED_BREAKPOINT_ANNOTATION_TYPE = "DisabledBreakpoint";
    public static final String CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "CondBreakpoint";
    public static final String DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "DisabledCondBreakpoint";
    public static final String DEACTIVATED_BREAKPOINT_SUFFIX = "_stroke";
    public static final String BROKEN_BREAKPOINT_SUFFIX = "_broken";
    private final String type;
    private final Breakpoint breakpoint;

    public LineBreakpointAnnotation(Annotatable annotatable, JSLineBreakpoint b, boolean active) {
        this.breakpoint = b;
        this.type = LineBreakpointAnnotation.getAnnotationType(b, active);
        this.attach(annotatable);
    }

    public String getAnnotationType() {
        return this.type;
    }

    public String getShortDescription() {
        if (this.type.endsWith(BROKEN_BREAKPOINT_SUFFIX)) {
            if (this.breakpoint.getValidity() == Breakpoint.VALIDITY.INVALID) {
                String msg = this.breakpoint.getValidityMessage();
                return Bundle.TOOLTIP_BREAKPOINT_BROKEN_INVALID(msg);
            }
            return Bundle.TOOLTIP_BREAKPOINT_BROKEN();
        }
        if (this.type == BREAKPOINT_ANNOTATION_TYPE) {
            return Bundle.TOOLTIP_BREAKPOINT();
        }
        if (this.type == DISABLED_BREAKPOINT_ANNOTATION_TYPE) {
            return Bundle.TOOLTIP_DISABLED_BREAKPOINT();
        }
        if (this.type == CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE) {
            return Bundle.TOOLTIP_CONDITIONAL_BREAKPOINT();
        }
        if (this.type == DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE) {
            return Bundle.TOOLTIP_DISABLED_CONDITIONAL_BREAKPOINT();
        }
        if (this.type.endsWith(DEACTIVATED_BREAKPOINT_SUFFIX)) {
            return Bundle.TOOLTIP_ALL_BREAKPOINTS_DEACTIVATED();
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown breakpoint type '" + this.type + "'."));
        return null;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }

    private static String getAnnotationType(JSLineBreakpoint b, boolean active) {
        String annotationType;
        boolean isInvalid = b.getValidity() == Breakpoint.VALIDITY.INVALID;
        boolean conditional = b.isConditional();
        String string = b.isEnabled() ? (conditional ? CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : BREAKPOINT_ANNOTATION_TYPE) : (annotationType = conditional ? DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : DISABLED_BREAKPOINT_ANNOTATION_TYPE);
        if (!active) {
            annotationType = annotationType + DEACTIVATED_BREAKPOINT_SUFFIX;
        } else if (isInvalid && b.isEnabled()) {
            annotationType = annotationType + BROKEN_BREAKPOINT_SUFFIX;
        }
        return annotationType;
    }
}

