/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class LatteSyntax {
    public static final Set<String> BLOCK_MACROS = new HashSet<String>(Arrays.asList("if", "ifset", "ifcurrent", "foreach", "for", "while", "first", "last", "sep", "capture", "cache", "syntax", "form", "label", "snippet"));
    public static final Set<String> ELSE_MACROS = new HashSet<String>(Arrays.asList("elseif", "else", "elseifset"));
    public static final Map<String, Set<String>> RELATED_MACROS = new HashMap<String, Set<String>>(){
        {
            this.put("if", new HashSet<String>(Arrays.asList("else", "elseif")));
            this.put("ifset", new HashSet<String>(Arrays.asList("else", "elseifset")));
        }
    };

    private LatteSyntax() {
    }

    public static boolean isBlockMacro(String macro) {
        assert (macro != null);
        String macroName = macro.toLowerCase();
        return !macroName.isEmpty() && (BLOCK_MACROS.contains(macroName) || BLOCK_MACROS.contains(macroName.substring(1)) || ELSE_MACROS.contains(macroName));
    }

    public static boolean isElseMacro(String macro) {
        assert (macro != null);
        String macroName = macro.toLowerCase();
        return ELSE_MACROS.contains(macroName);
    }

    public static boolean isRelatedMacro(String actualMacro, String relatedToMacro) {
        assert (actualMacro != null && actualMacro.length() > 0);
        assert (relatedToMacro != null);
        return actualMacro.substring(1).equals(relatedToMacro) || RELATED_MACROS.get(relatedToMacro) != null && RELATED_MACROS.get(relatedToMacro).contains(actualMacro);
    }
}

