/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.braces;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.latte.lexer.LatteMarkupTokenId;
import org.netbeans.modules.php.latte.lexer.LatteTopTokenId;
import org.netbeans.modules.php.latte.utils.LatteLexerUtils;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;

public class LatteBracesMatcher
implements BracesMatcher {
    private static final List<Matcher> MATCHERS = new ArrayList<Matcher>();
    private final MatcherContext context;

    private LatteBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws InterruptedException, BadLocationException {
        int[] result = null;
        BaseDocument document = (BaseDocument)this.context.getDocument();
        document.readLock();
        try {
            result = this.findOriginUnderLock();
        }
        finally {
            document.readUnlock();
        }
        return result;
    }

    private int[] findOriginUnderLock() {
        int[] result = null;
        TokenSequence<? extends LatteMarkupTokenId> ts = LatteLexerUtils.getLatteMarkupTokenSequence(this.context.getDocument(), this.context.getSearchOffset());
        if (ts != null) {
            result = this.findOriginInSequence(ts);
        }
        return result;
    }

    private int[] findOriginInSequence(TokenSequence<? extends LatteMarkupTokenId> ts) {
        LatteMarkupTokenId currentTokenId;
        Token currentToken;
        int[] result = null;
        ts.move(this.context.getSearchOffset());
        if (ts.moveNext() && (currentToken = ts.token()) != null && ((currentTokenId = (LatteMarkupTokenId)currentToken.id()) == LatteMarkupTokenId.T_MACRO_START || currentTokenId == LatteMarkupTokenId.T_MACRO_END)) {
            result = new int[]{ts.offset(), ts.offset() + currentToken.length()};
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        int[] result = null;
        BaseDocument document = (BaseDocument)this.context.getDocument();
        document.readLock();
        try {
            result = this.findMatchesUnderLock();
        }
        finally {
            document.readUnlock();
        }
        return result;
    }

    private int[] findMatchesUnderLock() {
        int[] result = null;
        TokenSequence<? extends LatteTopTokenId> topTs = LatteLexerUtils.getLatteTopTokenSequence(this.context.getDocument(), this.context.getSearchOffset());
        if (topTs != null) {
            result = this.findMatchesInTopSequence(topTs);
        }
        return result;
    }

    private int[] findMatchesInTopSequence(TokenSequence<? extends LatteTopTokenId> topTs) {
        assert (topTs != null);
        int[] result = null;
        topTs.move(this.context.getSearchOffset());
        topTs.moveNext();
        TokenSequence ts = topTs.embeddedJoined(LatteMarkupTokenId.language());
        if (ts != null) {
            result = this.findMatchesInEmbeddedSequence(topTs, (TokenSequence<LatteMarkupTokenId>)ts);
        }
        return result;
    }

    private int[] findMatchesInEmbeddedSequence(TokenSequence<? extends LatteTopTokenId> topTs, TokenSequence<LatteMarkupTokenId> embeddedTs) {
        Token currentToken;
        int[] result = null;
        embeddedTs.move(this.context.getSearchOffset());
        if (embeddedTs.moveNext() && (currentToken = embeddedTs.token()) != null) {
            result = this.processMatchers((Token<? extends LatteMarkupTokenId>)currentToken, topTs);
        }
        return result;
    }

    private int[] processMatchers(Token<? extends LatteMarkupTokenId> currentToken, TokenSequence<? extends LatteTopTokenId> topTs) {
        int[] result = null;
        for (Matcher matcher : MATCHERS) {
            if (!matcher.matches(currentToken)) continue;
            result = matcher.findMatches(currentToken, topTs);
            break;
        }
        return result;
    }

    private static int[] createMatches(List<OffsetRange> offsetRanges) {
        int[] result = null;
        if (!offsetRanges.isEmpty()) {
            int resultSize = offsetRanges.size() * 2;
            result = new int[resultSize];
            int i = 0;
            int j = 0;
            while (i < offsetRanges.size()) {
                result[j] = offsetRanges.get(i).getStart();
                result[j + 1] = offsetRanges.get(i).getEnd();
                ++i;
                j += 2;
            }
        }
        return result;
    }

    static {
        MATCHERS.add(new StartEndMacroMatcher("define"));
        MATCHERS.add(new StartEndMacroMatcher("ifCurrent"));
        MATCHERS.add(new StartEndMacroMatcher("for"));
        MATCHERS.add(new StartEndMacroMatcher("foreach"));
        MATCHERS.add(new StartEndMacroMatcher("while"));
        MATCHERS.add(new StartEndMacroMatcher("first"));
        MATCHERS.add(new StartEndMacroMatcher("last"));
        MATCHERS.add(new StartEndMacroMatcher("sep"));
        MATCHERS.add(new StartEndMacroMatcher("capture"));
        MATCHERS.add(new StartEndMacroMatcher("cache"));
        MATCHERS.add(new StartEndMacroMatcher("syntax"));
        MATCHERS.add(new StartEndMacroMatcher("_"));
        MATCHERS.add(new StartEndMacroMatcher("block"));
        MATCHERS.add(new StartEndMacroMatcher("form"));
        MATCHERS.add(new StartEndMacroMatcher("label"));
        MATCHERS.add(new StartEndMacroMatcher("snippet"));
        MATCHERS.add(new IfMatcher());
        MATCHERS.add(new IfsetMatcher());
        MATCHERS.add(new EndIfMatcher());
        MATCHERS.add(new EndIfsetMatcher());
        MATCHERS.add(new ElseMatcher());
        MATCHERS.add(new ElseIfMatcher());
        MATCHERS.add(new ElseIfsetMatcher());
    }

    public static final class Factory
    implements BracesMatcherFactory {
        public BracesMatcher createMatcher(MatcherContext context) {
            return new LatteBracesMatcher(context);
        }
    }

    private static final class ElseIfsetMatcher
    extends MultiMatcher {
        private ElseIfsetMatcher() {
        }

        @Override
        protected LatteLexerUtils.LatteTokenText matchingToken() {
            return ELSE_IFSET_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends LatteMarkupTokenId> token, TokenSequence<? extends LatteTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = LatteLexerUtils.findBackwardMatching(topTs, END_IFSET_TOKEN, IFSET_TOKEN, Arrays.asList(ELSE_IFSET_TOKEN, ELSE_TOKEN));
            offsetRanges.addAll(LatteLexerUtils.findForwardMatching(topTs, IFSET_TOKEN, END_IFSET_TOKEN, Arrays.asList(ELSE_IFSET_TOKEN, ELSE_TOKEN)));
            return LatteBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static final class ElseIfMatcher
    extends MultiMatcher {
        private ElseIfMatcher() {
        }

        @Override
        protected LatteLexerUtils.LatteTokenText matchingToken() {
            return ELSE_IF_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends LatteMarkupTokenId> token, TokenSequence<? extends LatteTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = LatteLexerUtils.findBackwardMatching(topTs, END_IF_TOKEN, IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN));
            offsetRanges.addAll(LatteLexerUtils.findForwardMatching(topTs, IF_TOKEN, END_IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN)));
            return LatteBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static final class ElseMatcher
    extends MultiMatcher {
        private ElseMatcher() {
        }

        @Override
        protected LatteLexerUtils.LatteTokenText matchingToken() {
            return ELSE_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends LatteMarkupTokenId> token, TokenSequence<? extends LatteTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = LatteLexerUtils.findBackwardMatching(topTs, END_IF_TOKEN, IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN));
            offsetRanges.addAll(LatteLexerUtils.findForwardMatching(topTs, IF_TOKEN, END_IF_TOKEN, Arrays.asList(LatteLexerUtils.LatteTokenText.NONE)));
            if (offsetRanges.isEmpty()) {
                offsetRanges.addAll(LatteLexerUtils.findBackwardMatching(topTs, END_IFSET_TOKEN, IFSET_TOKEN, Arrays.asList(ELSE_IFSET_TOKEN, ELSE_TOKEN)));
                offsetRanges.addAll(LatteLexerUtils.findForwardMatching(topTs, IFSET_TOKEN, END_IFSET_TOKEN, Arrays.asList(LatteLexerUtils.LatteTokenText.NONE)));
            }
            return LatteBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static final class EndIfsetMatcher
    extends MultiMatcher {
        private EndIfsetMatcher() {
        }

        @Override
        protected LatteLexerUtils.LatteTokenText matchingToken() {
            return END_IFSET_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends LatteMarkupTokenId> token, TokenSequence<? extends LatteTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = LatteLexerUtils.findBackwardMatching(topTs, END_IFSET_TOKEN, IFSET_TOKEN, Arrays.asList(ELSE_IFSET_TOKEN, ELSE_TOKEN));
            return LatteBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static final class EndIfMatcher
    extends MultiMatcher {
        private EndIfMatcher() {
        }

        @Override
        protected LatteLexerUtils.LatteTokenText matchingToken() {
            return END_IF_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends LatteMarkupTokenId> token, TokenSequence<? extends LatteTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = LatteLexerUtils.findBackwardMatching(topTs, END_IF_TOKEN, IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN));
            return LatteBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static final class IfsetMatcher
    extends MultiMatcher {
        private IfsetMatcher() {
        }

        @Override
        protected LatteLexerUtils.LatteTokenText matchingToken() {
            return IFSET_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends LatteMarkupTokenId> token, TokenSequence<? extends LatteTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = LatteLexerUtils.findForwardMatching(topTs, IFSET_TOKEN, END_IFSET_TOKEN, Arrays.asList(ELSE_IFSET_TOKEN, ELSE_TOKEN));
            return LatteBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static final class IfMatcher
    extends MultiMatcher {
        private IfMatcher() {
        }

        @Override
        protected LatteLexerUtils.LatteTokenText matchingToken() {
            return IF_TOKEN;
        }

        @Override
        public int[] findMatches(Token<? extends LatteMarkupTokenId> token, TokenSequence<? extends LatteTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            List<OffsetRange> offsetRanges = LatteLexerUtils.findForwardMatching(topTs, IF_TOKEN, END_IF_TOKEN, Arrays.asList(ELSE_IF_TOKEN, ELSE_TOKEN));
            return LatteBracesMatcher.createMatches(offsetRanges);
        }
    }

    private static abstract class MultiMatcher
    implements Matcher {
        protected static final LatteLexerUtils.LatteTokenText IF_TOKEN = LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_START, "if");
        protected static final LatteLexerUtils.LatteTokenText IFSET_TOKEN = LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_START, "ifset");
        protected static final LatteLexerUtils.LatteTokenText ELSE_IF_TOKEN = LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_START, "elseif");
        protected static final LatteLexerUtils.LatteTokenText ELSE_IFSET_TOKEN = LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_START, "elseifset");
        protected static final LatteLexerUtils.LatteTokenText ELSE_TOKEN = LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_START, "else");
        protected static final LatteLexerUtils.LatteTokenText END_IF_TOKEN = LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_END, "/if");
        protected static final LatteLexerUtils.LatteTokenText END_IFSET_TOKEN = LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_END, "/ifset");

        private MultiMatcher() {
        }

        @Override
        public boolean matches(Token<? extends LatteMarkupTokenId> token) {
            return this.matchingToken().matches(token);
        }

        protected abstract LatteLexerUtils.LatteTokenText matchingToken();
    }

    private static final class StartEndMacroMatcher
    implements Matcher {
        private static final String END = "/";
        private final String macroName;

        public StartEndMacroMatcher(String macroName) {
            assert (macroName != null);
            this.macroName = macroName;
        }

        @Override
        public boolean matches(Token<? extends LatteMarkupTokenId> token) {
            assert (token != null);
            return !(token.id() != LatteMarkupTokenId.T_MACRO_START && token.id() != LatteMarkupTokenId.T_MACRO_END || !this.macroName.equals(token.text().toString()) && !(END + this.macroName).equals(token.text().toString()));
        }

        @Override
        public int[] findMatches(Token<? extends LatteMarkupTokenId> token, TokenSequence<? extends LatteTopTokenId> topTs) {
            assert (token != null);
            assert (topTs != null);
            int[] result = null;
            String tagText = token.text().toString();
            if (tagText.equals(this.macroName)) {
                List<OffsetRange> offsetRanges = LatteLexerUtils.findForwardMatching(topTs, LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_START, this.macroName), LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_END, END + this.macroName));
                result = LatteBracesMatcher.createMatches(offsetRanges);
            } else if (tagText.equals(END + this.macroName)) {
                List<OffsetRange> offsetRanges = LatteLexerUtils.findBackwardMatching(topTs, LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_END, END + this.macroName), LatteLexerUtils.LatteTokenTextImpl.create(LatteMarkupTokenId.T_MACRO_START, this.macroName));
                result = LatteBracesMatcher.createMatches(offsetRanges);
            }
            return result;
        }
    }

    private static interface Matcher {
        public boolean matches(Token<? extends LatteMarkupTokenId> var1);

        public int[] findMatches(Token<? extends LatteMarkupTokenId> var1, TokenSequence<? extends LatteTopTokenId> var2);
    }
}

