/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import org.eclipse.mylyn.internal.bugzilla.core.Messages;

public interface IBugzillaConstants {
    public static final String PROPERTY_CONFIGTIMESTAMP = "org.eclipse.mylyn.tasklist.repositories.config.timestamp";
    public static final String ERROR_MIDAIR_COLLISION = "collision";
    public static final String ERROR_MSG_MIDAIR_COLLISION = "A mid-air collision has occurred. Please synchronize by selecting Synchronize in the task's context menu.";
    public static final String ERROR_COMMENT_REQUIRED = "comment required";
    public static final String ERROR_MSG_COMMENT_REQUIRED = "You have to specify a new comment when making this change. Please comment on the reason for this change.";
    public static final String ERROR_INVALID_USERNAME_OR_PASSWORD = "Invalid Username or Password";
    public static final String LOGGED_OUT = "logged out";
    public static final String MOST_RECENT_QUERY = "org.eclipse.mylyn.bugzilla.query.last";
    public static final String SERVER_VERSION = "org.eclipse.mylyn.bugzilla.server.version";
    public static final int RETURN_ALL_HITS = -1;
    public static final String CONTENT_TYPE_RDF = "&ctype=rdf";
    public static final String POST_INPUT_BUGZILLA_PASSWORD = "Bugzilla_password";
    public static final String POST_INPUT_BUGZILLA_LOGIN = "Bugzilla_login";
    public static final String POST_INPUT_BUGID = "bugid";
    public static final String POST_INPUT_ACTION = "action";
    public static final String POST_INPUT_COMMENT = "comment";
    public static final String POST_INPUT_DESCRIPTION = "description";
    public static final String POST_INPUT_DATA = "data";
    public static final String URL_POST_LOGIN = "/index.cgi?GoAheadAndLogIn=1";
    public static final String URL_POST_ATTACHMENT_UPLOAD = "/attachment.cgi";
    public static final String URL_BUGLIST = "/buglist.cgi";
    public static final String URL_GET_ATTACHMENT_DOWNLOAD = "/attachment.cgi?id=";
    public static final String URL_GET_ATTACHMENT_SUFFIX = "/attachment.cgi?id=";
    public static final String URL_BUG_ACTIVITY = "/show_activity.cgi?id=";
    public static final String URL_SHOW_VOTES = "/votes.cgi?action=show_bug&bug_id=";
    public static final String URL_VOTE = "/votes.cgi?action=show_user&bug_id=";
    public static final String URL_DEPENDENCY_TREE = "/showdependencytree.cgi?id=";
    public static final String URL_DEPENDENCY_GRAPH = "/showdependencygraph.cgi?id=";
    public static final String URL_GET_SHOW_BUG = "/show_bug.cgi?id=";
    public static final String URL_GET_CONFIG_RDF = "/config.cgi?ctype=rdf";
    public static final String URL_GET_SHOW_BUG_XML = "/show_bug.cgi?ctype=xml&excludefield=attachmentdata&id=";
    public static final String URL_GET_SHOW_BUG_XML_NOID = "/show_bug.cgi?ctype=xml&excludefield=attachmentdata";
    public static final String URL_POST_SHOW_BUG = "/show_bug.cgi";
    public static final String XML_ERROR_INVALIDBUGID = "invalidbugid";
    public static final String XML_ERROR_NOTFOUND = "notfound";
    public static final String XML_ERROR_NOTPERMITTED = "notpermitted";
    public static final String ENCODING_UTF_8 = "UTF-8";
    public static final int REPOSITORY_STATUS_SUSPICIOUS_ACTION = 99;
    public static final BugzillaServerVersion SERVER_VERSION_DEFAULT = BugzillaServerVersion.SERVER_30;
    public static final String REFRESH_QUERY = "org.eclipse.mylyn.bugzilla.query.refresh";
    public static final String MAX_RESULTS = "org.eclipse.mylyn.bugzilla.search.results.max";
    public static final String VALUES_STATUS = "org.eclipse.mylyn.bugzilla.values.status";
    public static final String VALUES_RESOLUTION = "org.eclipse.mylyn.bugzilla.values.resolution";
    public static final String VALUES_COMPONENT = "org.eclipse.mylyn.bugzilla.values.component";
    public static final String VALUES_VERSION = "org.eclipse.mylyn.bugzilla.values.version";
    public static final String VALUES_TARGET = "org.eclipse.mylyn.bugzilla.values.target";
    public static final String[] DEFAULT_STATUS_VALUES = new String[]{"Unconfirmed", "New", "Assigned", "Reopened", "Resolved", "Verified", "Closed"};
    public static final String[] DEFAULT_PRESELECTED_STATUS_VALUES = new String[]{"New", "Assigned", "Reopened"};
    public static final String[] DEFAULT_SEVERITY_VALUES = new String[]{"blocker", "critical", "major", "normal", "minor", "trivial", "enhancement"};
    public static final String[] DEFAULT_PRIORITY_VALUES = new String[]{"P1", "P2", "P3", "P4", "P5"};
    public static final String[] DEFAULT_HARDWARE_VALUES = new String[]{"All", "Macintosh", "PC", "Power PC", "Sun", "Other"};
    public static final String[] DEFAULT_OS_VALUES = new String[]{"All", "AIX Motif", "Windows 95", "Windows 98", "Windows CE", "Windows ME", "Windows 2000", "Windows NT", "Windows XP", "Windows All", "MacOS X", "Linux", "Linux-GTK", "Linux-Motif", "HP-UX", "Neutrino", "QNX-Photon", "Solaris", "Unix All", "other"};
    public static final String[] DEFAULT_PRODUCT_VALUES = new String[0];
    public static final String[] DEFAULT_COMPONENT_VALUES = new String[0];
    public static final String[] DEFAULT_VERSION_VALUES = new String[0];
    public static final String[] DEFAULT_TARGET_VALUES = new String[0];
    public static final String TITLE_MESSAGE_DIALOG = Messages.IBugzillaConstants_Mylyn_Bugzilla_Connector;
    public static final String MESSAGE_LOGIN_FAILURE = Messages.IBugzillaConstants_Bugzilla_login_information_or_repository_version_incorrect;
    public static final String INVALID_2201_ATTRIBUTE_IGNORED = "EclipsebugsBugzilla2.20.1";
    public static final String VALUE_STATUS_RESOLVED = "RESOLVED";
    public static final String VALUE_STATUS_NEW = "NEW";
    public static final String VALUE_STATUS_CLOSED = "CLOSED";
    public static final String VALUE_STATUS_ASSIGNED = "ASSIGNED";
    public static final String VALUE_STATUS_VERIFIED = "VERIFIED";
    public static final String VALUE_RESOLUTION_LATER = "LATER";
    public static final String ERROR_MSG_OP_NOT_PERMITTED = Messages.IBugzillaConstants_requested_operation_not_permitted;
    public static final String ERROR_MSG_INVALID_BUG_ID = Messages.IBugzillaConstants_invalid_bug_id_requested_bug_id_does_not_exist;
    public static final String ERROR_MSG_NOT_FOUND_BUG_ID = Messages.IBugzillaConstants_Bug_id_not_found;
    public static final String ERROR_MSG_NO_DATA_RETRIEVED = Messages.IBugzillaConstants_NO_DATA_RETRIEVED_FOR_TASK;
    public static final String INVALID_CREDENTIALS = Messages.IBugzillaConstants_invalid_repository_credentials;
    public static final String SHOW_ACTIVITY = "/show_activity.cgi?id=";
    public static final String REPOSITORY_SETTING_SHORT_LOGIN = "bugzilla.shortLoginEnabled";
    public static final String BUGZILLA_TASK_KIND = "Bug";
    public static final int MAX_URL_LENGTH = 2000;
    public static final String TIMESTAMP_NOT_AVAILABLE = "n/a";
    public static final String BUGZILLA_DEF_OS = "bugzilla.default.os";
    public static final String BUGZILLA_DEF_PLATFORM = "bugzilla.default.platform";
    public static final String BUGZILLA_LANGUAGE_SETTING = "bugzilla.languageSetting";
    public static final String BUGZILLA_DESCRIPTOR_FILE = "bugzilla.desciptorFile";
    public static final String BUGZILLA_USE_XMLRPC = "bugzilla.xmlrpc.status.transition";
    public static final String DEFAULT_LANG = "en (default)";
    public static final String BUGZILLA_PARAM_USECLASSIFICATION = "bugzilla.param.use.classification";
    public static final String BUGZILLA_PARAM_USETARGETMILESTONE = "bugzilla.param.usetargetmilestone";
    public static final String BUGZILLA_PARAM_USEQACONTACT = "bugzilla.param.useqacontact";
    public static final String BUGZILLA_PARAM_USESTATUSWHITEBOARD = "bugzilla.param.usestatuswhiteboard";
    public static final String BUGZILLA_PARAM_USEBUGALIASES = "bugzilla.param.usebugaliases";
    public static final String BUGZILLA_PARAM_USE_SEE_ALSO = "bugzilla.param.use_see_also";
    public static final String BUGZILLA_INSIDER_GROUP = "bugzilla.insider.group";
    public static final String BUGZILLA_DESCRIPTION_ID = "id";
    public static final String BUGZILLA_DESCRIPTION_IS_PRIVATE = "isprivate";
    public static final String BUGZILLA_PREFIX_DEFINED_ISPRIVATE = "defined_isprivate_";
    public static final String BUGZILLA_PREFIX_ISPRIVATE = "isprivate_";
    public static final String EDITOR_TYPE_KEYWORDS = "bugzilla.editor.keywords";
    public static final String EDITOR_TYPE_REMOVECC = "bugzilla.editor.removecc";
    public static final String EDITOR_TYPE_VOTES = "bugzilla.editor.votes";
    public static final String EDITOR_TYPE_FLAG = "bugzilla.editor.flag";
    public static final String ATTRIBUTE_BUGZILLA_QUERY_CUSTOM = "bugzilla.query.custom";
    public static final String TAG_BUGZILLA_QUERY = "BugzillaQuery";
    public static final String TAG_BUGZILLA_CUSTOM_QUERY = "BugzillaCustomQuery";
    public static final String CONTENT_ENCODING_GZIP = "gzip";
    public static final String LAST_PRODUCT_SELECTION = "last.selection.product";
    public static final String LAST_COMPONENT_SELECTION = "last.selection.component";

    public static enum BUGZILLA_REPORT_STATUS {
        UNCONFIRMED,
        NEW,
        ASSIGNED,
        REOPENED,
        RESOLVED,
        VERIFIED,
        CLOSED,
        SCHEDULED;

    }

    public static enum BUGZILLA_REPORT_STATUS_4_0 {
        START,
        UNCONFIRMED,
        CONFIRMED,
        IN_PROGRESS,
        RESOLVED,
        VERIFIED;

    }

    public static enum BUGZILLA_RESOLUTION_2_0 {
        FIXED,
        INVALID,
        WONTFIX,
        LATER,
        REMIND,
        WORKSFORME;

    }

    public static enum BUGZILLA_RESOLUTION_3_0 {
        FIXED,
        INVALID,
        WONTFIX,
        WORKSFORME;

    }

    public static enum BugzillaServerVersion {
        SERVER_218,
        SERVER_220,
        SERVER_222,
        SERVER_30;


        public String toString() {
            switch (this) {
                case SERVER_30: {
                    return "3.0";
                }
                case SERVER_222: {
                    return "2.22";
                }
                case SERVER_220: {
                    return "2.20";
                }
                case SERVER_218: {
                    return "2.18";
                }
            }
            return "null";
        }

        public static BugzillaServerVersion fromString(String version) {
            if (version.equals(SERVER_30.toString())) {
                return SERVER_30;
            }
            if (version.equals(SERVER_222.toString())) {
                return SERVER_222;
            }
            if (version.equals(SERVER_220.toString())) {
                return SERVER_220;
            }
            if (version.equals(SERVER_218.toString())) {
                return SERVER_218;
            }
            return null;
        }
    }
}

