package org.clank.java.stdimpl.aliases;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.clank.java.std;
import org.clank.support.Converted;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import static org.clank.support.Native.*;
import org.clank.support.NativeType;
import org.clank.support.aliases.*;

/** 
 * Notes:
 *  [1] assignment is not fully correct (no checks for assignable interface)
 *  [2] no destruction of keys
 * 
 * @author Petr Kudryavtsev <petrk@netbeans.org>
 */
//<editor-fold defaultstate="collapsed" desc="template">
@Converted(kind = Converted.Kind.DUMMY, source = "${SPUTNIK}/modules/org.clank.java/src/org/clank/java/stdimpl/aliases/templates/StdMap.tpl")
//</editor-fold>
public abstract class ${FILE_NAME}${CLASS_SUFFIX} implements Native.assignable<${DUAL_CLASS}>, NativeCloneable<${DUAL_CLASS}>, Destructors.ClassWithDestructor {
    
    protected ${VALUE_TYPE} defaultValue;
    
    protected TreeMap<${KEY_TYPE}, ${PAIR_TYPE}> treeMap;
    
    private static class DefaultComparator<${KEY_TYPE}> implements Comparator<${KEY_TYPE}> {
      @Override
      public int compare(${KEY_TYPE} o1, ${KEY_TYPE} o2) {
        if (o1 instanceof Native.ComparableLower) {
          if (((Native.ComparableLower) o1).$less(o2)) {
            return -1;
          }
          return ((Native.ComparableLower) o2).$less(o1) ? 1 : 0;
        } else if (o1 instanceof Comparable) {
          return ((Comparable) o1).compareTo(o2);
        } else {
          throw new UnsupportedOperationException("NO ComparableLower: " + o1.getClass() + " vs. " + o2.getClass());
        }
      }
    }

    protected ${FILE_NAME}(${VALUE_TYPE} defaultValue) {
      this(null, defaultValue);
    }

    protected ${FILE_NAME}(Comparator<${KEY_TYPE}> comparator, ${VALUE_TYPE} defaultValue) {
      this.treeMap = new TreeMap(comparator != null ? comparator : new DefaultComparator<${KEY_TYPE}>());
      this.defaultValue = defaultValue;
    }
    
    protected ${FILE_NAME}(${DUAL_CLASS} other) {
      this((Comparator<${KEY_TYPE}>) other.treeMap.comparator(), other.defaultValue);
      $assign(other);
    }    

    @Override
    public ${DUAL_CLASS} $assign(${DUAL_CLASS} other) {
      clear();
      for (Map.Entry<${KEY_TYPE}, ${PAIR_TYPE}> entry : other.treeMap.entrySet()) {
        this.treeMap.put(entry.getKey(), ${PAIR_FACTORY_METHOD}(entry.getKey(), isDataPointerLike() ? entry.getValue().second : $tryClone(entry.getValue().second)));
      }     
      return (${DUAL_CLASS}) this;
    }
    
    public void swap(${DUAL_CLASS} other) {
      TreeMap<${KEY_TYPE}, ${PAIR_TYPE}> tmpMap = this.treeMap;
      this.treeMap = other.treeMap;
      other.treeMap = tmpMap;
      
      ${VALUE_TYPE} tmpDefVal = this.defaultValue;
      this.defaultValue = other.defaultValue;
      other.defaultValue = tmpDefVal;
    }
    
    public ${VALUE_TYPE} $at(${KEY_TYPE} key) {
      ${PAIR_TYPE} out = treeMap.get(key);
      if (out == null) {
        out = ${PAIR_FACTORY_METHOD}(key, $tryClone(defaultValue));
        treeMap.put(key, out);
      }
      return out.second;
    }
    
    public ${VALUE_REF} ref$at(final ${KEY_TYPE} key) {
      if (!treeMap.containsKey(key)) {
        treeMap.put(key, ${PAIR_FACTORY_METHOD}(key, $tryClone(defaultValue)));
      }
      return new ${VALUE_REF}() {

        @Override
        public ${VALUE_TYPE} $deref() {
          return treeMap.get(key).second;
        }

        @Override
        public ${VALUE_TYPE} $set(${VALUE_TYPE} value) {
          treeMap.get(key).second = (isDataPointerLike() ? value : $tryClone(value));
          return value;
        }

        @Override
        public ${VALUE_PTR} deref$ptr() {
          throw new UnsupportedOperationException("Not supported.");
        }
      };
    }

    public int/*size_t*/ size() {
      return treeMap.size();
    }
    
    public boolean empty() {
      return treeMap.isEmpty();
    } 

    public void clear() {
      if (!isDataPointerLike()) {
        for (Map.Entry<${KEY_TYPE}, ${PAIR_TYPE}> entry : treeMap.entrySet()) {
          Native.destroy(entry.getValue().second);
        }
      }
      treeMap.clear();
    }
    
    public std.pairTypeBool<${ITERATOR}> insert(${PAIR_TYPE} val) {
      boolean newElement = !treeMap.containsKey(val.first);
      treeMap.put(val.first, ${PAIR_FACTORY_METHOD}(val.first, isDataPointerLike() ? val.second : $tryClone(val.second)));
      return std.make_pair(find(val.first), newElement);
    }
    
    public void insert(${GENERIC_ITERATOR} I, ${GENERIC_ITERATOR} E) {
      for (; $noteq(I, E); I.$preInc())  {
        ${PAIR_TYPE} val = I.$star();
        treeMap.put(val.first, ${PAIR_FACTORY_METHOD}(val.first, isDataPointerLike() ? val.second : $tryClone(val.second)));
      }
    }
    
    public void erase(${ITERATOR} position) {
      if (!isDataPointerLike()) {
        Native.destroy(position.$star().second);
      }
      position.erase();
    }
    
    public boolean erase(${KEY_TYPE} key) {
      if (!treeMap.containsKey(key)) {
        return false;
      }
      if (!isDataPointerLike()) {
        Native.destroy(treeMap.get(key).second);
      }      
      treeMap.remove(key);
      return true;
    }

    public ${ITERATOR} lower_bound(${KEY_TYPE} key) {
      ${KEY_TYPE} lowerBoundKey = treeMap.ceilingKey(key);
      return lowerBoundKey != null ? find(lowerBoundKey) : end();
    }
    
    public ${ITERATOR} upper_bound(${KEY_TYPE} key) {
      ${ITERATOR} upperBound = lower_bound(key);
      while (upperBound.$noteq(end()) && treeMap.comparator().compare(key, upperBound.getKey()) >= 0) {
        upperBound.$preInc();
      }
      return upperBound;
    }   

    public ${ITERATOR} begin() {
      return new iterator(treeMap, treeMap.firstEntry(), defaultValue, false);
    }

    public ${ITERATOR} end() {
      return new iterator(treeMap, null, defaultValue, false);
    }
    
    public boolean count(${KEY_TYPE} key) {
      return treeMap.containsKey(key);
    }    

    public boolean replaceValueReference(${KEY_TYPE} key, ${VALUE_TYPE} val) {
      ${PAIR_TYPE} entry = treeMap.get(key);
      assert entry != null : "must be called only for existing entry " + key + " => " + val;
      entry.second = val;
      return true;
    }
    
    public ${ITERATOR} find(${KEY_TYPE} key) {
      if (!treeMap.containsKey(key)) {
        return end();
      }
      Comparator<? super ${KEY_TYPE}> comparator = treeMap.comparator();
      for (${ITERATOR} I = begin(), E = end(); I.$noteq(E); I.$preInc()) {
        if (comparator.compare((${KEY_TYPE}) I.getKey(), key) == 0) {
          return I;
        }
      }
      throw new AssertionError("Why not found???");
    }    

    @Override
    public ${DUAL_CLASS} clone() {
      return new ${DUAL_CLASS}((${DUAL_CLASS}) this);
    }

    public static class ${ITERATOR} implements type$iterator<${ITERATOR}, ${PAIR_TYPE}> {
      
      private final ${VALUE_TYPE} defaultValue;
      
      private final TreeMap<${KEY_TYPE}, ${PAIR_TYPE}> map;

      private final boolean _const;
      
      // helpers
      
      private Map.Entry<${KEY_TYPE}, ${PAIR_TYPE}> currentEntry;

      private iterator(TreeMap<${KEY_TYPE}, ${PAIR_TYPE}> map, Map.Entry<${KEY_TYPE}, ${PAIR_TYPE}> curr, ${VALUE_TYPE} defaultValue, boolean asConst) {
        this.defaultValue = defaultValue;
        this.map = map;
        this.currentEntry = curr;
        this._const = asConst;
      }
      
      private ${KEY_TYPE} getKey() {
        return currentEntry.getKey();
      }
      
      private void erase() {
        // TODO? check if next and prev will get the next value
        map.remove(currentEntry.getKey());
      }      
      
      public ${PAIR_TYPE} $arrow() {
        return currentEntry.getValue();
      }      

      @Override
      public ${PAIR_TYPE} $star() {
        return currentEntry.getValue();
      }

      @Override
      public type$ref<${PAIR_TYPE}> star$ref() {
        return new type$ref<${PAIR_TYPE}>() {
          
          private final Map.Entry<${KEY_TYPE}, ${PAIR_TYPE}> localEntry = currentEntry;

          @Override
          public ${PAIR_TYPE} $deref() {
            return localEntry.getValue();
          }

          @Override
          public ${PAIR_TYPE} $set(${PAIR_TYPE} value) {
            assert map.comparator().compare(value.first, localEntry.getKey()) == 0 : "Trying to change key of entry via iterator!";
            localEntry.getValue().second = $tryAssign(localEntry.getValue().second, value.second, isDataPointerLike());
            return value;
          }

          @Override
          public type$ptr<${PAIR_TYPE}> deref$ptr() {
            throw new UnsupportedOperationException("Not supported.");
          }
        };
      }

      @Override
      public ${ITERATOR} $preInc() {
        currentEntry = map.higherEntry(currentEntry.getKey());
        return this;
      }
      
      @Override
      public ${ITERATOR} $postInc() {
        ${ITERATOR} cloned = clone();
        $preInc();
        return cloned;
      }      

      @Override
      public ${ITERATOR} clone() {
        return new iterator(map, currentEntry, defaultValue, false);
      }
      
      @Override
      public ${ITERATOR} const_clone() {
        return new iterator(map, currentEntry, defaultValue, true);
      }
      
      @Override
      public boolean $eq(Object other) {
        if (other instanceof iterator) {
          iterator otherIter = (iterator) other;
          if (otherIter.map == map) {
            if (otherIter.currentEntry == null) {
              return currentEntry == null;
            } else if (currentEntry == null) {
              return otherIter.currentEntry == null;
            } else {
              return Native.$eq(otherIter.currentEntry.getKey(), currentEntry.getKey());
            }
          }
        }
        return false;
      }      

      @Override
      public boolean $noteq(Object other) {
        return !$eq(other);
      }

      @Override
      public int $sub(${ITERATOR} iter) {
        throw new UnsupportedOperationException("Not supported.");
      }

      @Override
      public ${ITERATOR} $preDec() {
        if (currentEntry == null) {
          currentEntry = map.lastEntry();
        } else {
          currentEntry = map.lowerEntry(currentEntry.getKey());
        }
        return this;
      }

      @Override
      public ${ITERATOR} $postDec() {
        ${ITERATOR} cloned = clone();
        $preDec();
        return cloned;
      }

      @Override
      public ${ITERATOR} $inc(int amount) {
        throw new UnsupportedOperationException("Not supported.");
      }
      @Override
      public ${ITERATOR} $inc(long amount) {
        throw new UnsupportedOperationException("Not supported.");
      }

      @Override
      public ${ITERATOR} $dec(int amount) {
        throw new UnsupportedOperationException("Not supported.");
      }
      @Override
      public ${ITERATOR} $dec(long amount) {
        throw new UnsupportedOperationException("Not supported.");
      }

      @Override
      public ${ITERATOR} $add(int amount) {
        throw new UnsupportedOperationException("Not supported.");
      }
      @Override
      public ${ITERATOR} $add(long amount) {
        throw new UnsupportedOperationException("Not supported.");
      }

      @Override
      public ${ITERATOR} $sub(int amount) {
        throw new UnsupportedOperationException("Not supported.");
      }
      @Override
      public ${ITERATOR} $sub(long amount) {
        throw new UnsupportedOperationException("Not supported.");
      }
      
      private boolean isDataPointerLike() {
        return ${IS_DATA_POINTER_LIKE};
      }      
    }

    @Override
    public void $destroy() {
      clear();
    }
    
    private boolean isDataPointerLike() {
      return ${IS_DATA_POINTER_LIKE};
    }

    @Override
    public String toString() {
      return "${FILE_NAME}{" + treeMap + "}";
    }
}
