package org.clank.support.aliases;

import org.clank.support.Converted;
import org.clank.support.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.NativeMemory.*;


//<editor-fold defaultstate="collapsed" desc="template">
@Converted(kind = Converted.Kind.DUMMY, source = "${SPUTNIK}/modules/org.clank.java/src/org/clank/support/aliases/templates/memory.tpl")
//</editor-fold>
public interface ${FILE_NAME}${CLASS_SUFFIX} extends memory {
    
    /**
     * Gets value from memory at the given index
     * 
     * @param index
     * @return value
     */        
    ${Tp} $at(long index);
    
    /**
     * Replaces value in memory at the given index
     * 
     * @param value - new value
     * @return value
     */
    ${Tp} $set(long index, ${Tp} value);

    /**
     * modify value in memory at the given index (i.e. 'x[10] += value' in C++)
     * 
     * @param value - value
     * @return value
     */
    ${Tp} $set$andassign(long index, ${Tp} value); // "&="
    ${Tp} $set$xorassign(long index, ${Tp} value); // "^="
    ${Tp} $set$orassign(long index, ${Tp} value); // "|=" 
    ${ADDITIONAL_MODIFY_VALUE_SECTION_START}
    ${Tp} $set$addassign(long index, ${Tp} value); // "+=" 
    ${Tp} $set$minusassign(long index, ${Tp} value); // "-="
    ${Tp} $set$starassign(long index, ${Tp} value); // "*="    
    ${Tp} $set$slashassign(long index, ${Tp} value); // "/="
    ${Tp} $set$modassign(long index, ${Tp} value); // "%=" 
    ${Tp} $set$lshiftassign(long index, ${Tp} value); // "<<="
    ${Tp} $set$rshiftassign(long index, ${Tp} value); // ">>="    
    ${Tp} $set$postInc(long index); // "x++"    
    ${Tp} $set$postDec(long index); // "x--"    
    ${Tp} $set$preInc(long index); // "++x"    
    ${Tp} $set$preDec(long index); // "--x"    
    ${ADDITIONAL_MODIFY_VALUE_SECTION_END}
}