
package org.llvm.adt.aliases;

import java.util.Arrays;
import java.util.Iterator;
import org.clank.java.*;
import org.clank.support.*;
import org.clank.support.aliases.*;
import static org.clank.support.Casts.*;
import static org.clank.java.io.*;
import static org.clank.java.std.*;
import static org.llvm.adt.ADTAliases.*;
import static org.llvm.support.llvm.*;
import static org.clank.support.NativePointer.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import org.llvm.support.*;
import org.llvm.adt.*;
import org.llvm.adt.aliases.*;

/*template <typename ${VALUE_TYPE}> TEMPLATE*/

/// ${FILE_NAME} - Represent a constant reference to an array (0 or more elements
/// consecutively in memory), i.e. a start pointer and a length.  It allows
/// various APIs to take consecutive elements easily and conveniently.
///
/// This class does not own the underlying data, it is expected to be used in
/// situations where the data resides in some other buffer, whose lifetime
/// extends past that of the ${FILE_NAME}. For this reason, it is not in general
/// safe to store an ${FILE_NAME}.
///
/// This is intended to be trivially copyable, so it should be passed by
/// value.
//<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}">
@Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 30,
 cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}")
//</editor-fold>
public class ${FILE_NAME}${CLASS_SUFFIX} implements Iterable<${BOXED_VALUE_TYPE}> {
  private static final ${FILE_NAME} NONE;
  static {
    // initialize into temporary to have NONE = null in constructor
    ${FILE_NAME} obj = new ${FILE_NAME}(NoneType.None);
    NONE = obj;
  }

  // constant replacement for new ${FILE_NAME}${CLASS_SUFFIX}(NoneType.None)
  public static ${CLASS_SUFFIX} ${FILE_NAME}${CLASS_SUFFIX} None() {
    return (${FILE_NAME}${CLASS_SUFFIX})NONE;
  }
  
/*public:*/
  /*typedef const ${VALUE_TYPE} *iterator*/
//  public final class iterator extends /*const*/${VALUE_TYPE} /*P*/ { };
  /*typedef const ${VALUE_TYPE} *const_iterator*/
//  public final class const_iterator extends /*const*/${VALUE_TYPE} /*P*/ { };
  /*typedef size_t size_type*/;
  /*typedef std::${REVERSE_ITERATOR}<iterator> ${REVERSE_ITERATOR}*/
//  public final class ${REVERSE_ITERATOR} extends std.${REVERSE_ITERATOR}<iterator>{ };
/*private:*/
  /// The start of the array, in an external buffer.
  private /*const*/${VALUE_POINTER} /*P*/ Data;
  
  /// The number of elements.
  private int/*size_t*/ Length;
  
  // ###JAVA###: true if T is pointer in native code but not pointer here
  private final boolean isDataPointerLike;
/*public:*/

/// ###JAVA###: this class made public because JConvert creates it outside of ArrayRef
  ///
  /// \brief A dummy "optional" type that is only created by implicit
  /// conversion from a reference to T.
  ///
  /// This type must *only* be used in a function argument or as a copy of
  /// a function argument, as otherwise it will hold a pointer to a temporary
  /// past that temporaries' lifetime.
  //<editor-fold defaultstate="collapsed" desc="llvm::ArrayRef::TRefOrNothing">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/ArrayRef.h", line = 53,
   FQN="llvm::ArrayRef::TRefOrNothing", NM="_ZN4llvm8ArrayRef13TRefOrNothingE",
   cmd="jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -nm=_ZN4llvm8ArrayRef13TRefOrNothingE")
  //</editor-fold>
  public static class/*struct*/ TRefOrNothing {
    public /*const*/ ${TREF_TYPE} /*P*/ TPtr;

    //<editor-fold defaultstate="collapsed" desc="llvm::ArrayRef::TRefOrNothing::TRefOrNothing">
    @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/ArrayRef.h", line = 56,
     FQN="llvm::ArrayRef::TRefOrNothing::TRefOrNothing", NM="_ZN4llvm8ArrayRef13TRefOrNothingC1Ev",
     cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -nm=_ZN4llvm8ArrayRef13TRefOrNothingC1Ev")
    //</editor-fold>
    public TRefOrNothing() {
      /* : TPtr(null)*/ 
      //START JInit
      this.TPtr = ${TREF_DEFAULT_VALUE};
      //END JInit
    }

    //<editor-fold defaultstate="collapsed" desc="llvm::ArrayRef::TRefOrNothing::TRefOrNothing">
    @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/ArrayRef.h", line = 57,
     FQN="llvm::ArrayRef::TRefOrNothing::TRefOrNothing", NM="_ZN4llvm8ArrayRef13TRefOrNothingC1ERKT_",
     cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -nm=_ZN4llvm8ArrayRef13TRefOrNothingC1ERKT_")
    //</editor-fold>
    public TRefOrNothing(/*const*/ ${TREF_TYPE} /*&*/ TRef) {
      /* : TPtr(&TRef)*/ 
      //START JInit
      this.TPtr = TRef;
      //END JInit
    }


    public String toString() {
      return "" + "TPtr=" + TPtr; // NOI18N
    }
  }
  
  /// Construct an empty ${FILE_NAME}.
  /*implicit*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 51,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public ${FILE_NAME}() {
    /* : Data(0), Length(0)*/ 
    //START JInit
    this.Data = ${POINTER_FACTORY_METHOD}((${VALUE_TYPE}[]) null);
    this.Length = 0;
    this.isDataPointerLike = false;
    //END JInit
  }

  
  /// Construct an empty ${FILE_NAME} from None.
  /*implicit*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 54,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public ${FILE_NAME}(NoneType $Prm0) {
    /* : Data(0), Length(0)*/ 
    //START JInit
    this.Data = ${POINTER_FACTORY_METHOD}((${VALUE_TYPE}[]) null);
    this.Length = 0;
    this.isDataPointerLike = false;
    //END JInit
    if (NONE != null) {
      new Exception("use ${FILE_NAME}.None() instead").printStackTrace(System.err);
    }
  }

  
  /// Construct an ${FILE_NAME} from a single element.
  /*implicit*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 57,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public ${FILE_NAME}(/*const*/${VALUE_TYPE} /*&*/ OneElt) {
    this(OneElt, false);
  }
  public ${FILE_NAME}(/*const*/${VALUE_TYPE} /*&*/ OneElt, boolean isDataPointerLike) {
    /* : Data(&OneElt), Length(1)*/ 
    //START JInit
    this.Data = NativePointer.${POINTER_FACTORY_METHOD}((${VALUE_TYPE}[])${CREATE_ARRAY_FROM_ONE_ELT});
    this.Length = 1;
    this.isDataPointerLike = isDataPointerLike;
    //END JInit
  }
  
  // Construct an ${FILE_NAME} using length elements of passed array
  public ${FILE_NAME}(${VALUE_TYPE}[] data, long/*size_t*/ length) {
    this(data, length, false);
  }
  public ${FILE_NAME}(${VALUE_TYPE}[] data, long/*size_t*/ length, boolean isDataPointerLike) {
    this(NativePointer.${POINTER_FACTORY_METHOD}(data), length, isDataPointerLike);
  }
  public ${FILE_NAME}(${VALUE_TYPE}[] data, int/*size_t*/ length) {
    this(data, length, false);
  }
  public ${FILE_NAME}(${VALUE_TYPE}[] data, int/*size_t*/ length, boolean isDataPointerLike) {
    this(NativePointer.${POINTER_FACTORY_METHOD}(data), length, isDataPointerLike);
  }
  
  /// Construct an ${FILE_NAME} from a pointer and length.
  /*implicit*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 61,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public ${FILE_NAME}(/*const*/${VALUE_POINTER} /*P*/ data, long/*size_t*/ length) {
    this(data, length, false);
  }
  public ${FILE_NAME}(/*const*/${VALUE_POINTER} /*P*/ data, long/*size_t*/ length, boolean isDataPointerLike) {
    this(data, Unsigned.long2uint(length), isDataPointerLike);
  }
  public ${FILE_NAME}(/*const*/${VALUE_POINTER} /*P*/ data, int/*size_t*/ length) {
    this(data, length, false);
  }
  public ${FILE_NAME}(/*const*/${VALUE_POINTER} /*P*/ data, int/*size_t*/ length, boolean isDataPointerLike) {
    /* : Data(data), Length(length)*/ 
    //START JInit
    this.Data = data.clone();
    this.Length = length;
    this.isDataPointerLike = isDataPointerLike;
    //END JInit
  }

  
  /// Construct an ${FILE_NAME} from a range.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 65,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public ${FILE_NAME}(/*const*/${VALUE_POINTER} /*P*/ begin, /*const*/${VALUE_POINTER} /*P*/ end) {
    this(begin, end, false);
  }
  public ${FILE_NAME}(/*const*/${VALUE_POINTER} /*P*/ begin, /*const*/${VALUE_POINTER} /*P*/ end, boolean isDataPointerLike) {
    /* : Data(begin), Length(end - begin)*/ 
    //START JInit
    this.Data = begin.clone();
    this.Length = end.$sub(begin);
    this.isDataPointerLike = isDataPointerLike;
    //END JInit
  }

  
  /// Construct an ${FILE_NAME} from a SmallVector. This is templated in order to
  /// avoid instantiating SmallVectorTemplateCommon${CLASS_SUFFIX} whenever we
  /// copy-construct an ${FILE_NAME}.
  /*template <typename U> TEMPLATE*/
  /*implicit*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 72,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public </*typename*/ U> ${FILE_NAME}(/*const*/${SMALL_VECTOR_TYPE} /*&*/ Vec) {
    /* : Data(Vec.data()), Length(Vec.size())*/ 
    //START JInit
    this.Data = Vec.data().clone();
    this.Length = Vec.size();
    this.isDataPointerLike = Vec.isDataPointerLike();
    //END JInit
  }

  
  /// Construct an ${FILE_NAME} from a std::vector.
  /*template <typename A> TEMPLATE*/
  /*implicit*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 78,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public </*typename*/ A> ${FILE_NAME}(/*const*/${VECTOR_TYPE} /*&*/ Vec) {
    /* : Data(Vec.empty() ? (${VALUE_TYPE} * )0 : &Vec[0]), Length(Vec.size())*/ 
    //START JInit
    this.Data = Vec.data();
    this.Length = Vec.size();
    this.isDataPointerLike = Vec.isDataPointerLike();
    //END JInit
  }
  public ${FILE_NAME}(/*const*/std.vectorString /*&*/ Vec) {
    /* : Data(Vec.empty() ? (${VALUE_TYPE} * )0 : &Vec[0]), Length(Vec.size())*/ 
    //START JInit
    this.Data = (${VALUE_POINTER}) (Object) Vec.data(); // hack to make specializations compilable
    this.Length = Vec.size();
    this.isDataPointerLike = Vec.isDataPointerLike();
    //END JInit
  }

  
  /// Construct an ${FILE_NAME} from a C array.
  /*template <size_t N> TEMPLATE*/
  /*implicit*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 83,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public /*<long*//*size_t*//* N>*/ ${FILE_NAME}(/*const*/${VALUE_TYPE} /*&*/ Arr[]) {
    this(Arr, false);
  }
  public /*<long*//*size_t*//* N>*/ ${FILE_NAME}(/*const*/${VALUE_TYPE} /*&*/ Arr[], boolean isDataPointerLike) {
    /* : Data(Arr), Length(N)*/ 
    //START JInit
    this.Data = NativePointer.${POINTER_FACTORY_METHOD}(Arr);
    this.Length = Arr.length;
    this.isDataPointerLike = isDataPointerLike;
    //END JInit
  }


  // Copy constructor
  public ${FILE_NAME}(${FILE_NAME}${CLASS_SUFFIX} other) {
    this.Data = $tryClone(other.data());
    this.Length = other.size();
    this.isDataPointerLike = other.isDataPointerLike;
  }

  
  /// @}
  /// @name Simple Operations
  /// @{
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::begin">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 97,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::begin")
  //</editor-fold>
  public ${VALUE_POINTER} begin() /*const*/ {
    return Data;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::end">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 98,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::end")
  //</editor-fold>
  public ${VALUE_POINTER} end() /*const*/ {
    return Data.$add(Length);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::rbegin">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 100,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::rbegin")
  //</editor-fold>
  public ${REVERSE_ITERATOR} rbegin() /*const*/ {
    return new ${REVERSE_ITERATOR}(end());
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::rend">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 101,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::rend")
  //</editor-fold>
  public ${REVERSE_ITERATOR} rend() /*const*/ {
    return new ${REVERSE_ITERATOR}(begin());
  }

  
  /// empty - Check if the array is empty.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::empty">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 104,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::empty")
  //</editor-fold>
  public boolean empty() /*const*/ {
    return Length == 0;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::data">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 106,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::data")
  //</editor-fold>
  public /*const*/${VALUE_POINTER} /*P*/ data() /*const*/ {
    return Data;
  }

  
  /// size - Get the array size.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::size">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 109,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::size")
  //</editor-fold>
  public int/*size_t*/ size() /*const*/ {
    return Length;
  }

  
  /// front - Get the first element.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::front">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 112,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::front")
  //</editor-fold>
  public /*const*/${VALUE_TYPE} /*&*/ front() /*const*/ {
    return Data.$at(0);
  }

  
  /// back - Get the last element.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::back">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 118,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::back")
  //</editor-fold>
  public /*const*/${VALUE_TYPE} /*&*/ back() /*const*/ {
    return Data.$at(Length - 1);
  }


  // copy - Allocate copy in Allocator and return ArrayRef<T> to it.
  /*template <typename Allocator> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::ArrayRef::copy">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/ArrayRef.h", line = 146,
   FQN="llvm::ArrayRef::copy", NM="_ZN4llvm8ArrayRef4copyERT_",
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -nm=_ZN4llvm8ArrayRef4copyERT_")
  //</editor-fold>
  public ${FILE_NAME}${CLASS_SUFFIX} copy(Class<${BOXED_VALUE_TYPE}> cls, NativeMemory.Allocator /*&*/ A) {
    ${VALUE_POINTER} Buff = (${VALUE_POINTER}) A.Allocate(cls, Length);
    std.copy(begin(), end(), Buff);
    return new ${FILE_NAME}(Buff, Length, isDataPointerLike);
  }

  
  /// equals - Check for element-wise equality.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::equals">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 124,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::equals")
  //</editor-fold>
  public boolean equals(${FILE_NAME}${CLASS_SUFFIX} RHS) /*const*/ {
    if ($noteq(Length, RHS.Length)) {
      return false;
    }
    // Don't use std::equal(), since it asserts in MSVC on nullptr iterators.
    for (${VALUE_POINTER} L = begin(), LE = end(), R = RHS.begin(); L.$noteq(LE); L.$preInc(), R.$preInc()) {
      // Match std::equal() in using == (instead of !=) to minimize API
      // requirements of ArrayRef'ed types.
      if (!(Native.$eq(L.$star(), R.$star(), isDataPointerLike))) {
        return false;
      }
    }
    return true;
  }

  
  /// slice(n) - Chop off the first N elements of the array.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::slice">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 134,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::slice")
  //</editor-fold>
  public ${FILE_NAME}${CLASS_SUFFIX} slice(/*uint*/int N) /*const*/ {
    return new ${FILE_NAME}${CLASS_SUFFIX}(data().$add(N), size() - N);
  }

  
  /// slice(n, m) - Chop off the first N elements of the array, and keep M
  /// elements in the array.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::slice">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 141,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::slice")
  //</editor-fold>
  public ${FILE_NAME}${CLASS_SUFFIX} slice(/*uint*/int N, /*uint*/int M) /*const*/ {
    return new ${FILE_NAME}${CLASS_SUFFIX}(data().$add(N), M);
  }


  // \brief Drop the last \p N elements of the array.
  //<editor-fold defaultstate="collapsed" desc="llvm::ArrayRef::drop_back">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/ArrayRef.h", line = 179,
   FQN="llvm::ArrayRef::drop_back", NM="_ZNK4llvm8ArrayRef9drop_backEj",
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -nm=_ZNK4llvm8ArrayRef9drop_backEj")
  //</editor-fold>
  public ${FILE_NAME}${CLASS_SUFFIX} drop_back() /*const*/ {
    return drop_back(1);
  }
  public ${FILE_NAME}${CLASS_SUFFIX} drop_back(/*uint*/int N/*= 1*/) /*const*/ {
    assert size() >= N : "Dropping more elements than exist";
    return slice(0, size() - N);
  }

  
  /// @}
  /// @name Operator Overloads
  /// @{
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator[]">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 149,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::operator[]")
  //</editor-fold>
  public /*const*/${VALUE_TYPE} /*&*/ $at(int/*size_t*/ Index) /*const*/ {
    return Data.$at(Index);
  }

  
  /// @}
  /// @name Expensive Operations
  /// @{
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::vec">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 157,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::vec")
  //</editor-fold>
  public ${VECTOR_TYPE} vec() /*const*/ {
    return new ${VECTOR_TYPE}(Data, Data.$add(Length), ${DEFAULT_VALUE});
  }

  
  /// @}
  /// @name Conversion operators
  /// @{
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator vector<type-parameter-0-0, allocator<type-parameter-0-0> >">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/${FILE_NAME}.h", line = 164,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -filter=llvm::${FILE_NAME}::operator vector<type-parameter-0-0, allocator<type-parameter-0-0> >")
  //</editor-fold>
  public ${VECTOR_TYPE} $vector/*<type-parameter-0-0, allocator<type-parameter-0-0> >*/() /*const*/ {
    return new ${VECTOR_TYPE}(Data, Data.$add(Length), ${DEFAULT_VALUE});
  }


  /// @brief Predicate for testing that the array equals the exact sequence of
  /// arguments.
  ///
  /// Will return false if the size is not equal to the exact number of
  /// arguments given or if the array elements don't equal the argument
  /// elements in order. Currently supports up to 16 arguments, but can
  /// easily be extended.
  //<editor-fold defaultstate="collapsed" desc="llvm::ArrayRef::equals">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/ArrayRef.h", line = 217,
   FQN="llvm::ArrayRef::equals", NM="_ZN4llvm8ArrayRef6equalsENS0_13TRefOrNothingES1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_",
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringRef.cpp -nm=_ZN4llvm8ArrayRef6equalsENS0_13TRefOrNothingES1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_S1_")
  //</editor-fold>
  public boolean equals(TRefOrNothing ... Args) {
    // #JAVA: native code accepted only 16 arguments
    if (Args.length > 16) {
      throw new IllegalArgumentException("Too many arguments passed!");
    }

    if (size() != array_lengthof(Args)) {
      return false;
    }

    for (/*uint*/int i = 0, e = size(); i != e; ++i)  {
      if (Native.$noteq(this.$at(i), Args[(int)i].TPtr, isDataPointerLike)) {
        return false;
      }
    }
    
    return true;
  }


  @Override
  public String toString() {
    if (this.Length == 0) {
      return "<Empty>";
    }
    StringBuilder out = new StringBuilder("\nArRef{");
    String fmt = "%" + (int)Math.ceil(Math.log10(Length+1)) +"d";
    for (int i = 0; i < Length; i++) {
      out.append("[").append(String.format(fmt, i)).append("]");
      out.append("{").append(this.$at(i)).append("}\n");
    }
    out.append("}ArRef\n");
    return out.toString();
  }

  public void $assign(${FILE_NAME}${CLASS_SUFFIX} other) {
    this.Data = other.Data;
    this.Length = other.Length;
  }
  
  @Override
  public Iterator<${BOXED_VALUE_TYPE}> iterator() {
    return new ArrayRefIterator(Data, Length);
  }  
  
  private static final class ArrayRefIterator${CLASS_SUFFIX} implements Iterator<${BOXED_VALUE_TYPE}> {
      
    private final ${VALUE_POINTER} localData;
    
    private final int localLength;
    
    private int pos = 0;

    public ArrayRefIterator(${VALUE_POINTER} Data, int Length) {
      this.localData = $tryClone(Data);
      this.localLength = Length;
    }

    @Override
    public boolean hasNext() {
      return pos < localLength;
    }

    @Override
    public ${BOXED_VALUE_TYPE} next() {
      ${BOXED_VALUE_TYPE} val = localData.$star();
      localData.$preInc();
      ++pos;
      return val;
    }

    @Override
    public void remove() {
      throw new UnsupportedOperationException("Not supported.");
    }
  };
}
