
package org.llvm.adt.aliases;

import org.clank.java.*;
import org.clank.support.*;
import org.clank.support.aliases.*;
import static org.clank.java.built_in.*;
import static org.clank.support.Casts.*;
import static org.clank.java.io.*;
import static org.clank.java.std.*;
import static org.llvm.adt.ADTAliases.*;
import static org.llvm.support.llvm.*;
import static org.clank.support.NativePointer.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import org.llvm.support.*;
import org.llvm.adt.*;
import org.llvm.adt.aliases.*;

/*template <typename ${VALUE_TYPE}, typename ValueInfoT = ${DENSE_MAP_INFO}> TEMPLATE*/

/// DenseSet - This implements a dense probed hash-table based set.
///
/// FIXME: This is currently implemented directly in terms of DenseMap, this
/// should be optimized later if there is a need.
//<editor-fold defaultstate="collapsed" desc="llvm::DenseSet">
@Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 25,
 cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet")
//</editor-fold>
public class ${FILE_NAME}${CLASS_SUFFIX} implements Destructors.ClassWithDestructor {
  /*typedef DenseMap<${VALUE_TYPE}, char, ValueInfoT> MapTy*/
//  public final class MapTy extends DenseMap<${VALUE_TYPE}, /*char*/byte, ValueInfoT>{ };
  private ${DENSE_MAP_ITSELF} TheMap;
/*public:*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::DenseSet<${VALUE_TYPE}, ValueInfoT>">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 30,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::DenseSet<${VALUE_TYPE}, ValueInfoT>")
  //</editor-fold>
  public ${FILE_NAME}(/*const*/${FILE_NAME}${CLASS_SUFFIX} /*&*/ Other) {
    /* : TheMap(Other.TheMap)*/ 
    //START JInit
    this.TheMap = new ${DENSE_MAP_ITSELF}(Other.TheMap);
    //END JInit
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::DenseSet<${VALUE_TYPE}, ValueInfoT>">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 31,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::DenseSet<${VALUE_TYPE}, ValueInfoT>")
  //</editor-fold>
  public /*explicit*/ ${FILE_NAME}(${DENSE_MAP_INFO} ValueInfo) {
    this(ValueInfo, 0);
  }
  public /*explicit*/ ${FILE_NAME}(${DENSE_MAP_INFO} ValueInfo,/*uint*/long NumInitBuckets/*= 0*/) {
    this(ValueInfo, Unsigned.long2uint(NumInitBuckets));
  }
  public /*explicit*/ ${FILE_NAME}(${DENSE_MAP_INFO} ValueInfo,/*uint*/int NumInitBuckets/*= 0*/) {
    /* : TheMap(NumInitBuckets)*/ 
    assert NumInitBuckets >= 0 : "can not be negative " + NumInitBuckets;
    //START JInit
    this.TheMap = new ${DENSE_MAP_ITSELF}(ValueInfo, NumInitBuckets, $TERM);
    //END JInit
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::empty">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 33,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::empty")
  //</editor-fold>
  public boolean empty() /*const*/ {
    return TheMap.empty();
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::size">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 34,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::size")
  //</editor-fold>
  public /*uint*/int size() /*const*/ {
    return TheMap.size();
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::getMemorySize">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 35,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::getMemorySize")
  //</editor-fold>
  public long/*size_t*/ getMemorySize() /*const*/ {
    return TheMap.getMemorySize();
  }

  
  /// Grow the DenseSet so that it has at least Size buckets. Will not shrink
  /// the Size of the set.
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::resize">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 39,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::resize")
  //</editor-fold>
  public void resize(long/*size_t*/ Size) {
    TheMap.resize(Size);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::clear">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 41,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::clear")
  //</editor-fold>
  public void clear() {
    TheMap.clear();
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::count">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 45,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::count")
  //</editor-fold>
  public boolean count(/*const*/${VALUE_TYPE} /*&*/ V) /*const*/ {
    return TheMap.count(V);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::erase">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 49,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::erase")
  //</editor-fold>
  public boolean erase(/*const*/${VALUE_TYPE} /*&*/ V) {
    return TheMap.erase(V);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::swap">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 53,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::swap")
  //</editor-fold>
  public void swap(${FILE_NAME}${CLASS_SUFFIX} /*&*/ RHS) {
    TheMap.swap(RHS.TheMap);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::operator=">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 57,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::operator=")
  //</editor-fold>
  public ${FILE_NAME}${CLASS_SUFFIX} /*&*/ $assign(/*const*/${FILE_NAME}${CLASS_SUFFIX} /*&*/ RHS) {
    TheMap.$assign(RHS.TheMap);
    return /*Deref*/this;
  }

  @Override
  public void $destroy() {
    TheMap.$destroy();
  }

  // Iterators.
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::Iterator">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 64,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::Iterator")
  //</editor-fold>
  public static class ${ITERATOR_TYPE} implements ${ITERATOR_INTERFACE} {
    private  ${DENSE_MAP_ITER} I;
    /*friend  class DenseSet<${VALUE_TYPE}, ValueInfoT>*/;
  /*public:*/
    /*typedef typename MapTy::iterator::difference_type difference_type*/
    //public final class difference_type extends  MapTy.iterator.difference_type{ };
    /*typedef ${VALUE_TYPE} value_type*/
    //public final class value_type extends ${VALUE_TYPE}{ };
    /*typedef value_type *pointer*/
    //public final class pointer extends value_type /*P*/ { };
    /*typedef value_type &reference*/
    //public final class reference extends value_type /*&*/ { };
    /*typedef std::forward_iterator_tag iterator_category*/
//    public final class iterator_category extends std.forward_iterator_tag{ };
    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::Iterator::Iterator">
    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 74,
     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::Iterator::Iterator")
    //</editor-fold>
    public iterator(/*const*/ ${DENSE_MAP_ITER} /*&*/ i) {
      /* : I(i)*/ 
      //START JInit
      this.I = $tryClone(i);
      //END JInit
    }

    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::Iterator::operator*">
    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 76,
     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::Iterator::operator*")
    //</editor-fold>
    public ${VALUE_TYPE} /*&*/ $star() {
      return I.$star().first;
    }

    @Override
    public ${REFERENCE_TO_VALUE} star$ref() {
      return new ${REFERENCE_TO_VALUE}() {
        
        private ${DENSE_MAP_ITER} localIter = $tryClone(I);

        @Override
        public ${VALUE_TYPE} $deref() {
          return localIter.$star().first;
        }

        @Override
        public ${VALUE_TYPE} $set(${VALUE_TYPE} value) {
          return localIter.$star().first = $tryClone(value);
        }

        @Override
        public ${POINTER_TO_VALUE} deref$ptr() {
          throw new UnsupportedOperationException("Not supported.");
        }
      };
    }

    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::Iterator::operator->">
    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 77,
     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::Iterator::operator->")
    //</editor-fold>
    public ${VALUE_TYPE} /*P*/ $arrow() {
      return /*AddrOf*/I.$star().first;
    }

    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::Iterator::operator++">
    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 79,
     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::Iterator::operator++")
    //</editor-fold>
    public ${ITERATOR_TYPE} /*&*/ $preInc() {
      I.$preInc();
      return /*Deref*/this;
    }

    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::Iterator::operator==">
    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 80,
     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::Iterator::operator==")
    //</editor-fold>
    public boolean $eq(/*const*/${ITERATOR_TYPE} /*&*/ X) /*const*/ {
      return Native.$eq(I, X.I);
    }

    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::Iterator::operator!=">
    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 81,
     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::Iterator::operator!=")
    //</editor-fold>
    public boolean $noteq(/*const*/${ITERATOR_TYPE} /*&*/ X) /*const*/ {
      return Native.$noteq(I, X.I);
    }
    
    @Override
    public boolean $noteq(Object other) {
      if (other instanceof iterator) {
        return $noteq((${ITERATOR_TYPE}) other);
      }
      return true;
    }

    @Override
    public boolean $eq(Object other) {
      if (other instanceof iterator) {
        return $eq((${ITERATOR_TYPE}) other);
      }
      return false;
    }
        

    @Override
    public iterator clone() {
      return new iterator(I);
    }

    @Override
    public iterator const_clone() {
      // TODO: pass constness
      return new iterator(I);
    }

    @Override
    public int $sub(iterator iter) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public iterator $preDec() {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public iterator $postInc() {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public iterator $postDec() {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public iterator $inc(int amount) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    @Override
    public iterator $inc(long amount) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public iterator $dec(int amount) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    @Override
    public iterator $dec(long amount) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public iterator $add(int amount) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    @Override
    public iterator $add(long amount) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }

    @Override
    public iterator $sub(int amount) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }    
    @Override
    public iterator $sub(long amount) {
      throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }    
  };
  
//  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::ConstIterator">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 84,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::ConstIterator")
//  //</editor-fold>
//  public static class ConstIterator implements Native.NativeComparable<ConstIterator> {
//    private  MapTy.const_iterator I;
//    /*friend  class DenseSet<${VALUE_TYPE}, ValueInfoT>*/;
//  /*public:*/
//    /*typedef typename MapTy::const_iterator::difference_type difference_type*/
//    public final class difference_type extends  MapTy.const_iterator.difference_type{ };
//    /*typedef ${VALUE_TYPE} value_type*/
//    public final class value_type extends ${VALUE_TYPE}{ };
//    /*typedef value_type *pointer*/
//    public final class pointer extends value_type /*P*/ { };
//    /*typedef value_type &reference*/
//    public final class reference extends value_type /*&*/ { };
//    /*typedef std::forward_iterator_tag iterator_category*/
//    public final class iterator_category extends std.forward_iterator_tag{ };
//    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::ConstIterator::ConstIterator">
//    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 94,
//     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::ConstIterator::ConstIterator")
//    //</editor-fold>
//    public ConstIterator(/*const*/ MapTy.const_iterator /*&*/ i) {
//      /* : I(i)*/ 
//      //START JInit
//      this.I = new  MapTy.const_iterator(i);
//      //END JInit
//    }
//
//    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::ConstIterator::operator*">
//    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 96,
//     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::ConstIterator::operator*")
//    //</editor-fold>
//    public /*const*/${VALUE_TYPE} /*&*/ $star() {
//      return I.first;
//    }
//
//    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::ConstIterator::operator->">
//    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 97,
//     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::ConstIterator::operator->")
//    //</editor-fold>
//    public /*const*/${VALUE_TYPE} /*P*/ $arrow() {
//      return /*AddrOf*/I.first;
//    }
//
//    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::ConstIterator::operator++">
//    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 99,
//     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::ConstIterator::operator++")
//    //</editor-fold>
//    public ConstIterator /*&*/ $inc() {
//      ++I;
//      return /*Deref*/this;
//    }
//
//    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::ConstIterator::operator==">
//    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 100,
//     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::ConstIterator::operator==")
//    //</editor-fold>
//    public boolean $eq(/*const*/ConstIterator /*&*/ X) /*const*/ {
//      return $eq(I, X.I);
//    }
//
//    //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::ConstIterator::operator!=">
//    @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 101,
//     cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::ConstIterator::operator!=")
//    //</editor-fold>
//    public boolean $noteq(/*const*/ConstIterator /*&*/ X) /*const*/ {
//      return $noteq(I, X.I);
//    }
//
//  };
//  /*typedef Iterator iterator*/
//  public final class iterator extends Iterator{ };
//  /*typedef ConstIterator const_iterator*/
//  public final class const_iterator extends ConstIterator{ };
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::begin">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 107,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::begin")
  //</editor-fold>
  public iterator begin() {
    return new iterator(TheMap.begin());
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::end">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 108,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::end")
  //</editor-fold>
  public iterator end() {
    return new iterator(TheMap.end());
  }

//  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::begin">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 110,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::begin")
//  //</editor-fold>
//  public iterator begin() /*const*/ {
//    return ConstIterator(TheMap.begin());
//  }
//
//  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::end">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 111,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::end")
//  //</editor-fold>
//  public iterator end() /*const*/ {
//    return ConstIterator(TheMap.end());
//  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::find">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 113,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::find")
  //</editor-fold>
  public iterator find(/*const*/${VALUE_TYPE} /*&*/ V) {
    return new iterator(TheMap.find(V));
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::erase">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 114,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::erase")
  //</editor-fold>
  public void erase(iterator I) {
    TheMap.erase(I.I);
  }

//  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::erase">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 115,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::erase")
//  //</editor-fold>
//  public void erase(ConstIterator CI) {
//    TheMap.erase(CI.I);
//  }

  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::insert">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 117,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::insert")
  //</editor-fold>
  public std.pairTypeBool<iterator> insert(/*const*/${VALUE_TYPE} /*&*/ V) {
    std.pairTypeBool<${DENSE_MAP_ITER}> mapPair = TheMap.insert(${MAKE_PAIR_VALUE_CHAR_FACTORY_MTD}(V, (byte) 0));
    return std.make_pair(new iterator(mapPair.first), mapPair.second);
  }

  
  // Range insertion of values.
  /*template <typename InputIt> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::DenseSet::insert">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/DenseSet.h", line = 123,
   cmd="jclank.sh ${LLVM_SRC}/llvm/tools/clang/lib/Lex/Lexer.cpp -filter=llvm::DenseSet::insert")
  //</editor-fold>
  public void insert(${GENERIC_ITERATOR} I, ${GENERIC_ITERATOR} E) {
    I = $tryClone(I);
    for (; Native.$noteq(I, E); I.$preInc())  {
      insert(/*Deref*/I.$star());
    }
  }

}
