
package org.llvm.adt.aliases;

import org.clank.java.*;
import org.clank.support.*;
import org.clank.support.aliases.*;
import static org.clank.support.Casts.*;
import static org.clank.java.io.*;
import static org.clank.java.std.*;
import static org.llvm.adt.ADTAliases.*;
import static org.llvm.support.llvm.*;
import static org.clank.support.NativePointer.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import org.clank.support.NativeMemory.*;
import org.llvm.support.*;
import org.llvm.adt.*;
import org.llvm.adt.aliases.*;

/*template <typename ${VALUE_TYPE}> TEMPLATE*/

/// ${FILE_NAME} - This is used to represent one value that is inserted into
/// a StringMap.  It contains the Value itself and the key: the string length
/// and data.
//<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}">
@Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 117,
 cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}")
//</editor-fold>
public class ${FILE_NAME}${CLASS_SUFFIX}  extends /*public*/ StringMapEntryBaseCharArray 
  implements Destructors.ClassWithDestructor, NativeType.SizeofCapable {
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 119,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  protected ${FILE_NAME}(${FILE_NAME}${CLASS_SUFFIX} /*&*/ E) {
    super(E);
    this.second = E.second;
  }

/*public:*/
  public ${VALUE_TYPE} second;
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 123,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public /*explicit*/ ${FILE_NAME}(/*uint*/int strLen) {
    /* : ${FILE_NAME}Base(strLen), second()*/ 
    //START JInit
    super(strLen);
    this.second = ${DEFAULT_VALUE}/*new ${VALUE_TYPE}()*/;
    //END JInit
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 123,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public /*explicit*/ ${FILE_NAME}(char$ptr Str, /*uint*/int strLen) {
    /* : ${FILE_NAME}Base(strLen), second()*/ 
    //START JInit
    super(Str, strLen);
    this.second = ${DEFAULT_VALUE}/*new ${VALUE_TYPE}()*/;
    //END JInit
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::StringMapEntryIdentifierInfo::StringMapEntryIdentifierInfo">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 123,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::StringMapEntryIdentifierInfo::StringMapEntryIdentifierInfo")
  //</editor-fold>
  public /*explicit*/ ${FILE_NAME}(byte Str[], int fromIdx, /*uint*/int strLen, int FullHashValue) {
    /* : ${FILE_NAME}Base(strLen), second()*/ 
    //START JInit
    super(Str, fromIdx, strLen, FullHashValue);
    this.second = ${DEFAULT_VALUE}/*new ${VALUE_TYPE}()*/;
    //END JInit
  }

  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 123,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::StringMapEntryIdentifierInfo::StringMapEntryIdentifierInfo")
  //</editor-fold>
  public /*explicit*/ ${FILE_NAME}(JavaDifferentiators.Misc dummy, byte Str[], int fromIdx, /*uint*/int strLen, /*const*/${VALUE_TYPE} /*&*/ V) {
    /* : ${FILE_NAME}Base(strLen), second()*/ 
    //START JInit
    super(Str, fromIdx, strLen);
    this.second = V/*new ValueT()*/;
    //END JInit
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 125,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}${CLASS_SUFFIX}")
  //</editor-fold>
  public ${FILE_NAME}(/*uint*/long strLen, /*const*/${VALUE_TYPE} /*&*/ V) {
    /* : ${FILE_NAME}Base(strLen), second(V)*/ 
    //START JInit
    super(strLen);
    this.second = V;
    //END JInit
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::getKey">
  @Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 128,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::getKey")
  //</editor-fold>
  public StringRef getKey() /*const*/ {
    return new StringRef(getKeyData(), getKeyLength());
  }

//  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::getValue">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 132,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::getValue")
//  //</editor-fold>
//  public /*const*/${VALUE_TYPE} /*&*/ getValue() /*const*/ {
//    return second;
//  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::getValue">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 133,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::getValue")
  //</editor-fold>
  public ${VALUE_TYPE} /*&*/ getValue() {
    return second;
  }
  public ${VALUE_REFERENCE} getValue$Ref() {
    return new ${VALUE_REFERENCE}() {

      @Override
      public ${VALUE_TYPE} $deref() {
        return second;
      }

      @Override
      public ${VALUE_TYPE} $set(${VALUE_TYPE} value) {
        second = value;
        return value;
      }

      @Override
      public ${VALUE_POINTER} deref$ptr() {
        throw new UnsupportedOperationException("Not supported yet.");
      }
    };
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::setValue">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 135,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::setValue")
  //</editor-fold>
  public void setValue(/*const*/${VALUE_TYPE} /*&*/ V) {
    second = V;
  }

  
  /// getKeyData - Return the start of the string data that is the key for this
  /// value.  The string data is always stored immediately after the
  /// ${FILE_NAME} object.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::getKeyData">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 140,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::getKeyData")
  //</editor-fold>
  public /*const*/char$ptr/*char P*/ getKeyData() /*const*/ {
    return getKeyStr()/*reinterpret_cast(char$ptr.class, this + 1)*/;
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::first">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 142,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::first")
  //</editor-fold>
  public StringRef first() /*const*/ {
    return new StringRef(getKeyData(), getKeyLength());
  }
  
  /// Create - Create a ${FILE_NAME} for the specified key and default
  /// construct the value.
  /*template <typename AllocatorTy, typename InitType> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::Create">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 147,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::Create")
  //</editor-fold>
  public static ${INIT_1_PREFIX} ${INIT_1_RET_TYPE} /*P*/ Create(/*const*/char$ptr/*char P*/ KeyStart, int KeyLength, int FullHashValue, ${INIT_1_ALLOCATOR} /*&*/ Allocator, ${INIT_1_TYPE} InitVal) {
//    /*uint*/long KeyLength = (/*static_cast*//*uint*/long)(KeyEnd.$sub(KeyStart));    
    // Okay, the item doesn't already exist, and 'Bucket' is the bucket to fill
    // in.  Allocate a new item with space for the string at the end and a null
    // terminator.
//    /*uint*/long AllocSize = (/*static_cast*//*uint*/long)(sizeof(${FILE_NAME}${CLASS_SUFFIX})) + KeyLength + 1;
//    /*uint*/long Alignment = alignOf<${FILE_NAME}${CLASS_SUFFIX} >();    
//    ${FILE_NAME}${CLASS_SUFFIX} /*P*/ NewItem = (/*static_cast*/${FILE_NAME}${CLASS_SUFFIX} /*P*/ )(Allocator.Allocate(AllocSize, Alignment));
    // Copy the string information.
    int StrBufferIndex = ((BumpAllocator)Allocator).AllocateAndGetIndex(KeyLength + 1, 1);
    byte[] StrBuffer = ((BumpAllocator)Allocator).GetLastAllocationStorage();
    memcpy(StrBuffer, StrBufferIndex, KeyStart, 0, KeyLength);
    StrBuffer[StrBufferIndex + KeyLength] = (byte)0; // Null terminate for convenience of clients.
    //StrBuffer = $toConst(StrBuffer);    
    ${INIT_1_RET_TYPE} NewItem = new ${INIT_1_RET_TYPE}(StrBuffer, StrBufferIndex, KeyLength, FullHashValue);
    //assert StrBuffer == NewItem.getKeyData();
    assert StrBuffer == NewItem.getKeyData().$array();
    assert StrBufferIndex == NewItem.getKeyData().$index();

    // Default construct the value.
//    new (NewItem) ${FILE_NAME}${CLASS_SUFFIX}(( KeyLength ));
    
    // Initialize the value if the client wants to.
    ${INITIALIZE_STRING}(/*Deref*/NewItem, InitVal);
    return NewItem;
  }
  public static ${INIT_1_PREFIX} ${INIT_1_RET_TYPE} /*P*/ Create(/*const*/byte[]/*char P*/ KeyArray, int KeyStartIndex, int KeyLength, int FullHashValue, ${INIT_1_ALLOCATOR} /*&*/ Allocator, ${INIT_1_TYPE} InitVal) {
//    /*uint*/long KeyLength = (/*static_cast*//*uint*/long)(KeyEnd.$sub(KeyStart));    
    // Okay, the item doesn't already exist, and 'Bucket' is the bucket to fill
    // in.  Allocate a new item with space for the string at the end and a null
    // terminator.
//    /*uint*/long AllocSize = (/*static_cast*//*uint*/long)(sizeof(${FILE_NAME}${CLASS_SUFFIX})) + KeyLength + 1;
//    /*uint*/long Alignment = alignOf<${FILE_NAME}${CLASS_SUFFIX} >();    
//    ${FILE_NAME}${CLASS_SUFFIX} /*P*/ NewItem = (/*static_cast*/${FILE_NAME}${CLASS_SUFFIX} /*P*/ )(Allocator.Allocate(AllocSize, Alignment));
    // Copy the string information.
    int StrBufferIndex = ((BumpAllocator)Allocator).AllocateAndGetIndex(KeyLength + 1, 1);
    byte[] StrBuffer = ((BumpAllocator)Allocator).GetLastAllocationStorage();
    memcpy(StrBuffer, StrBufferIndex, KeyArray, KeyStartIndex, KeyLength);
    StrBuffer[StrBufferIndex + KeyLength] = (byte)0; // Null terminate for convenience of clients.
    //StrBuffer = $toConst(StrBuffer);    
    ${INIT_1_RET_TYPE} NewItem = new ${INIT_1_RET_TYPE}(StrBuffer, StrBufferIndex, KeyLength, FullHashValue);
    //assert StrBuffer == NewItem.getKeyData();
    assert StrBuffer == NewItem.getKeyData().$array();
    assert StrBufferIndex == NewItem.getKeyData().$index();

    // Default construct the value.
//    new (NewItem) ${FILE_NAME}${CLASS_SUFFIX}(( KeyLength ));
    
    // Initialize the value if the client wants to.
    ${INITIALIZE_STRING}(/*Deref*/NewItem, InitVal);
    return NewItem;
  }

//  /*template <typename AllocatorTy> TEMPLATE*/
//  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::Create">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 177,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::Create")
//  //</editor-fold>
//  public static </*typename*/ AllocatorTy> ${FILE_NAME}${CLASS_SUFFIX} /*P*/ Create(/*const*/char$ptr/*char P*/ KeyStart, /*const*/char$ptr/*char P*/ KeyEnd, AllocatorTy /*&*/ Allocator) {
//    return Create(KeyStart, KeyEnd, Allocator, 0);
//  }

  
  /// Create - Create a ${FILE_NAME} with normal malloc/free.
  /*template <typename InitType> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::Create">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 184,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::Create")
  //</editor-fold>
  public static ${INIT_2_PREFIX} ${INIT_2_RET_TYPE} /*P*/ Create(/*const*/char$ptr/*char P*/ KeyStart, int KeyLength, int FullHashValue, ${INIT_2_TYPE} InitVal) {
    Allocator A/*J*/= new StringMapBumpPtrAllocator();
    return Create(KeyStart, KeyLength, FullHashValue, A, InitVal);
  }

//  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::Create">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 190,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::Create")
//  //</editor-fold>
//  public static ${FILE_NAME}${CLASS_SUFFIX} /*P*/ Create(/*const*/char$ptr/*char P*/ KeyStart, /*const*/char$ptr/*char P*/ KeyEnd) {
//    return Create(KeyStart, KeyEnd, ${VALUE_TYPE}());
//  }

  
  /// Get${FILE_NAME}FromValue - Given a value that is known to be embedded
  /// into a ${FILE_NAME}, return the ${FILE_NAME} itself.
//  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::Get${FILE_NAME}FromValue">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 196,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::Get${FILE_NAME}FromValue")
//  //</editor-fold>
//  public static <${VALUE_TYPE}> ${FILE_NAME}${CLASS_SUFFIX} /*&*/ Get${FILE_NAME}FromValue(${VALUE_TYPE} /*&*/ V) {
//    ${FILE_NAME}${CLASS_SUFFIX} /*P*/ EPtr = 0;
//    char$ptr/*char P*/ Ptr = reinterpret_cast(char$ptr/*char P*/ .class, /*AddrOf*/V).$sub((reinterpret_cast(char$ptr/*char P*/ .class, /*AddrOf*/EPtr.second).$sub(reinterpret_cast(char$ptr/*char P*/ .class, EPtr))));
//    return /*Deref*/reinterpret_cast(${FILE_NAME}${CLASS_SUFFIX} /*P*/ .class, Ptr);
//  }

//  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::Get${FILE_NAME}FromValue">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 203,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::Get${FILE_NAME}FromValue")
//  //</editor-fold>
//  public static /*const*/${FILE_NAME}${CLASS_SUFFIX} /*&*/ Get${FILE_NAME}FromValue(/*const*/${VALUE_TYPE} /*&*/ V) {
//    return Get${FILE_NAME}FromValue((/*const_cast*/${VALUE_TYPE} /*&*/ )(V));
//  }

  
//  /// Get${FILE_NAME}FromKeyData - Given key data that is known to be embedded
//  /// into a ${FILE_NAME}, return the ${FILE_NAME} itself.
//  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::Get${FILE_NAME}FromKeyData">
//  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 209,
//   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::Get${FILE_NAME}FromKeyData")
//  //</editor-fold>
//  public static ${FILE_NAME}${CLASS_SUFFIX} /*&*/ Get${FILE_NAME}FromKeyData(/*const*/char$ptr/*char P*/ KeyData) {
//    char$ptr/*char P*/ Ptr = (/*const_cast*/char$ptr/*char P*/ )(KeyData).$sub(sizeof(${FILE_NAME}${CLASS_SUFFIX}));
//    return /*Deref*/reinterpret_cast(${FILE_NAME}${CLASS_SUFFIX} /*P*/ .class, Ptr);
//  }

  
  /// Destroy - Destroy this ${FILE_NAME}, releasing memory back to the
  /// specified allocator.
  /*template <typename AllocatorTy> TEMPLATE*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::Destroy">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 217,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::Destroy")
  //</editor-fold>
  public </*typename*/ AllocatorTy> void Destroy(AllocatorTy /*&*/ Allocator) {
    // Free memory referenced by the item.
    this.$destroy();
//    Allocator.Deallocate(this);
  }

  
  /// Destroy this object, releasing memory back to the malloc allocator.
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::Destroy">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 224,
   cmd="jclank.sh ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::Destroy")
  //</editor-fold>
  public void Destroy() {
    MallocAllocator A = null;
    try {
      A/*J*/= new MallocAllocator();
      Destroy(A);
    } finally {
      if (A != null) { A.$destroy(); }
    }
  }

  @Override
  public void $destroy() {
    // do nothing
  }

  @Override
  public String toString() {
    return "{" + getKeyData() + "=>" + second + '}';
  }

  @Override
  public long $sizeof() {
    return $sizeof_${FILE_NAME}();
  }
    
  public static long/*size_t*/$sizeof_${FILE_NAME}() {
    return NativeType.BYTES_IN_JAVA_OBJECT_HEADER +
       NativeType.sizeof(${DEFAULT_VALUE}) +
       (StringMapEntryBase.$sizeof_StringMapEntryBase_Fields());
  }
}
