// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GccAna_CircLin2dBisec_HeaderFile
#define _GccAna_CircLin2dBisec_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <gp_Circ2d.hxx>
#include <gp_Lin2d.hxx>
#include <Handle_GccInt_Bisec.hxx>
class Standard_OutOfRange;
class StdFail_NotDone;
class gp_Circ2d;
class gp_Lin2d;
class GccInt_Bisec;


//! Describes functions for building bisecting curves between a 2D line and a 2D circle.
//! A bisecting curve between a circle and a line is a curve
//! such that each of its points is at the same distance from
//! the circle and the line. It can be a parabola or a line,
//! depending of the relative position of the line and the
//! circle. The algorithm computes all the elementary curves which are solutions.
//! A CircLin2dBisec object provides a framework for:
//! -   defining the construction of the bisecting curves,
//! -   implementing the construction algorithm, and
//! -   consulting the result.
class GccAna_CircLin2dBisec 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs bisecting curves between the circle Circle and the line Line.
  Standard_EXPORT GccAna_CircLin2dBisec(const gp_Circ2d& Circle, const gp_Lin2d& Line);
  
  //! Returns true (this construction algorithm never fails).
  Standard_EXPORT   Standard_Boolean IsDone()  const;
  

  //! Returns the number of curves, representing solutions computed by this algorithm.
  Standard_EXPORT   Standard_Integer NbSolutions()  const;
  
  //! Returns the solution number Index and raises OutOfRange
  //! exception if Index is greater than the number of solutions
  //! Exceptions
  //! Standard_OutOfRange if Index is less than zero or
  //! greater than the number of solutions computed by this algorithm.
  Standard_EXPORT   Handle(GccInt_Bisec) ThisSolution (const Standard_Integer Index)  const;




protected:





private:



  Standard_Boolean WellDone;
  Standard_Integer NbrSol;
  gp_Circ2d circle;
  gp_Lin2d line;


};







#endif // _GccAna_CircLin2dBisec_HeaderFile
