// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeUpgrade_ShapeDivideContinuity_HeaderFile
#define _ShapeUpgrade_ShapeDivideContinuity_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <GeomAbs_Shape.hxx>
#include <Standard_Real.hxx>
#include <ShapeUpgrade_ShapeDivide.hxx>
#include <Handle_ShapeUpgrade_FaceDivide.hxx>
class TopoDS_Shape;
class ShapeUpgrade_FaceDivide;


//! API Tool for converting shapes with C0 geometry into C1 ones
class ShapeUpgrade_ShapeDivideContinuity  : public ShapeUpgrade_ShapeDivide
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT ShapeUpgrade_ShapeDivideContinuity();
  
  //! Initialize by a Shape.
  Standard_EXPORT ShapeUpgrade_ShapeDivideContinuity(const TopoDS_Shape& S);
  
  //! Sets tolerance.
  Standard_EXPORT   void SetTolerance (const Standard_Real Tol) ;
  
  //! Sets tolerance.
  Standard_EXPORT   void SetTolerance2d (const Standard_Real Tol) ;
  

  //! Defines a criterion of continuity for the boundary (all the
  //! Wires)
  //!
  //! The possible values are C0, G1, C1, G2, C2, C3, CN The
  //! default is C1 to respect the Cas.Cade Shape Validity.  G1
  //! and G2 are not authorized.
  Standard_EXPORT   void SetBoundaryCriterion (const GeomAbs_Shape Criterion = GeomAbs_C1) ;
  

  //! Defines a criterion of continuity for the boundary (all the
  //! pcurves of Wires)
  //!
  //! The possible values are C0, G1, C1, G2, C2, C3, CN The
  //! default is C1 to respect the Cas.Cade Shape Validity.  G1
  //! and G2 are not authorized.
  Standard_EXPORT   void SetPCurveCriterion (const GeomAbs_Shape Criterion = GeomAbs_C1) ;
  

  //! Defines a criterion of continuity for the boundary (all the
  //! Wires)
  //!
  //! The possible values are C0, G1, C1, G2, C2, C3, CN The
  //! default is C1 to respect the Cas.Cade Shape Validity.  G1
  //! and G2 are not authorized.
  Standard_EXPORT   void SetSurfaceCriterion (const GeomAbs_Shape Criterion = GeomAbs_C1) ;




protected:

  
  //! Returns the tool for dividing faces.
  Standard_EXPORT virtual   Handle(ShapeUpgrade_FaceDivide) GetSplitFaceTool()  const;




private:



  GeomAbs_Shape myCurve3dCriterion;
  GeomAbs_Shape myCurve2dCriterion;
  GeomAbs_Shape mySurfaceCriterion;
  Standard_Real myTolerance3d;
  Standard_Real myTolerance2d;


};







#endif // _ShapeUpgrade_ShapeDivideContinuity_HeaderFile
