/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.application;

import ch.ehi.basics.types.NlsString;
import ch.ehi.interlis.associations.AssociationDef;
import ch.ehi.interlis.metaobjects.MetaObjectFile;
import ch.ehi.interlis.modeltopicclass.ClassDef;
import ch.ehi.interlis.modeltopicclass.INTERLIS2Def;
import ch.ehi.interlis.modeltopicclass.ModelDef;
import ch.ehi.interlis.modeltopicclass.TopicDef;
import ch.ehi.uml1_4.foundation.core.AssociationEnd;
import ch.ehi.uml1_4.foundation.core.Element;
import ch.ehi.uml1_4.foundation.core.Feature;
import ch.ehi.uml1_4.foundation.core.ModelElement;
import ch.ehi.uml1_4.implementation.UmlModel;
import ch.ehi.uml1_4.implementation.UmlPackage;
import ch.ehi.umleditor.application.ElementUtils;
import ch.ehi.umleditor.application.LauncherView;
import ch.ehi.umleditor.umlpresentation.Diagram;
import ch.softenvironment.util.StringUtils;
import ch.softenvironment.util.Tracer;
import java.io.File;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NavigationTreeNodeUtility {
    private NavigationTreeNodeUtility() {
    }

    public static Icon getIcon(Object node, boolean expanded) {
        String fileName = null;
        if (node instanceof Diagram) {
            fileName = "classDiagram.gif";
        } else {
            if (node instanceof UmlModel) {
                return NavigationTreeNodeUtility.getPackageLeafIcon(expanded);
            }
            if (node instanceof INTERLIS2Def) {
                return NavigationTreeNodeUtility.getPackageLeafIcon(expanded);
            }
            if (node instanceof ModelDef) {
                return NavigationTreeNodeUtility.getPackageLeafIcon(expanded);
            }
            if (node instanceof TopicDef) {
                return NavigationTreeNodeUtility.getPackageLeafIcon(expanded);
            }
            if (node instanceof UmlPackage) {
                return NavigationTreeNodeUtility.getPackageLeafIcon(expanded);
            }
            fileName = StringUtils.getPureClassName(node) + ".gif";
        }
        URL url = node.getClass().getResource("/ch/ehi/umleditor/images/Navigation/" + fileName);
        if (url == null) {
            Tracer.getInstance().developerWarning("file not found <" + fileName + ">");
            return null;
        }
        return new ImageIcon(url);
    }

    public static String getName(Object element) {
        if (element instanceof UmlModel) {
            File file = null;
            if (LauncherView.getInstance() != null) {
                file = LauncherView.getInstance().getCurrentFile();
            }
            return file != null ? file.getName() : LauncherView.defaultFileName;
        }
        if (NavigationTreeNodeUtility.isModelElement(element)) {
            return ((ModelElement)element).getDefLangName();
        }
        if (NavigationTreeNodeUtility.isClassDiagram(element)) {
            return ElementUtils.mapNlsString(((Diagram)element).getName());
        }
        throw new IllegalArgumentException("unknown EditorTreeElement");
    }

    private static Icon getPackageLeafIcon(boolean expanded) {
        return null;
    }

    public static boolean hasSpecification(Element element) {
        return ElementUtils.getElementDialog(element) != null;
    }

    public static boolean isAssociationDef(Element node) {
        return node instanceof AssociationDef;
    }

    public static boolean isClassDef(Element node) {
        return node instanceof ClassDef;
    }

    public static boolean isClassDiagram(Object element) {
        return element instanceof Diagram;
    }

    private static boolean isModelElement(Object element) {
        return element instanceof ModelElement;
    }

    public static boolean isNodeEditable(Element node) {
        return !(node instanceof UmlModel) && !(node instanceof MetaObjectFile);
    }

    public static boolean isNodeRemovable(Element node) {
        return !(node instanceof UmlModel);
    }

    public static boolean isNodeMovable(Element node) {
        return !(node instanceof UmlModel) && !(node instanceof Feature) && !(node instanceof AssociationEnd);
    }

    public static void setName(Object node, String newName) {
        if (NavigationTreeNodeUtility.isModelElement(node)) {
            ((ModelElement)node).setName(new NlsString(((ModelElement)node).getName(), newName));
        } else if (NavigationTreeNodeUtility.isClassDiagram(node)) {
            ((Diagram)node).setName(new NlsString(((Diagram)node).getName(), newName));
        }
    }
}

