/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.graph.canvas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.owasp.jbrofuzz.version.ImageCreator;

public class ResponseSizeChart {
    private static final int MAX_CHARS = 0x100000;
    private final String[] xData;
    private final int[] yData;
    private final DefaultCategoryDataset dataset;
    private static final String END_SIGNATURE = "--jbrofuzz-->\n";

    public ResponseSizeChart() {
        this(0);
    }

    public ResponseSizeChart(int size) {
        this.xData = new String[size];
        this.yData = new int[size];
        this.dataset = new DefaultCategoryDataset();
    }

    /*
     * Loose catch block
     */
    private int calculateValue(File inputFile) {
        if (inputFile.isDirectory()) {
            return -1;
        }
        long headerLength = 0L;
        BufferedReader inBuffReader = null;
        try {
            int got;
            inBuffReader = new BufferedReader(new FileReader(inputFile));
            StringBuffer one = new StringBuffer();
            int counter = 0;
            while ((got = inBuffReader.read()) > 0 && counter < 0x100000) {
                one.append((char)got);
                ++counter;
            }
            inBuffReader.close();
            one.delete(0, 5);
            one.delete(one.indexOf("\n--"), one.length());
            headerLength = one.indexOf(END_SIGNATURE) + END_SIGNATURE.length();
        }
        catch (IOException e1) {
            IOUtils.closeQuietly(inBuffReader);
            return -2;
        }
        catch (StringIndexOutOfBoundsException e2) {
            IOUtils.closeQuietly(inBuffReader);
            return -3;
        }
        catch (NumberFormatException e3) {
            IOUtils.closeQuietly(inBuffReader);
            return -4;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inBuffReader);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(inBuffReader);
        return (int)(inputFile.length() - headerLength);
    }

    public void createFinalPlotCanvas() {
    }

    public ChartPanel getPlotCanvas() {
        JFreeChart chart = ChartFactory.createBarChart((String)"JBroFuzz Response Size Bar Chart", (String)"File Name", (String)"Response Size (bytes)", (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)true);
        Plot plot = chart.getPlot();
        plot.setBackgroundImage(ImageCreator.IMG_OWASP_MED.getImage());
        plot.setBackgroundImageAlignment(9);
        CategoryItemRenderer renderer = chart.getCategoryPlot().getRenderer();
        renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        return new ChartPanel(chart);
    }

    public void setValueAt(int index, File inputFile) {
        this.xData[index] = inputFile.getName();
        this.yData[index] = this.calculateValue(inputFile);
        this.dataset.addValue((double)this.yData[index], (Comparable)((Object)"Row 1"), (Comparable)((Object)this.xData[index]));
    }
}

